@extends('backend.layouts.app')
@section('title', "University Course Finder")

@section('content')
<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col" style="margin-bottom:10px;">
                <h4 style="">University Course Finder</h4>
            </div>
        </div>
        <form id="cf_form">
            <div class="filterBox" style="">
                <div class="row mt-4">
                    <div class="col-md-3">
                        <label class="" style="font-weight: normal !important;">Study Level</label>
                        <select name="study_level" id="study_level" class="form-select" required>
                            {{-- <option value="">Select Study Level</option> --}}
                            @foreach($levels as $level)
                            <option value="{{ $level }}">{{ $level }}</option>
                            @endforeach
                        </select>
                    </div>
                    {{-- <div class="col-md-3">
                        <label class="">Year</label>
                        <select name="year" class="form-select">
                            <option value="">Select Year</option>
                            @foreach($years as $year)
                            <option value="{{ $year }}">{{ $year }}</option>
                            @endforeach
                        </select>
                    </div> --}}
                    <div class="col-md-3">
                        <label class="" style="font-weight: normal !important;">Study Area</label>
                        <select name="category" id="category" class="form-select" required>
                            <option value="">Select Study Area</option>
                            @foreach($categories as $cat)
                            <option value="{{ $cat->id }}">{{ $cat->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label style="font-weight: normal !important;">Discipline Area</label>
                        <select name="sub_category" id="sub-cat" class="form-select">
                            <option value="">Select Discipline Area</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="" style="font-weight: normal !important;">Country</label>
                        <select name="country" id="country" class="form-select" required>
                            <option value="">Select Country</option>
                            @foreach($countries as $country)
                            <option value="{{ get_country_id_by_name($country) }}">{{ $country }}</option>
                            @endforeach
                        </select>
                    </div>
                    {{-- <div class="col-md-3" style="font-weight: normal !important;">
                        <label style="font-weight: normal !important;">Campus/City</label>
                        <select name="campus" id="campus" class="form-select">
                            <option value="">Select Campus/City</option>
                        </select>
                    </div> --}}
                    <div class="col-md-3">
                        <div class="form-group">
                            <label style="font-weight: normal !important;">Intake</label>
                            <select name="intake[]" id="search_intake" class="form-select select2" multiple="multiple">
                                <option value="Jan">January</option>
                                <option value="Feb">February</option>
                                <option value="Mar">March</option>
                                <option value="Apr">April</option>
                                <option value="May">May</option>
                                <option value="Jun">June</option>
                                <option value="Jul">July</option>
                                <option value="Aug">August</option>
                                <option value="Sep">September</option>
                                <option value="Oct">October</option>
                                <option value="Nov">November</option>
                                <option value="Dec">December</option>
                                <option value="Spring">Spring</option>
                                <option value="Summer">Summer</option>
                                <option value="Fall">Fall</option>
                                <option value="Winter">Winter</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label style="font-weight: normal !important;">Duration</label>
                            <select name="duration" id="search_duration" class="form-control form-select">
                                <option value="">Select Duration</option>
                                @if(count($durations))
                                @foreach($durations as $duration)
                                    <option value="{{$duration->duration}}">{{$duration->duration}}</option>
                                @endforeach
                                @endif
                                {{-- <option value="12">0-1 year</option>
                                <option value="24">1-2 years</option>
                                <option value="36">2-3 years</option>
                                <option value="48">3-4 years</option>
                                <option value="60">4+ years</option> --}}
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label style="font-weight: normal !important;">Search by Course or University Name</label>
                            <input type="text" id="course_university_search" placeholder="Course/University Name" name="course" value="" class="form-control course-finder-search-input">
                        </div>
                    </div>
                    {{-- <div class="col-md-2">
                        <div class="form-group">
                            <label style="font-weight: normal !important;">IELTS Score</label>
                            <input type="number" id="ielts_score" placeholder="IELTS Score" step="0.5" name="ielts" value="" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group" id="IELTS_No_Less">
                            <label id="IELTS_No_Less_Label" style="font-weight: normal !important;">IELTS No Less..</label>
                            <input type="number" id="IELTS_No_Less_input" placeholder="IELTS No Band Less Than" step="0.5" name="ielts_no_band" value="" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label style="font-weight: normal !important;">TOEFL Score</label>
                            <input type="number" 
                            id="toefl_score" placeholder="TOEFL Score" step="1" name="toefl" value="" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group" id="TOEFL_No_Less">
                            <label id="TOEFL_No_Less_Label" style="font-weight: normal !important;">TOEFL No Less</label>
                            <input type="number" 
                            id="TOEFL_No_Less_Input"placeholder="TOEFL No Band Less Than" step="1" name="toefl_no_band" value="" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group mb-3">
                            <label style="font-weight: normal !important;">PTE Score</label>
                            <input type="number" 
                            id="PTE_Score" placeholder="PTE Score" step="1" name="pte" value="" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group mb-3" id="PTE_No_Less">
                            <label id="PTE_No_Less_Label" style="font-weight: normal !important;">PTE No Less</label>
                            <input type="number" id="PTE_No_Less_input" placeholder="PTE No Band Less Than" step="1" name="pte_no_band" value="" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group mb-3">
                            <label style="font-weight: normal !important;">GRE Score</label>
                            <input type="number" id="GRE_Score" idplaceholder="GRE Score" step="1" name="gre" value="" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group mb-3">
                            <label style="font-weight: normal !important;">GMAT Score</label>
                            <input type="number" id="GMAT_Score" placeholder="GMAT Score" step="0.5" name="gmat" value="" class="form-control">
                        </div>
                    </div> --}}
                </div>
                <div class="row">
                    {{-- <div class="col-md-6 mx-auto">
                        <div class="form-group">
                            <input type="text" id="course_university_search" placeholder="Course/University Name" name="course" value="" class="form-control course-finder-search-input">
                        </div>
                    </div> --}}
                    <div class="col-md-4 mx-auto text-center">
                        <div class="form-group" style="margin-top: 23px;">
                            <button id="search_courses" class="btn btn-primary btn-lg" style="width:200px;">Search</button>
                            <a href="{{route('admin.coursemanagement.course-finder')}}" class=" btn btn-secondary btn-lg">Reset</a>
                        </div>
                    </div>
                </div>
                {{-- <div class="row">
                    <div class="form-group mt-2" style="text-align: center">
                        {{ form_submit("Search Courses") }}
                    </div>
                </div> --}}
        </form>
        <div id="result_body">
        </div>
    </div>
</div>

<div class="modal fade" id="courseModal" role="dialog" aria-labelledby="courseModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Suggest Course to Student</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="courseBody">
                <p><b>Course:</b> <span id="course_name"></span></p>
                <p><b>University:</b> <span id="course_uni"></span></p>
                <p><b>Country:</b> <span id="course_country"></span></p>
                <hr>
                <form id="assign_form">
                    <input type="hidden" id="assign_course" name="assign_course" value="">
                    <!-- <input type="hidden" id="assign_course_country" name="assign_course_country" value="">
                    <input type="hidden" id="assign_course_uni" name="assign_course_uni" value=""> -->
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label class="required-field">Select Student</label>
                            <select class="se_ajax" data-dropdown-parent="#courseModal" id="stu_id" name="student_id" required></select>
                        </div>
                    </div>
                    <!-- <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label class="required-field">Intake Month</label>
                            <select name="intake_month" id="cors_month" class="form-select" required>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label class="required-field">Intake Year</label>
                            <select name="intake_year" id="cors_year" class="form-select" required>
                            </select>
                        </div>
                    </div> -->
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <input type="submit" class="btn btn-primary" value="Suggest">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="coursePreferenceModal" role="dialog" aria-labelledby="coursePreferenceModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add to Student Course Preference</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="courseBody">
                <p><b>Course:</b> <span id="course_preference_name"></span></p>
                <p><b>University:</b> <span id="course_preference_uni"></span></p>
                <p><b>Country:</b> <span id="course_preference_country"></span></p>
                <hr>
                <form id="assign_course_preference_form">
                    <input type="hidden" id="assign_preference_course_id" name="assign_preference_course_id" value="">
                    <input type="hidden" id="assign_course_preference" name="assign_course_preference" value="">
                    <input type="hidden" id="assign_course_preference_country" name="assign_course_preference_country" value="">
                    <input type="hidden" id="assign_course_preference_uni" name="assign_course_preference_uni" value=""> 
                    {{-- <input type="hidden" id="assign_course_preference_intake" name="assign_course_preference_intake" value="">  --}}
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label class="required-field">Select Student</label>
                            <select class="se_ajax" data-dropdown-parent="#coursePreferenceModal" id="course_preference_stu_id" name="course_preference_stu_id" required></select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label for="intake" class="required-field">Intake</label>
                            <select name="intake" style="width:100%;" id="intake" class="form-select form-control select2" required>
                                <option value="">Intake</option>
                                <?php $month = date('n'); // current month
                                for ($x = 0; $x < 24; $x++) { ?>
                                <option value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                                <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                                <?php } ?></option>
                            </select>
                        </div>
                    </div>
                    {{-- <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label>Intake Month</label>
                            <select name="intake_month" id="cors_month" class="form-select">
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label>Intake Year</label>
                            <select name="intake_year" id="cors_year" class="form-select">
                            </select>
                        </div>
                    </div> --}}
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <input type="submit" class="btn btn-primary" value="Add Course Preference">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="courseMultiModal" role="dialog" aria-labelledby="courseMultiModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Suggest Selected Courses to Student</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="courseBody">
                {{-- <p><b>Course:</b> <span id="course_name"></span></p>
                <p><b>University:</b> <span id="course_uni"></span></p>
                <p><b>Country:</b> <span id="course_country"></span></p> --}}
                {{-- <hr> --}}
                <form id="assign_multi_form">
                    <input type="hidden" id="assign_multi_course" name="assign_course" value="">
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <label class="required-field">Select Student</label>
                            <select class="se_ajax" data-dropdown-parent="#courseMultiModal" id="multi_stu_id" name="student_id" required></select>
                        </div>
                    </div>
    
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <input type="submit" class="btn btn-primary" value="Suggest">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script type="text/javascript">
    $(document).ready(function() {

        $('#study_level').trigger('keyup');

        var html = '';
        $('#category').on('change', function() {
            var idCat = this.value;
            $("#sub-cat").html('');
            $.ajax({
                url: "{{route('admin.coursemanagement.fetchSubCat')}}",
                type: "POST",
                data: {
                    category_id: idCat,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#sub-cat').html('<option value="">Select Discipline Area</option>');
                    $.each(result.subcategories, function(key, value) {
                        $("#sub-cat").append('<option value="' + value
                            .id + '">' + value.title + '</option>');
                    });
                }
            });
        });

        $('#country').on('change', function() {
            var idCountry = this.value;
            $("#campus").html('');
            $.ajax({
                url: "{{route('admin.coursemanagement.fetchCampus')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#campus').html('<option value="">Select Campus/City</option>');
                    if(Array.isArray(result.campus)){
                        $.each(result.campus, function(key, value) {
                            $("#campus").append('<option value="' + value
                                .campus + '">' + value.campus + '</option>');
                        });
                    }
                }
            });
        });

        $('.se_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.search.my.student") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $('#assign_form').on('submit', function(e) {
            e.preventDefault();
            let assign_course = $('#assign_course').val();
            // let assign_course_country = $('#assign_course_country').val();
            // let assign_course_uni = $('#assign_course_uni').val();
            let stu_id = $('#stu_id').val();
            // let cors_month = $('#cors_month').val();
            // let cors_year = $('#cors_year').val();
            let assign_url = "{{route('admin.coursemanagement.suggestcourse')}}";
            $.ajax({
                url: assign_url,
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    assign_course: assign_course,
                    // assign_course_country: assign_course_country,
                    // assign_course_uni: assign_course_uni,
                    stu_id: stu_id,
                    // cors_month: cors_month,
                    // cors_year: cors_year,
                },
                success: function(response) {
                    if (response.error) {
                        swal.fire({
                            title: response.error,
                            icon: "error",
                            button: "ok",
                        });
                        console.log(response.error);
                        $('#courseModal').modal('hide');
                    } else {
                        swal.fire({
                            title: response.success,
                            icon: "success",
                            button: "ok",
                        });
                        console.log(response);
                        $('#courseModal').modal('hide');
                    }
                },
                error: function(response) {
                    swal.fire({
                        title: "Something went wrong!",
                        icon: "danger"
                    });
                },
            });
        });

        $('#assign_course_preference_form').on('submit', function(e) {
            e.preventDefault();
            let assign_preference_course_id = $('#assign_preference_course_id').val();
            let assign_course = $('#assign_course_preference').val();
            let assign_course_country = $('#assign_course_preference_country').val();
            let assign_course_uni = $('#assign_course_preference_uni').val();
            let stu_id = $('#course_preference_stu_id').val();
            let intake = $('#intake').val();
            let from_course_preference = 1;
            // let cors_month = $('#cors_month').val();
            // let cors_year = $('#cors_year').val();
            let assign_url = "{{route('admin.studyabroad.coursepref.save')}}";
            $.ajax({
                url: assign_url,
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    course: assign_preference_course_id,
                    country: assign_course_country,
                    university: assign_course_uni,
                    user_id: stu_id,
                    intake: intake,
                    from_course_preference: from_course_preference,
                    // cors_month: cors_month,
                    // cors_year: cors_year,
                },
                success: function(response) {
                    if (response.error) {
                        swal.fire({
                            title: response.error,
                            icon: "error",
                            button: "ok",
                        });
                        console.log(response.error);
                        $('#coursePreferenceModal').modal('hide');
                    } else {
                        swal.fire({
                            title: response.success,
                            icon: "success",
                            button: "ok",
                        });
                        console.log(response);
                        $('#coursePreferenceModal').modal('hide');
                    }
                },
                error: function(response) {
                    swal.fire({
                        title: "Something went wrong!",
                        icon: "danger"
                    });
                },
            });
        });

        $('#assign_multi_form').on('submit', function(e) {
            e.preventDefault();
            let assign_course = $('#assign_multi_course').val();
            let is_multi = "1";
            let stu_id = $('#multi_stu_id').val();
            let assign_url = "{{route('admin.coursemanagement.suggestcourse')}}";
            $.ajax({
                url: assign_url,
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    assign_course: assign_course,
                    is_multi : is_multi,
                    stu_id: stu_id,
                },
                success: function(response) {
                    if (response.error) {
                        swal.fire({
                            title: response.error,
                            icon: "error",
                            button: "ok",
                        });
                        console.log(response.error);
                        $('#courseMultiModal').modal('hide');
                    } else {
                        swal.fire({
                            title: response.success,
                            icon: "success",
                            button: "ok",
                        });
                        console.log(response);
                        $('#courseMultiModal').modal('hide');
                    }
                },
                error: function(response) {
                    swal.fire({
                        title: "Something went wrong!",
                        icon: "danger"
                    });
                },
            });
        });
        $('#courseModal,#courseMultiModal').on('hidden.bs.modal', function() {
            $(this).find('form').trigger('reset');
            $(".se_ajax").val([]).trigger("change");
        })
    });

    // $('#cf_form').on('submit', function(e) {
    //     var html = '<h5 class="text-center mt-4 p-4">Searching...</h5>';
    //     e.preventDefault();
    //     $.ajaxSetup({
    //         headers: {
    //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //         }
    //     });
    //     $.ajax({
    //         url: "{{route('admin.coursemanagement.course-finder.get-result')}}",
    //         type: "POST",
    //         data: $('#cf_form').serialize(),
    //         success: function(response) {
    //             html = '';
    //             if (response.data.length > 0) {
    //                 html += '<div class="row"><div class="col-md-12 text-end"><a onclick="javascript:processBulkSuggest();" title="show" class="btn btn-sm btn-primary process-selected" style="margin-right:10px;display:none;"><i class="fa fa-arrow-circle-up"></i> Suggest to Student</a></div></div><div class="card-header d-flex justify-content-between bg-primary p-2 pt-3 mt-1 text-white"><p class="h6"><b>' + response.data.length + ' COURSE(S) FOUND</b></p><p class="mb-1" style="padding-right:12px;"><label style="vertical-align:super;">Select All</label> <input type="checkbox" onclick="javascript:check_allBox();" id="check_all" name="check_all" style="width:20px;height:20px;"></p></div>';
    //                 for (var count = 0; count < response.data.length; count++) {
    //                     var duration = "";
    //                     var intakes = "";
    //                     var tuition_fee_onshore = "";
    //                     if(response.data[count].duration){
    //                         var duration = response.data[count].duration;
    //                     }else{
    //                         var duration = "--";
    //                     }
    //                     if(response.data[count].intakes){
    //                         var intakes = response.data[count].intakes;
    //                     }else{
    //                         var intakes = "--";
    //                     }
    //                     if(response.data[count].tuition_fee_onshore){
    //                         var tuition_fee_onshore = response.data[count].tuition_fee_onshore;
    //                     }else{
    //                         var tuition_fee_onshore = "--";
    //                     }

    //                     var link = "{{url('admin/course-finder/course-details/')}}/" + response.data[count].id;
    //                     var uni_link = "{{url('admin/course-finder/university-details/')}}/" + response.data[count].uni_id;
    //                     html += '<div class="row mt-3 m-2">';
    //                     html += '<div class="col-10 "><h1 ><b><a class="text-primary" style="font-size: 24px !important;" href="' + link + '" target="_blank">' + response.data[count].course_name + '</a></b></h1>';
    //                     html += '<p class="mb-1"><b>ID:</b> ' + response.data[count].id + '</p>';
    //                     html += '<p class="mb-1"><b>University:</b> <a class="text-primary" target="_blank" href="'+uni_link+'">' + response.data[count].university_name + '</a></p>';
    //                     html += '<p class="mb-1"><b>Country:</b> ' + response.data[count].country + '</p>';
    //                     html += '<p class="mb-1"><b>Duration:</b> ' + duration + ' </p>';
    //                     html += '<p class="mb-1"><b>Intakes:</b> ' + intakes + '</p>';
    //                     html += '<p class="mb-1"><b>Tuition Fees:</b> ' + tuition_fee_onshore + '</p>';
    //                     html += '<p class="mb-1"><a data-toggle="modal" id="courseButton" data-target="#courseModal" data-id="' + response.data[count].id + '" title="show" class="btn btn-sm btn-warning"><i class="fa fa-arrow-circle-up"></i> Suggest to Student</a> <a data-toggle="modal" id="coursePreferenceButton" data-target="#coursePreferenceModal" data-id="' + response.data[count].id + '" title="Add to Student Course Preference" class="btn btn-sm btn-info"><i class="fa fa-plus"></i> Add to Student Course Preference</a></p>';
    //                     html += '<p class="mb-1"></p>';
    //                     html += '</div>';
    //                     html += '<div class="col-2 text-end"> Select <input type="checkbox" style="width:20px;height:15px;" onclick="javascript:checkboxCheckSelected();" name="multiselect" value="'+response.data[count].id+'"></div>';
    //                     html += '</div><hr>';
    //                     //console.log(response.data);
    //                 }
    //             } else {
    //                 html = '<h5 class="text-center p-5">No Data Found</h5>';
    //             }
    //             $('#result_body').html(html);
    //         },
    //         error: function(response) {

    //         },
    //     });
    //     $('#result_body').html(html);
    // });

    // $('#cf_form').on('submit', function(e) {
    // $('#cf_form').on('keyup change', function(e) {
        
    // $('#study_level,#category,#sub-cat,#country,#campus,#search_intake,#search_duration,#ielts_score,#IELTS_No_Less_input,#toefl_score,#TOEFL_No_Less_Input,#PTE_Score,#PTE_No_Less_input,#GRE_Score,#GMAT_Score,#course_university_search').on('keyup change', function(e) {
    $('#search_courses').on('click', function(e) {
        var html = '<h5 class="text-center mt-4 p-4">Searching...</h5>';
        e.preventDefault();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "{{route('admin.coursemanagement.course-finder.get-result')}}",
            type: "POST",
            data: $('#cf_form').serialize(),
            success: function(response) {
                html = '';
                if (response.data.length > 0) {
                    @if(!auth()->user()->isAgent())
                        html += '<div class="row mt-3"><div class="col-md-12 text-end"><a onclick="javascript:processBulkSuggest();" title="show" class="btn btn-sm btn-primary process-selected" style="margin-right:10px;display:none;"><i class="fa fa-arrow-circle-up"></i> Suggest to Student</a></div></div>';
                    @endif
                        html += '<div class="card-header d-flex justify-content-between bg-primary p-2 pt-3 mt-1 text-white"><p class="h6"><b>' + response.data.length + ' COURSE(S) FOUND</b></p>';
                    @if(!auth()->user()->isAgent())
                        html += '<p class="mb-1" style="padding-right:12px;"><label style="vertical-align:super;">Select All &nbsp;</label> <input type="checkbox" onclick="javascript:check_allBox();" id="check_all" name="check_all" style="width:15px;height:15px;"></p>';
                    @endif
                        html += '</div>';
                    for (var count = 0; count < response.data.length; count++) {
                        var duration = "";
                        var intakes = "";
                        var tuition_fee_onshore = "";
                        if(response.data[count].duration){
                            var duration = response.data[count].duration;
                        }else{
                            var duration = "--";
                        }
                        if(response.data[count].intakes){
                            var intakes = response.data[count].intakes;
                        }else{
                            var intakes = "--";
                        }
                        if(response.data[count].tuition_fee_onshore){
                            var tuition_fee_onshore = response.data[count].tuition_fee_onshore;
                        }else{
                            var tuition_fee_onshore = "--";
                        }
                        if(response.data[count].yearly_tuition_fee){
                            var yearly_tuition_fee = response.data[count].yearly_tuition_fee;
                        }else{
                            var yearly_tuition_fee = "--";
                        }
                        if(response.data[count].currency){
                            var currency = response.data[count].currency;
                        }else{
                            var currency = "";
                        }

                        var link = "{{url('admin/course-finder/course-details/')}}/" + response.data[count].id;
                        var uni_link = "{{url('admin/course-finder/university-details/')}}/" + response.data[count].uni_id;
                        html += '<div class="row mt-3 m-2">';
                        html += '<div class="col-10 "><h1 ><b><a class="text-primary" style="font-size: 24px !important;" href="' + link + '" target="_blank">' + response.data[count].course_name + '</a></b></h1>';
                        html += '<p class="mb-1"><b>ID:</b> ' + response.data[count].id + '</p>';
                        html += '<p class="mb-1"><b>University:</b> <a class="text-primary" target="_blank" href="'+uni_link+'">' + response.data[count].university_name + '</a></p>';
                        html += '<p class="mb-1"><b>Country:</b> ' + response.data[count].country + '</p>';
                        html += '<p class="mb-1"><b>Duration:</b> ' + duration + ' </p>';
                        html += '<p class="mb-1"><b>Intakes:</b> ' + intakes + '</p>';
                        html += '<p class="mb-1"><b>Tuition Fees:</b> ' +currency+' '+ yearly_tuition_fee + '</p>';

                        html += '<p class="mb-1">';
                            @if(!auth()->user()->isAgent())
                                html += '<a data-toggle="modal" id="courseButton" data-target="#courseModal" data-id="' + response.data[count].id + '" title="show" class="btn btn-sm btn-warning"><i class="fa fa-arrow-circle-up"></i> Suggest to Student</a> ';
                            @endif
                            html += '<a data-toggle="modal" id="coursePreferenceButton" data-target="#coursePreferenceModal" data-id="' + response.data[count].id + '" title="Add to Student Course Preference" class="btn btn-sm btn-info"><i class="fa fa-plus"></i> Add to Student Course Preference</a></p>';

                        html += '<p class="mb-1"></p>';
                        html += '</div>';
                        @if(!auth()->user()->isAgent())
                        html += '<div class="col-2 text-end"> Select <input type="checkbox" style="width:20px;height:15px;" onclick="javascript:checkboxCheckSelected();" name="multiselect" value="'+response.data[count].id+'"></div>';
                        @endif
                        html += '</div><hr>';
                        //console.log(response.data);
                    }
                    if(response.data.length == 200){
                        html += '<p><b>Notes: Maximum 200 results are shown</b></p>';
                    }
                } else {
                    html = '<h5 class="text-center p-5">No Data Found</h5>';
                }
                $('#result_body').html(html);
            },
            error: function(response) {

            },
        });
        $('#result_body').html(html);
    });


    $(document).on('click', '#courseButton', function(event) {
        event.preventDefault();
        let btn = $(this);
        let href = "{{url('admin/course-finder/course-info/')}}/" + $(this).attr('data-id');
        $.ajax({
            url: href,
            beforeSend: function() {
                btn.html('Wait...');
                btn.addClass('btn-secondary');
            },
            // return the result
            success: function(result) {
                //console.log(result);
                $('#courseModal').modal("show");
                $('#course_name').html(result.data['course_name']).show();
                $('#course_uni').html(result.data['course_uni']).show();
                $('#course_country').html(result.data['course_country']).show();
                $('#assign_course').val(result.data['id']).show();
                //$('#assign_course_country').val(result.data['course_country']).show();
                //$('#assign_course_uni').val(result.data['course_uni']).show();
                // lenmo = result.data['course_months'].length;
                // $("#cors_month").html('');
                // $("#cors_month").append("<option value=''>Select Month</option>");
                // for (var j = 0; j < lenmo; j++) {
                //     var moname = result.data['course_months'][j]['moName'];
                //     var monum = result.data['course_months'][j]['moNum'];
                //     var mooption = "<option value='" + monum + "'>" + moname + "</option>";
                //     $("#cors_month").append(mooption);
                // }

                // len = result.data['course_years'].length;
                // $("#cors_year").html('');
                // $("#cors_year").append("<option value=''>Select Year</option>");
                // for (var i = 0; i < len; i++) {
                //     var name = result.data['course_years'][i];
                //     var option = "<option value='" + name + "'>" + name + "</option>";
                //     $("#cors_year").append(option);
                // }
            },
            complete: function() {
                btn.html('<i class="fa fa-arrow-circle-up"></i> Suggest to Student');
                btn.removeClass('btn-secondary');
            },
            error: function(jqXHR, testStatus, error) {
                console.log(error);
                alert("Page " + href + " cannot open. Error:" + error);
                btn.html('<i class="fa fa-arrow-circle-up"></i> Suggest to Student');
                btn.removeClass('btn-secondary');
            },
            timeout: 8000
        })
    });

    $(document).on('click', '#coursePreferenceButton', function(event) {
        event.preventDefault();
        let btn = $(this);
        let href = "{{url('admin/course-finder/course-info/')}}/" + $(this).attr('data-id');
        $.ajax({
            url: href,
            beforeSend: function() {
                btn.html('Wait...');
                btn.addClass('btn-secondary');
            },
            // return the result
            success: function(result) {
                $('#coursePreferenceModal').modal("show");
                $('#course_preference_name').html(result.data['course_name']).show();
                $('#course_preference_uni').html(result.data['course_uni']).show();
                $('#course_preference_country').html(result.data['course_country']).show();
                
                $('#assign_preference_course_id').val(result.data['id']).show();
                $('#assign_course_preference_country').val(result.data['university_country_id']).show();
                $('#assign_course_preference_uni').val(result.data['university_id']).show();
                //$('#assign_course_country').val(result.data['course_country']).show();
                //$('#assign_course_uni').val(result.data['course_uni']).show();
                lenmo = result.data['course_months'].length;
                $("#cors_month").html('');
                $("#cors_month").append("<option value=''>Select Month</option>");
                for (var j = 0; j < lenmo; j++) {
                    var moname = result.data['course_months'][j]['moName'];
                    var monum = result.data['course_months'][j]['moNum'];
                    var mooption = "<option value='" + monum + "'>" + moname + "</option>";
                    $("#cors_month").append(mooption);
                }

                len = result.data['course_years'].length;
                $("#cors_year").html('');
                $("#cors_year").append("<option value=''>Select Year</option>");
                for (var i = 0; i < len; i++) {
                    var name = result.data['course_years'][i];
                    var option = "<option value='" + name + "'>" + name + "</option>";
                    $("#cors_year").append(option);
                }
            },
            complete: function() {
                btn.html('<i class="fa fa-plus"></i> Add to Student Course Preference');
                btn.removeClass('btn-secondary');
            },
            error: function(jqXHR, testStatus, error) {
                console.log(error);
                alert("Page " + href + " cannot open. Error:" + error);
                btn.html('<i class="fa fa-plus"></i> Add to Student Course Preference');
                btn.removeClass('btn-secondary');
            },
            timeout: 8000
        })
    });

    $('#IELTS_No_Less').mouseover(function(){
        $("#IELTS_No_Less_Label").text("IELTS No Band Less Than");
        $("#IELTS_No_Less_Label").css("text-wrap", "nowrap");
    });
    $('#IELTS_No_Less').mouseout(function(){
        $("#IELTS_No_Less_Label").text("IELTS No Less..");
    });

    $('#TOEFL_No_Less').mouseover(function(){
        $("#TOEFL_No_Less_Label").text("TOEFL No Band Less Than");
        $("#TOEFL_No_Less_Label").css("text-wrap", "nowrap");
    });
    $('#TOEFL_No_Less').mouseout(function(){
        $("#TOEFL_No_Less_Label").text("TOEFL No Less..");
    });

    $('#PTE_No_Less').mouseover(function(){
        $("#PTE_No_Less_Label").text("PTE No Band Less Than");
        $("#PTE_No_Less_Label").css("text-wrap", "nowrap");
    });
    $('#PTE_No_Less').mouseout(function(){
        $("#PTE_No_Less_Label").text("PTE No Less..");
    });

    function check_allBox() {
        if ($("input:checkbox[name='check_all']").prop("checked")) {
            $("input:checkbox[name='multiselect']").prop("checked", true);
        } else {
            $("input:checkbox[name='multiselect']").prop("checked", false);
        }
        checkboxCheckSelected();
    }

    function checkboxCheckSelected() {
        var total_check_boxes = $("input:checkbox[name='multiselect']").length;
        var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
        if (total_check_boxes === total_checked_boxes) {
            $("#check_all").prop("checked", true);
        } else {
            $("#check_all").prop("checked", false);
        }
        if (total_checked_boxes > 0) {
            $(".process-selected").show();
        } else {
            $(".process-selected").hide();
        }
    }

    function processBulkSuggest() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        //let btn = $(this);
        //let href = "{{url('admin/course-finder/course-info/')}}/" + $(this).attr('data-id');
        // $.ajax({
        //     url: href,
        //     beforeSend: function() {
        //         btn.html('Wait...');
        //         btn.addClass('btn-secondary');
        //     },
            
            //success: function(result) {
                //console.log(result);
                $('#courseMultiModal').modal("show");
                //$('#course_name').html(result.data['course_name']).show();
                //$('#course_uni').html(result.data['course_uni']).show();
                //$('#course_country').html(result.data['course_country']).show();
                $('#assign_multi_course').val(dataArray).show();
           // },
           // complete: function() {
                // btn.html('Suggest to Student');
                // btn.removeClass('btn-secondary');
            //},
            // error: function(jqXHR, testStatus, error) {
            //     console.log(error);
            //     alert("Page " + href + " cannot open. Error:" + error);
            //     btn.html('Suggest to Student');
            //     btn.removeClass('btn-secondary');
            // },
            // timeout: 8000
       // })
    }

</script>
@endpush

@push('after-styles')
<style>
    .select2-container {
        width: 100% !important;
    }

    .select2-container.select2-container--default.select2-container--open {
        z-index: 5000;
    }
    .select2-selection {
        padding: 0px!important;
    }
    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        vertical-align: baseline!important;
    }
</style>
@endpush