@extends('backend.layouts.app')
@section('title', "University Course Finder")
<style>
/* table.dataTable tbody tr.selected>* {
    box-shadow: inset 0 0 0 9999px rgb(197, 211, 255) !important;
} */ 
</style>
<link href="https://cdn.datatables.net/select/1.3.3/css/select.dataTables.min.css" rel="stylesheet" />
@section('content')
<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col" style="margin-bottom:10px;">
                <h4 style="">University Course Finder</h4>
            </div>
        </div>

        <div class="row mt-3 mb-2 card">
            <div class="col-12 card-body p-3">
                <div class="row">
                    <div class="col-md-3">
                        <label class="fw-bold text-dark">Study Level</label>
                        <select class="form-select form-control" name="study_level" id="study_level" style="height: 42px;">
                            {{-- <option hidden>Select Study Level</option> --}}
                            @foreach(get_study_levels() as $level)
                                <option value="{{$level}}" @if($level == "Undergraduate")selected @endif>{{ $level }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label>Select Country</label>
                        <select name="country[]" id="country" class="form-control form-select select2 select2country" style="height: 10px !important;" multiple>
                            @foreach($countries as $key => $country)
                            <option value="{{$key}}">{{ $country }}</option>
                            @endforeach
                        </select>
                    </div>
            
                    <div class="col-md-6">
                        <label>Enter a Keyword</label>
                        <input type="search" style="height: 41px;" id="course" class="form-control" placeholder="Search a Course, University...">
                    </div>
                    <div class="col-12 align-self-center mt-3">
                        <div class="row justify-content-center">
                            <div class="col-6 text-center">
                                <button type="button" id="search_btn" class="btn btn-primary">Search</button>
                                <button type="button" onClick="window.location.reload();" class="btn btn-outline-primary">Clear</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-12 text-start">
                <a onclick="javascript:processBulkSuggest();" title="show" class="btn btn-sm btn-primary process-selected" style="margin-right:10px;display:none;"><i class="fa fa-arrow-circle-up"></i> Suggest to Student</a>
                <div class="btn-group process-selected" role="group" aria-label="Button group" style="display:none;">
                    <form method="post" action="{{route('admin.coursemanagement.course-download')}}" class="mb-0">
                    <div class="dropdown">
                        @csrf
                        <a class="btn btn-primary btn-sm dropdown-toggle" href="#" onclick="javascript:processBulkDownload();" role="button" id="breadcrumb-dropdown-1" data-bs-toggle="dropdown" aria-expanded="true">Download</a>
                        <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end" aria-labelledby="breadcrumb-dropdown-1">
                            <input type="hidden" name="download_multi_course" id="download_multi_course" value="">
                            <button class="dropdown-item mb-0" type="submit" name="btn_pdf" value="1"><i class="bi bi-file-earmark-pdf"></i> PDF</button>
                            <button class="dropdown-item mb-0" type="submit" name="btn_xls" value="1"><i class="bi bi-file-earmark-excel"></i> XLS</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
                
        <div class="row mt-4">
            <div class="col-3 card py-3" id="side_filters" style="display: none">
                <div class="row">
                    <div class="col-md-12">
                        <label class="form-label fw-bold">Select Student</label>
                        <select class="form-control select2_ajax" name="student_id" required></select>
                    </div>
                    
                    <div class="col-md-12 mt-2">
                        <label for="filterstudyArea" class="form-label mb-0 fw-bold">Study Area</label>
                        <select class="form-select" id="filterstudyArea">
                            <option value="">Study Area</option>
                            @foreach($categories as $cat)
                                <option {{(isset(Session::get('course_finder_filters')['study_area']) && Session::get('course_finder_filters')['study_area'] == $cat->id) ? 'selected' : ''}} value="{{ $cat->id }}">{{ $cat->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-12 mt-3">
                        <label for="filterdisciplineArea" class="form-label mb-0 fw-bold">Discipline Area</label>
                        <select class="form-select" id="filterdisciplineArea">
                            <option value="">Any</option>
                        </select>
                    </div>
                    
                    <hr class="mt-4" style="height:2px;border-width:0;background-color:#49494982;">
                    <div class="col-md-12 mt-2">
                        <label for="search_intake" class="form-label mb-0 fw-bold">Intake</label>
                        <select class="form-select select2" style="width:100%;" name="intake[]" id="search_intake" multiple="multiple">
                                {{-- <option value="">Any</option> --}}
                                <option value="Jan">January</option>
                                <option value="Feb">February</option>
                                <option value="Mar">March</option>
                                <option value="Apr">April</option>
                                <option value="May">May</option>
                                <option value="Jun">June</option>
                                <option value="Jul">July</option>
                                <option value="Aug">August</option>
                                <option value="Sep">September</option>
                                <option value="Oct">October</option>
                                <option value="Nov">November</option>
                                <option value="Dec">December</option>
                                <option value="Spring">Spring</option>
                                <option value="Summer">Summer</option>
                                <option value="Fall">Fall</option>
                                <option value="Winter">Winter</option>
                        </select>
                    </div>
                    <div class="col-md-12 mt-3">
                        <label for="search_duration" class="form-label mb-0 fw-bold">Duration</label>
                        <select class="form-select fltrs" id="search_duration">
                            <option value="">Any</option>
                            <option value="12">0-1 year</option>
                            <option value="24">1-2 years</option>
                            <option value="36">2-3 years</option>
                            <option value="48">3-4 years</option>
                            <option value="60">4+ years</option>
                        </select>
                    </div>
                    <hr class="mt-4" style="height:2px;border-width:0;background-color:#49494982;">

                    <div class="col-md-12 mt-2">
                        <div class="dropdown">
                            <label for="filterdisciplineArea" class="form-label mb-0 fw-bold">Sort</label>
                            <select name="sort_by" id="sort_by" class="form-select">
                                <option value="">Sort By</option>
                                <option value="ielts_lth">IELTS Score Low to High</option>
                                <option value="ielts_htl">IELTS Score High to Low</option>
                                <option value="course_name">Course Name</option>
                                <option value="fee_lth">Course Fee Low to High</option>
                                <option value="fee_htl">Course Fee High to Low</option>
                            </select>
                        </div>
                    </div>
                    <hr class="mt-4" style="height:2px;border-width:0;background-color:#49494982;">

                    <div class="col-md-12 mt-2">
                        <div class="accordion" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne" style="">
                                    IELTS Score 
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show">
                                    <div class="accordion-body py-3 px-2">
                                        <div class="col-12">
                                            <label for="ielts_score" class="form-label mb-0" style="font-weight: 400;">IELTS Score</label>
                                            <input class="form-control " type="number" id="ielts_score" step="0.5" placeholder="IELTS Score" name="ielts" value="">
                                        </div>
                                        <div class="col-md-12 mt-3">
                                            <label for="ielts_no_band_score" class="form-label mb-0" style="font-weight: 400;">IELTS No Band Less Than</label>
                                            <input type="number" id="ielts_no_band_score" step="0.5" placeholder="IELTS No Band Less Than" name="ielts_no_band" value="" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo" style="">
                                        TOEFL Score
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse">
                                    <div class="accordion-body py-3 px-2">
                                        <div class="col-md-12">
                                            <label for="toefl_score" class="form-label mb-0" style="font-weight: 400;">TOEFL Score</label>
                                            <input type="number" id="toefl_score" step="1" placeholder="TOEFL Score" name="toefl" value="" class="form-control">
                                        </div>
                        
                                        <div class="col-md-12 mt-3">
                                            <label for="toefl_no_band_score" class="form-label mb-0" style="font-weight: 400;">TOEFL No Band Less Than</label>
                                            <input type="number" id="toefl_no_band_score" step="1" placeholder="TOEFL No Band Less Than" name="toefl_no_band" value="" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree" style="">
                                    PTE Scores
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse">
                                    <div class="accordion-body py-3 px-2">
                                        <div class="col-md-12 ">
                                            <label for="pte_score" class="form-label mb-0" style="font-weight: 400;">PTE Score</label>
                                            <input type="number" id="pte_score" step="1" placeholder="PTE Score" name="pte" value="" class="form-control">
                                        </div>
                        
                                        <div class="col-md-12 mt-3">
                                            <label for="pte_no_band_score" class="form-label mb-0" style="font-weight: 400;">PTE No Band Less Than</label>
                                            <input type="number" id="pte_no_band_score" step="1" placeholder="PTE No Band Less Than" name="pte_no_band" value="" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour" style="">
                                    GRE/ GMAT Scores
                                    </button>
                                </h2>
                                <div id="collapseFour" class="accordion-collapse collapse" >
                                    <div class="accordion-body py-3 px-2">
                                        <div class="col-md-12">
                                            <label for="gre_score" class="form-label mb-0" style="font-weight: 400;">GRE Score</label>
                                            <input type="number" id="gre_score" step="1" placeholder="GRE Score" name="gre" value="" class="form-control">
                                        </div>
                        
                                        <div class="col-md-12 mt-3">
                                            <label for="gmat_score" class="form-label mb-0" style="font-weight: 400;">GMAT Score</label>
                                            <input type="number" id="gmat_score" step="1" placeholder="GMAT Score" name="gmat" value="" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-9" id="result_table" style="display: none;">
                <div class="card">
                    <div class="card-body">
                    <div class="row">
                        <h3 id="default_txt" class="mt-5 text-center">Select a Country and Study Level to search!</h3>
                        <div class="table-responsive mt-2"> 
                            <table class="table w-100 fixTableHead border-none" id="course_list">
                                <thead >
                                    <tr>
                                        <th data-orderable="false">
                                            <div class="form-check form-check-sm form-check-custom form-check-solid ms-2">
                                                <input class="form-check-input" type="checkbox" id="check_all" onclick="javascript:check_allBox();" name="check_all" /> <label class="form-check-label pt-1" for="check_all">Select All</label>
                                            </div>
                                        </th>
                                        <th style="display: none;">Course</th>
                                        <th style="display: none;">University</th>
                                        <th style="display: none;">Country</th>
                                        <th style="display: none;">Study Level</th>
                                        <th style="display: none;">Duration</th>
                                        <th style="display: none;">Intakes</th>
                                        <th style="display: none;">Application Fees</th>
                                        <th style="display: none;">Tuition Fees</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- @foreach ($courses as $course)
                                        <tr>
                                            <td style="display: none;">{{ $course->course_name }}</td>
                                            <td style="display: none;">{{ $course->university->name ?? 'N/A' }}</td>
                                            <td style="display: none;">{{ $course->country ?? 'N/A' }}</td>
                                            <td style="display: none;">{{ $course->study_level ?? 'N/A' }}</td>
                                            <td style="display: none;">{{ $course->duration ?? 'N/A' }}</td>
                                            <td style="display: none;">{{ $course->intakes ?? 'N/A' }}</td>
                                            <td style="display: none;">{{ $course->application_fee ?? 'N/A' }}</td>
                                            <td style="display: none;">{{ $course->tuition_fee ?? 'N/A' }}</td>
                                        </tr>
                                    @endforeach --}}
                                </tbody>
                            </table> 
                        </div>
                    </div> 
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="main_student_id" id="main_student_id">
    </div>

    <div class="modal fade" id="courseModal" role="dialog" aria-labelledby="courseModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Suggest Course to Student</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="courseBody">
                    <p><b>Course:</b> <span id="course_name"></span></p>
                    <p><b>University:</b> <span id="course_uni"></span></p>
                    <p><b>Country:</b> <span id="course_country"></span></p>
                    <hr>
                    <form id="assign_form">
                        <input type="hidden" id="assign_course" name="assign_course" value="">
                        <!-- <input type="hidden" id="assign_course_country" name="assign_course_country" value="">
                        <input type="hidden" id="assign_course_uni" name="assign_course_uni" value=""> -->
                        <div class="row stu_sel_row">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Select Student</label>
                                <select class="se_ajax" data-dropdown-parent="#courseModal" id="stu_id" name="student_id" required></select>
                            </div>
                        </div>
                        <div class="row stu_show_row" style="display: none;">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Student</label> <br>
                                <span class="stu_name"></span> <br>
                                <span class="stu_email"></span> <br>
                                <span class="stu_study_level"></span> <br>
                            </div>
                        </div>
                        <!-- <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Intake Month</label>
                                <select name="intake_month" id="cors_month" class="form-select" required>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Intake Year</label>
                                <select name="intake_year" id="cors_year" class="form-select" required>
                                </select>
                            </div>
                        </div> -->
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <input type="submit" class="btn btn-primary" value="Suggest">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="coursePreferenceModal" role="dialog" aria-labelledby="coursePreferenceModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add to Student Course Preference</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="courseBody">
                    <p><b>Course:</b> <span id="course_preference_name"></span></p>
                    <p><b>University:</b> <span id="course_preference_uni"></span></p>
                    <p><b>Country:</b> <span id="course_preference_country"></span></p>
                    <hr>
                    <form id="assign_course_preference_form">
                        <input type="hidden" id="assign_preference_course_id" name="assign_preference_course_id" value="">
                        <input type="hidden" id="assign_course_preference" name="assign_course_preference" value="">
                        <input type="hidden" id="assign_course_preference_country" name="assign_course_preference_country" value="">
                        <input type="hidden" id="assign_course_preference_uni" name="assign_course_preference_uni" value=""> 
                        {{-- <input type="hidden" id="assign_course_preference_intake" name="assign_course_preference_intake" value="">  --}}
                        <div class="row stu_sel_row">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Select Student</label>
                                <select class="se_ajax" data-dropdown-parent="#coursePreferenceModal" id="course_preference_stu_id" name="course_preference_stu_id" required></select>
                            </div>
                        </div>
                        <div class="row stu_show_row" style="display: none;">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Student</label> <br>
                                <span class="stu_name"></span> <br>
                                <span class="stu_email"></span> <br>
                                <span class="stu_study_level"></span> <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <label for="intake" class="required-field">Intake</label>
                                <select name="intake" style="width:100%;" id="intake" class="form-select form-control select2" required>
                                    <option value="">Intake</option>
                                    <?php $month = date('n'); // current month
                                    for ($x = 0; $x < 24; $x++) { ?>
                                    <option value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                                    <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                                    <?php } ?></option>
                                </select>
                            </div>
                        </div>
                        {{-- <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <label>Intake Month</label>
                                <select name="intake_month" id="cors_month" class="form-select">
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <label>Intake Year</label>
                                <select name="intake_year" id="cors_year" class="form-select">
                                </select>
                            </div>
                        </div> --}}
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <input type="submit" class="btn btn-primary" value="Add Course Preference">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="courseMultiModal" role="dialog" aria-labelledby="courseMultiModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Suggest Selected Courses to Student</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="courseBody">
                    {{-- <p><b>Course:</b> <span id="course_name"></span></p>
                    <p><b>University:</b> <span id="course_uni"></span></p>
                    <p><b>Country:</b> <span id="course_country"></span></p> --}}
                    {{-- <hr> --}}
                    <form id="assign_multi_form">
                        <input type="hidden" id="assign_multi_course" name="assign_course" value="">
                        <div class="row stu_sel_row">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Select Student</label>
                                <select class="se_ajax" data-dropdown-parent="#courseMultiModal" id="multi_stu_id" name="student_id" required></select>
                            </div>
                        </div>
                        <div class="row stu_show_row" style="display: none;">
                            <div class="col-sm-12 col-md-12">
                                <label class="required-field">Student</label> <br>
                                <span class="stu_name"></span> <br>
                                <span class="stu_email"></span> <br>
                                <span class="stu_study_level"></span> <br>
                            </div>
                        </div>
        
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <input type="submit" class="btn btn-primary" value="Suggest">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap Modal -->
    <div class="modal fade" id="commissionModal" tabindex="-1" aria-labelledby="commissionModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="commissionModalLabel">Your Commission</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><strong>Commission Amount:</strong> <span id="commissionValue"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('after-scripts')
<script src="https://cdn.datatables.net/select/1.3.3/js/dataTables.select.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(".select2country").select2({
            placeholder: "Select Country",
        });

        // Attach click event to .commissionModal links dynamically
        $(document).on("click", ".commissionModal", function (e) {
            e.preventDefault(); // prevent page jump
            let commissionValue = $(this).data("commission");
            let commission_detail = $(this).data("commission_detail");
            commissionValue = `${commissionValue} ${commission_detail}`;
            $("#commissionValue").html(commissionValue);
        });

        // $('#study_level').trigger('keyup');
        $('#filterstudyArea').on('change', function() {
            var idCat = this.value;
            $("#filterdisciplineArea").html('');
            $.ajax({
                url: "{{route('frontend.fetchSubCat')}}",
                type: "POST",
                data: {
                    category_id: idCat,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    
                    $('#filterdisciplineArea').html('<option value="">Any</option>');
                    $.each(result.subcategories, function(key, value) {
                        if(value.id == "{{(isset(Session::get('course_finder_filters')['discipline_area']))? Session::get('course_finder_filters')['discipline_area'] : ''}}"){
                            var selectedSubCat = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedSubCat = "";
                        }
                        $("#filterdisciplineArea").append('<option '+selectedSubCat +' value="' + value
                            .id + '">' + value.title + '</option>');
                    });
                },
                async: true,
            });
    });

        // var html = '';
        // $('#category').on('change', function() {
        //     var idCat = this.value;
        //     $("#sub-cat").html('');
        //     $.ajax({
        //         url: "{{route('admin.coursemanagement.fetchSubCat')}}",
        //         type: "POST",
        //         data: {
        //             category_id: idCat,
        //             _token: '{{csrf_token()}}'
        //         },
        //         dataType: 'json',
        //         success: function(result) {
        //             $('#sub-cat').html('<option value="">Select Discipline Area</option>');
        //             $.each(result.subcategories, function(key, value) {
        //                 $("#sub-cat").append('<option value="' + value
        //                     .id + '">' + value.title + '</option>');
        //             });
        //         }
        //     });
        // });

        // $('#country').on('change', function() {
        //     var idCountry = this.value;
        //     $("#campus").html('');
        //     $.ajax({
        //         url: "{{route('admin.coursemanagement.fetchCampus')}}",
        //         type: "POST",
        //         data: {
        //             country_id: idCountry,
        //             _token: '{{csrf_token()}}'
        //         },
        //         dataType: 'json',
        //         success: function(result) {
        //             $('#campus').html('<option value="">Select Campus/City</option>');
        //             if(Array.isArray(result.campus)){
        //                 $.each(result.campus, function(key, value) {
        //                     $("#campus").append('<option value="' + value
        //                         .campus + '">' + value.campus + '</option>');
        //                 });
        //             }
        //         }
        //     });
        // });

        $('.select2_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.search.my.student") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $(".select2_ajax").on("select2:close", function() {
            $(".study_levels").prop('checked', false).trigger('change');
            $.ajax({
                url: '{{ route("admin.search.my.studentData") }}',
                type: "post",
                data: {
                    id: $(this).val(),
                    _token: '{{csrf_token()}}'
                },
                success: function(data) {
                    $("#study_level").val(data.results.overseas_study_level_selection);
                    $('.stu_name').html(data.results.full_name);
                    $('.stu_email').html(data.results.email);
                    $('.stu_study_level').html(data.results.overseas_study_level);
                    // $("#country").val(data.country_interested).trigger('change');
                    // $("input[value='" + data.results.overseas_study_level_selection + "']").trigger("click");
                    
                    $("#search_intake").val(data.intake_month).trigger('change');
                }
            });
        });

        $('.se_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.search.my.student") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $('#assign_course_preference_form').on('submit', function(e) {
            e.preventDefault();
            let assign_preference_course_id = $('#assign_preference_course_id').val();
            let assign_course = $('#assign_course_preference').val();
            let assign_course_country = $('#assign_course_preference_country').val();
            let assign_course_uni = $('#assign_course_preference_uni').val();
            let stu_id = $('#course_preference_stu_id').val();
            if($("#main_student_id").val()!=""){
                stu_id = $("#main_student_id").val();
            }
            let intake = $('#intake').val();
            let from_course_preference = 1;
            let assign_url = "{{route('admin.studyabroad.coursepref.save')}}";
            $.ajax({
                url: assign_url,
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    course: assign_preference_course_id,
                    country: assign_course_country,
                    university: assign_course_uni,
                    user_id: stu_id,
                    intake: intake,
                    from_course_preference: from_course_preference,
                },
                success: function(response) {
                    if (response.error) {
                        swal.fire({
                            title: response.error,
                            icon: "error",
                            button: "ok",
                        });
                        console.log(response.error);
                        $('#coursePreferenceModal').modal('hide');
                    } else {
                        swal.fire({
                            title: response.success,
                            icon: "success",
                            button: "ok",
                        });
                        console.log(response);
                        $('#coursePreferenceModal').modal('hide');
                    }
                },
                error: function(response) {
                    swal.fire({
                        title: "Something went wrong!",
                        icon: "danger"
                    });
                },
            });
        });

        $('#assign_multi_form').on('submit', function(e) {
            e.preventDefault();
            let assign_course = $('#assign_multi_course').val();
            let is_multi = "1";
            let stu_id = $('#multi_stu_id').val();
            if($("#main_student_id").val()!=""){
                stu_id = $("#main_student_id").val();
            }
            let assign_url = "{{route('admin.coursemanagement.suggestcourse')}}";
            $.ajax({
                url: assign_url,
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    assign_course: assign_course,
                    is_multi : is_multi,
                    stu_id: stu_id,
                },
                success: function(response) {
                    if (response.error) {
                        swal.fire({
                            title: response.error,
                            icon: "error",
                            button: "ok",
                        });
                        console.log(response.error);
                        $('#courseMultiModal').modal('hide');
                    } else {
                        swal.fire({
                            title: response.success,
                            icon: "success",
                            button: "ok",
                        });
                        console.log(response);
                        $('#courseMultiModal').modal('hide');
                    }
                },
                error: function(response) {
                    swal.fire({
                        title: "Something went wrong!",
                        icon: "danger"
                    });
                },
            });
        });
        $('#courseModal,#courseMultiModal').on('hidden.bs.modal', function() {
            $(this).find('form').trigger('reset');
            $(".se_ajax").val([]).trigger("change");
        })
    });

    $(document).on('click', '#courseButton', function(event) {
        event.preventDefault();
        let btn = $(this);
        let href = "{{url('admin/course-finder/course-info/')}}/" + $(this).attr('data-id');
        $.ajax({
            url: href,
            beforeSend: function() {
                btn.html('Wait...');
                btn.addClass('btn-secondary');
            },
            // return the result
            success: function(result) {
                if($(".select2_ajax").val()!=null){
                var sel_stu_id = $('.select2_ajax').val();
                    $(".stu_sel_row").hide();
                    $(".stu_show_row").show();
                    $("#stu_id").attr('required',false);
                    $("#main_student_id").val(sel_stu_id);
                }else{
                    $(".stu_show_row").hide();
                    $("#stu_id").attr('required',true);
                    $(".stu_sel_row").show();
                }
                //console.log(result);
                $('#courseModal').modal("show");
                $('#course_name').html(result.data['course_name']).show();
                $('#course_uni').html(result.data['course_uni']).show();
                $('#course_country').html(result.data['course_country']).show();
                $('#assign_course').val(result.data['id']).show();
            },
            complete: function() {
                btn.html('<i class="fa fa-arrow-circle-up"></i> Suggest to Student');
                btn.removeClass('btn-secondary');
            },
            error: function(jqXHR, testStatus, error) {
                console.log(error);
                alert("Page " + href + " cannot open. Error:" + error);
                btn.html('<i class="fa fa-arrow-circle-up"></i> Suggest to Student');
                btn.removeClass('btn-secondary');
            },
            timeout: 8000
        })
    });

    $('#assign_form').on('submit', function(e) {
            e.preventDefault();
            let assign_course = $('#assign_course').val();
            let stu_id = $('#stu_id').val();
            if($("#main_student_id").val()!=""){
                stu_id = $("#main_student_id").val();
            }
            let assign_url = "{{route('admin.coursemanagement.suggestcourse')}}";
            $.ajax({
                url: assign_url,
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    assign_course: assign_course,
                    stu_id: stu_id,
                },
                success: function(response) {
                    if (response.error) {
                        swal.fire({
                            title: response.error,
                            icon: "error",
                            button: "ok",
                        });
                        console.log(response.error);
                        $('#courseModal').modal('hide');
                    } else {
                        swal.fire({
                            title: response.success,
                            icon: "success",
                            button: "ok",
                        });
                        console.log(response);
                        $('#courseModal').modal('hide');
                    }
                },
                error: function(response) {
                    swal.fire({
                        title: "Something went wrong!",
                        icon: "danger"
                    });
                },
            });
        });

    $(document).on('click', '#coursePreferenceButton', function(event) {
        event.preventDefault();
        let btn = $(this);
        let href = "{{url('admin/course-finder/course-info/')}}/" + $(this).attr('data-id');
        $.ajax({
            url: href,
            beforeSend: function() {
                btn.html('Wait...');
                btn.addClass('btn-secondary');
            },
            // return the result
            success: function(result) {
                if($(".select2_ajax").val()!=null){
                var sel_stu_id = $('.select2_ajax').val();
                    $(".stu_sel_row").hide();
                    $(".stu_show_row").show();
                    $("#course_preference_stu_id").attr('required',false);
                    $("#main_student_id").val(sel_stu_id);
                }else{
                    $(".stu_show_row").hide();
                    $("#course_preference_stu_id").attr('required',true);
                    $(".stu_sel_row").show();
                }
                $('#coursePreferenceModal').modal("show");
                $('#course_preference_name').html(result.data['course_name']).show();
                $('#course_preference_uni').html(result.data['course_uni']).show();
                $('#course_preference_country').html(result.data['course_country']).show();
                $('#assign_preference_course_id').val(result.data['id']).show();
                $('#assign_course_preference_country').val(result.data['university_country_id']).show();
                $('#assign_course_preference_uni').val(result.data['university_id']).show();
                lenmo = result.data['course_months'].length;
                $("#cors_month").html('');
                $("#cors_month").append("<option value=''>Select Month</option>");
                for (var j = 0; j < lenmo; j++) {
                    var moname = result.data['course_months'][j]['moName'];
                    var monum = result.data['course_months'][j]['moNum'];
                    var mooption = "<option value='" + monum + "'>" + moname + "</option>";
                    $("#cors_month").append(mooption);
                }
                len = result.data['course_years'].length;
                $("#cors_year").html('');
                $("#cors_year").append("<option value=''>Select Year</option>");
                for (var i = 0; i < len; i++) {
                    var name = result.data['course_years'][i];
                    var option = "<option value='" + name + "'>" + name + "</option>";
                    $("#cors_year").append(option);
                }
            },
            complete: function() {
                btn.html('<i class="fa fa-plus"></i> Add to Student Course Preference');
                btn.removeClass('btn-secondary');
            },
            error: function(jqXHR, testStatus, error) {
                console.log(error);
                alert("Page " + href + " cannot open. Error:" + error);
                btn.html('<i class="fa fa-plus"></i> Add to Student Course Preference');
                btn.removeClass('btn-secondary');
            },
            timeout: 8000
        })
    });

    $('#IELTS_No_Less').mouseover(function(){
        $("#IELTS_No_Less_Label").text("IELTS No Band Less Than");
        $("#IELTS_No_Less_Label").css("text-wrap", "nowrap");
    });
    $('#IELTS_No_Less').mouseout(function(){
        $("#IELTS_No_Less_Label").text("IELTS No Less..");
    });

    $('#TOEFL_No_Less').mouseover(function(){
        $("#TOEFL_No_Less_Label").text("TOEFL No Band Less Than");
        $("#TOEFL_No_Less_Label").css("text-wrap", "nowrap");
    });
    $('#TOEFL_No_Less').mouseout(function(){
        $("#TOEFL_No_Less_Label").text("TOEFL No Less..");
    });

    $('#PTE_No_Less').mouseover(function(){
        $("#PTE_No_Less_Label").text("PTE No Band Less Than");
        $("#PTE_No_Less_Label").css("text-wrap", "nowrap");
    });
    $('#PTE_No_Less').mouseout(function(){
        $("#PTE_No_Less_Label").text("PTE No Less..");
    });
</script>
<script type="text/javascript">
    loadData()
    $(".select2stats").select2({
        placeholder: "Select Intakes",
    });

    function loadData(myCourses) {
        $("#default_txt").hide();
        $("#result_table,#side_filters").show();
        var table = $('#course_list').DataTable({
            dom: '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: ""
            },
            searching:false,
            autoWidth: true,
            responsive: true,
            pageLength: 25,
            "lengthMenu": [25,50, 100, 200],
            "ajax": {
                "url": "{{route('admin.ajaxcoursefinderlist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'course_university_search': $('#course_university_search').val(),
                    'course': $('#course').val(),
                    'country': $('#country').val(),
                    // 'category': $('#category').val(),
                    // 'sub_category': $('#sub-cat').val(),
                    'universities': $('#universities').val(),
                    'filterstudyArea': $('#filterstudyArea').val(),
                    'filterdisciplineArea': $('#filterdisciplineArea').val(),
                    'sort_by': $('#sort_by').val(),
                    'study_level': $('#study_level').val(),
                    'search_intake': $('#search_intake').val(),
                    'search_duration': $('#search_duration').val(),
                    'campus': $('#campus').val(),

                    'toefl': $('#toefl_score').val(),
                    'toefl_no_band': $('#toefl_no_band_score').val(),
                    'ielts_no_band': $('#ielts_no_band_score').val(),
                    'ielts': $('#ielts_score').val(),
                    'pte': $('#pte_score').val(),
                    'pte_no_band': $('#pte_no_band_score').val(),
                    'gre': $('#gre_score').val(),
                    'gmat': $('#gmat_score').val(),
                },
            },
            columns: [
                {
                    data: 'course_name',
                },
                {
                    data: 'course',
                    visible: false,
                },
                {
                    data: 'university',
                    visible: false,
                },   
                {
                    data: 'country',
                    visible: false,
                },     
                {
                    data: 'study_level',
                    visible: false,
                }, 
                {
                    data: 'duration',
                    visible: false,
                }, 
                {
                    data: 'intakes',
                    visible: false,
                }, 
                {
                    data: 'application_fees',
                    visible: false,
                }, 
                {
                    data: 'tution_fees',
                    visible: false,
                }, 
            ],
            order: [[0, 'asc']],
            columnDefs: [{
                    orderable: false,
                    targets: 0,
                }
            ],
            @if(isset($search) && strlen($search))
                "search": {
                    "search": "{{$search}}"
                },
            @endif
            "buttons": [
                {
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8]
                    }
                },
            ]
        });

    }

    function check_allBox() {
            if ($("input:checkbox[name='check_all']").prop("checked")) {
                $("input:checkbox[name='multiselect']").prop("checked", true);
            } else {
                $("input:checkbox[name='multiselect']").prop("checked", false);
            }
            checkboxCheckSelected();
        }

        function checkboxCheckSelected() {
            var total_check_boxes = $("input:checkbox[name='multiselect']").length;
            var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
            if (total_check_boxes === total_checked_boxes) {
                $("#check_all").prop("checked", true);
            } else {
                $("#check_all").prop("checked", false);
            }
            if (total_checked_boxes > 0) {
                $(".process-selected").show();
            } else {
                $(".process-selected").hide();
            }
        }

        function processBulkSuggest() {
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            if($(".select2_ajax").val()!=null){
                var sel_stu_id = $('.select2_ajax').val();
                    $(".stu_sel_row").hide();
                    $(".stu_show_row").show();
                    $("#multi_stu_id").attr('required',false);
                    $("#main_student_id").val(sel_stu_id);
                }else{
                    $(".stu_show_row").hide();
                    $("#multi_stu_id").attr('required',true);
                    $(".stu_sel_row").show();
                }
            $('#courseMultiModal').modal("show");
            $('#assign_multi_course').val(dataArray).show();
        }

        function processBulkDownload() {
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            $('#download_multi_course').val(dataArray).show();
        }

    $('#search_btn').click(function() {
        searchTable();
    }); 

    $('#filterstudyArea,#filterdisciplineArea,#sort_by,#search_intake,#search_duration').change(function() {
        searchTable();
    }); 
    $('#toefl_score,#toefl_no_band_score,#ielts_score,#ielts_no_band_score,#pte_score,#pte_no_band_score,#gre_score,#gmat_score').keyup(function() {
        searchTable();
    }); 
    $(document).ready(function() {
        let study_level_array = $("#study_level").val();
            $(".study_level_val").click(function() {
                if($(this).is(":checked")) {
                    console.log(this.value);
                    study_level_array = [...study_level_array, this.value];
                    $("#study_level").val(study_level_array);
                    searchTable();
                } else{
                    study_level_array = study_level_array.filter((study_level) => study_level != this.value);
                    $("#study_level").val(study_level_array);
                    searchTable();
                }
            });
    });

    function searchTable() {
        $("#course_list").dataTable().fnDestroy();
        loadData();
    }

    // function clearTable() {
    //     $('#course_university_search').val('');
    //     $("#country").val('');
    //     $('#universities').val('');
    //     $('#study_level').val('');
    //     $("#search_intake").select2('destroy').val('').select2();
    //     $('#yearly_tuition_fee').val('');
    //     $('#institution_turnaround_time').val('');
    //     $("#course_list").dataTable().fnDestroy();
    //     loadData();
    // }
</script>
@endpush

@push('after-styles')
<style>
    .select2-container {
        width: 100% !important;
    }
    .select2-container.select2-container--default.select2-container--open {
        z-index: 5000;
    }
    table.dataTable tbody td {
        border-bottom: none!important;
        border-color: rgb(208,214,219)!important;
    }

    table.dataTable thead > tr > th.sorting_asc:after{
        display: none;
    }
    table.dataTable thead > tr > th.sorting_asc:before{
        display: none;
    }
</style>
@endpush