@extends('backend.layouts.app')

@section('title', "Add New Course")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New Course
                </h4>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.coursemanagement') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-9">
                {{ html()->form('POST', route('admin.coursemanagement.store'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                <div style="margin-top:10px;">
                    <div class="form-group mb-3">
                        <label>Title <span style="color: red;">*</span></label>
                        <input type="text" name="title" value="{{old('title')}}" class="form-control" maxlength="100" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Category <span style="color: red;">*</span></label>
                        <select name="category" id="category" class="form-select" required>
                            <option value="">Select Category</option>
                            @foreach($categories as $cat)
                            <option value="{{ $cat->id }}">{{ $cat->title }}</option>
                            @endforeach
                        </select>
                    </div> 
                    <div class="form-group mb-3">
                        <label>Sub Category</label>
                        <select name="sub_category" id="sub-cat" class="form-select" >
                            <option value="">Select Sub Category</option>
                        </select>
                    </div> 
                     <div class="form-group mb-3">
                        <label>University <span style="color: red;">*</span></label>
                        <select name="university" class="form-select" required>
                            <option value="">Select University</option>
                            @foreach($universities as $uni)
                            <option value="{{ $uni->id }}">{{ $uni->university_name }}</option>
                            @endforeach
                        </select>
                    </div> 
                                    
                    <div class="form-group mb-3">
                        <label>Study Level <span style="color: red;">*</span></label>
                        <select name="study_level" class="form-select" required>
                            <option value="">Select Study Level</option>
                            @foreach($levels as $level)
                            <option value="{{ $level }}">{{ $level }}</option>
                            @endforeach
                        </select>
                    </div>

                        <div class="form-group">
                            <label>Intake <span style="color: red;">*</span></label>
                            <select name="intake[]" class="form-select select2" multiple="multiple" required>
                            <option value="">Select Intake</option>
                            <option value="Jan">January</option>
                            <option value="Feb">February</option>
                            <option value="Mar">March</option>
                            <option value="Apr">April</option>
                            <option value="May">May</option>
                            <option value="Jun">June</option>
                            <option value="Jul">July</option>
                            <option value="Aug">August</option>
                            <option value="Sep">September</option>
                            <option value="Oct">October</option>
                            <option value="Nov">November</option>
                            <option value="Dec">December</option>
                            <option value="Spring">Spring</option>
                            <option value="Summer">Summer</option>
                            <option value="Fall">Fall</option>
                            <option value="Winter">Winter</option>
                        </select>
                        </div>

                    {{-- <div class="form-group">
                        <label>Year <span style="color: red;">*</span></label>
                        <select name="year[]" class="form-select select2" multiple="multiple" required>
                            <option value="">Select Year</option>
                            @foreach($years as $year)
                            <option value="{{ $year }}">{{ $year }}</option>
                            @endforeach
                        </select>
                    </div> --}}
                    <div class="form-group mb-3">
                        {{-- <label >Campus<span style="color: red;">*</span></label> --}}
                        <label >Concentration</label>
                        <input type="text" name="concentration" value="{{old('concentration')}}" class="form-control">
                    </div> 
                    <div class="form-group mb-3">
                        {{-- <label >Campus<span style="color: red;">*</span></label> --}}
                        <label >Campus/City</label>
                        <input type="text"  name="campus" value="{{old('campus')}}" class="form-control">
                    </div> 

                    <div class="form-group mb-3">
                        <label>Duration (Months)</label>
                        <input type="number" name="duration" value="{{old('duration')}}" class="form-control">
                    </div>
                    
                    <div class="form-group mb-3">
                        <label>Course Details</label>
                        <textarea name="course_details" rows="7" class="form-control textarea_editor1">{{old('course_details')}}</textarea>
                    </div>

                    <div class="form-group mb-3">
                        <label>Occupation Outcome </label>
                        <textarea type="text" name="occupation_outcome" value="{{old('occupation_outcome')}}" class="form-control">{{old('occupation_outcome')}}</textarea>
                    </div>

                    <div class="form-group">
                        <label>Practical Work</label>
                        <select name="practical_work" class="form-select">
                        <option value="">Select</option>
                        <option {{(old('practical_work') == 'Yes')? 'selected' : ''}} value="Yes">Yes</option>
                        <option {{(old('practical_work') == 'No')? 'selected' : ''}} value="No">No</option>
                        <option {{(old('practical_work') == 'Maybe')? 'selected' : ''}} value="Maybe">Maybe</option>
                    </select>
                    </div>

                    <div class="form-group mb-3">
                        <label>Entry Requirements</label>
                        <textarea name="entry_requirements" rows="5" class="form-control">{{old('entry_requirements')}}</textarea>
                    </div>
                    <div class="form-group mb-3">
                        <label>Course Content/Learning</label>
                        <textarea name="course_content" rows="7" class="form-control textarea_editor2">{{old('course_content')}}</textarea>
                    </div> 

                    <div class="form-group">
                        <label>Qualify for extended Visa</label>
                        <select name="qualify_extended_visa" class="form-select">
                        <option value="">Select</option>
                        <option {{(old('qualify_extended_visa') == 'Yes')? 'selected' : ''}} value="Yes">Yes</option>
                        <option {{(old('qualify_extended_visa') == 'No')? 'selected' : ''}} value="No">No</option>
                        <option {{(old('qualify_extended_visa') == 'Maybe')? 'selected' : ''}} value="Maybe">Maybe</option>
                    </select>
                    </div>
                    <div class="form-group">
                        <label>Regional Location</label>
                        <select name="regional_location" class="form-select">
                        <option value="">Select</option>
                        <option {{(old('regional_location') == 'Yes')? 'selected' : ''}} value="Yes">Yes</option>
                        <option {{(old('regional_location') == 'No')? 'selected' : ''}} value="No">No</option>
                        <option {{(old('regional_location') == 'Maybe')? 'selected' : ''}} value="Maybe">Maybe</option>
                    </select>
                    </div>

                    <div class="form-group mb-3">
                        <label>Country students not accepted</label>
                        <select name="country_students_not_accepted[]" class="form-select select2" multiple>
                            <option value="">Select Countries</option>
                            @foreach($countries as $country)
                            <option {{(old('country_students_not_accepted') == $country->name)? 'selected' : ''}}  value="{{ $country->name }}">{{ $country->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="row">
                        <div class="form-group col-md-3 mb-3">
                            <label>IELTS Score</label>
                            <input type="number" step=".5" name="ielts_score" value="{{old('ielts_score')}}" class="form-control">
                        </div>

                        <div class="form-group col-md-3 mb-3">
                            <label>IELTS No Band Less Than</label>
                            <input type="number" step=".5" name="ielts_no_band_less_than" value="{{old('ielts_no_band_less_than')}}" class="form-control">
                        </div> 

                        <div class="form-group col-md-3 mb-3">
                            <label>TOEFL Score</label>
                            <input type="number" step=".5" name="toefl_score" value="{{old('toefl_score')}}" class="form-control">
                        </div>  


                        <div class="form-group col-md-3 mb-3">
                            <label>TOEFL No Band Less Than</label>
                            <input type="number" step=".5" name="toefl_no_band_less_than" value="{{old('toefl_no_band_less_than')}}" class="form-control">
                        </div> 

                        <div class="form-group col-md-3 mb-3">
                            <label>PTE Score</label>
                            <input type="number" step=".5" name="pte_score" value="{{old('pte_score')}}" class="form-control">
                        </div>

                        <div class="form-group col-md-3 mb-3">
                            <label>PTE No Band Less Than</label>
                            <input type="number" step=".5" name="pte_no_band_less_than" value="{{old('pte_no_band_less_than')}}" class="form-control">
                        </div> 

                        <div class="form-group col-md-3 mb-3">
                            <label>GRE Score</label>
                            <input type="number" step=".5" name="gre_score" value="{{old('gre_score')}}" class="form-control">
                        </div>

                        <div class="form-group col-md-3 mb-3">
                            <label>GMAT Score</label>
                            <input type="number" step=".5" name="gmat_score" value="{{old('gmat_score')}}" class="form-control">
                        </div> 
                    </div>

                    <div class="form-group mb-3">
                        <label>University Applications Deadline</label>
                        <input type="text" name="application_deadline" value="{{old('application_deadline')}}" class="form-control">
                    </div> 

                    <div class="row">
                        <div class="form-group col-md-2 mb-3">
                            <label>Currency</label>
                            <select name="currency" class="form-select">
                                <option value="">Select</option>
                                @foreach($currency as $curr)
                                <option {{(old('currency') == $curr->currency_code)? 'selected' : ''}}  value="{{ $curr->currency_code }}">{{ $curr->currency_code }} ({{ $curr->currency_symbol }})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-2 mb-3">
                            <label>Application Fee</label>
                            <input type="number" step="1" name="application_fee" value="{{old('application_fee')}}" class="form-control" placeholder="">
                        </div> 
                        <div class="form-group col-md-3 mb-3">
                            <label>Tuition Fee (Yearly)</label>
                            <input type="number" step="1" name="yearly_tuition_fee" value="{{old('yearly_tuition_fee')}}" class="form-control" placeholder="">
                        </div> 
                        <div class="form-group col-md-2 mb-3">
                            <label>Non Tuition Fee (Yearly)</label>
                            <input type="number" step="1" name="non_tuition_fee" value="{{old('non_tuition_fee')}}" class="form-control" placeholder="">
                        </div> 
                        <div class="form-group col-md-3 mb-3">
                            <label>Total Tuition Fee</label>
                            <input type="number" step="1" name="total_tuition_fee" value="{{old('total_tuition_fee')}}" class="form-control" placeholder="">
                        </div> 
                        <div class="form-group col-md-6 mb-3">
                            <label>Commission %</label>
                            <input type="number" step="1" name="commission_percentage" value="{{old('commission_percentage')}}" class="form-control" placeholder="">
                            <span style="display: block; margin-top: -10px;">Your commission. Percentage of Yearly tuition fee.</span>
                        </div>
                        <div class="form-group col-md-6 mb-3"></div>
                        <div class="form-group col-md-6 mb-3">
                            <label>Sub-agent commission details (Shown to Sub-agents)</label>
                            <textarea class="form-control" name="sub_agent_commission_detail" id="sub_agent_commission_detail" cols="30" rows="4" placeholder="Sub-agent commission details (Shown to Sub-agents)"></textarea>
                        </div>
                    </div>

                    <div class="form-group mb-3">
                        <label>Scholarship Available</label>
                        <input type="text" name="scholarship_available" value="{{old('scholarship_available')}}" class="form-control">
                    </div>


                    <div class="form-group mb-3">
                        <label>Scholarship Detail</label>
                        <textarea name="scholarship_detail" rows="5" class="form-control">{{old('scholarship_detail')}}</textarea>
                    </div>  

                    <div class="form-group mb-3">
                        <label>Backlog Range</label>
                        <input type="text" name="backlog_range" value="{{old('backlog_range')}}" class="form-control">
                    </div> 

                    <div class="form-group mb-3">
                        <label>ESL/ELP Detail</label>
                        <textarea name="esl_elp_detail" rows="5" class="form-control">{{old('esl_elp_detail')}}</textarea>
                    </div>

                    <div class="form-group mb-3">
                        <label>University Applications Mode</label>
                        <input type="text" name="applicationmode" value="{{old('applicationmode')}}" class="form-control">
                    </div>

                    <div class="form-group mb-3">
                        <label>DET Score</label>
                        <input type="text" name="detscore" value="{{old('detscore')}}" class="form-control">
                    </div>
                    <div class="form-group mb-3">
                        <label>Website URL</label>
                        <input type="text" name="website_url" value="{{old('website_url')}}" class="form-control">
                    </div> 

                    <div class="form-group mb-3">
                        <label>Remarks</label>
                        <textarea name="remarks" rows="5" class="form-control">{{old('remarks')}}</textarea>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="seo_desc">Status<label>
                        </div>
                        <div class="col-md-12 col-lg-12 col-sm-12">
                            <select class="form-control form-select" id="status" name="status">
                                <option value="1" @if(old('status')== "1") selected="selected" @endif>Enabled</option>
                                <option value="0" @if(old('status')== "0") selected="selected" @endif>Disabled</option>
                            </select>
                        </div>
                    </div>                     
                    
                    <div class="form-group" style="text-align: center">
                        {{ form_submit("Submit") }}
                    </div>
                    
                    {{ html()->form()->close() }}  
                    {{-- <div class="row">
                        <div class="col-md-12">
                            <small><b>Notes: </b> All Fees must be in Local Currency as per Educational Institution Location.</small>
                        </div>
                    </div> --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
<script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
<script>
    $(document).ready(function () {
        $('#category').on('change', function () {
            var idCat = this.value;
            $("#sub-cat").html('');
            $.ajax({
                url: "{{route('admin.coursemanagement.fetchSubCat')}}",
                type: "POST",
                data: {
                    category_id: idCat,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#sub-cat').html('<option value="">Select Sub Category</option>');
                    $.each(result.subcategories, function (key, value) {
                        $("#sub-cat").append('<option value="' + value
                            .id + '">' + value.title + '</option>');
                    });
                }
            });
        });
        $('.textarea_editor1').wysihtml5();
        $('.textarea_editor2').wysihtml5();
    });
</script>
@endpush