@extends('backend.layouts.app')

@section('title', "Add New University")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New University
                </h4>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.coursemanagement.universities') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-6">
                {{ html()->form('POST', route('admin.coursemanagement.store.university'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    
                    <div class="form-group mb-3">
                        <label for="university_name">University Name <span style="color: red;">*</span></label>
                        <input type="text" class="form-control" id="university_name" value="{{old('university_name')}}" name="university_name" required>        
                    </div>

                    <div class="form-group mb-3">
                        <label>Country <span style="color: red;">*</span></label>
                        <select name="country" class="form-select" required>
                            <option value="">Select Country</option>
                            @foreach($countries as $country)
                            <option value="{{ get_country_id_by_name($country) }}" {{(old('country')== $country)? 'selected' : ''}}>{{ $country }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6 mb-3">
                            <label for="university_logo">University Logo</label>
                            <input type="file" class="form-control" id="university_logo" name="university_logo" accept="image/*">
                        </div> 
                        
                    <div class="row">
                    <div class="form-group col-md-6 mb-3">
                        <label>Institution Type</label>
                        <select name="institution_type" class="form-select">
                        <option value="">Select</option>
                        <option {{(old('institution_type') == 'private_university')? 'selected' : ''}} value="private_university">Private University</option>
                        <option {{(old('institution_type') == 'government_university')? 'selected' : ''}} value="government_university">Government University</option>
                        {{-- <option {{(old('institution_type') == 'Level 1')? 'selected' : ''}} value="Level 1">Level 1</option>
                        <option {{(old('institution_type') == 'Level 2')? 'selected' : ''}} value="Level 2">Level 2</option>
                        <option {{(old('institution_type') == 'Level 3')? 'selected' : ''}} value="Level 3">Level 3</option>
                        <option {{(old('institution_type') == 'Not applicable')? 'selected' : ''}} value="Not applicable">Not applicable</option> --}}
                    </select>
                    </div>
                    <div class="form-group col-md-6 mb-3">
                        <label>Concurrent Course Allowed?</label>
                        <select name="concurrent_course_allowed" class="form-select">
                        <option value="">Select</option>
                        <option {{(old('concurrent_course_allowed') == 'Yes')? 'selected' : ''}} value="Yes">Yes</option>
                        <option {{(old('concurrent_course_allowed') == 'No')? 'selected' : ''}} value="No">No</option>
                        <option {{(old('concurrent_course_allowed') == 'Maybe')? 'selected' : ''}} value="Maybe">Maybe</option>
                    </select>
                    </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6 mb-3">
                                <label>Commission Count</label>
                                <select name="commission_count" class="form-select">
                                <option {{old('commission_count' == '1')? 'selected' : ''}} value="1">1</option>
                                <option {{old('commission_count' == '2')? 'selected' : ''}} value="2">2</option>
                                <option {{old('commission_count' == '3')? 'selected' : ''}} value="3">3</option>
                                <option {{old('commission_count' == '4')? 'selected' : ''}} value="4">4</option>
                            </select>
                        </div>
                        <div class="form-group col-md-6 mb-3">
                            <label>Commission Percent</label>
                            <input type="number" name="commission_percent" class="form-control" value="{{old('commission_percent')}}">
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group col-md-6 mb-3">
                                <label>Tax type</label>
                                <select name="tax_type" class="form-select">
                                <option {{old('tax_type' == 'inclusive')? 'selected' : ''}} value="inclusive">Inclusive</option>
                                <option {{old('tax_type' == 'exclusive')? 'selected' : ''}} value="exclusive">Exclusive</option>
                            </select>
                        </div>
                        <div class="form-group col-md-6 mb-3">
                            <label>Tax Percent</label>
                            <input type="number" name="tax_percent" class="form-control" value="{{old('tax_percent')}}">
                        </div>
                    </div>
                    <div class="form-group mb-3">
                        <label>University Details</label>
                        <textarea name="college_details" rows="7" class="form-control textarea_editor">{{old('college_details')}}</textarea>
                    </div>

                    <div class="form-group mb-3">
                        <label>Address</label>
                        <textarea name="address" rows="5" class="form-control">{{old('address')}}</textarea>
                    </div>
                    <div class="form-group mb-3">
                        <label>Website</label>
                        <input type="url" name="website" value="{{old('website')}}" class="form-control">
                    </div> 
                    <div class="form-group mb-3">
                        <label>CRICOS Link</label>
                        <input type="url" name="cricos_link" value="{{old('cricos_link')}}" class="form-control">
                    </div> 
                    <div class="form-group mb-3">
                        <label>Documents Link</label>
                        <input type="url" name="documents_link" value="{{old('documents_link')}}" class="form-control">
                    </div>
                    <div class="form-group mb-3">
                        <label>Current Fee List Link</label>
                        <input type="url" name="current_fee_list_link" value="{{old('current_fee_list_link')}}" class="form-control">
                    </div>

                    <div class="form-group mb-3">
                        <label>Initial Deposit Options</label>
                        <input type="text" name="initial_deposit_options" value="{{old('initial_deposit_options')}}" class="form-control">
                    </div> 

                    <div class="form-group mb-3">
                        <label>Admission Process</label>
                        <textarea name="admission_process" rows="5" class="form-control">{{old('admission_process')}}</textarea>
                    </div>

                    <div class="form-group mb-3">
                        <label>Contact Person Name</label>
                        <input type="text" name="contact_person_name" value="{{old('contact_person_name')}}" class="form-control">
                    </div>

                    <div class="row">
                    <div class="form-group col-md-6 mb-3">
                        <label>Contact Person Phone</label>
                        <input type="text" name="contact_person_phone" value="{{old('contact_person_phone')}}" class="form-control">
                    </div>
                    <div class="form-group col-md-6 mb-3">
                        <label>Contact Person Email ID</label>
                        <input type="text" name="contact_person_email" value="{{old('contact_person_email')}}" class="form-control">
                    </div>
                    </div>
                     <div class="form-group">
                        <label>
                            <input type="checkbox" name="agent_uni" value="1" {{ isset($university) && $university->agent_uni ? 'checked' : '' }}>
                            Hide this university from agents
                        </label>
                    </div>
                    <div class="form-group" style="text-align: center">
                        {{ form_submit("Submit") }}
                    </div>
                    
               
                    {{ html()->form()->close() }}  
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush