@extends('backend.layouts.app')

@section('title', "Edit Category")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Edit Category
                </h4>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.coursemanagement.categories') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-6">
                {{ html()->form('POST', route('admin.coursemanagement.update-category',$cat_det->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    
                    <div class="form-group mb-3">
                        <label for="title">Category Title<span style="color: red;">*</span></label>
                        <input type="text" class="form-control" id="title" value="{{$cat_det->title}}" name="title" required>        
                    </div>

                    <div class="form-group mb-3">
                        <label>Parent Category</label> 
                        <br>                       
                        <label>{{get_university_course_category_name($cat_det->parent_id)}}</label>
                    </div>                         

                    <div class="form-group mb-3">
                        <label for="seo_url_slug">URL Slug <span style="color: red;">*</span></label>
                        <input type="text" class="form-control" id="seo_url_slug" style="margin-bottom: 3px" value="{{$cat_det->seo_url_slug}}" name="seo_url_slug" required>
                        <small>Only letters, digits, hyphen. Ex: cloud-computing</small>
                    </div>

                    <div class="form-group mb-3">
                        <label for="description">Category Description</label>
                        <textarea class="form-control" id="description" name="description" rows="5">{{$cat_det->description}}</textarea>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="display_order"><b>Display Order</b> <span style="color: red;">*</span><label>
                        </div>
                        <div class="col-md-12 col-lg-12 col-sm-12">
                            <input type="number" value="{{$cat_det->display_order}}" min="0" name="display_order" id="display_order" class="form-control" required>
                        </div>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="seo_desc">Status<label>
                            </div>
                            <div class="col-md-12 col-lg-12 col-sm-12">
                                <select class="form-control form-select" id="status" name="status">
                                    <option value="1" @if($cat_det->status== "1") selected="selected" @endif>Enabled</option>
                                    <option value="0" @if($cat_det->status== "0") selected="selected" @endif>Disabled</option>
                                </select>
                            </div>
                        </div>

                    <div class="form-group" style="text-align: center">
                        {{ form_submit("Submit") }}
                    </div>
                    
               
                    {{ html()->form()->close() }}  
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection
@push('after-scripts')
<script>
    $(document).ready(function () {
        $('#category').on('change', function () {
            var idCat = this.value;
            $("#sub-cat").html('');
            $.ajax({
                url: "{{route('admin.coursemanagement.fetchSubCat')}}",
                type: "POST",
                data: {
                    category_id: idCat,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#sub-cat').html('<option value="">Select Sub Category</option>');
                    $.each(result.subcategories, function (key, value) {
                        $("#sub-cat").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                }
            });
        });

        $('#title').change(function() {
            var url_val = $(this).val().replace(/[_\W]+/g, "-").toLowerCase();
            $('#seo_url_slug').val(url_val);
        });
    });
</script>
@endpush