@extends('backend.layouts.app')
@section('title', 'University Course Management')

@section('content')
    <div class="card">
        <div class="card-body pt-3">
            <div class="row">
                <div class="col-sm-7">
                    <h4 style="">University Course Management</h4>
                </div>

                <div class="col-sm-5 col-5">
                    <ul class="list-unstyled" style="float: right;">
                        <li class=" ms-auto">
                            <div class="ms-auto d-flex ">
                                <button id="filter_toggle" class="btn btn-outline-primary btn-sm" style="margin-right: 5px;" title="Filters"><i class="bi bi-funnel-fill"></i></button>
                                <a target="_blank" href="{{ route('admin.import-export.index', 'course') }}"
                                    class="btn btn-outline-primary btn-sm" data-toggle="tooltip" title="Import"><i
                                        class="bi bi-cloud-arrow-up"></i> Import</a>
                                <a style="margin-left: 5px;" href="{{ route('admin.coursemanagement.create') }}"
                                    class="btn btn-primary btn-sm" data-toggle="tooltip" title="Add New Course"><i
                                        class="bi bi-plus-circle"></i> Add Course</a>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="mt-3 mb-4 filterBox" id="filters" style="display:none;">
                <div class="row mt-3">
                    <div class="col-md-3">
                        <select name="study_level" id="study_level" class="form-select" required>
                            <option value="">Select Study Level</option>
                            @foreach ($levels as $level)
                                <option value="{{ $level }}">{{ $level }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="category" id="category" class="form-select" required>
                            <option value="">Select Study Area</option>
                            @foreach ($categories as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="sub_category" id="sub-cat" class="form-select">
                            <option value="">Select Discipline Area</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="country" id="country" class="form-select select2" style="width: 100%">
                            <option value="">Select Country</option>
                            @foreach ($countries as $country)
                                <option value="{{ get_country_id_by_name($country) }}">{{ $country }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-sm-12 col-md-4">
                        <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                        <button onclick="javascript:clearTable();" class=" btn btn-outline-primary btn-sm">Clear</button>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="table-responsive" style="height:550px!important;">
                    <table class="table w-100 fixTableHead" id="course_list" class="display">
                        <thead>
                            <tr>
                                <th data-orderable="false">
                                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" id="check_all" name="check_all" />
                                    </div>
                                </th>
                                <th></th>
                                <th>Actions</th>
                                <th style="min-width:35px">ID</th>
                                <th style="min-width:65px">Status</th>
                                {{-- <th style="min-width:35px">ID</th> --}}
                                <th style="min-width:200px">Course</th>
                                <th style="min-width:100px">University</th>
                                {{-- <th >Campus</th> --}}
                                {{-- <th style="min-width:80px">Duration</th> --}}
                                <th style="min-width:75px">Country</th>
                                <th style="min-width:95px">Study Level</th>
                                <th style="min-width:120px">Study Area </th>
                                <th style="min-width:120px">Discipline Area</th>
                                <th style="min-width:75px">Intakes</th>
                                {{-- <th style="min-width:65px">Year</th> 
                            <th >Website Url</th> 
                            <th >Entry Requirements</th> --}}
                                <th style="min-width:100px">IELTS Score</th>
                                <th style="min-width:120px">IELTS No Band Less Than</th>
                                <th style="min-width:100px">TOEFL Score</th>
                                <th style="min-width:120px">TOEFL No Band Less Than</th>
                                <th style="min-width:80px">PTE Score</th>
                                <th style="min-width:135px">PTE No Band Less Than</th>
                                <th style="min-width:85px">GRE Score</th>
                                <th style="min-width:100px">GMAT Score</th>
                                {{-- <th >Application Deadline</th>
                            <th style="min-width:100px">Application Fee</th> 
                            <th style="min-width:70px">Tuition Fee</th> 
                            <th >Scholarship Available</th> 
                            <th style="min-width:75px">Scholarship Detail</th> 
                            <th >Backlog Range</th> 
                            <th >Remarks</th> 
                            <th >Esl Elp Ddetail</th> 
                            <th >Application Mode</th>                           
                            <th style="min-width:85px">DET Score</th> --}}
                            </tr>
                        </thead>
                    </table>
                </div>

                <div class="col-md-3 col-sm-12 process-selected" style="display:none;">
                    {{-- <label class="label">With Selected</label> --}}
                    <select class="form-select" name="bulk_change" id="bulk_change">
                        <option value="">- Select -</option>
                        <option value="bulk_enable">Enable Courses</option>
                        <option value="bulk_disable">Disable Courses</option>
                        <option value="bulk_delete">Delete Courses</option>
                    </select>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('after-styles')
    <style>
        .id-column {
            max-width: 20px;
        }
        .actions-column {
            max-width: 55px;
        }
        .fixTableHead {
            overflow-y: auto;
            height: 110px;
        }

        .fixTableHead thead {
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }
    </style>
@endpush

@push('after-scripts')
    <script type="text/javascript">
        loadData();
        $(document).ready(function() {
            $('#filter_toggle').on('click', function() {
                $('#filters').toggle();
            });

            $('#category').on('change', function() {
                var idCat = this.value;
                $("#sub-cat").html('');
                $.ajax({
                    url: "{{ route('admin.coursemanagement.fetchSubCat') }}",
                    type: "POST",
                    data: {
                        category_id: idCat,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#sub-cat').html('<option value="">Select Discipline Area</option>');
                        $.each(result.subcategories, function(key, value) {
                            $("#sub-cat").append('<option value="' + value
                                .id + '">' + value.title + '</option>');
                        });
                    }
                });
            });

            $("#check_all").on("click", function() {
                if ($("input:checkbox[name='check_all']").prop("checked")) {
                    $("input:checkbox[name='multiselect']").prop("checked", true);
                } else {
                    $("input:checkbox[name='multiselect']").prop("checked", false);
                }
                checkboxCheckSelected();
            });

            $('#bulk_change').on('change', function() {
                if (this.value == 'bulk_delete') {
                    Swal.fire({
                        title: `Are you sure you want to delete selected Course(s)?`,
                        html: "<h6 class='text-danger'>This action cannot be undone!</h6>",
                        showCancelButton: true,
                        confirmButtonText: "Delete",
                        cancelButtonText: "Cancel",
                        type: 'warning'
                    }).then((result) => {
                        result.value && processBulkChange('bulk_delete');
                    });
                } else if (this.value == 'bulk_enable') {
                    processBulkChange('bulk_enable');
                } else if (this.value == 'bulk_disable') {
                    processBulkChange('bulk_disable');
                } else {}
            });

        });

        function processBulkChange(action) {
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            if (action == 'bulk_delete') {
                var sub_options = {
                    url: "{{ route('admin.bulkcoursedelete') }}",
                    method: "POST",
                    data: {
                        'id_arr': dataArray,
                        '_token': $('meta[name="csrf-token"]').attr('content')
                    }
                };
            }
            if (action == 'bulk_enable') {
                var sub_options = {
                    url: "{{ route('admin.bulkcourseenable') }}",
                    method: "POST",
                    data: {
                        'id_arr': dataArray,
                        '_token': $('meta[name="csrf-token"]').attr('content')
                    }
                };
            }
            if (action == 'bulk_disable') {
                var sub_options = {
                    url: "{{ route('admin.bulkcoursedisable') }}",
                    method: "POST",
                    data: {
                        'id_arr': dataArray,
                        '_token': $('meta[name="csrf-token"]').attr('content')
                    }
                };
            }
            manual_form_submit(sub_options);
        }

        function manual_form_submit(options) {
            var $form = $("<form />");
            $form.attr("action", options.url);
            $form.attr("method", options.method);
            for (var data in options.data)
                $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
            $("body").append($form);
            $form.submit();
        }

        function checkboxCheckSelected() {
            var total_check_boxes = $("input:checkbox[name='multiselect']").length;
            var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
            if (total_check_boxes === total_checked_boxes) {
                $("#check_all").prop("checked", true);
            } else {
                $("#check_all").prop("checked", false);
            }
            if (total_checked_boxes > 0) {
                $(".process-selected").show();
            } else {
                $(".process-selected").hide();
            }
        }

        function clearSelectedCheckboxs() {
            $("#check_all").prop("checked", false);
            $(".process-selected").hide();

        }

        function format(d) {
            console.log(d);
            // `d` is the original data object for the row
            return (
                '<table cellpadding="3" cellspacing="0" border="0" style="padding-left:50px;">' +
                '<tr >' +
                '<td ><b>Campus:</b></td>' +
                '<td>' +
                d.campus +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Duration (Months):</b></td>' +
                '<td>' +
                d.duration +
                '</td>' +
                '</tr>' +
                
                '<tr >' +
                                '<td ><b>Intakes:</b></td>' +
                                '<td>' +
                                d.intakes +
                                '</td>' +
                                '</tr>' +
                                '<tr>' +
                                '<td><b>Commission %:</b></td>' +
                                '<td>' +
                                d.commission_percentage +
                                '</td>' +
                                '</tr>' +   
                '<tr >' +
                                '<td ><b>IELTS Score:</b></td>' +
                                '<td>' +
                                d.ielts_score +
                                '</td>' +
                                '</tr>' +  

'<tr >' +
                '<td ><b>IELTS No Band Less Than:</b></td>' +
                '<td>' +
                d.ielts_no_band_less_than +
                '</td>' +
                '</tr>' +  

'<tr >' +
                '<td ><b>TOEFL Score:</b></td>' +
                '<td>' +
                d.toefl_score +
                '</td>' +
                '</tr>' +  
'<tr >' +
                '<td ><b>TOEFL No Band Less Than:</b></td>' +
                '<td>' +
                d.toefl_no_band_less_than +
                '</td>' +
                '</tr>' +  
'<tr >' +
                '<td ><b>PTE Score:</b></td>' +
                '<td>' +
                d.pte_score +
                '</td>' +
                '</tr>' + 
'<tr >' +
                '<td ><b>PTE No Band Less Than:</b></td>' +
                '<td>' +
                d.pte_no_band_less_than +
                '</td>' +
                '</tr>' + 

'<tr >' +
                '<td ><b>GRE Score:</b></td>' +
                '<td>' +
                d.gre_score +
                '</td>' +
                '</tr>' + 
'<tr >' +
                '<td ><b>GMAT Score:</b></td>' +
                '<td>' +
                d.gmat_score +
                '</td>' +
                '</tr>' +  
                // '<tr>' +
                // '<td><b>Year:</b></td>' +
                // '<td>' +
                // d.year +
                // '</td>' +
                // '</tr>' +
                '<tr >' +
                '<td ><b>Course Details:</b></td>' +
                '<td>' +
                d.course_details +
                '</td>' +
                '</tr>' +
                '<tr >' +
                '<td ><b>Course Content/Learning:</b></td>' +
                '<td>' +
                d.course_content +
                '</td>' +
                '</tr>' +
                '<tr >' +
                '<td ><b>Occupation Outcome:</b></td>' +
                '<td>' +
                d.occupation_outcome +
                '</td>' +
                '</tr>' +
                '<tr >' +
                '<td ><b>Practical Work:</b></td>' +
                '<td>' +
                d.practical_work +
                '</td>' +
                '</tr>' +
                '<tr >' +
                '<td ><b>Qualify extended Visa:</b></td>' +
                '<td>' +
                d.qualify_extended_visa +
                '</td>' +
                '</tr>' +
                '<tr >' +
                '<td ><b>Regional Location:</b></td>' +
                '<td>' +
                d.regional_location +
                '</td>' +
                '</tr>' +
                '<tr >' +
                '<td ><b>Country students not accepted:</b></td>' +
                '<td>' +
                d.country_students_not_accepted +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Website Url:</b></td>' +
                '<td>' +
                d.website_url +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td ><b>Entry Requirements:</b></td>' +
                '<td>' +
                d.entry_requirements +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Application Deadline:</b></td>' +
                '<td>' +
                d.application_deadline +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Application Fee:</b></td>' +
                '<td>' + d.currency +
                d.application_fee +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Yearly Tuition Fee:</b></td>' +
                '<td>' + d.currency +
                d.yearly_tuition_fee +
                '</td>' +
                '</tr>' +
                // '<tr>' +
                // '<td><b>Tuition Fee Offshore:</b></td>' +
                // '<td>' +
                // d.tuition_fee_offshore +
                // '</td>' +
                // '</tr>' +
                '<tr>' +
                '<td><b>Non Tuition Fee:</b></td>' +
                '<td>' + d.currency +
                d.non_tuition_fee +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Total Tuition Fee:</b></td>' +
                '<td>' +

                d.total_tuition_fee +
                '</td>' +
                '</tr>' +
                '<td><b>Scholarship Available:</b></td>' +
                '<td>' +
                d.scholarship_available +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Scholarship Detail:</b></td>' +
                '<td>' +
                d.scholarship_detail +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Backlog Range:</b></td>' +
                '<td>' +
                d.backlog_range +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Remarks:</b></td>' +
                '<td>' +
                d.remarks +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Esl Elp Detail:</b></td>' +
                '<td>' +
                d.esl_elp_detail +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Application Mode:</b></td>' +
                '<td>' +
                d.applicationmode +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>DET Score:</b></td>' +
                '<td>' +
                d.detscore +
                '</td>' +
                '</tr>' +
                '<tr>' +
                '<td><b>Concentration:</b></td>' +
                '<td>' +
                d.concentration +
                '</td>' +
                '</tr>' +
                '</table>'
            );
        }

        // Ajax DataTable

        function loadData(myleads) {
            var table = $('#course_list').DataTable({
                "dom": '<"row"<"col-md-3 text-start"i><"col-md-3"l><"col-md-3 text-start"f><"col-md-3 text-end"B>>rtip',
                processing: true,
                serverSide: true,
                language: {
                    searchPlaceholder: ""
                },
                autoWidth: true,
                responsive: true,
                lengthMenu: [50, 100, 200],
                "ajax": {
                    "url": "{{ route('admin.ajaxcoursemanagementlist') }}",
                    "dataType": "json",
                    "type": "post",
                    data: {
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                        'study_level': $('#study_level').val(),
                        'category': $('#category').val(),
                        'sub_category': $('#sub-cat').val(),
                        'country': $('#country').val(),
                    },
                },
                "drawCallback": function(settings) {
                    addDeleteForms();
                },
                'order': [
                    [3, 'desc']
                ],
                columns: [{
                        data: 'id',
                        orderable: false,
                        className: 'id-column',
                    },
                    {
                        className: 'dt-control id-column',
                        orderable: false,
                        data: null,
                        defaultContent: '',
                    },
                    {
                        data: 'actions',
                        className: 'actions-column',
                        orderable: false,
                    },
                    {
                        data: 'course_id',
                        // orderable: false,
                    },
                    {
                        data: 'status',
                        // orderable: false,
                    },
                    {
                        data: 'course_name',
                        // orderable: false,
                    },
                    {
                        data: 'university',
                        // orderable: false,
                    },
                    // {
                    //     data: 'campus',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'duration',
                    //     // orderable: false,
                    // },
                    {
                        data: 'country',
                        // orderable: false,
                    },
                    {
                        data: 'study_level',
                        // orderable: false,
                        //searchable: false,
                    },
                    {
                        data: 'category',
                        // orderable: false,
                    },
                    {
                        data: 'sub_category',

                        // orderable: false,
                    },
                    {
                        data: 'intakes',
                        // orderable: false,
                    },
                    // {
                    //     data: 'year',
                    //     // orderable: false,
                    // },
                    // {
                    //     data: 'website_url',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'entry_requirements',
                    //     orderable: false,
                    // },
                    {
                        data: 'ielts_score',
                        // orderable: false,
                    },
                    {
                        data: 'ielts_no_band_less_than',
                        // orderable: false,
                    },
                    {
                        data: 'toefl_score',
                        // orderable: false,
                    },
                    {
                        data: 'toefl_no_band_less_than',
                        // orderable: false,
                    },
                    {
                        data: 'pte_score',
                        // orderable: false,
                    },
                    {
                        data: 'pte_no_band_less_than',
                        // orderable: false,
                    },
                    {
                        data: 'gre_score',
                        // orderable: false,
                    },
                    {
                        data: 'gmat_score',
                        // orderable: false,
                    },
                    // {
                    //     data: 'application_deadline',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'application_fee',
                    //     // orderable: false,
                    // },
                    // {
                    //     data: 'tuition_fee',
                    //     // orderable: false,
                    // },
                    // {
                    //     data: 'scholarship_available',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'scholarship_detail',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'backlog_range',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'remarks',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'esl_elp_detail',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'applicationmode',
                    //     orderable: false,
                    // },
                    // {
                    //     data: 'detscore',
                    //     // orderable: false,
                    // },

                ],
                columnDefs: [{
                        targets: [ 11, 12, 13, 14, 15, 16, 17, 18, 19],
                        visible: false,
                    }, {
                        targets: 0,
                        // orderable: false,
                        render: function(data) {

                            if (data != '') {
                                return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" onclick="javascript:checkboxCheckSelected();" name="multiselect" type="checkbox" value="${data}" />
                                </div>`;
                            } else {
                                return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" name="multiselectd" type="checkbox" value="" disabled />
                                </div>`;
                            }
                        }
                    },

                ],
                @if (isset($search) && strlen($search))
                    "search": {
                        "search": "{{ $search }}"
                    },
                @endif
                "buttons": [{
                        extend: 'excel',
                        text: '<i class="ri-file-excel-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
                        }
                    },
                    {
                        extend: 'pdf',
                        text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
                        }
                    },
                    {
                        extend: 'print',
                        text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
                        }
                    },
                    {
                        extend: 'copy',
                        text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
                        }
                    },
                    {
                        extend: 'csv',
                        text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
                        }
                    },
                ]
            });

            $('#course_list tbody').on('click', 'td.dt-control', function() {
                var tr = $(this).closest('tr');
                var row = table.row(tr);
                console.log(row);

                if (row.child.isShown()) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                } else {
                    // Open this row
                    row.child(format(row.data())).show();
                    tr.addClass('shown');
                }
            });
        }

        function searchTable() {
            $("#course_list").dataTable().fnDestroy();
            loadData();
        }

        function clearTable() {
            $('#study_level').val('');
            $('#category').val('');
            $('#sub-cat').val('');
            $("#country").select2('destroy').val('').select2();
            $("#course_list").dataTable().fnDestroy();
            loadData();
        }
    </script>
@endpush
