@extends('backend.layouts.app')
@section('title', "View Course Suggestion")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    View Course Suggestion
                </h4>
            </div><!--col-->
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-8">
                    <div style="margin-top:10px;">
                        <div class="form-group mb-3">
                            <label><strong>Title:</strong></label><br />
                            {{ $coursesuggestion->title }}
                        </div>
                        <div class="form-group mb-3">
                            <label><strong>Country:</strong></label><br />
                            {{ $coursesuggestion->country }}
                        </div>                        
                        <div class="form-group mb-3">
                            <label><strong>Level:</strong></label><br />
                            {{ $coursesuggestion->level }}
                        </div>
                        <div class="form-group mb-3">
                            <label><strong>Year:</strong></label><br />
                            {{ $coursesuggestion->year }}
                        </div>                        
                        <div class="form-group mb-3">
                            <label><strong>Intake:</strong></label><br />
                            {{ $coursesuggestion->intake }}
                        </div>                        
                        <div class="form-group" style="text-align: center">
                            <a href="{{ url('storage/' . $coursesuggestion->file) }}" class="btn btn-primary">Download</a>
                            <a href="{{ route('admin.coursesuggestion.share',$coursesuggestion->id)}}" class="btn btn-primary">Share</a>
                        </div>
                        <div class="form-group" style="margin-top: 50px;">
                            <a href="" class="btn btn-danger">Delete This Item</a>
                        </div>                        
                    </div>
                
                
                
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection        