@extends('backend.layouts.app')
@section('title', "Course Management- Universities")

@section('content')
<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col-sm-7 col-7" style="margin-bottom:10px;">
                <h4 style="">Course Management - Universities</h4>
            </div>

            <div class="col-sm-5 col-5">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="Add New Course" style="float: right;"> 
                    <a href="{{ route('admin.coursemanagement.create.university') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New University"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
            </div>          
        </div> 

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table eductrl-datatable nowrap" id="suggestions_tbl">
                        <thead>
                            <tr>
                                <th>
                                    <input type="checkbox" id="select_all">
                                </th>
                                <th>Actions</th>
                                <th class="select_filter eductrl-datatable-col-header">University Logo</th>
                                <th class="select_filter eductrl-datatable-col-header">University Name</th>
                                <th class="select_filter eductrl-datatable-col-header">Country</th>
                                <th class="select_filter eductrl-datatable-col-header">Institution Type</th>
                                <th class="select_filter eductrl-datatable-col-header">Concurrent Course Allowed?</th>
                                <th class="select_filter eductrl-datatable-col-header">University Details</th>
                                <th class="select_filter eductrl-datatable-col-header">Address</th>
                                <th class="select_filter eductrl-datatable-col-header">Website</th>
                                <th class="select_filter eductrl-datatable-col-header">CRICOS Link</th>
                                <th class="select_filter eductrl-datatable-col-header">Documents Link</th>
                                <th class="select_filter eductrl-datatable-col-header">Current Fee List Link</th>
                                <th class="select_filter eductrl-datatable-col-header">Initial Deposit Options</th>
                                <th class="select_filter eductrl-datatable-col-header">Admission Process</th>
                                <th class="select_filter eductrl-datatable-col-header">Contact Person Name</th>
                                <th class="select_filter eductrl-datatable-col-header">Contact Person Phone</th>
                                <th class="select_filter eductrl-datatable-col-header">Contact Person Email ID</th>
                                <th class="select_filter eductrl-datatable-col-header">Visible to Agents?</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($universities as $university)

                            <tr>
                                <td>
                                    <input type="checkbox" class="select_item" name="selected_ids[]" value="{{ $university->id }}">
                                </td>
                                <td>
                                    <div class="btn-group">
                                    <a href="{{ route('admin.coursemanagement.edit-university',$university->id)}}" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>
                                    <a href="{{ route('admin.coursemanagement.destroy-university',$university->id)}}"
                                        data-method="delete"
                                        data-trans-button-cancel="Cancel"
                                        data-trans-button-confirm="Delete"
                                        data-trans-title="Are you sure?"
                                        class="btn btn-danger btn-sm" ><i class="fa fa-trash"></i></a>
                                    </div>
                                </td>
                                <td>
                                    <img src="{{asset("storage/" . $university->university_logo)}}" alt="College Logo" width="50" height="50">
                                </td>
                                <td>{{ $university->university_name }}</td>
                                <td>{{ get_country_name($university->country) }}</td>
                                <td>{{($university->institution_type)? ucwords(str_replace("_", " ", $university->institution_type)) : '--'}}</td>
                                <td>{{ ($university->concurrent_course_allowed)? $university->concurrent_course_allowed : '--' }}</td>
                                <td>{!! ($university->college_details)? $university->college_details : '--' !!}</td>
                                <td>{{ ($university->address)? $university->address : '--' }}</td>
                                <td>{{ ($university->website)? $university->website : '--' }}</td>
                                <td>{{ ($university->cricos_link)? $university->cricos_link : '--' }}</td>
                                <td>{{ ($university->documents_link)? $university->documents_link : '--' }}</td>
                                <td>{{ ($university->current_fee_list_link) ? $university->current_fee_list_link : '--' }}</td>
                                <td>{{ ($university->initial_deposit_options)? $university->initial_deposit_options : '--' }}</td>
                                <td>{{ ($university->admission_process)? $university->admission_process : '--' }}</td>
                                <td>{{ ($university->contact_person_name)? $university->contact_person_name : '--' }}</td>
                                <td>{{ ($university->contact_person_phone) ? $university->contact_person_phone : '--' }}</td>
                                <td>{{ ($university->contact_person_email)? $university->contact_person_email : '--' }}</td>
                                <td>
                                    @if(!$university->agent_uni)
                                        <span class="badge bg-success">Yes</span>
                                    @else
                                        <span class="badge bg-danger">No</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <form method="post" action="{{ route('admin.coursemanagement.bulkHideUniversities')}}" id="bulk_hide_form">
                    @csrf
                    <input type="hidden" name="selected_ids" id="selected_ids_input">
                    <div class="row mb-3 mt-3">
                        <div class="col-md-4">
                            <select name="bulk_action" id="bulk_action" class="form-select">
                                <option value="">-- Select --</option>
                                <option value="hide">Hide selected universities from agents</option>
                                <option value="unhide">Unhide selected universities from agents</option>
                                <option value="delete">Delete selected universities</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary">Apply</button>
                        </div>
                    </div>
                </form> 
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection        
@push('after-scripts')
<script>
    $('#select_all').on('change', function () {
        $('.select_item').prop('checked', this.checked);
    });

    $('#bulk_hide_form').on('submit', function (e) {
        e.preventDefault();

        const selected = $('.select_item:checked').map(function () {
            return this.value;
        }).get();

        if (selected.length === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'No selection',
                text: 'Please select at least one university.',
            });
            return;
        }

        const action = $('#bulk_action').val();

        if (!action) {
            Swal.fire({
                icon: 'info',
                title: 'No action selected',
                text: 'Please choose an action to apply.',
            });
            return;
        }

        if (action === 'delete') {
            Swal.fire({
                title: 'Are you sure you want to delete selected university(ies)?',
                text: "This action cannot be undone!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Delete',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#selected_ids_input').val(selected.join(','));
                    $('#bulk_hide_form')[0].submit();
                }
            });
        } else {
            $('#selected_ids_input').val(selected.join(','));
            this.submit();
        }
    });
</script>
@endpush
