@extends('backend.layouts.app')

@section('title', "Add New Course Suggestion")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New Course Suggestion 
                </h4>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.coursesuggestion') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-6">


                {{ html()->form('POST', route('admin.coursesuggestion.store'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                <div style="margin-top:10px;">
                    <div class="form-group mb-3">
                        <label>Title</label>
                        <input tyle="text" name="title" class="form-control" maxlength="100" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Country</label>
                        <select name="country" class="form-select" required>
                            <option value="">Select Country</option>
                            @foreach($countries as $country)
                            <option value="{{ $country }}">{{ $country }}</option>
                            @endforeach
                        </select>
                    </div>                        
                    <div class="form-group mb-3">
                        <label>Education Level</label>
                        <select name="level" class="form-select" required>
                            <option value="">Select Education Level</option>
                            @foreach($levels as $level)
                            <option value="{{ $level }}">{{ $level }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group mb-3">
                        <label>Year</label>
                        <select name="year" class="form-select" required>
                            <option value="">Select Year</option>
                            @foreach($years as $year)
                            <option value="{{ $year }}">{{ $year }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group mb-3">
                        <label>Intake</label>
                        <select name="intake[]" class="form-select select2" multiple="multiple" required>
                            <!-- <option value="">Select Intake</option> -->
                            <!-- @foreach($intakes as $intake)
                            <option value="{{ $intake }}">{{ $intake }}</option>
                            @endforeach -->
                            <option value="Spring">Spring</option>
                            <option value="Summer">Summer</option>
                            <option value="Fall">Fall</option>
                        </select>
                    </div>                        
                    <div class="form-group mb-3">
                        <label>Select File</label>
                        <input type="file" name="file" required />
                    </div>                        

                    <div class="form-group" style="text-align: center">
                        {{ form_submit("Submit") }}
                    </div>
                    {{ html()->form()->close() }}  
                </div>



            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection        