@extends('backend.layouts.app')
@section('title', "Course Suggestions")

@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Course Suggestions
                </h4>
            </div><!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Course Info Page"  style="margin-top: 20px;float: right;"> 
                    <a href="{{ route('admin.coursesuggestion.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Course Suggestion"><i class="bi bi-plus-circle"></i> Create</a>
                </div><!--btn-toolbar-->
            </div><!--col-->            
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table eductrl-datatable" id="sgsn_tbl">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th class="select_filter eductrl-datatable-col-header">Country</th>
                                <th class="select_filter eductrl-datatable-col-header">Level</th>
                                <th class="select_filter eductrl-datatable-col-header">Year</th>                            
                                <th class="select_filter eductrl-datatable-col-header">Intake</th>                            
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($suggestions as $suggestion)
                            <tr>
                                <td><a href="{{ route('admin.coursesuggestion.show',$suggestion->id)}}">{{ $suggestion->title }}</a></td>
                                <td>{{ $suggestion->country }}</td>
                                <td>{{ $suggestion->level }} </td>
                                <td>{{ $suggestion->year }}</td>
                                <td>{{ $suggestion->intake }}</td>
                                <td>
                                    <a href="{{ route('admin.coursesuggestion.share',$suggestion->id)}}" class="btn btn-primary btn-sm"><i class="fas fa-share"></i> Share</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection
@push('after-styles')
<link href="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
<style>
    #suggestions_tbl_filter input {
        display: block;
        width: 100%;
        height: calc(2.0625rem + 2px);
        padding: 0.375rem 0.75rem;
        font-size: 0.875rem;
        font-weight: 400;
        line-height: 1.5;
        color: #5c6873;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #e4e7ea;
        border-radius: 0.25rem;
        transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;        
    }
    
    #suggestions_tbl_paginate {
        margin-top: 15px;
    }    
    #suggestions_tbl_paginate a {
        margin-right: 5px;
        cursor: pointer;
        padding: 0.5rem 0.75rem;
        line-height: 1.25;
        border: 1px solid #c8ced3;        
    }
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script>
$(document).ready(function (){
    if ( $.fn.dataTable.isDataTable( '#sgsn_tbl' ) ) {
            table = $('#sgsn_tbl').DataTable();
        }
        else {
            table = $('#sgsn_tbl').DataTable( {
                "ordering": false,
            } );
        }
            buildSelect(table);
    });
function buildSelect(table)
{
    table.columns('.select_filter').every(function ()
    {
        var column = table.column(this, {search: 'applied'});
        var select = $('<select class="form-control"><option value=""></option></select>')
                .appendTo($(column.header()))
                .on('change', function ()
                {
                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                    column.search(val ? '^' + val + '$' : '', true, false).draw();
                });

        column.data().unique().sort().each(function (d, j)
        {
            if(d !== '')
                select.append('<option value="' + d + '">' + d + '</option>');

        });

        var currSearch = column.search();
        if (currSearch)
        {
            select.val(currSearch.substring(1, currSearch.length - 1));
        }
    });
}

</script>
@endpush