@extends('backend.layouts.app')
@section('title', "Share Course Suggestion")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Share Course Suggestion
                </h4>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.coursesuggestion') }}" class="btn btn-sm btn-primary" title="Back" > <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-8">
                    {{ html()->form('POST', route('admin.coursesuggestion.share.do', $coursesuggestion->id))->class('form-horizontal')->open() }}
                    <input type="hidden" name="suggestion" value="{{ $coursesuggestion->id }}">
                    <div style="margin-top:10px;">
                        <div class="form-group">
                            {{ $coursesuggestion->title }}
                            <br />
                            {{ $coursesuggestion->country }} / {{ $coursesuggestion->level }} / {{ $coursesuggestion->year }} / {{ $coursesuggestion->intake }}
                        </div>                        
                        <div class="form-group">
                            <label><strong>Select Student:</strong></label><br />
                            <select name="student" class="select2 form-select custom-select" style="width: 100%;" required>
                                    <option>Select</option>
                                     @foreach($students as $student)
                                     <option value="{{ $student['id'] }}">{{ $student['name'] }}</option>
                                     @endforeach
                            </select>
                        </div>
                        <div class="form-group" style="text-align: center;margin-top: 50px;">
                            <input type="submit" class="btn btn-primary" name="submit" value="Share">
                        </div>
                    </div>
                <br /><br /><br /><br /><br /><br /><br /><br />
                
                
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection        
@push('after-styles')
<!--<link href="{{ asset('assets/plugins/typeahead.js-master/dist/typehead-min.css') }}" rel="stylesheet">-->
<link href="{{ asset('assets/plugins/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css" />
@endpush
    
@push('after-scripts')
<script src="{{ asset('assets/plugins/select2/dist/js/select2.full.min.js') }}" type="text/javascript"></script>
<script>
    $(document).ready(function () {
        $(".select2").select2();
    });
</script>
@endpush