@extends('backend.layouts.app')

@section('title', app_name() . ' | ' . __('strings.backend.dashboard.title'))

@section('content')
@php $counselling_lead_status = get_counselling_lead_status(); @endphp
<section class="admin-home-page" style="padding-left: 10px;">
  	<div class="row">
		<div class="@if(env('STAFF_LEAVES_AND_ATTENDANCE_ENABLE')) col-lg-8 @else col-lg-10 @endif">
			<h3 class="dashboard-main-heading">Welcome back, {{$logged_in_user->first_name}} !</h3>
		</div>
		<div class="col-lg-2 float-right">
			<select class="form-select" id="branch" name="branch">
					<option value="all" @if($current_branch == 'all') selected="selected" @endif>All Branch</option>
					@foreach($branch as $id => $name)
					<option value="{{ $id }}" @if($current_branch == $id) selected="selected" @endif>{{ $name }}</option>
					@endforeach
			</select>
		</div>
    @if(env('STAFF_LEAVES_AND_ATTENDANCE_ENABLE'))
     <div class="col-md-2" style="text-align: right;">
      <span style="font-size: 20px!important;"><span id="hours" style="font-weight:bold;font-size: 20px!important;">0</span>:<span id="minutes" style="font-weight:bold;font-size: 20px!important;">00</span>:<span id="seconds" style="font-size: 20px!important;">00</span></span>
      <button id="clockin" title="Clock-In" class="btn btn-success ml-3" onclick="doClockIn()" @if($working || $work_completed) style="display:none;" @endif><i class="fa fa-clock"></i></button>
      <button id="clockout" title="Clock-Out" class="btn btn-danger ml-3" onclick="doClockOut()" @if(!$working || $work_completed) style="display:none;" @endif><i class="fa fa-clock"></i></button>
    </div>
    @endif
	</div>

	<div class="row bg-white shadow-sm pt-4 mx-1">
		<div class="col-md-3">
			<div class="row">
				<div class="rounded ms-3" style="background-color: #fef9c1; width: 2.5rem !important; height: 2.5rem !important; display:flex; justify-content:center; align-items:center;">
					<i class="bi bi-people text-warning" style="font-size: 25px !important;"></i>
				</div>
				<div class="col-9">
					<div style="font-size: 15px !important; margin: 0px !important; padding: 0; line-height: 1em; color:rgb(54, 54, 54)">Leads</div>
					<div style="font-size: 22px !important; margin: 0px !important; padding: 0; line-height: 1.4em;" id="allOpenLeadsCount" class="fw-bolder" >@if($allOpenLeads){{$allOpenLeads}}@else 0 @endif</div>
				</div>
			</div>
			<div class="row">
				<p class="ps-3 text-muted">Open Leads</p>
			</div>
		</div>
		<div class="col-md-3">
			<div class="row">
				<div class="rounded ms-3" style="background-color: #cce0ff; width: 2.5rem !important; height: 2.5rem !important; display:flex; justify-content:center; align-items:center;">
					<i class="bi bi-person text-primary" style="font-size: 25px !important;"></i>
				</div>
				<div class="col-9">
					<div style="font-size: 15px !important; margin: 0px !important; padding: 0; line-height: 1em; color:rgb(54, 54, 54)">{{_label('backend_students')}}</div>
					<div style="font-size: 22px !important; margin: 0px !important; padding: 0; line-height: 1.4em;" id="allOpenStudentCount" class="fw-bolder" >@if($allStudents){{$allStudents}}@else 0 @endif</div>
				</div>
			</div>
			<div class="row">
				<p class="ps-3 text-muted">Total {{_label('backend_students')}}</p>
			</div>
		</div>
		<div class="col-md-3">
			<div class="row">
				<div class="rounded ms-3" style="background-color: rgb(222,246,254); width: 2.5rem !important; height: 2.5rem !important; display:flex; justify-content:center; align-items:center;">
					<i class="bi bi-card-checklist" style="font-size: 25px !important; color: rgb(0, 153, 204);"></i>
				</div>
				<div class="col-9">
					<div style="font-size: 15px !important; margin: 0px !important; padding: 0; line-height: 1em; color:rgb(54, 54, 54)">Applications</div>
					<div style="font-size: 22px !important; margin: 0px !important; padding: 0; line-height: 1.4em;" id="allOpenApplicationCount" class="fw-bolder" >@if($allOpenApplications){{$allOpenApplications}}@else 0 @endif</div>
				</div>
			</div>
			<div class="row">
				<p class="ps-3 text-muted">Open Applications</p>
			</div>
		</div>
		
		<div class="col-md-3">
			<div class="row">
				<div class="rounded ms-3" style="background-color: #e0cefd; width: 2.5rem !important; height: 2.5rem !important; display:flex; justify-content:center; align-items:center;">
					<i class="bi bi-chat-left" style="font-size: 20px !important; color: rgb(104, 0, 224);"></i>
				</div>
				<div class="col-9">
					<div style="font-size: 15px !important; margin: 0px !important; padding: 0; line-height: 1em; color:rgb(54, 54, 54)">{{_label('backend_support_tickets_menu')}}</div>
					<div style="font-size: 22px !important; margin: 0px !important; padding: 0; line-height: 1.4em;" id="allOpenTicketsCount" class="fw-bolder" >@if($allOpenTickets){{$allOpenTickets}}@else 0 @endif</div>
				</div>
			</div>
			<div class="row">
				<p class="ps-3 text-muted">Open {{_label('backend_support_tickets_menu')}}</p>
			</div>
		</div>
	</div>

	<div class="row mt-3 mb-4 ">
		<div class="col-md-8 ">
			<div class="shadow-sm border rounded py-2 px-2 h-100 bg-white px-4 pt-4">
				<h4 style="font-size: 14px !important; font-weight: bold;">{{_label('backend_students')}}</h4>
				<canvas id="studentsCreatedChart"></canvas>
				<p class="text-center text-muted pb-0 pt-3 mb-0" style="font-size: 12px !important;">Last 14 Days</p>
			</div>
		</div>
		<div class="col-md-4 mt-3 mt-md-0">
			<div class="row">
				<div class="col-12">
					<div class="shadow-sm border rounded py-2 px-2 bg-white px-4 pt-4">
						<h4 style="font-size: 14px !important; font-weight: bold;">Leads</h4>
						<canvas id="leadsCreatedChart"></canvas>
						<p class="text-center text-muted pb-0 mb-0" style="font-size: 12px !important;">Last 7 Days</p>
					</div>
				</div>
				<div class="col-12 mt-3">
					<div class="shadow-sm border rounded py-2 px-2 bg-white px-4 pt-4">
						<h4 style="font-size: 14px !important; font-weight: bold;">Applications</h4>
						<canvas id="applicationsCreatedChart"></canvas>
						<p class="text-center text-muted pb-0 mb-0" style="font-size: 12px !important;">Last 7 Days</p>
					</div>
				</div>
			</div>
		</div>
	</div>

  {{-- <div class="row accordion ">
    <div class="col-12 ">
        <button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold fw-bold" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#pending-followup-accordion" aria-expanded="true" aria-controls="pending-followup-accordion">
          Pending Follow-ups
        </button>
      <div class="row accordion-collapse" id="pending-followup-accordion">
        <div class="col-lg-6">
          <div class="card dashboard-card mt-1">
            <div class="container" style="padding-right: 0px;">
              <div class="row dashboard-row justify-content-between">
                <div class="col-9">
                  <h5 class="dashboard-main-heading"> Pending Lead Follow-ups</h5>
                </div>
                <div class="col-3">
                  @if(count($today_followups))
                  <h3 class="dashboard-main-heading" style="text-align: end;font-size:12px;"><a href="{{route('admin.leadmanagementdetails')}}/?followup_daterange=todayPlusPast">View All ({{count($today_followups)}})</a></h3>
                  @endif
                </div>
              </div>
            </div>

            @if(count($today_followups))
            <div class="people-list" id="people-list" style="margin-top: 10px;">
              <ul class="list">
              @foreach($today_followups as $lead)
                <a target="_blank" href="{{url('admin/leads?lead_info=')}}{{$lead->id}}&&q=nextfollowup::todayPlusPast">
                <li class="clearfix mx-3">
                  <div class="staus-pic mx-2">
                    @if($lead->gender == "female")
                    <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                    @else
                    <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                    @endif
                  </div>
                  <div class="about">
                    <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$lead->full_name}}</div>
                    @if(date('d-m-y', strtotime($lead->next_followup)) == date('d-m-y'))
                    <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('h:i A', strtotime($lead->next_followup))}} &nbsp; {{($lead->lead_status == get_counselling_lead_status())? " - Counselling " : ''}} - 
                      @if($logged_in_user->id == $lead->assigned_to)
                          You  
                        @else
                        {{get_user_full_name_by_id($lead->assigned_to)}} {{($lead->lead_status == get_counselling_lead_status())? " - Counselling" : ''}}
                        @endif
                      </div>
                    @else
                    <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('d M, h:i A', strtotime($lead->next_followup))}} &nbsp;<i class="bi bi-exclamation-circle text-warning"></i> {{($lead->lead_status == get_counselling_lead_status())? " - Counselling - " : ''}} - 
                      @if($logged_in_user->id == $lead->assigned_to)
                          You 
                        @else
                        {{get_user_full_name_by_id($lead->assigned_to)}} {{($lead->lead_status == get_counselling_lead_status())? " - Counselling" : ''}}
                        @endif </div>
                    @endif
                  </div>
                </li>
              </a>
              @endforeach
              </ul>
            </div>
            @else
            <div class="text-center p-3">
              No pending follow-ups!
            </div>
            @endif

          </div>
        </div>

        <div class="col-lg-6">
          <div class="card dashboard-card mt-1">
            <div class="container" style="padding-right: 0px;">
              <div class="row dashboard-row justify-content-between">
                <div class="col-9">
                  <h5 class="dashboard-main-heading"> Pending Student Follow-ups</h5>
                </div>
                <div class="col-3">
                  @if(count($today_stu_followups))
                  <h3 class="dashboard-main-heading" style="text-align: end;font-size:12px;"><a href="{{route('admin.auth.user.index')}}?query=nextfollowup::todayPlusPast">View All ({{count($today_stu_followups)}})</a></h3>
                  @endif
                </div>
              </div>
            </div>

            @if(count($today_stu_followups))
            <div class="people-list" id="people-list" style="margin-top: 10px;">
              <ul class="list">
                @foreach($today_stu_followups as $stu_follow)
                <a target="_blank" href="{{url('admin/auth/user/')}}/{{$stu_follow->id}}">
                  <li class="clearfix mx-3">
                    <div class="staus-pic mx-2">
                      @if($stu_follow->gender == "female")
                      <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                      @else
                      <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                      @endif
                    </div>
                  <div class="about">
                    <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$stu_follow->first_name." ".$stu_follow->last_name}}</div>
                    @if(date('d-m-y', strtotime($stu_follow->next_followup)) == date('d-m-y'))
                      <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('d M, g:ia', strtotime($stu_follow->next_followup))}}
                          @if($logged_in_user->id == $stu_follow->assigned_to)
                            - You  
                          @else
                            - {{get_user_full_name_by_id($stu_follow->assigned_to)}}
                          @endif
                      </div>
                    @else
                        <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('d M, g:ia', strtotime($stu_follow->next_followup))}} &nbsp;<i class="bi bi-exclamation-circle text-warning"></i>
                            @if($logged_in_user->id == $stu_follow->assigned_to)
                                - You 
                            @else
                              - {{get_user_full_name_by_id($stu_follow->assigned_to)}}
                            @endif
                        </div>
                    @endif
                  </div>
                </li>
                </a>
                @endforeach
              </ul>
            </div>
            @else
            <div class="text-center p-3">
              No pending follow-ups!
            </div>
            @endif
          </div>
        </div>
      </div>
    </div>
  </div> --}}
  <div class="row accordion ">
    <div class="col-12 ">
        <button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold fw-bold" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#future-followup-accordion" aria-expanded="true" aria-controls="future-followup-accordion">
          Follow-ups
        </button>
      <div class="row accordion-collapse" id="future-followup-accordion">
        <div class="col-lg-6">
          <div class="card dashboard-card mt-1">
            <div class="container" style="padding-right: 0px;">
              <div class="row dashboard-row justify-content-between" style="border-bottom: 0px !important;">
                <div class="col-9">
                  <h5 class="dashboard-main-heading">Lead Follow-ups</h5>
                </div>
              </div>
              <div class="row justify-content-between">
                <div class="col-12">
                  <ul class="nav nav-tabs" id="leadTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button style="font-weight:bold;" class="nav-link active" id="today-tab" data-bs-toggle="tab" data-bs-target="#lead_today" type="button" role="tab" aria-controls="today" aria-selected="true"><i class="bx bxs-id-card"></i> Today</button>
                    </li>
                    <li class="nav-item" role="presentation">
                      <button style="font-weight:bold;" class="nav-link" id="due-tab" data-bs-toggle="tab" data-bs-target="#lead_due" type="button" role="tab" aria-controls="due" aria-selected="true"><i class="bx bxs-id-card"></i> Due</button>
                    </li>
                    <li class="nav-item" role="presentation">
                      <button style="font-weight:bold;" class="nav-link" id="upcomming-tab" data-bs-toggle="tab" data-bs-target="#lead_upcomming" type="button" role="tab" aria-controls="upcomming" aria-selected="true"><i class="bx bxs-id-card"></i> Upcoming</button>
                    </li>
                  </ul>
                </div>
                <div class="tab-content" id="myTabContent">
                  <div class="tab-pane fade show active" id="lead_today" role="tabpanel" aria-labelledby="today-tab">
                    <div class="row">
                      <div class="col-sm-12 col-md-12">
                          @if(count($today_followups))
                          <div class="people-list" id="people-list" style="margin-top: 10px;">
                            <ul class="list">
                            @foreach($today_followups as $lead)
                              <a target="_blank" href="{{url('admin/leads?lead_info=')}}{{$lead->id}}&&q=nextfollowup::future">
                              <li class="clearfix mx-3">
                                <div class="staus-pic mx-2">
                                  @if($lead->gender == "female")
                                  <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @else
                                  <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @endif
                                </div>
                                <div class="about">
                                  <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$lead->full_name}}</div>
                                    <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('h:i A', strtotime($lead->next_followup))}} &nbsp;{{($lead->lead_status == $counselling_lead_status)? " - Counselling " : ''}} - 
                                      @if($logged_in_user->id == $lead->assigned_to)
                                        You  
                                      @else
                                      {{$lead->staff_first_name}} {{$lead->staff_last_name}} {{($lead->lead_status == $counselling_lead_status)? " - Counselling" : ''}}
                                      @endif
                                    </div>
                                </div>
                              </li>
                            </a>
                            @endforeach
                            </ul>
                          </div>
                            <a style="float: right;" class="p-2 pb-0" href="{{route('admin.leadmanagementdetails')}}/?followup_daterange=today">View All ({{count($today_followups)}})</a>
                          @else
                          <div class="text-center p-3">
                            No follow-ups for today!
                          </div>
                          @endif
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="lead_due" role="tabpanel" aria-labelledby="due-tab">
                    <div class="row">
                      <div class="col-sm-12 col-md-12">
                          @if(count($due_followups))
                          <div class="people-list" id="people-list" style="margin-top: 10px;">
                            <ul class="list">
                            @foreach($due_followups as $lead)
                              <a target="_blank" href="{{url('admin/leads?lead_info=')}}{{$lead->id}}&&q=nextfollowup::future">
                              <li class="clearfix mx-3">
                                <div class="staus-pic mx-2">
                                  @if($lead->gender == "female")
                                  <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @else
                                  <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @endif
                                </div>
                                <div class="about">
                                  <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$lead->full_name}}</div>
                                    <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('d M Y, g:ia', strtotime($lead->next_followup))}} &nbsp;{{($lead->lead_status == $counselling_lead_status)? " - Counselling " : ''}} - 
                                      @if($logged_in_user->id == $lead->assigned_to)
                                        You  
                                      @else
                                      {{$lead->staff_first_name}} {{$lead->staff_last_name}} {{($lead->lead_status == $counselling_lead_status)? " - Counselling" : ''}}
                                      @endif
                                    </div>
                                </div>
                              </li>
                            </a>
                            @endforeach
                            </ul>
                          </div>
                          <a style="float: right;" class="p-2 pb-0" href="{{route('admin.leadmanagementdetails')}}/?followup_daterange=past">View All ({{count($due_followups)}})</a>
                          @else
                          <div class="text-center p-3">
                            No due follow-ups!
                          </div>
                          @endif
                      </div>
                    </div>
                  </div>


                  <div class="tab-pane fade" id="lead_upcomming" role="tabpanel" aria-labelledby="upcomming-tab">
                    <div class="row">
                      <div class="col-sm-12 col-md-12">
                          @if(count($future_followups))
                          <div class="people-list" id="people-list" style="margin-top: 10px;">
                            <ul class="list">
                            @foreach($future_followups as $lead)
                              <a target="_blank" href="{{url('admin/leads?lead_info=')}}{{$lead->id}}&&q=nextfollowup::future">
                              <li class="clearfix mx-3">
                                <div class="staus-pic mx-2">
                                  @if($lead->gender == "female")
                                  <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @else
                                  <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @endif
                                </div>
                                <div class="about">
                                  <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$lead->full_name}}</div>
                                    <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('d M Y, g:ia', strtotime($lead->next_followup))}} &nbsp;{{($lead->lead_status == $counselling_lead_status)? " - Counselling " : ''}} - 
                                      @if($logged_in_user->id == $lead->assigned_to)
                                        You  
                                      @else
                                      {{$lead->staff_first_name}} {{$lead->staff_last_name}} {{($lead->lead_status == $counselling_lead_status)? " - Counselling" : ''}}
                                      @endif
                                    </div>
                                </div>
                              </li>
                            </a>
                            @endforeach
                            </ul>
                          </div>
                          <a style="float: right;" class="p-2 pb-0" href="{{route('admin.leadmanagementdetails')}}/?followup_daterange=future">View All ({{count($future_followups)}})</a>
                          @else
                          <div class="text-center p-3">
                            No upcoming follow-ups!
                          </div>
                          @endif
                      </div>
                    </div>
                  </div>

                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="card dashboard-card mt-1">
            <div class="container" style="padding-right: 0px;">
              <div class="row dashboard-row justify-content-between" style="border-bottom: 0px !important;">
                <div class="col-9">
                  <h5 class="dashboard-main-heading"> Student Follow-ups</h5>
                </div>
              </div>
              <div class="row justify-content-between">
                <div class="col-12">
                  <ul class="nav nav-tabs" id="stuTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button style="font-weight:bold;" class="nav-link active" id="stu-today-tab" data-bs-toggle="tab" data-bs-target="#stu_today" type="button" role="tab" aria-controls="stu-today" aria-selected="true"><i class="bx bxs-id-card"></i> Today</button>
                    </li>
                    <li class="nav-item" role="presentation">
                      <button style="font-weight:bold;" class="nav-link" id="stu-due-tab" data-bs-toggle="tab" data-bs-target="#stu_due" type="button" role="tab" aria-controls="stu-due" aria-selected="true"><i class="bx bxs-id-card"></i> Due</button>
                    </li>
                    <li class="nav-item" role="presentation">
                      <button style="font-weight:bold;" class="nav-link" id="stu-upcomming-tab" data-bs-toggle="tab" data-bs-target="#stu_upcomming" type="button" role="tab" aria-controls="stu-upcomming" aria-selected="true"><i class="bx bxs-id-card"></i> Upcoming</button>
                    </li>
                  </ul>
                </div>
                <div class="tab-content" id="myTabContent">
                  <div class="tab-pane fade show active" id="stu_today" role="tabpanel" aria-labelledby="stu-today-tab">
                    <div class="row">
                      <div class="col-sm-12 col-md-12">
                        @if(count($today_stu_followups))
                        <div class="people-list" id="people-list" style="margin-top: 10px;">
                          <ul class="list">
                            @foreach($today_stu_followups as $stu_follow)
                            <a target="_blank" href="{{url('admin/auth/user/')}}/{{$stu_follow->id}}">
                              <li class="clearfix mx-3">
                                <div class="staus-pic mx-2">
                                  @if($stu_follow->gender == "female")
                                  <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @else
                                  <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @endif
                                </div>
                              <div class="about">
                                <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$stu_follow->first_name." ".$stu_follow->last_name}}</div>
                                  <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('g:ia', strtotime($stu_follow->next_followup))}}
                                      @if($logged_in_user->id == $stu_follow->assigned_to)
                                        - You  
                                      @else
                                        - {{$stu_follow->staff_first_name}} {{$stu_follow->staff_last_name}}
                                      @endif
                                  </div>
                              </div>
                            </li>
                            </a>
                            @endforeach
                          </ul>
                        </div>
                        <a style="float: right;" class="p-2 pb-0" href="{{route('admin.auth.user.index')}}?query=nextfollowup::today">View All ({{count($today_stu_followups)}})</a>
                        @else
                        <div class="text-center p-3">
                          No follow-ups for today!
                        </div>
                        @endif
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="stu_due" role="tabpanel" aria-labelledby="stu-due-tab">
                    <div class="row">
                      <div class="col-sm-12 col-md-12">
                        @if(count($due_stu_followups))
                        <div class="people-list" id="people-list" style="margin-top: 10px;">
                          <ul class="list">
                            @foreach($due_stu_followups as $stu_follow)
                            <a target="_blank" href="{{url('admin/auth/user/')}}/{{$stu_follow->id}}">
                              <li class="clearfix mx-3">
                                <div class="staus-pic mx-2">
                                  @if($stu_follow->gender == "female")
                                  <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @else
                                  <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @endif
                                </div>
                              <div class="about">
                                <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$stu_follow->first_name." ".$stu_follow->last_name}}</div>
                                  <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('d M Y, g:ia', strtotime($stu_follow->next_followup))}}
                                      @if($logged_in_user->id == $stu_follow->assigned_to)
                                        - You  
                                      @else
                                        - {{$stu_follow->staff_first_name}} {{$stu_follow->staff_last_name}}
                                      @endif
                                  </div>
                              </div>
                            </li>
                            </a>
                            @endforeach
                          </ul>
                        </div>
                        <a style="float: right;" class="p-2 pb-0" href="{{route('admin.auth.user.index')}}?query=nextfollowup::past">View All ({{count($due_stu_followups)}})</a>
                        @else
                        <div class="text-center p-3">
                          No due follow-ups!
                        </div>
                        @endif
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="stu_upcomming" role="tabpanel" aria-labelledby="stu-upcomming-tab">
                    <div class="row">
                      <div class="col-sm-12 col-md-12">
                        @if(count($future_stu_followups))
                        <div class="people-list" id="people-list" style="margin-top: 10px;">
                          <ul class="list">
                            @foreach($future_stu_followups as $stu_follow)
                            <a target="_blank" href="{{url('admin/auth/user/')}}/{{$stu_follow->id}}">
                              <li class="clearfix mx-3">
                                <div class="staus-pic mx-2">
                                  @if($stu_follow->gender == "female")
                                  <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @else
                                  <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                                  @endif
                                </div>
                              <div class="about">
                                <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$stu_follow->first_name." ".$stu_follow->last_name}}</div>
                                  <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">{{date('d M Y, g:ia', strtotime($stu_follow->next_followup))}}
                                      @if($logged_in_user->id == $stu_follow->assigned_to)
                                        - You  
                                      @else
                                        - {{$stu_follow->staff_first_name}} {{$stu_follow->staff_last_name}}
                                      @endif
                                  </div>
                              </div>
                            </li>
                            </a>
                            @endforeach
                          </ul>
                        </div>
                        <a style="float: right;" class="p-2 pb-0" href="{{route('admin.auth.user.index')}}?query=nextfollowup::future">View All ({{count($future_stu_followups)}})</a>
                        @else
                        <div class="text-center p-3">
                          No upcoming follow-ups!
                        </div>
                        @endif
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
   <div class="row accordion">
    <div class="col-12">
        <button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#upcoming-application-accordion" aria-expanded="true" aria-controls="upcoming-application-accordion">
          Reminders
        </button>
      <div class="row accordion-collapse" id="upcoming-application-accordion">
        <div class="col-lg-12">
          <div class="card dashboard-card mt-1">
            <div class="" style="padding-right: 0px;">
              <div class="row dashboard-row justify-content-between">
                <div class="col-9">
                  <h5 class="dashboard-main-heading"> University/Visa Application Reminders</h5>
                </div>
                <div class="col-3">
                  @if(count($reminderData))
                  <h6 class="dashboard-main-heading" style="text-align: end;font-size:12px;">{{count(array_filter($reminderData))}} Reminder(s)</h6>
                  @endif
                </div>
              </div>
            </div>

            @if(count($reminderData))
            <div class="people-list" id="people-list" style="margin-top: 10px;">
              <ul class="list">
                @foreach($reminderData as $app_tasks)
                  @if(!empty($app_tasks))
                    @if($app_tasks->entity == 'university_application')
                      <a target="_blank" href="{{url('admin/application/detail/')}}/{{$app_tasks->id}}">
                    @else
                      <a target="_blank" href="{{url('admin/service-and-visa/view/')}}/{{$app_tasks->id}}">
                    @endif
                    <li class="clearfix mx-3">
                      <div class="staus-pic mx-2">
                        @if($app_tasks->gender == "female")
                        <img src="{{asset('assets/images/users/girl.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                        @else
                        <img src="{{asset('assets/images/users/boy.png')}}" width="40px" height="40px" style="border-radius: 50%" class="border" alt="">
                        @endif
                      </div>
                    <div class="about">
                      <div class="name" style="font-size: 14px !important; font-weight: 600;">{{$app_tasks->first_name." ".$app_tasks->last_name}} - {{($app_tasks->entity == 'university_application')? "University": "Visa"}} Application #{{$app_tasks->appl_id}}</div>
                      @if(date('d-m-y', strtotime($app_tasks->deadline)) < date('d-m-y'))
                        <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">Deadline: {{date('d M Y', strtotime($app_tasks->deadline))}} &nbsp;<i class="bi bi-exclamation-circle text-warning"></i>
                            @if($logged_in_user->id == $app_tasks->assign_to)
                              - You - <b>Activity: </b>{{Str::limit($app_tasks->activity, 100)}}
                            @else
                              - {{$app_tasks->staff_first_name}} {{$app_tasks->staff_last_name}} - <b>Activity: </b>{{Str::limit($app_tasks->activity, 100)}}
                            @endif
                        </div>
                      @else
                          <div class="time" style="font-size: 13px !important; color: #686464; font-weight: 400;">Deadline: {{date('d M Y', strtotime($app_tasks->deadline))}}
                              @if($logged_in_user->id == $app_tasks->assign_to)
                                  - You - <b>Activity: </b>{{Str::limit($app_tasks->activity, 100)}}
                              @else
                                - {{$app_tasks->staff_first_name}} {{$app_tasks->staff_last_name}} - <b>Activity: </b>{{Str::limit($app_tasks->activity, 100)}}
                              @endif
                          </div>
                      @endif
                    </div>
                  </li>
                  </a>
                  @endif
                @endforeach
              </ul>
            </div>
            @else
            <div class="text-center p-3">
              No Reminders Found!
            </div>
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>

  @if(!\Auth::user()->can('view assigned data only'))
  @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
  	<div class="row accordion ">
    	<div class="col-12 ">
			<button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#study-abroad-stats" aria-expanded="true" aria-controls="study-abroad-stats">
			STUDY ABROAD STATS
			</button>
			<div class="row accordion-collapse show" id="study-abroad-stats">
				<h6>University Applications</h6>
				@foreach($allApplicationStatus as $key => $applicationStatus)
				<div class="col-md-3 col-sm-4 col-6">
					<div class="card text-white" style="cursor:pointer; height:95px; background-color: {{get_application_status_color($key)}}" onclick="document.location='{{route('admin.applications').'/?q='.$key}}'">
						<div class="card-body">
							<div class="stats-heading">
								<span>{{$key}}</span>
								<i class="fas fa-chart-pie float-end"></i>
							</div>
							<div class="stats-count">{{$applicationStatus}}</div>
						</div>
					</div>
				</div>
				@endforeach			
				<div class="col-md-3 col-sm-4 col-6">
					<div class="card bg-primary text-white" style=" height:95px; cursor:pointer;" onclick="document.location='{{route('admin.applications')}}'">
						<div class="card-body">
						<div class="stats-heading">
							<span>Total Applications</span>
							<i class="fas fa-chart-pie float-end"></i>
						</div>
						<div class="stats-count">{{$appl_total}}</div>
						</div>
					</div>
				</div> 
			</div>
		</div>
  	</div>

  <div class="row accordion ">
    <div class="col-12 ">
        <button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold collapsed" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#student-stats" aria-expanded="true" aria-controls="student-stats">
          {{_label('backend_students')}}
        </button>
      <div class="row accordion-collapse collapse" id="student-stats">
    
    @foreach($allStudentStatus as $stu_key => $studentStatus)
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card text-white" style="cursor:pointer; height:95px; background-color: {{get_overseas_status_color($stu_key)}}" onclick="document.location='{{route('admin.auth.user.index').'/?query='.$stu_key}}'">
        <div class="card-body">
          <div class="stats-heading">
            <span>{{$stu_key}}</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$studentStatus}}</div>
        </div>
      </div>
    </div>
  @endforeach

    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q='}}'" style="cursor:pointer;height:95px;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Total {{_label('backend_students')}}</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_total}}</div>

        </div>
      </div>
    </div>

  </div>
</div>
</div>
  @endif

  @if($logged_in_user->isAdmin() || $logged_in_user->can('leads'))
  <div class="row accordion ">
    <div class="col-12 ">
        <button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold collapsed" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#leads-stats" aria-expanded="true" aria-controls="leads-stats">
          LEADS
        </button>
      	<div class="row accordion-collapse collapse" id="leads-stats">
			@foreach($allLeadsStatus as $key => $leadStatus)
			<div class="col-md-3 col-sm-4 col-6">
				<div class="card" style="cursor:pointer; background-color: {{get_lead_status_color($key)}}; height:95px;" onclick="document.location='{{route('admin.leadmanagementdetails').'/?allStatus='.$key}}'">
					<div class="card-body">
						<div class="stats-heading">
							<span style="color: black">{{$key}}</span>
							<i class="fas fa-chart-pie float-end"></i>
						</div>
						<div class="stats-count" style="color: black">{{$leadStatus}}</div>
					</div>
				</div>
			</div>
			@endforeach
    		<div class="col-md-3 col-sm-4 col-6">
				<div class="card bg-info text-white" onclick="document.location='{{route('admin.leadmanagementdetails').'/?allOpenLeads=1'}}'" style="cursor:pointer; height:95px;">
					<div class="card-body">
						<div class="stats-progress">TOTAL LEADS
							<i class="fas fa-chart-pie float-end"></i>
						</div>
						<div class="stats-count">{{$total_leads}}</div>
					</div>
				</div>
			</div>
		</div>							
  	</div>
  </div>
  @endif

  @if($logged_in_user->isAdmin() || $logged_in_user->can('support tickets'))
  <div class="row accordion ">
    <div class="col-12 ">
        <button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold collapsed" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#tickets-stats" aria-expanded="true" aria-controls="tickets-stats">
          TICKETS
        </button>
      	<div class="row accordion-collapse collapse" id="tickets-stats">
    		<div class="col-md-3 col-sm-4 col-6">
				<div class="card" onclick="document.location='{{route('admin.ticketlist').'/?q=allstatus::new'}}'" style="cursor:pointer; height:95px;">
					<div class="card-body">
						<div class="stats-progress">New Tickets <i class="fas fa-chart-pie float-end"></i></div>
						<div class="stats-count">{{$ticket_new}}</div>
					</div>
				</div>
			</div>
			<div class="col-md-3 col-sm-4 col-6">
			<div class="card" onclick="document.location='{{route('admin.ticketlist').'/?q=allstatus::customer_reply'}}'" style="cursor:pointer; height:95px;">
				<div class="card-body">
					<div class="stats-progress">User Replied <i class="fas fa-chart-pie float-end"></i></div>
					<div class="stats-count">{{$ticket_cust}}</div>
				</div>
			</div>
		</div>
			<div class="col-md-3 col-sm-4 col-6">
			<div class="card" onclick="document.location='{{route('admin.ticketlist').'/?q=allstatus::inprogress'}}'" style="cursor:pointer; height:95px;">
				<div class="card-body">
					<div class="stats-progress">In progress <i class="fas fa-chart-pie float-end"></i></div>
					<div class="stats-count">{{$ticket_inprogress}}</div>
				</div>
			</div>
			</div>
		</div>
  </div>
  </div>
  @endif
@endif

<div class="row accordion ">
	<div class="col-12 ">
	<button class="accordion-button text-dark py-2 text-uppercase shadow-sm fw-bold collapsed" style="font-size: 14px !important; background-color: rgb(237,239,255) !important;" type="button" data-bs-toggle="collapse" data-bs-target="#your-stats" aria-expanded="true" aria-controls="your-stats">
		YOUR STATS
	</button>
	<div class="row accordion-collapse collapse" id="your-stats">
		@if($logged_in_user->isAdmin() || $logged_in_user->can('leads'))
		<h6>LEADS</h6>
		@foreach($myOpenLeadStatus as $key => $leadStatus)
			<div class="col-md-3 col-sm-4 col-6">
				<div class="card" style="cursor:pointer;  height:95px; background-color: {{get_lead_status_color($key)}}" onclick="document.location='{{route('admin.leadmanagementdetails').'/?status='.$key.'&&my_leads='.Auth::user()->id}}'">
					<div class="card-body">
						<div class="stats-heading">
							<span style="color: black">{{$key}}</span>
							<i class="fas fa-chart-pie float-end"></i>
						</div>
						<div class="stats-count" style="color: black">{{$leadStatus}}</div>
					</div>
				</div>
			</div>
		@endforeach
		<div class="col-md-3 col-sm-4 col-6">
			<div class="card  bg-info text-white" style="cursor:pointer; height:95px; " onclick="document.location='{{route('admin.leadmanagementdetails').'/?my_leads='.Auth::user()->id}}'">
				<div class="card-body">
					<div class="stats-heading">
						<span>My Total Leads</span>
						<i class="fas fa-chart-pie float-end"></i>
					</div>
					<div class="stats-count">{{$myOpenLeads}}</div>
				</div>
			</div>
		</div>
		@endif
		<div class="row">
			@if($logged_in_user->isAdmin() || $logged_in_user->can('support tickets'))
			<h6>TICKETS</h6>
			<div class="col-md-3 col-sm-4 col-6">
				<div class="card bg-primary text-white" onclick="document.location='{{route('admin.ticketlist').'/?q=mystatus::new&&logged_in_user='.Auth::user()->id}}'" style="cursor:pointer; height:95px;">
					<div class="card-body">
						<div class="stats-heading">
							<span>New Tickets</span>
							<i class="fas fa-chart-pie float-end"></i>
						</div>
						<div class="stats-count">{{$ticket_new_my}}</div>
					</div>
				</div>
			</div>
			<div class="col-md-3 col-sm-4 col-6">
				<div class="card text-white bg-success" onclick="document.location='{{route('admin.ticketlist').'/?q=mystatus::customer_reply&&logged_in_user='.Auth::user()->id}}'" style="cursor:pointer; height:95px;">
					<div class="card-body">
						<div class="stats-heading">
							<span>User Replied</span>
							<i class="fas fa-chart-pie float-end"></i>
						</div>
						<div class="stats-count">{{$ticket_cust_my}}</div>
					</div>
				</div>
			</div>
			@endif
		</div>
	</div>
</div>
</div>
</div>

	{{-- @if(!\Auth::user()->can('view assigned data only'))
	<div class="row dashboard">
		<div class="col-lg-12">
			<div class="row">
				<div class="col-md-12">
					<div class="row">
						<div class="col-xxl-12 col-md124">
							<div class="card ">
								<div class="card-body">
									<div class="row">
										<div class="col-md-8">
											<div class="ps-3">
												@if(config('app.product_code') == 'VISA')
												<h5 class="card-title" style="font-size:20px;font-weight: 600;padding-bottom: 0px;">Clients</h5>
												@else
												<h5 class="card-title" style="font-size:20px;font-weight: 600;padding-bottom: 0px;">Students</h5>
												@endif
												<div id="signup_chart_block">
												</div>
											</div>
										</div>
										<div class="col-md-4 card-title">
											<div class="row">
												<div class="col-md-6 col-mb">
													<h3 class="dashboard-heading">{{ $user_registered }}</h3>
													<p class="dashboard-text">Total</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	@endif --}}
</section>

@endsection

@push('after-styles')
<style>
	.stat_num {
		text-align: center;
		font-size: 2em;
	}

	.stat_info {
		margin-bottom: 0;
	}

  .stats-heading span {
    white-space: nowrap;  
    overflow: hidden;   
    text-overflow: ellipsis;  
  }
</style>
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script type="text/javascript">

	//FOR LEADS CHARTS
	const ctx = document.getElementById('leadsCreatedChart');
    new Chart(ctx, {
        // type: 'line',
        type: 'bar',
        data: {
            labels: [{!!implode(",", $leads_created_labels)!!}],
            datasets: [{
                label: 'Leads',
                data: [{!!implode(",", $leads_created_data)!!}],
                // borderWidth: 2,
				// backgroundColor: "rgba(234,179,8,0.1)",
				// borderColor: "rgba(234,179,8,0.8)",
				// hoverBackgroundColor: "rgba(234,179,8,0.4)",
				// hoverBorderColor: "rgba(234,179,8,1)",
				// pointStyle: 'circle',
				// pointRadius: 2,
				// fill: true,
				// pointHoverRadius: 6,
				// tension: 0.5

				borderWidth: 0,
                barThickness: 10,
                borderRadius: 5,
                borderSkipped: false,
				backgroundColor: "rgb(234,179,8)",
				borderColor: "rgb(234,179,8)",
				hoverBackgroundColor: "rgb(234,179,8)",
				pointStyle: 'circle',
				pointRadius: 2,
				fill: true,
				pointHoverRadius: 6,
				tension: 0.5
            }]
        },
        options: {
            scales: {
				x: {
					grid: {
						display: false,
					}
				},
                y: {
                    beginAtZero: true,	
					grid: {
						display: false,
					},
          ticks: {
                    stepSize: 1, 
                    callback: function(value) {
                        return Number.isInteger(value) ? value : null; 
                    }
                },
					step: 1
                }
            },
			plugins: {
				legend: {
					display: false
				}
			}
        }
    });
	

	//FOR STUDENTS CHARTS
	const ctx2 = document.getElementById('studentsCreatedChart');
    new Chart(ctx2, {
        // type: 'line',
        type: 'bar',
        data: {
            labels: [{!!implode(",", $students_created_labels)!!}],
            datasets: [{
				label: 'Students',
                data: [{!!implode(",", $students_created_data)!!}],
                // borderWidth: 2,
				// backgroundColor: "rgba(13,110,253,0.1)",
				// borderColor: "rgba(13,110,253,0.8)",
				// hoverBackgroundColor: "rgba(13,110,253,0.4)",
				// hoverBorderColor: "rgba(13,110,253,1)",
				// pointStyle: 'circle',
				// pointRadius: 2,
				// fill: true,
				// pointHoverRadius: 6,
				// tension: 0.5

				borderWidth: 0,
                barThickness: 10,
                borderRadius: 5,
                borderSkipped: false,
				backgroundColor: "rgb(13,110,253)",
				borderColor: "rgb(13,110,253)",
				hoverBackgroundColor: "rgb(13,110,253)",
				pointStyle: 'circle',
				pointRadius: 2,
				fill: true,
				pointHoverRadius: 6,
				tension: 0.5
            }]
        },
        options: {
            scales: {
				x: {
					grid: {
						display: false,
					}
				},
                y: {
                    beginAtZero: true,	
					grid: {
						display: false,
					},	
          ticks: {
                    stepSize: 1, 
                    callback: function(value) {
                        return Number.isInteger(value) ? value : null; 
                    }
                }
                }
            },
			plugins: {
				legend: {
					display: false
				}
			}
        }
    });

	//FOR APPLICATIONS CREATED CHARTS
	const ctx3 = document.getElementById('applicationsCreatedChart');
    new Chart(ctx3, {
        // type: 'line',
        type: 'bar',
        data: {
            labels: [{!!implode(",", $applications_created_labels)!!}],
            datasets: [{
                label: 'Applications',
                data: [{!!implode(",", $applications_created_data)!!}],
                // borderWidth: 2,
				// backgroundColor: "rgba(16,185,129,0.1)",
				// borderColor: "rgba(16,185,129,0.8)",
				// hoverBackgroundColor: "rgba(16,185,129,0.4)",
				// hoverBorderColor: "rgba(16,185,129,1)",
				// pointStyle: 'circle',
				// pointRadius: 2,
				// fill: true,
				// pointHoverRadius: 6,
				// tension: 0.5

				borderWidth: 0,
                barThickness: 10,
                borderRadius: 5,
                borderSkipped: false,
				backgroundColor: "rgb(16,185,129)",
				borderColor: "rgb(16,185,129)",
				hoverBackgroundColor: "rgb(16,185,129)",
				pointStyle: 'circle',
				pointRadius: 2,
				fill: true,
				pointHoverRadius: 6,
				tension: 0.5
            }]
        },
        options: {
            scales: {
				x: {
					grid: {
						display: false,
					}
				},
                y: {
                    beginAtZero: true,	
					grid: {
						display: false,
					},
          ticks: {
                    stepSize: 1, 
                    callback: function(value) {
                        return Number.isInteger(value) ? value : null; 
                    }
                }		
                }
            },
			plugins: {
				legend: {
					display: false
				}
			}
        }
    });
	

	// ------------------------------------------------------------------------------------------------------

	// Load the Visualization API and the corechart package.
	// google.charts.load('current', {
	// 	'packages': ['corechart', 'bar']
	// });

	// Set a callback to run when the Google Visualization API is loaded.
	// google.charts.setOnLoadCallback(drawSignupChart);

	// Callback that creates and populates a data table,
	// instantiates the pie chart, passes in the data and
	// draws it.
	// function drawSignupChart() {

	// 	// Create the data table.
	// 	var data = google.visualization.arrayToDataTable([
	// 	['Month', 'Registered Users'],
	// 	@php
	// 	if (count($signup_chart_data)) {
	// 		foreach($signup_chart_data as $d) {
	// 		echo "['".$d->month_name."', ".$d->count."],";
	// 		}
	// 	} else {
	// 		echo "['', 0],";
	// 	}
	// 	@endphp
	// 	]);

	// 	// Set chart options
	// 	var options = {
	// 	height: 300,
	// 	legend: {
	// 		position: 'none'
	// 	}
	// 	};

	// 	// Instantiate and draw our chart, passing in some options.
	// 	var chart = new google.visualization.ColumnChart(document.getElementById('signup_chart_block'));
	// 	chart.draw(data, options);
	// }
 
</script>

<script type="text/javascript">
    $("#branch").change(function() {
        if ($("#branch").val() == 'all') {
            window.location.replace('{{route('admin.dashboard')}}');
        }else{
            var brnch = $("#branch").val();
            window.location.replace("{{url('admin/dashboard/')}}/"+brnch);
        }
    });

      $(document).ready(function() {
    var mytimer;
        @if($working && !$work_completed)
        startTimer("{{$startsec}}");
        @else
        showTotalTime("{{$startsec}}");
        @endif

    });

    function doClockIn() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(clockInRequest, showError);
        } else { 
          alert("Geolocation is not supported by this browser.");
        }
    }

    function clockInRequest(position) {

        $.post('{{route("admin.clockin")}}', {
            '_token': $('meta[name="csrf-token"]').attr('content'),
            'screen': screen.width + 'x' + screen.height,
            'lat': position.coords.latitude,
            'long': position.coords.longitude
        }, function(response) {
            var resp = JSON.parse(response);
            console.log(resp);
            if (resp.status) {
                startTimer(-1);
                swal({
                    title: "You have Clocked-In!",
                    showCancelButton: false,
                    confirmButtonText: "OK",
                    type: 'success'
                });
                $("#clockin").hide();
                $("#clockout").show();
            } else {
                alert("Error: " + resp.message);
            }

        });

    }

    function doClockOut() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(clockOutRequest, showError);
        }
    }

    function clockOutRequest(position) {

        Swal.fire({
            title: "Are you sure?",
            showCancelButton: true,
            confirmButtonText: "Clock-out",
            cancelButtonText: "Cancel",
            type: 'warning'
        }).then((result) => {
            result.value && $.post('{{route("admin.clockout")}}', {
                '_token': $('meta[name="csrf-token"]').attr('content'),
                'screen': screen.width + 'x' + screen.height,
                'lat': position.coords.latitude,
                'long': position.coords.longitude
            }, function(response) {
                var resp = JSON.parse(response);
                console.log(resp);
                if (resp.status) {
                    clearInterval(mytimer);
                    swal({
                        title: "You have Clocked-Out!",
                        showCancelButton: false,
                        confirmButtonText: "OK",
                        type: 'success'
                    });
                    $("#clockout").hide();
                } else {
                    alert("Error: " + resp.message);
                }

            });
        });
    }

function showError(error) {
  switch(error.code) {
    case error.PERMISSION_DENIED:
      swal({
            title: "Please enable your location to use this feature.",
            showCancelButton: false,
            confirmButtonText: "OK",
            type: 'warning'
        });
      break;
    case error.POSITION_UNAVAILABLE:
       swal({
            title: "Location information is unavailable.",
            showCancelButton: false,
            confirmButtonText: "OK",
            type: 'warning'
        });
      break;
    case error.TIMEOUT:
      swal({
            title: "The request to get user location timed out.",
            showCancelButton: false,
            confirmButtonText: "OK",
            type: 'warning'
        });
      break;
    case error.UNKNOWN_ERROR:
      swal({
            title: "An unknown error occurred. Please try again",
            showCancelButton: false,
            confirmButtonText: "OK",
            type: 'warning'
        });
      break;
  }
}

    function pad(val) {
        return val > 9 ? val : "0" + val;
    }

    function startTimer(startsec) {
        var sec = startsec;
        mytimer = setInterval(function() {
            $("#seconds").html(pad(++sec % 60));
            $("#minutes").html(pad(parseInt(sec / 60, 10) % 60));
            $("#hours").html(pad(parseInt(sec / 3600, 10)));
        }, 1000);
    }

    function stopTimer() {
        clearInterval(mytimer);
    }

    function showTotalTime(totalsec) {
        if (totalsec > 0) {
            var sec = totalsec;
            $("#seconds").html(pad(++sec % 60));
            $("#minutes").html(pad(parseInt(sec / 60, 10) % 60));
            $("#hours").html(pad(parseInt(sec / 3600, 10)));
        }
    }
</script>
@endpush


@push('after-styles')
    <style>
        .stat_num {
            text-align: center;
            font-size: 2em;
        }

        .stat_info {
            margin-bottom: 0;
        }

        /* dashboard widgets */
        .dashboard-card {
            padding: 10px 20px 20px 0px;
        }

        .dashboard-row {
            padding: 5px 0;
            border-bottom: 0.5px solid #e2e8f0;
            margin: 0px 0px;

        }


        .dashboard-card a {
            color: #0d6efd;
        }

        .people-list {
            float: left;
            /* padding: 10px; */
            width: 100%;
            height: 200px;
            overflow-y: scroll;
            scrollbar-width: initial;
            /* border: 1px solid #d1d1d1; */
        }

        /* .people-list::-webkit-scrollbar {
          width: 10px !important;
          scrollbar-width: initial;
        } */

        .people-list ul li {
            padding-top: 0.25rem;
            padding-bottom: 0.25rem;
            list-style: none;
        }

        .people-list .staus-pic .user-icon {
            width: 40px;
            height: 40px;
            float: left;
            border-radius: 50px;
            border: 1px solid #bec8d7;
            padding: 5px;
            background: white;
        }

        .people-list .about {
            float: left;
            padding-left: 10px;

        }

        .people-list .about .name {
            color: #1d212f;
            font-weight: 500;
            font-size: 14px;
        }

        .people-list .about .time {
            color: #8f8fb1;
        }

        .people-list .staus-pic {
            position: relative;
        }

        .clearfix {
            margin: 0;
            /* padding: 10px; */
            border-bottom: 0.5px solid #e2e8f0;
        }
    </style>
@endpush