@extends('backend.layouts.app')

@section('title', "Demo Class Management")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Demo Class Management
                    <small class="text-muted">Create category, upload videos</small>
                </h4>
                <br />
            </div><!--col-->
        </div><!--row-->    

        <div class="row">
            <div class="col-md-12">

                <ul class="nav nav-tabs" id="myTab" role="tablist">
                  <li class="nav-item" role="presentation">
                    <button class="nav-link " id="folders-tab" data-bs-toggle="tab" data-bs-target="#folders" type="button" role="tab" aria-controls="folders" aria-selected="true"><i class="bi bi-folder-fill"></i> Add Category</button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="docs-tab" data-bs-toggle="tab" data-bs-target="#docs" type="button" role="tab" aria-controls="docs" aria-selected="false"><i class="bi bi-file-earmark-fill"></i> Add Video</button>
                  </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                  <div class="tab-pane fade show " id="folders" role="tabpanel" aria-labelledby="folders-tab">
                       @include('backend.democlass.tabs.folders')
                  </div>
                  <div class="tab-pane fade" id="docs" role="tabpanel" aria-labelledby="docs-tab">
                       @include('backend.democlass.tabs.docs')
                  </div>
                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <br />
                <strong>You are Here: 
                    <?php
                    $level = count($folder_breadcrumb);
                    for ($i = $level - 1; $i >= 0; $i--) {
                        if ($i != $level - 1) {
                            echo " > ";
                        }
                        echo "<a class=\"links\" href=\"" . route('admin.democlass') . "/" . $folder_breadcrumb[$i]['id'] . "\">" . $folder_breadcrumb[$i]['name'] . "</a>";
                    }
                    ?>

                </strong>
                <br />
                <br />
                <h5>Folders</h5>
            </div>
        </div>          

        <div class="row">
            @foreach($folders as $folder)
            <div class="col-sm-12 col-md-4">
                <p style="padding:15px;border:1px solid #ccc;">
                    <span style="font-size: 1.2em;font-weight: bold;text-decoration: underline"><a href="<?php echo route('admin.democlass') . "/" . $folder['id']; ?>">{{ $folder['name'] }}</a></span>
                    @if($folder['sharing'] == 'private')
                    <span><i class="ri-lock-fill"></i></span>
                    @elseif($folder['sharing'] == 'member')
                    <span><i class="ri-user-3-fill"></i></span>
                    @else
                    <span><i class="ri-lock-unlock-fill"></i></span>
                    @endif
                    <br /><br/><span style="color:#F40080;margin-top:20px;"><i class="ri-close-fill"></i> <a  href="<?php echo route('admin.democlass.removefolder', $folder['id']); ?>" onclick="if (confirm('Delete selected item?')) {
                                return true;
                            } else {
                                event.stopPropagation();
                                event.preventDefault();
                            }
                            ;">Remove</a></span>
                </p>
            </div>
            @endforeach
        </div>

        @if($current_folder > 0)
        <div class="row m-t-30">
            <div class="col-md-12">
                <h5>Videos</h5>
                @foreach($docs as $doc)
                <p style="padding:0px 20px 10px 10px;">
                    <span style="font-size: 1.2em;font-weight: bold;"><a href="{{ $doc['file'] }}">{{ $doc['title'] }}</a></span>
                    @if(strlen($doc['description']))
                    <br />{{ $doc['description'] }}
                    @endif
                    <br /><br/><span style="color:#F40080"><i class="fa fa-times"></i> <a  href="<?php echo route('admin.democlass.removedoc', $doc['id']); ?>" onclick="if (confirm('Delete selected item?')) {
                                return true;
                            } else {
                                event.stopPropagation();
                                event.preventDefault();
                            }
                            ;" >Remove</a></span>
                </p>
                @endforeach            
            </div>
        </div>
        @endif

            <div class="alert alert-warning" role="alert">
                <strong>Legends:</strong></br />
            <i class="fa fa-lock"></i> - Private. Only explicitly allowed users can access<br />
                  <i class="fa fa-unlock"></i> - Public. All logged in users can access<br />
            </div>
    </div>
</div>
@endsection
