@extends('backend.layouts.app')
@section('title', "Add New Downloadable")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New Downloadable
                </h4>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ url()->previous() }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-12">
                <form action="{{route('admin.downloads-management.save-downloads')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 col-md-12">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="name"><b>Name</b> <span style="color: red;">*</span></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="name" value="{{old('name')}}" name="name" required>             
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="file"><b>File</b> <span style="color: red;">*</span></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="file" accept=".pdf,.docx,.doc,.zip" name="file" id="file" class="form-control" value="{{old('file')}}" required>
                                Extensions: .pdf, .docx, .doc, .zip<br>
                                Max file size: 100MB
                            </div>
                        </div>
                    </div>
                        <div class="col-lg-12 col-sm-12 col-md-12 ml-4 mt-4">
                            <button type="submit" class="ml-2 btn btn-primary">Add</button>
                        </div>

                    </div>
                </form>
            </div>
            </div><!--col-->
        </div><!--row-->
    </div>
@endsection

@push ('after-scripts')
<script type="text/javascript">
</script>
@endpush