@extends('backend.layouts.app')

@push('after-styles')
    <link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.textarea_editor').wysihtml5();
        });
    </script>
@endpush

@section('title', 'Edit Email Template')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        Edit Email Template
                    </h4>
                </div><!--col-->
            </div><!--row-->
             
            <div class="row mt-4">
                <div class="col-md-8">
                    {{ html()->form('POST', route('admin.mailtemplates.update', $template->hook))->class('form-horizontal')->open() }}
                    @method('PATCH')
                    <div style="margin-top:10px;">
                        <div class="form-group mb-3">
                            <label>Email:</label>
                            {{ $template->hook }}
                        </div>

                        <div class="form-group mb-3">
                            <label>Subject</label>
                            <input tyle="text" name="subject" class="form-control" maxlength="100"
                                value="{{ $template->subject }}" required>
                        </div>
                        <div class="mb-3" style="width:80vw;">
                            <div class="row">

                                <div class="col-8 ">
                                    <label>Message</label>
                                    <input type="hidden" name='template' value="mail">
                                    {{-- <textarea name='message' rows="10" class="textarea_editor form-control" required>{!! $template->message !!}</textarea> --}}
                                    <textarea name='message' rows="10" id="editor_intro" class="ckeditor_toolbar_create form-control" required>{!! $template->message !!}</textarea>
                                </div>
                                <div class="col-4">
                                    <div class="container">
                                        <div class="">
                                            <div class=" text-start ">
                                                <label>Rephrase Message using AI <img class="mb-4 ms-1" src="{{asset('assets/backend/img/creative.png')}}"></label>
                                            </div>
                                            <div class="mt-2">
                                                <!-- Tone selection and rephrase button -->
                                                <div class="form-group  row">
                                                    <div class="col-md-8">
                                                        <select name="tone" id="tone"
                                                            class="form-control form-select">
                                                            <option value="Neutral">Neutral Tone</option>
                                                            <option value="Professional">Professional Tone</option>
                                                            <!-- Additional tone options can go here -->
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="btn btn-primary btn-block"
                                                            onclick="getRephrasedMessage()">Rephrase</div>

                                                    </div>
                                                </div>

                                                <!-- Message area for loading or error messages -->
                                                <div class="form-group">
                                                    <small id="buffer" class="form-text text-muted"
                                                        style="display: none;">Please
                                                        wait...</small>
                                                    <div class="alert" id="response-alert" style="display: none;"></div>
                                                </div>

                                                <!-- Rephrased message textarea -->
                                                <div class="form-group" id="rephrasedContainer" style="display: none;">
                                                    <label class="font-weight-bold">Rephrased Message</label>
                                                    <textarea class="form-control" style="background-color: rgb(255, 255, 255)" id="rephrasedMessage" name="rephrasedMessage" rows="10" readonly></textarea>

                                                    <!-- Copy button -->
                                                    <div class="text-start">
                                                        <div class="btn btn-sm" onclick="copyText()">
                                                            <i class="fas fa-copy"></i> Copy
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group" style="text-align: center;margin-top:50px;">
                            {{ form_submit('Save') }}
                            <a href="{{ route('admin.mailtemplates') }}"
                                class="btn btn-secondary btn-sm waves-effect waves-light " title="Cancel"> Cancel
                            </a>
                        </div>
                        {{ html()->form()->close() }}
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mt-4">
                    <p><strong>Variables that you can use in message:</strong></p>
                    <p>
                        <?php
                        if (strlen($template->variables)) {
                            $variables = '#' . $template->variables . '#';
                            $variables = str_replace(',', '#<br>#', $variables);
                            echo $variables;
                        }
                        ?>
                    </p>
                    <p><strong>Note:</strong> <br> #password# works with LEAD_WELCOME, STUDENT_CREATE_WELCOME templates
                        only </p>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('after-scripts')
    <script>
       

        $(".ckeditor_toolbar_create").each(function(index) {
            editor_id = $(this).attr("id");
            ClassicEditor
                .create(document.querySelector('#' + editor_id), {
                    licenseKey: '',
                    //extraPlugins: [ MyCustomUploadAdapterPlugin ],
                    simpleUpload: {
                        uploadUrl: "{{ route('admin.articles.storeimage') }}",
                        withCredentials: true,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    },
                    toolbar: {
                        items: [
                            'heading', 'findAndReplace', '|',
                            'alignment', 'bold', 'italic', 'link', 'underline', 'undo', 'redo',
                            '|',
                            'bulletedList', 'numberedList', 'uploadImage', 'insertTable',
                            'mediaEmbed', 'pageBreak', 'horizontalLine', '|',
                            'fontfamily', 'fontsize', 'fontColor', 'fontBackgroundColor',
                            'blockQuote', 'highLight', '|',
                            'outdent', 'indent', '|',
                            'subscript', 'superscript', 'code', 'codeBlock', 'strikethrough',
                            'sourceEditing', '|',
                        ],
                        shouldNotGroupWhenFull: true
                    },


                    image: {
                        // You need to configure the image toolbar, too, so it uses the new style buttons.
                        toolbar: ['imageTextAlternative', '|', 'imageStyle:alignLeft',
                            'imageStyle:alignCenter', 'imageStyle:alignRight'
                        ],

                        styles: [
                            // This option is equal to a situation where no style is applied.
                            'full',

                            // This represents an image aligned to the left.
                            'alignLeft',

                            // This represents an image aligned to the right.
                            'alignRight'
                        ]
                    }

                })
                .then(loadedEditor => {
                    editor = loadedEditor; // Store the editor instance in the 'editor' variable
                })
                .catch(error => {
                    console.error('Oops, something went wrong!');
                    console.error(error);
                });
        });
        function getEditorData() {
            if (editor) {
                const editorData = editor.getData(); // Fetch the data from the editor
                return editorData; // Return the content
            } else {
                console.log("Editor instance not found.");
            }
        }
     
        const alertDiv = document.getElementById('response-alert');
        const rephraseDiv = document.getElementById('rephrasedContainer');
        const rephraseMessage = document.getElementById('rephrasedMessage');
        const buffer = document.getElementById('buffer');
        const tone = document.getElementById('tone');

        function getRephrasedMessage() {
            buffer.style.display = 'block';
            rephraseDiv.style.display = 'none';
            alertDiv.style.display = 'none';
            $.ajax({
                url: "{{ route('admin.ai_rephrase.openapi.call') }}",
                type: "POST",
                data: {
                    message: getEditorData(),
                    tone: tone.value,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        buffer.style.display = 'none';
                        rephraseMessage.value = response.rephrased_message;
                        rephraseDiv.style.display = 'block';
                    } else if (response.status === 'failed') {
                        buffer.style.display = 'none';
                        alertDiv.innerHTML = response.message; // Set the message
                        alertDiv.className =
                            'alert alert-danger'; // Add Bootstrap success class
                        alertDiv.style.display = 'block'; // Show the alert

                    } else {
                        alertDiv.innerHTML =
                            "There was an issue saving your data. Please try again."; // Set the message
                        alertDiv.className =
                            'alert alert-warning'; // Add Bootstrap success class
                        alertDiv.style.display = 'block'; // Show the alert

                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) { // Laravel validation error
                        const errors = xhr.responseJSON.errors;
                        let errorMessage = '\n';
                        for (const field in errors) {
                            errorMessage += `${errors[field][0]}\n`;
                        }
                        alert(errorMessage);
                    } else {
                        alert("An error occurred. Please try again.");
                    }
                }
            });
        }

        function copyText() {
            var textarea = $("#rephrasedMessage")[0];

            // Select the text field
            textarea.select();
            textarea.setSelectionRange(0, 99999); // For mobile devices

            // Copy the text inside the text area
            document.execCommand("copy");

            // Alert or display a success message
            alertDiv.innerHTML = "Message copied to clipboard!"; // Set the message
            alertDiv.className =
                'alert alert-success'; // Add Bootstrap success class
            alertDiv.style.display = 'block'; // Show the alert

        }
        // $("#editor_intro").prop("required", false);


        
    </script>
@endpush