@extends('backend.layouts.app')
@section('title', "Email Templates")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Email Templates
                </h4>
            </div><!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.mailtemplates.create') }}" class="btn btn-primary ml-1 btn-sm" data-toggle="tooltip" title="Add New Template" style="margin-left:10px;"><i class="bi bi-plus-circle"></i> Add New</a>
                </div>
            </div><!--col-->            
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Email</th>
                                <th>Subject</th>
                                <th>Details</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($templates as $template)
                            <tr>
                                <td><a href="{{ route('admin.mailtemplates.edit',$template->hook)}}">{{ $template->hook }}</a></td>
                                <td>{{ $template->subject }}</td>
                                <td>@if($template->details){{ $template->details }}@else -- @endif</td>
                                 <td>@if($template->status) 
                                    <button class="btn btn-success btn-sm" onclick="document.location='{{route('admin.mailtemplates.changestatus', [$template->hook, 0])}}'">Enabled</button> 
                                    @else 
                                    <button class="btn btn-secondary btn-sm" onclick="document.location='{{route('admin.mailtemplates.changestatus', [$template->hook, 1])}}'">Disabled</button>  
                                    @endif</td>
                                <td>
                                    <a href="{{ route('admin.mailtemplates.edit',$template->hook)}}" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i> Edit</a>
                                    @if($template->system_tpl)
                                    <button class="btn btn-secondary btn-sm" disabled><i class="fa fa-trash"></i></button>
                                    @else
                                    <a href="{{ route('admin.mailtemplates.delete',$template->hook)}}" class="btn btn-danger btn-sm" data-method="delete"><i class="fa fa-trash"></i></a>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection        

@push('after-scripts')
<script>
    addDeleteForms();
</script>
@endpush
