@extends('backend.layouts.app')
@section('title')
@section('content')
<div class="card">
   	@php
	$extension = pathinfo($image, PATHINFO_EXTENSION);
	$imagePath = public_path($image); // Use public_path to get the absolute path of the image
	$dimensions = null;
	$videoResolution = null;

	// Get dimensions for image types
	if (in_array($extension, ['jpg', 'jpeg', 'png', 'gif', 'webp']) && file_exists($imagePath)) {
		$dimensions = getimagesize($imagePath);
	}

	// Get resolution for video types
	if(in_array($extension, ['mp4', 'mov', 'wmv', 'webm']) && file_exists($imagePath))
	$output = [];
	exec("ffprobe -v error -select_streams v:0 -show_entries stream=width,height -of default=noprint_wrappers=1:nokey=1 " . escapeshellarg($imagePath), $output);

	// Check if we got two values back (width and height)
	if (count($output) == 2) {
		$videoResolution = trim($output[0]) . 'x' . trim($output[1]); // e.g., "1920x1080"
	} else {
		$videoResolution = "Not available"; // Handle error case
	}

   	@endphp

<div class="card-body">
    <div class="row">
        <div class="col-md-10">
            <h4 class="card-title mb-0">Media Details</h4>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-md-6">
            @if(in_array($extension, ['jpg', 'jpeg', 'png', 'gif', 'webp']))
				<label class="text-center">Image</label>
				<a href="{{ asset($image) }}" target="_blank">
				<img src="{{ asset($image) }}" id="imageToCopy" name="file" class="img-fluid rounded d-block">
				</a>
				@if($dimensions)
					<p class="text-center">Image dimensions: {{ $dimensions[0] }} x {{ $dimensions[1] }} pixels</p>
				@endif
            @elseif(in_array($extension, ['mp4', 'mov', 'wmv', 'webm']))
            	<!-- Display as video -->
				<label class="text-center">Video</label>
				<a href="{{ asset($image) }}" target="_blank">
					<video id="mediaToCopy" name="file" class="img-fluid rounded d-block" controls>
						<source src="{{ asset($image) }}" type="video/{{ $extension }}">
						Your browser does not support the video tag.
					</video>
				</a>
				@if($videoResolution) @else @endif
            @else
            
            @endif
		</div>

		<div class="col-md-6 d-flex mt-5">
			<div class="mt-2 w-100 text-center">
				<p style="text-align: left;">URL :</p>
				@php
				$imageUrl = url('storage/media-upload/' . basename($image));
				@endphp
				<div class="d-flex">
					<input type="text" id="imageUrlInput" class="form-control d-inline-block" value="{{ $imageUrl }}" readonly onclick="copyImageUrl()">
					<button type="button" onclick="copyImageUrl()" title="Copy URL to clipboard" class="btn btn-sm btn-primary p-0 ms-2 border px-3 py-2"><i class="fas fa-copy"></i></button>
				</div>

				<form action="{{ route('admin.delete.image') }}" method="POST" id="gallery_delete" class="float-end" style="margin-top: 100px;">
					@csrf
					<input type="hidden" name="image" value="{{ $image }}">
		
					<div class="text-start">
						<button type="submit" data-gallery_id={{ $image }} class="btn btn-sm btn-danger position-absolute bottom-0 end-0 mx-2" id="deleteBtn" title="Delete"><i class="fas fa-trash-alt"></i> Delete Image</button>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection

@push('after-scripts')
<script>
	function copyImageUrl() {
		const imageUrlInput = document.getElementById('imageUrlInput');
		imageUrlInput.select(); // Select the text
		navigator.clipboard.writeText(imageUrlInput.value).then(() => {
			// alert('Image URL copied to clipboard!');
			Swal.fire({
				title: "Image URL copied to clipboard!",
				icon: "success",
			});
		}).catch(err => {
			// console.error('Failed to copy URL:', err);
			Swal.fire({
				title: 'Failed to copy URL:', err,
				icon: "error",
			});
		});
	}

	$('#deleteBtn').on("click", function(e) {
		e.preventDefault();
        let btn = $(this);
        let gallery_id = btn.data("gallery_id");
        Swal.fire({
            title: "Are you sure you want to delete this?",
			text: "This action cannot be reversed!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes",
        }).then((result) => {
            if (result.value) {
                $('#gallery_delete').submit();
            } 
        });
    });
</script>
@endpush