@extends('backend.layouts.app')
@section('title')
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                Media Library
                </h4>
            </div>
        </div>

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.css">

        <style>
            .dropzone {
                border: 2px solid #f2f2f2 !important; 
                border-radius: 5px; 
            }
            .dropzone .dz-message {
                color: #6c757d; 
            }

            #gallery-library::-webkit-scrollbar {
                width: 8px;               /* width of the entire scrollbar */
            }
            #gallery-library::-webkit-scrollbar-track {
                background: rgb(221, 221, 221);        /* color of the tracking area */
            }
            #gallery-library::-webkit-scrollbar-thumb {
                background-color: rgb(13,110,253);    /* color of the scroll thumb */
                border-radius: 20px;       /* roundness of the scroll thumb */
                border: 3px solid rgb(13,110,253);  /* creates padding around scroll thumb */
            }
        </style>

        <div class="row mt-4">
            <div class="col">
                <form action="{{route('admin.gallery.store')}}" method="post" enctype="multipart/form-data" class="dropzone border" style="background-color: rgb(248,250,252)">
                @csrf
                    <div class="mb-3">
                        <strong>
                            <p class="text-center">Drag and drop images/video here or click to upload.</p>
                        </strong>
                    </div>
                    <div>
                    <input type="file" name="file[]" id="myDropzone" style="display: none" multiple>
                </div>
                </form>
            </div>
        </div>

        <p> Note: Allowed file types : jpeg, png, mp4, mov, wmv, webm | 
            Maximum file size : 16MB | 
            Refresh the page to view uploaded images in the below section
        </p>
        
        <div class="row " style="margin-top: 50px;">
            <h4>Available Photos</h4>
            <div class="col-12">
                <div class="row" style="border: 3px solid rgb(232, 233, 234); max-height: 500px; overflow-y: scroll; background-color: rgb(248,250,252);" id="gallery-library">
                    @foreach($imageFiles as $file)
                        <div class="col-sm-6 col-md-3">
                            <form action="{{ route('admin.gallery.edit') }}" method="GET">
                                @csrf
                                <input type="hidden" name="file" value="{{ $file }}">

                                @php
                                    // Get the file extension
                                    $extension = pathinfo($file, PATHINFO_EXTENSION);
                                @endphp

                                @if(in_array($extension, ['jpg', 'jpeg', 'png', 'gif', 'webp']))
                                    <img src="{{ asset($file) }}" alt="Image" class="p-3 img-fluid rounded" onclick="this.closest('form').submit()">
                                @elseif(in_array($extension, ['mp4', 'mov', 'wmv', 'webm']))
                                    <video class="p-3 img-fluid rounded" controls onclick="this.closest('form').submit()">
                                        <source src="{{ asset($file) }}" type="video/{{ $extension }}">
                                        Your browser does not support the video tag.
                                    </video>
                                @endif
                            </form>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@push ('after-scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.js"></script>
<script>
    Dropzone.options.myDropzone = {
        paramName: "file", 
        maxFilesize: 16, 
        acceptedFiles: ".jpg, .jpeg, .png, .gif .mp4", 
        addRemoveLinks: true,   
        dictDefaultMessage: "<strong>Drop files here or click to upload</strong",
    };
</script>
@endpush