@extends('backend.layouts.app')
@section('title', 'Select a Google Sheet')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card p-3">
                <h2 class="mb-4">Select a Google Sheet</h2>

                <form action="{{ route('admin.google.sheets.select') }}" method="POST" class="mb-5">
                    @csrf
                    <div class="mb-3">
                        <label for="sheet_id" class="form-label">Google Sheets</label>
                        <select name="sheet_id" id="sheet_id" class="form-select" onchange="updateSheetName()">
                            @foreach ($files as $file)
                                <option value="{{ $file->id }}" data-name="{{ $file->name }}">{{ $file->name }}
                                </option>
                            @endforeach
                        </select>
                        <input type="hidden" name="sheet_name" id="sheet_name" value="{{ $files[0]->name }}">
                    </div>

                    <button type="submit" class="btn btn-primary">Use This Sheet</button>
                </form>

                <h4 class="mb-3">Your Selected Google Sheets</h4>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped align-middle">
                        <thead class="table-light">
                            <tr>
                                <th scope="col">Sheet Name</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($googleSheets as $sheet)
                                <tr>
                                    <td>{{ $sheet->name }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="1" class="text-center text-muted">No sheets added yet.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('after-scripts')
    <script>
        document.querySelector('select[name="sheet_id"]').addEventListener('change', function() {
            let selected = this.options[this.selectedIndex];
            document.getElementById('sheet_name').value = selected.getAttribute('data-name');
        });
    </script>
@endpush
