@extends('backend.layouts.app')
@section('title', "Import Course (Any CSV)")

@section('content')

<div class="row">
    <div class="col-sm-12 col-md-12">

        <div class="card">
            <div class="card-body" style="overflow-x: scroll;">
                <h4 class="card-title">Import Courses from CSV file</h4><br />
                {{ html()->form('POST', route('admin.import-export.anycsvcourse.save'))->class('form-horizontal')->open() }}
                <input type="hidden" name="file" value="{{$file}}">
                <input type="hidden" name="category" value="{{$category}}">
                <input type="hidden" name="has_header" value="{{$has_header}}">
                <input type="hidden" name="create_study_level" value="{{$has_study_level}}">

                <h5 style="font-size:15px;">Choose Column Mapping for your data</h5>
                <table>
                    <tr>
                        <td style="padding:5px;min-width: 180px;"><b>Map To Course Attribute:</b><br><small>Choose 'Ignore' to exclude a column from import</small></td>
                        @php
                        $i=0;
                        @endphp
                        @foreach($header_row as $col)
                        <td style="padding:5px; min-width: 200px;">
                            <select class="form-control form-select" name="columnmap[{{$i}}]">
                                <option value="">Ignore</option>
                                @foreach(config('app.course_attributes') as $key => $value)
                                <option value="{{$key}}">{{$value}}</option>
                                @endforeach
                            </select>
                        </td>
                        @php
                        $i++;
                        @endphp
                        @endforeach
                    </tr>
                    <tr>
                        <td style="padding:5px;min-width: 180px;"><b>Your data file Columns:</b></td>
                        @foreach($header_row as $col)
                        <td style="padding:5px; min-width: 240px;">
                            {{substr($col, 0, 100)}}
                            @if(strlen($col)  > 100)
                                ....
                            @endif
                        </td>
                        @endforeach
                    </tr>
                    @if(count($header_row2))
                    <tr>
                        <td style="padding:5px;min-width: 180px;"><b>Your data file Columns:</b></td>
                        @foreach($header_row2 as $col)
                        <td style="padding:5px; min-width: 240px;">{{substr($col, 0, 100)}}
                            @if(strlen($col) > 100)
                                ....
                            @endif
                        </td>
                        @endforeach
                    </tr>
                    @endif
                    @if(count($header_row3))
                    <tr>
                        <td style="padding:5px;min-width: 180px;"><b>Your data file Columns:</b></td>
                        @foreach($header_row3 as $col)
                        <td style="padding:5px; min-width: 240px;">{{substr($col, 0, 100)}}
                            @if(strlen($col)  > 100)
                                ....
                            @endif
                        </td>
                        @endforeach
                    </tr>
                    @endif
                </table>

                
            </div>
            <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
            </div>
            </form>
        </div>
    </div>
</div>

@endsection