@extends('backend.layouts.app')
@section('title', "Import Leads (Any CSV)")

@section('content')

<div class="row">
    <div class="col-sm-12 col-md-12">

        <div class="card">
            <div class="card-body" style="overflow-x: scroll;">
                <h4 class="card-title">Import Leads from CSV file</h4><br />
                {{ html()->form('POST', route('admin.import-export.anycsvleads.save'))->class('form-horizontal')->open() }}
                <input type="hidden" name="file" value="{{$file}}">
                <input type="hidden" name="assign_to" value="{{$assign_to}}">
                <input type="hidden" name="branch" value="{{$branch}}">
                <input type="hidden" name="set_followup_today" value="{{$set_followup_today}}">
                <input type="hidden" name="has_header" value="{{$has_header}}">

                <h5 style="font-size:15px;">Choose Column Mapping for your data</h5>
                <table>
                    <tr>
                        <td style="padding:5px;min-width: 180px;"><b>Map To Lead Attribute:</b><br>Choose 'Ignore' to exclude a column from import</td>
                        @php
                        $i=0;
                        @endphp
                        @foreach($header_row as $col)
                        <td style="padding:5px;">
                            <select class="form-control form-select" name="columnmap[{{$i}}]">
                                <option value="">Ignore</option>
                                @foreach(config('app.lead_attributes') as $key => $value)
                                <option value="{{$key}}">{{$value}}</option>
                                @endforeach
                            </select>
                        </td>
                        @php
                        $i++;
                        @endphp
                        @endforeach
                    </tr>
                    <tr>
                        <td style="padding:5px;min-width: 180px;"><b>Your Data file Columns:</b></td>
                        @foreach($header_row as $col)
                        <td style="padding:5px;min-width: 120px;">{{$col}}</td>
                        @endforeach
                    </tr>
                    @if(count($header_row2))
                    <tr>
                        <td style="padding:5px;min-width: 180px;"></td>
                        @foreach($header_row2 as $col)
                        <td style="padding:5px;min-width: 120px;">{{$col}}</td>
                        @endforeach
                    </tr>
                    @endif
                    @if(count($header_row3))
                    <tr>
                        <td style="padding:5px;min-width: 180px;"></td>
                        @foreach($header_row3 as $col)
                        <td style="padding:5px;min-width: 120px;">{{$col}}</td>
                        @endforeach
                    </tr>
                    @endif
                    
                </table>

                <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                    <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                </div>
                </form>

            </div>
        </div>
    </div>



</div>

@endsection