@extends('backend.layouts.app')
@section('title', "Import\Export")

@section('content')


@if(!empty($import_errors))
<div class="row">
    <div class="col-md-12">
        @foreach ($import_errors as $imp_error)
        <div class="alert alert-danger" role="alert">
            {{ $imp_error }}
        </div>
        @endforeach
    </div>
</div>
@elseif(!empty($import_success))
<div class="row">
    <div class="col-md-12">
        @foreach ($import_success as $imp_success)
        <div class="alert alert-success" role="alert">
            {{ $imp_success }}
        </div>
        @endforeach
    </div>
</div>
@endif

<div class="row">
    <div class="col-sm-12 col-md-6">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Import</h4><br />
                {{ html()->form('POST', route('admin.import-export.upload.custom'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                <div class="form-group col-sm-12 col-md-10">
                    <label>Select data file (.csv)</label>
                    <input class="form-control" type="file" name="data_file" accept=".csv" required>
                </div>
                <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                    <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                </div>
                </form>

            </div>
        </div>
    </div>
</div>

@endsection