@extends('backend.layouts.app')
@section('title', "Import\Export")

@section('content')

{{-- @if(!empty($import_errors))
<div class="row">
    <div class="col-md-12">
        @foreach ($import_errors as $imp_error)
        <div class="alert alert-danger" role="alert">
            {{ $imp_error }}
        </div>
        @endforeach
    </div>
</div>
@endif
@if(!empty($import_success))
<div class="row">
    <div class="col-md-12">
        @foreach ($import_success as $imp_success)
        <div class="alert alert-success" role="alert">
            {{ $imp_success }}
        </div>
        @endforeach
    </div>
</div>
@endif  --}}

<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="card">
            <div class="card-body" style="padding-top:25px;">
                <h4>Import</h4>
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button style="font-weight:bold;" class="nav-link @if($currentPage == 'leads')active @endif" id="leadsImportTab-tab" data-bs-toggle="tab" data-bs-target="#leadsImportTab" type="button" role="tab" aria-controls="leadsImportTab" aria-selected="false"><i class="bx bxs-user-circle"></i> Leads</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button style="font-weight:bold;" class="nav-link @if($currentPage == 'students') active @endif" active" id="importStudentsTab-tab" data-bs-toggle="tab" data-bs-target="#importStudentsTab" type="button" role="tab" aria-controls="importStudentsTab" aria-selected="true"><i class="bx bxs-id-card"></i> Students</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button style="font-weight:bold;" class="nav-link @if($currentPage == 'course')active @endif" id="courseImportTab-tab" data-bs-toggle="tab" data-bs-target="#courseImportTab" type="button" role="tab" aria-controls="courseImportTab" aria-selected="false"><i class="bx bx-book"></i> Course Data</button>
                    </li>
                </ul>

                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade @if($currentPage == 'students') show active @endif" id="importStudentsTab" role="tabpanel" aria-labelledby="importStudentsTab-tab">
                        <div class="accordion" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingStudents">
                                    <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importStudents" aria-expanded="false" aria-controls="importStudents">
                                        Import Students
                                    </button>
                                </h2>
                                <div id="importStudents" class="accordion-collapse collapse" aria-labelledby="headingStudents" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <label>
                                            <span class="text-danger">The data file must be in "CSV UTF-8 (Comma delimited) (*.csv)" format</span>
                                            <br />Data must be formatted as in sample file. <a href="{{asset('storage/sample/Student-import-sample.csv')}}" class="text-primary">Download Sample File</a>
                                            <br />
                                            <span class="text-info text-smaller">
                                                <ul>
                                                    <li>The header row must be as present in sample file</li>
                                                    <li>Mandatory Column values are: SI No., First name, 
                                                        @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email')
                                                            Email.
                                                        @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile')
                                                            Email and Mobile no.
                                                        @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile')
                                                            Email or Mobile no.
                                                        @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile')
                                                            Mobile.         
                                                        @endif
                                                        You can leave other columns blank if you don't have data.
                                                    </li>
                                                    <li>Valid values for 'Title' are: Mr., Ms., Mrs., Dr., Prof.</li>
                                                    <li>Valid values for 'Type' are: Study Abroad, Coaching, Study Abroad & Coaching</li>
                                                </ul>
                                            </span>
                                            <br />
                                            <br />
                                            <br />
                                            <br />
                                        </label>
                                        {{ html()->form('POST', route('admin.import-export.upload.students'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                        <div class="form-group col-sm-12 col-md-10">
                                            <label>Select student data file (.csv)</label>
                                            <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6" id="branch" required>
                                            <label class="col-form-label">Assign to Branch</label>
                                                <select class="form-select" id="branch" name="branch">
                                                    <option value="">Select Branch</option>
                                                    @foreach($branchList as $branches)
                                                    <option {{($branches->id == Request::old('branch'))? 'selected' : ''}} value="{{ $branches->id }}">{{ $branches->branch_name }}</option>
                                                    @endforeach
                                                </select>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-10">
                                            <input type="checkbox" id="email_password" name="email_password">
                                            <label for="email_password">Auto-generate password & email to students</label>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-12 text-center" style="padding-top:42px;">
                                            <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                        </div>
                                        </form>
        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade @if($currentPage == 'leads') show active @endif" id="leadsImportTab" role="tabpanel" aria-labelledby="leadsImportTab-tab">
                        <div class="accordion" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingLeads2">
                                    <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importLeads2" aria-expanded="false" aria-controls="importLeads2">
                                        Import Leads (Any format .csv)
                                    </button>
                                </h2>
                                <div id="importLeads2" class="accordion-collapse collapse" aria-labelledby="headingLeads2" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        {{ html()->form('POST', route('admin.import-export.anycsvleads'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                        <div class="form-group col-sm-12 col-md-10">
                                            <label>Select leads data file (.csv)</label>
                                            <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-12">
                                            <input type="checkbox" id="has_header" name="has_header" value="1">
                                            <label for="has_header">My file has header row</label>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6">
                                            <label class="col-form-label required-field">Assign to Branch</label>
                                            <select class="form-select assign_to_branch" name="branch" id="branch" required>
                                                <option value="">Select Branch</option>
                                                @foreach($branchList as $branch)
                                                <option {{(Request::old('branch') == $branch->id)? 'selected' : ''}} value="{{$branch->id}}">{{$branch->branch_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6" id="">
                                            <label class="required-field">Assign imported leads to</label>
                                            <select class="form-select assign_to" name="assign_to" id="assign_to" required>
                                                <option value="">Select Staff</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6 mt-3">
                                            <label for="set_followup_today"><input type="checkbox" id="set_followup_today" name="set_followup_today" value="1"> Set next follow-up to today's date</label>
                                        </div>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                                            <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                        </div>
                                        </form>
        
                                        <label>
                                            <span class="text-info text-smaller">
                                                <p>Mandatory fields are: First Name, 
                                                    @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email')
                                                        Email.
                                                    @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile')
                                                        Email and Mobile no.
                                                    @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile')
                                                        Email or Mobile no.
                                                    @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile')
                                                        Mobile.         
                                                    @endif
                                                </p>
                                                <strong>Data format requirements for columns if these fields exists in your data file:</strong>
                                                <ul>
                                                    <li class="text-danger">The data file must be in "CSV UTF-8 (Comma delimited) (*.csv)" format</li>
                                                    <li>Valid values for 'Status' are: As defined in 'Settings > Leads > Status List'. If 'Status' is blank, default status will be assigned.</li>
                                                    <li>Valid values for 'Lead Source' are: As defined in 'Settings > Leads > Lead Sources'</li>
                                                    <li>Gender: Male, Female</li>
                                                    <li>Dial code: Country dial code without +. Ex:91</li>
                                                    <li>Date of birth: YYYY-MM-DD or DD-MM-YYYY</li>
                                                    <li>Qualification: 9th, 10th, 11th, 12th, Bachelors, Masters</li>
                                                    <li>Interested Study Level: 
                                                        @foreach(get_study_levels() as $value)
                                                            {{$value}}
                                                        @endforeach
                                                    </li>
                                                    <li>Next/Last Followup Date: YYYY-MM-DD or DD-MM-YYYY</li>
                                                    <li>Created Date: YYYY-MM-DD or DD-MM-YYYY</li>
                                                </ul>
                                            </span>
                                            <br />
                                            <br />
                                        </label>
                                    </div>
                                </div>
                            </div>
        
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingLeads">
                                    <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importLeads" aria-expanded="false" aria-controls="importLeads">
                                        Import Leads (Predefined Format .csv)
                                    </button>
                                </h2>
                                <div id="importLeads" class="accordion-collapse collapse" aria-labelledby="headingLeads" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <label>
                                            <span class="text-danger">The data file must be in "CSV UTF-8 (Comma delimited) (*.csv)" format</span>
                                            <br />Data must be formatted as in sample file. <a href="{{asset('storage/sample/Leads-import-sample.csv')}}" class="text-primary">Download Sample File</a>
                                            <br /><span class="text-info text-smaller">
                                                <ul>
                                                    <li>The header row must be as present in sample file</li>
                                                    <li>Mandatory Column values are: SI No., First name, 
                                                        @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email')
                                                            Email.
                                                        @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile')
                                                            Email and Mobile no.
                                                        @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile')
                                                            Email or Mobile no.
                                                        @elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile')
                                                            Mobile.         
                                                        @endif
                                                        You can leave other columns blank if you don't have data.
                                                    </li>
                                                    <li>Valid values for 'Status' are: As defined in 'Settings > Leads > Status List'. If 'Status' is blank, default status will be assigned.</li>
                                                    <li>Qualification: 9th, 10th, 11th, 12th, Bachelors, Masters</li>
                                                    <li>Valid values for 'Type' are: Study Abroad, Coaching, Study Abroad & Coaching</li>
                                                    <li>Valid values for 'Source' are: As defined in 'Settings > Leads > Lead Sources'</li>
                                                </ul>
                                            </span>
                                            <br />
                                            <br />
                                        </label>
                                        {{ html()->form('POST', route('admin.import-export.upload.leads'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                        <div class="form-group col-sm-12 col-md-10">
                                            <label>Select leads data file (.csv)</label>
                                            <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6">
                                            <label class="col-form-label required-field">Assign to Branch</label>
                                            <select class="form-select assign_to_branch" name="branch" id="branch" required>
                                                <option value="">Select Branch</option>
                                                @foreach($branchList as $branch)
                                                <option {{(Request::old('branch') == $branch->id)? 'selected' : ''}} value="{{$branch->id}}">{{$branch->branch_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6" id="">
                                            <label class="required-field">Assign imported leads to</label>
                                            <select class="form-select assign_to" name="assign_to" id="assign_to" required>
                                                <option value="">Select Staff</option>
                                            </select> 
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6 mt-3">
                                            <label for="set_followup_today2"><input type="checkbox" id="set_followup_today2" name="set_followup_today" value="1"> Set next follow-up to today's date</label>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                                            <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                        </div>
                                        </form>
        
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                    <div class="tab-pane fade @if($currentPage == 'course') show active @endif" id="courseImportTab" role="tabpanel" aria-labelledby="courseImportTab-tab">
                        <div class="accordion" id="accordionExample">

                            

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingLeads2">
                                    <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importCourses2" aria-expanded="false" aria-controls="importCourses2">
                                        Import University Course Data (Any format .csv)
                                    </button>
                                </h2>
                                <div id="importCourses2" class="accordion-collapse collapse" aria-labelledby="headingLeads2" data-bs-parent="#accordionExample">
                                    <div class="accordion-body col-sm-12 col-md-12">
                                        {{ html()->form('POST', route('admin.import-export.anycsvcoursemanagement'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                        <div class="form-group col-sm-12 col-md-6">
                                            <label>Select Course Data file (.csv)</label>
                                            <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-12">
                                            <input type="checkbox" id="create_study_level" name="create_study_level" value="1">
                                            <label for="create_study_level">Create 'Study Level' if it is not present in Database</label>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6">
                                            <input type="checkbox" id="has_checked" name="has_header" value="1">
                                            <label for="has_checked">My file has header row</label>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6">
                                            <label class="">Category (Optional)</label>
                                            <select class="form-control form-select" name="category" >
                                                <option value="">Select Category</option>
                                                @foreach($courseCategory as $category)
                                                    @if($category->parent_id == 0)
                                                        <option value="{{$category->id}}">{{$category->title}}</option>
                                                        {{-- <optgroup label="{{$category->title}}"> --}}
                                                            @foreach($courseCategory as $subCategory)
                                                                @if($subCategory->parent_id == $category->id)
                                                                    <option value="{{get_university_course_sub_category_name($subCategory->id)->id}}">-- {{get_university_course_sub_category_name($subCategory->id)->title}}</option>
                                                                @endif
                                                            @endforeach
                                                        {{-- </optgroup> --}}
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6 text-center mt-4">
                                            <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                        </div>
                                        </form>
        
                                        <label>
                                            <span class="text-info text-smaller">
                                                <strong>Notes:</strong>
                                                <ul>
                                                    <li class="text-danger">The data file must be in .csv format. When saving the file as csv from MS Excel, choose save as type "CSV UTF-8 (Comma delimited) (*.csv)".</li>
                                                    <li>Mandatory Columns are: Course Name, University, Study Level, Country.</li>
                                                    <li>Valid Study Levels are: {{'"'.implode('", "', get_study_levels()).'"'}}</li>
                                                    <li>Intake: Must be 3 letter month name. Multiple months can be comma seperated. Ex: Aug, Jan OR Fall (Aug), Spring (Jan), Summer (May)</li>
                                                    <li>If 'University' is not present in the database, it will be created.</li>
                                                    <li>If 'Course' already exists, it's data will be updated.</li>
                                                    {{-- <li>Available Data Columns For Import: University, Name, Course Details, Occupation Outcome, Practical Work, Course Content, Qualify Extended Visa, Regional Location, Country Students Not Accepted, Tuition Fee (Yearly), Non Tuition Fee, Website URL, Campus, Country, Study Level, Duration, Intakes, Entry Requirements, IELTS Score, IELTS No Band Less Than, TOEFL Score, TOEFL No Band Less Than, PTE Score, PTE No Band Less Than, GRE Score, GMAT Score, University Applications Deadline,	University Applications Fee, Tuition Fee, Remarks, DET Score, Backlog Range, Scholarship Detail, Scholarship Available, ESL/ELP Detail, ApplicationMode	</li> --}}
                                                    <li>Available Data Columns For Import are: Course Name, Study Level, University, Campus, Website URL, Duration, Intakes, Course Details, Tuition Fee (Yearly), Non Tuition Fee, Entry Requirements, IELTS Score, IELTS No Band Less Than, TOEFL Score, TOEFL No Band Less Than, PTE Score, PTE No Band Less Than, GRE Score, GMAT Score, University Application Deadline, University Applications Fee, Tuition Fee, Remarks, DET Score, Backlog Range, Scholarship Detail, Scholarship Available, ESL/ELP Detail, ApplicationMode, Occupation Outcome, Practical Work, Course Content, Qualify Extended Visa, Regional Location, Country Students Not Accepted</li>
                                                    <li>Tuition Fee, Non Tuition Fee, Application Fee allowed formats: $31926.00, $ 31926.00, Can$ 31926.00, CAD $ 31926, £ 31926.00 </li>
                                                </ul>
                                            </span>
                                            <br />
                                            <br />
                                        </label>
                                    </div>
                                </div>
                            </div>
        
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingCourses">
                                    <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importCourses" aria-expanded="false" aria-controls="importCourses">
                                        Import University Course Data (Predefined Format .csv)
                                    </button>
                                </h2>
                                <div id="importCourses" class="accordion-collapse collapse" aria-labelledby="headingCourses" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <label>
                                            {{-- The data file must be in .csv format. When saving the file as csv from MS Excel, choose save as type "CSV UTF-8". --}}
                                            <span class="text-danger">
                                                The data file must be in .csv format. When saving the file as csv from MS Excel, choose save as type "CSV UTF-8 (Comma delimited) (*.csv)".
                                                <br />Data must be formatted as in sample file. Download: <br> <a style="text-decoration: underline;" href="{{asset('storage/sample/Course-sample-minimal.csv')}}" class="text-primary">Sample 1 (Minimal Fields)</a> <br> <a style="text-decoration: underline;" href="{{asset('storage/sample/Course-sample-full.csv')}}" class="text-primary">Sample 2 (All Fields)</a>
                                            </span>
                                            <br>
                                            <br /><span class="text-info text-smaller">
                                                <ul>
                                                    <li>The header row must be as present in sample file</li>
                                                    <li>
                                                        Category ID must be first column. 
                                                        You can find Category ID in Study Abroad > Course Management > <a href="{{route('admin.coursemanagement.categories')}}" class="text-info" style="text-decoration: underline;">Categories Tab</a> next to Category Name.
                                                        Other column order doesn't matter.
                                                    </li>
                                                    <li>Mandatory Column values are: Category ID, Course Name,  University, Campus, Country, Study Level. You can leave other columns blank if you don't have data.</li>
                                                    <li>Valid Study Levels are: {{'"'.implode('", "', get_study_levels()).'"'}}</li>
                                                    <li>Intake: Must be 3 letter month name. Multiple months can be comma seperated. Ex: Aug, Jan OR Fall (Aug), Spring (Jan), Summer (May)</li>
                                                    <li>If University is not present in the database, it will be added.</li>
                                                    <li>If Course exists, it's data will be updated.</li>
                                                    <li>Tuition Fee, Non Tuition Fee, Application Fee allowed formats: $31926.00, $ 31926.00, Can$ 31926.00, CAD $ 31926, £ 31926.00 </li>
                                                </ul>
                                            </span>
                                            <br />
                                            <br />
                                        </label>
                                        {{ html()->form('POST', route('admin.import-export.upload.course'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                        <div class="form-group col-sm-12 col-md-10">
                                            <label>Select course data file (.csv)</label>
                                            <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-12">
                                            <input type="checkbox" id="create_study_level" name="create_study_level" value="1">
                                            <label for="create_study_level">Create 'Study Level' if it is not present in Database</label>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                                            <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                        </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingLeads2">
                                    <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importCourses1" aria-expanded="false" aria-controls="importCourses1">
                                        Import Course Data for single University
                                    </button>
                                </h2>
                                <div id="importCourses1" class="accordion-collapse collapse" aria-labelledby="headingLeads2" data-bs-parent="#accordionExample">
                                    <div class="accordion-body col-sm-12 col-md-12">
                                        {{ html()->form('POST', route('admin.import-export.anyCsvUniversityCourseManagement'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

                                        <div class="col-md-6 form-group">
                                            <label for="country" class="required-field">Country</label>
                                            <select class="form-control form-select" id="country" name="country" required>
                                                <option value="">Country</option>
                                                @foreach($countries as $country)
                                                <option @if(old('country')==$country->id) selected @endif value="{{$country->id}}">{{$country->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="university-select" class="required-field">University</label>
                                            <select name="university" id="university-select" placeholder="university" class='form-control form-select' type="text" required>
                                                <option value="">Select University</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6">
                                            <label>Select Course Data file (.csv)</label>
                                            <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6">
                                            <input type="checkbox" id="has_checked" name="has_header" value="1">
                                            <label for="has_checked">My file has header row</label>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6">
                                            <label class="">Category (Optional)</label>
                                            <select class="form-control form-select" name="category">
                                                <option value="">Select Category</option>
                                                @foreach($courseCategory as $category)
                                                    @if($category->parent_id == 0)
                                                        {{-- <optgroup label="{{$category->title}}"> --}}
                                                            <option value="{{$category->id}}">{{$category->title}}</option>
                                                            @foreach($courseCategory as $subCategory)
                                                                @if($subCategory->parent_id == $category->id)
                                                                    <option value="{{get_university_course_sub_category_name($subCategory->id)->id}}">-- {{get_university_course_sub_category_name($subCategory->id)->title}}</option>
                                                                @endif
                                                            @endforeach
                                                        {{-- </optgroup> --}}
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-12 col-md-6 text-center mt-4">
                                            <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                        </div>
                                        </form>
                                        <label>
                                            <span class="text-info text-smaller">
                                                <strong>Notes:</strong>
                                                <ul>
                                                    <li class="text-danger">The data file must be in .csv format. When saving the file as csv from MS Excel, choose save as type "CSV UTF-8 (Comma delimited) (*.csv)".</li>
                                                    <li>Mandatory Columns are: Course Name, Study Level.</li>
                                                    <li>Valid Study Levels are: {{'"'.implode('", "', get_study_levels()).'"'}}</li>
                                                    <li>Intake: Must be 3 letter month name. Multiple months can be comma seperated. Ex: Aug, Jan OR Fall (Aug), Spring (Jan), Summer (May)</li>
                                                    <li>If 'Course' already exists, it's data will be updated.</li>
                                                    {{-- <li>Available Data Columns For Import: Name, Course Details, Occupation Outcome, Practical Work, Course Content, Qualify Extended Visa, Regional Location, Country Students Not Accepted, Tuition Fee (Yearly), Non Tuition Fee, Website URL, Campus, Study Level, Duration, Intakes, Entry Requirements, IELTS Score, IELTS No Band Less Than, TOEFL Score, TOEFL No Band Less Than, PTE Score, PTE No Band Less Than, GRE Score, GMAT Score, University Applications Deadline, University Applications Fee, Tuition Fee, Remarks, DET Score, Backlog Range, Scholarship Detail, Scholarship Available, ESL/ELP Detail, ApplicationMode	</li> --}}
                                                    <li>Available Data Columns For Import are: Course Name, Study Level, Duration, Intakes, Course Details, Tuition Fee (Yearly), Non Tuition Fee, Website URL, Campus, Entry Requirements, IELTS Score, IELTS No Band Less Than, TOEFL Score, TOEFL No Band Less Than, PTE Score, PTE No Band Less Than, GRE Score, GMAT Score, University Application Deadline, University Applications Fee, Tuition Fee, Remarks, DET Score, Backlog Range, Scholarship Detail, Scholarship Available, ESL/ELP Detail, ApplicationMode, Occupation Outcome, Practical Work, Course Content, Qualify Extended Visa, Regional Location, Country Students Not Accepted</li>
                                                    <li>Tuition Fee, Non Tuition Fee, Application Fee allowed formats: $31926.00, $ 31926.00, Can$ 31926.00, CAD $ 31926, £ 31926.00 </li>
                                                </ul>
                                            </span>
                                            <br />
                                            <br />
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- <div class="accordion" id="accordionExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingStudents">
                            <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importStudents" aria-expanded="false" aria-controls="importStudents">
                                Import Students
                            </button>
                        </h2>
                        <div id="importStudents" class="accordion-collapse collapse" aria-labelledby="headingStudents" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <label>
                                    The data file must be in .csv format
                                    <br />Data must be formatted as in sample file. <a href="{{asset('storage/sample/Student-import-sample.csv')}}" class="text-primary">Download Sample File</a>
                                    <br />
                                    <span class="text-info text-smaller">
                                        <ul>
                                            <li>The header row must be as present in sample file</li>
                                            <li>Mandatory Column values are: SI No., First name, Email. You can leave other columns blank if you don't have data.</li>
                                            <li>Valid values for 'Title' are: Mr., Ms., Mrs., Dr., Prof.</li>
                                            <li>Valid values for 'Type' are: Study Abroad, Coaching, Study Abroad & Coaching</li>
                                        </ul>
                                    </span>
                                    <br />
                                    <br />
                                    <br />
                                    <br />
                                </label>
                                {{ html()->form('POST', route('admin.import-export.upload.students'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                <div class="form-group col-sm-12 col-md-10">
                                    <label>Select student data file (.csv)</label>
                                    <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                </div>
                                <div class="form-group col-sm-12 col-md-10">
                                    <input type="checkbox" id="email_password" name="email_password">
                                    <label for="email_password">Auto-generate password & email to students</label>
                                </div>
                                <div class="form-group col-sm-12 col-md-12 text-center" style="padding-top:42px;">
                                    <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingLeads2">
                            <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importLeads2" aria-expanded="false" aria-controls="importLeads2">
                                Import Leads (Any .csv)
                            </button>
                        </h2>
                        <div id="importLeads2" class="accordion-collapse collapse" aria-labelledby="headingLeads2" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                {{ html()->form('POST', route('admin.import-export.anycsvleads'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                <div class="form-group col-sm-12 col-md-10">
                                    <label>Select leads data file (.csv)</label>
                                    <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                </div>
                                <div class="form-group col-sm-12 col-md-12">
                                    <input type="checkbox" id="has_header" name="has_header" value="1">
                                    <label for="has_header">My file has header row</label>
                                </div>
                                <div class="form-group col-sm-12 col-md-6">
                                    <label>Assign imported leads to*</label>
                                    <select class="form-control form-select" name="assign_to" required>
                                        <option value="">Select Staff</option>
                                        @foreach($staff as $stf)
                                        <option value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                                    <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                </div>
                                </form>

                                <label>
                                    <span class="text-info text-smaller">
                                        <p>Mandatory fields are: First Name, Email</p>
                                        <strong>Data format requirements for columns if these fields exists in your data file:</strong>
                                        <ul>
                                            <li>Valid values for 'Status' are: As defined in 'Settings > Leads > Status List'. If 'Status' is blank, default status will be assigned.</li>
                                            <li>Valid values for 'Lead Source' are: As defined in 'Settings > Leads > Lead Sources'</li>
                                            <li>Gender: Male, Female</li>
                                            <li>Dial code: Country dial code without +. Ex:91</li>
                                            <li>Date of birth: YYYY-MM-DD or DD-MM-YYYY</li>
                                            <li>Qualification: 9th, 10th, 11th, 12th, Bachelors, Masters</li>
                                            <li>Interested Study Level: 
                                                @foreach(get_study_levels() as $value)
                                                    {{$value}}
                                                @endforeach
                                            </li>
                                            <li>Next/Last Followup Date: YYYY-MM-DD or DD-MM-YYYY</li>
                                            <li>Created Date: YYYY-MM-DD or DD-MM-YYYY</li>
                                        </ul>
                                    </span>
                                    <br />
                                    <br />
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingLeads">
                            <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importLeads" aria-expanded="false" aria-controls="importLeads">
                                Import Leads (Predefined Format)
                            </button>
                        </h2>
                        <div id="importLeads" class="accordion-collapse collapse" aria-labelledby="headingLeads" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <label>
                                    The data file must be in .csv format
                                    <br />Data must be formatted as in sample file. <a href="{{asset('storage/sample/Leads-import-sample.csv')}}" class="text-primary">Download Sample File</a>
                                    <br /><span class="text-info text-smaller">
                                        <ul>
                                            <li>The header row must be as present in sample file</li>
                                            <li>Mandatory Column values are: SI No., First name, Email. You can leave other columns blank if you don't have data.</li>
                                            <li>Valid values for 'Status' are: As defined in 'Settings > Leads > Status List'. If 'Status' is blank, default status will be assigned.</li>
                                            <li>Qualification: 9th, 10th, 11th, 12th, Bachelors, Masters</li>
                                            <li>Valid values for 'Type' are: Study Abroad, Coaching, Study Abroad & Coaching</li>
                                            <li>Valid values for 'Source' are: As defined in 'Settings > Leads > Lead Sources'</li>
                                        </ul>
                                    </span>
                                    <br />
                                    <br />
                                </label>
                                {{ html()->form('POST', route('admin.import-export.upload.leads'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                <div class="form-group col-sm-12 col-md-10">
                                    <label>Select leads data file (.csv)</label>
                                    <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                </div>
                                <div class="form-group col-sm-12 col-md-6">
                                    <label>Assign imported leads to*</label>
                                    <select class="form-select" name="assign_to" required>
                                        <option value="">Select Staff</option>
                                        @foreach($staff as $stf)
                                        <option value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                                        @endforeach
                                    </select>

                                </div>
                                <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                                    <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingLeads2">
                            <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importCourses2" aria-expanded="false" aria-controls="importCourses2">
                                Import University Course Data (Any .csv)
                            </button>
                        </h2>
                        <div id="importCourses2" class="accordion-collapse collapse" aria-labelledby="headingLeads2" data-bs-parent="#accordionExample">
                            <div class="accordion-body col-sm-12 col-md-12">
                                {{ html()->form('POST', route('admin.import-export.anycsvcoursemanagement'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                <div class="form-group col-sm-12 col-md-6">
                                    <label>Select Course Data file (.csv)</label>
                                    <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                </div>
                                <div class="form-group col-sm-12 col-md-6">
                                    <input type="checkbox" id="has_checked" name="has_header" value="1">
                                    <label for="has_checked">My file has header row</label>
                                </div>
                                <div class="form-group col-sm-12 col-md-6">
                                    <label>Category (Discipline Area)*</label>
                                    <select class="form-control form-select" name="category" required>
                                        <option value="">Select Category</option>
                                        @foreach($courseCategory as $category)
                                            @if($category->parent_id == 0)
                                                <optgroup label="{{$category->title}}">
                                                    @foreach($courseCategory as $subCategory)
                                                        @if($subCategory->parent_id == $category->id)
                                                            <option value="{{get_university_course_sub_category_name($subCategory->id)->id}}">{{get_university_course_sub_category_name($subCategory->id)->title}}</option>
                                                        @endif
                                                    @endforeach
                                                </optgroup>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-sm-12 col-md-6 text-center mt-4">
                                    <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                </div>
                                </form>

                                <label>
                                    <span class="text-info text-smaller">
                                        <strong>Notes:</strong>
                                        <ul>
                                            <li>Mandatory Columns are: Course Name, University, Study Level, Country.</li>
                                            <li>Valid Study Levels are: {{'"'.implode('", "', get_study_levels()).'"'}}</li>
                                            <li>Intake: Must be 3 letter month name. Multiple months can be comma seperated.</li>
                                            <li>If 'University' is not present in the database, it will be created.</li>
                                            <li>If 'Course' already exists, it's data will be updated.</li>
                                            <li>Available Data Columns For Import: University, Name, Course Details, Occupation Outcome, Practical Work, Course Content, Qualify Extended Visa, Regional Location, Sountry Students Not Accepted, Tuition Fee Onshore, Tuition Fee Offshore, Non Tuition Fee, Website URL, Campus, Country, Study Level, Duration, Intakes, Entry Requirements, IELTS Score, IELTS No Band Less Than, TOEFL Score, TOEFL No Band Less Than, PTE Score, PTE No Band Less Than, GRE Score, GMAT Score, Application Deadline,	Application Fee, Tuition Fee, Remarks, DET Score, Backlog Range, Scholarship Detail, Scholarship Available, ESL/ELP Detail, ApplicationMode	</li>
                                        </ul>
                                    </span>
                                    <br />
                                    <br />
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingCourses">
                            <button class="accordion-button collapsed" style="font-weight: 600;" type="button" data-bs-toggle="collapse" data-bs-target="#importCourses" aria-expanded="false" aria-controls="importCourses">
                                Import University Course Data (Predefined Format)
                            </button>
                        </h2>
                        <div id="importCourses" class="accordion-collapse collapse" aria-labelledby="headingCourses" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <label>
                                    The data file must be in .csv format. When saving the file as csv from MS Excel, choose save as type "CSV UTF-8".
                                    <br />Data must be formatted as in sample file. <a href="{{asset('storage/sample/Course-import-sample.csv')}}" class="text-primary">Download Sample File</a>
                                    <br /><span class="text-info text-smaller">
                                        <ul>
                                            <li>The header row must be as present in sample file</li>
                                            <li>Mandatory Column values are: Serial No., Category, University, Name, Campus, Country, Study Level. You can leave other columns blank if you don't have data.</li>
                                            <li>Category ID must be of a sub category(Discipline Area).</li>
                                            <li>Valid Study Levels are: {{'"'.implode('", "', get_study_levels()).'"'}}</li>
                                            <li>Intake: Must be 3 letter month name. Multiple months can be comma seperated.</li>
                                            <li>If University is not present in the database, it will be added.</li>
                                            <li>If Course exists, it's data will be updated.</li>
                                        </ul>
                                    </span>
                                    <br />
                                    <br />
                                </label>
                                {{ html()->form('POST', route('admin.import-export.upload.course'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                <div class="form-group col-sm-12 col-md-10">
                                    <label>Select course data file (.csv)</label>
                                    <input class="form-control" type="file" name="data_file" accept=".csv" required>
                                </div>
                                <div class="form-group col-sm-12 col-md-12 text-center mt-4">
                                    <input class="btn btn-primary" style="" type="submit" name="submit" value="Import">
                                </div>
                                </form>


                            </div>
                        </div>
                    </div>

                </div> --}}

            </div>
        </div>
    </div>

</div>

@endsection

@push('after-scripts')
<script>
$(document).ready(function () {
  location.hash && $(location.hash + '.collapse').collapse('show');

  $('#country').on('change', function () {
            var idCountry = this.value;
            $("#university-select").html('');
            $.ajax({
                url: "{{url('api/fetch-university')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#university-select').html('<option value="">Select University</option>');
                    $.each(result.university, function (key, value) {
                       if(value.id == "{{old('university')}}"){
                            var selectedUniversity = "selected=\"'selected'\"";
                       }
                       else{
                            var selectedUniversity = "";
                       }
                        $("#university-select").append('<option '+selectedUniversity+' value="'+ value.id + '">' + value.university_name + '</option>');
                    });
                }
            });
        });

        $('.assign_to_branch').change(function(){
            var branch_id= $(this).val();
            if(branch_id!=''){
            $.ajax({
            type: "get",
            url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+branch_id,
            cache: false,
            success: function(data){                     
            try{  
                if(data){
                    console.log(data);
                $(".assign_to").empty();
                    $(".assign_to").append('<option value="">Select Staff</option>');
                $.each(data,function(key,value){
                    $(".assign_to").append('<option value="'+key+'">'+value+'</option>');
                });
                }else{
                    $(".assign_to").empty();
                }
            }catch(e) {     
                alert('Exception while request..');
            }   

            },
            error: function(){                      
                alert('Error while request..');
            }
            });
            }
        });
});
</script>
@endpush