@extends('backend.layouts.app')
@section('title', "New Ad-hoc Invoice")

@section('content')
<div class="card" style="border:none;">
    <div class=" card-body printableArea">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    New Ad-hoc Invoice
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{route('admin.invoice.university-invoices')}}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="form-horizontal" method="POST" action="{{route('admin.invoice.generate-ad-hoc-invoice.save')}}">
            @csrf
            <input type="hidden" value="{{$current_business}}" name="business_id">
            <div class="row mt-4">
                <div class="col-sm-12 col-md-3">
                    <label class="col-form-label">Invoice From</label>
                    <select class="form-control form-select" id="business_id" name="business_id" required>
                        @foreach(get_business_list() as $business)
                        <option @if($current_business == $business->id) selected="selected" @endif value="{{$business->id}}">{{$business->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-sm-12 col-md-3">
                    Select University
                    <select name="university" id="university" style="width:100%;" class='form-control form-select select2'>
                        <option value="">Select University</option>
                        @foreach($universities as $uni)
                            <option value="{{$uni->id}}">{{$uni->university_name}}</option>
                        @endforeach
                    </select>
                </div>
                <span id="tax_err" style="display: none;" class="text-danger"></span>
            </div>
           
            <div class="row mt-4">
                <div class="col-md-4">
                    <div class="pull-left">
                        @if(empty($user))
                        <address>
                            <h5><b>Bill To</b></h5>
                            <p class="m-l-5">
                                <span id="uni_name"></span><br />
                                <span id="uni_addr"></span><br />
                                {{-- Mob: <span id="uni_mob"></span><br />
                                Email: <span id="uni_email"></span> --}}
                            </p>
                        </address>
                        @else
                        <address>
                            <h5><b>Bill To</b></h5>
                            <p class="m-l-5">
                                <span id="uni_name">{{get_user_full_name_by_id($user->id)}}</span> <br />
                                @php
                                    $address = "";
                                    if($user){
                                        if($user->address_1){
                                            $address .= $user->address_1. ", ";
                                        }
                                        if($user->address_2){
                                            $address .= $user->address_2 . ", ";
                                        }
                                        if($user->city){
                                            $address .= $user->city . ", ";
                                        }
                                        if($user->state){
                                            $address .= get_state_name($user->state) . ", ";
                                        }
                                        if($user->country){
                                            $address .= get_country_name($user->country);
                                        }
                                        if($user->post_code){
                                            $address .= "-". $user->post_code ;
                                        }
                                    }
                                @endphp
                                @if($address)
                                    <span id="stu_city"> {{ $address }}</span><br /> 
                                @else
                                    Address: N/A<br />
                                @endif
                                Ph: @if($user && $user->mobile)<span id="stu_mob">{{$user->mobile}} </span> <br /> @else -- <br />@endif
                                Email: @if($user)<span id="stu_email">{{$user->email}} </span> <br /> @else --@endif
                            </p>
                        </address>
                        @endif
                    </div>
                </div>
                <div class="col-md-5">
                </div>
                <div class="col-md-3">
                    <div class="pull-right text-left">
                        <address>
                            <h5 class="font-bold">{{get_business_details($current_business)->name}}</h5>
                            <p class="m-l-30">
                                Address: {!!get_business_details($current_business)->address!!} <br />
                                Ph: {!!(get_business_details($current_business)) ? get_business_details($current_business)->phone : get_business_details(1)->phone!!} <br />
                                Email: {!!(get_business_details($current_business)) ? get_business_details($current_business)->email : get_business_details(1)->email!!}<br>
                                @lang('labels.general.taxid'): {!!(get_business_details($current_business)) ? get_business_details($current_business)->tax_id : get_business_details(1)->tax_id!!}<br><br />
                                <b>Due Date :</b> <input class="form-control mydatepicker" type="text" name="due_date" placeholder="dd-mm-yyyy" value="{{Carbon\Carbon::today()->format('d-m-Y')}}" autocomplete="off" required />
                            </p>
                        </address>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="table-responsive m-t-40" style="clear: both;">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr>
                                    {{-- <th class="text-center">Sl.No</th> --}}
                                    <th>Item & Description</th>
                                    <th class="text-right">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    {{-- <td class="text-center" id="ct2">1</td> --}}
                                    <td><textarea class="form-control" name="item1" id="item1" style="display: inline; width: 100%;" placeholder="Enter item / description" required></textarea></td>
                                    <td style="width: 220px;"><span class="curr_sym">{{config('app.currency_symbol')}}</span> <input type="text" class="form-control item_value inputs" name="item1amount" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" style="display: inline; width: 150px;" required></td>
                                </tr>
                            </tbody>
                        </table>
                        {{-- <div class="btn btn-sm btn-primary" id="see_more">Show More &nbsp;<i class="fas fa-angle-down"></i></div>
                        <div class="btn btn-sm btn-primary" id="see_less" style="display: none;">Show Less &nbsp;<i class="fas fa-angle-up"></i></div> --}}
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="m-t-30 col-md-6" style="text-align: left;">
                            <h6><b>Terms & Conditions</b>
                            <textarea class="form-control" style="height: 100px" name="terms_conditions">{{(get_business_details($current_business)) ? get_business_details($current_business)->terms_text : get_business_details(1)->terms_text}}</textarea>
                        </div>

                        <div class="m-t-30 col-md-6" style="text-align: right;">
                            <h6><b>Sub Total :</b> <span class="curr_sym">{{config('app.currency_symbol')}}</span> <span id="tot">0</span>
                                {{-- <input type="hidden" name="cart_total" id="tot_val">
                                <input type="hidden" name="sub_total" id="sub_val"> --}}
                            </h6>
                            <p style="text-align:right;" class="mb-0">
                                <label class="p-2">Tax: <span id="tax_type"></span></label>
                                {{-- <input type="text" style="display: inline; width: 150px;" name="tax1_name" placeholder="Tax Name" class="form-control"> --}}
                                <span class="curr_sym">{{config('app.currency_symbol')}}</span> <input type="number" id="tax_one" name="tax_amount" style="display: inline; width: 110px;" placeholder="Tax Amount" readonly class="form-control inputs">
                                <input type="hidden" name="tax_type" id="tax_type_val">
                                <input type="hidden" name="tax_percent" id="tax_per">
                            </p>
                            <h6><b>Total :</b> <span class="curr_sym">{{config('app.currency_symbol')}}</span> <span id="ftot">0</span>
                                <input type="hidden" name="grand_total" id="tot_val">
                                <input type="hidden" name="sub_total" id="sub_val">
                                <input type="hidden" name="currency" id="currency">
                            </h6>
                        </div>
                    </div>
                    
                    <div class="clearfix"></div>
                    <!-- <div class="text-left">
                        <p><b>Payment Terms:</b></p>
                        <p><b>Terms & Conditions & bank/upi details can be displayed here</b></p>
                    </div> -->
                    <hr />
                    <div class="text-center">
                        {{-- <p style="text-align:center;"><label class="p-2"><input type="checkbox" name="send_invoice" value="1"> Email Invoice to Client</label></p> --}}
                        <button class="btn btn-primary btn-sm" type="submit" id="create_btn" name="crt" value="create">Create </button>
                        <a href="{{route('admin.invoice.university-invoices')}}" class="btn btn-primary btn-sm" type="button">Cancel</a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@push ('after-scripts')
<script>
    $(document).ready(function() {
       
        $("#business_id").change(function() {
                var brnch = $("#business_id").val();
                window.location.replace("{{url('admin/invoices/generate/ad-hoc/?business=')}}"+brnch);
            // }
        });
        // $('.select2_ajax').select2({
        //     minimumInputLength: 3,
        //     ajax: {
        //         url: '{{ route("admin.search.student") }}',
        //         type: "POST",
        //         dataType: 'json',
        //         data: function(params) {
        //             return {
        //                 q: params.term, // search term
        //                 _token: '{{csrf_token()}}'
        //             };
        //         },
        //     },
        // });


        $("#university").on("change", function() {
            $("#tax_err").hide();
            $.ajax({
                url: '{{ route("admin.search.universityData") }}',
                type: "post",
                data: {
                    id: $(this).val(),
                    _token: '{{csrf_token()}}'
                },
                success: function(data) {
                    $('.curr_sym').html(data.uni_currency);
                    $('#currency').val(data.currency_code);
                    $('#uni_name').html(data.uniData['university_name']);
                    if(data.uniData['tax_percent'] != null){
                        $("#tax_err").hide();
                        $("#create_btn").removeAttr('disabled');
                        var perc = data.uniData['tax_percent'] +"% "+data.uniData['tax_type'];
                        $("#tax_per").val(data.uniData['tax_percent']);
                        $("#tax_type_val").val(data.uniData['tax_type']);
                    }else{
                        var conf_url = "{{url('admin/coursemanagement/university/')}}/"+ data.uniData['id'] + "/edit";
                        var configure_link = "<a class='btn-link' href='"+conf_url+"'> Configure</a>";
                        $("#tax_err").html("Tax is not configured for the selected university! "+ configure_link);
                        $("#tax_err").show();
                        $("#create_btn").prop("disabled", true);
                        var perc = "";
                        $("#tax_per").val("");
                        $("#tax_type_val").val("");
                    }
                    $('#tax_type').html(perc);
                    $('#uni_addr').html(data.uniData['address']);
                }
            });
        });

        $('.inputs').on('input', function() {
            var total = 0;
            var totalAmt = 0;
            $('.item_value').each(function() {
                total += parseFloat($(this).val()) || 0;
            });
            
            var tax_type = $('#tax_type_val').val();
            var tax_percent = $('#tax_per').val();

            if(tax_type == 'exclusive'){
                finalComm = parseFloat(total);
                var tax_amt = finalComm * tax_percent /100;
                totalAmt = finalComm;
                ftotalAmt = parseFloat(total) + tax_amt;
            }
            else if(tax_type == 'inclusive'){
                //finalComm = parseFloat(total) / ( 1 + (tax_percent / 100));
                var tax_amt = total * tax_percent /100;
                ftotalAmt = total;
                totalAmt = total;
            }else{
                ftotalAmt = total;
                totalAmt = total;
            }
            if(tax_amt){
                $('#tax_one').val(tax_amt.toFixed(2));
            }
            
            // if($('#tax_one').val()){
            //     var tax_one =  parseFloat($('#tax_one').val());
            // }else{
            //     var tax_one =  0;
            // }
    
            //console.log(totalAmt + tax_amt);
            $('#tot').html(totalAmt.toFixed(2));
            $('#ftot').html(ftotalAmt.toFixed(2));
            $('#sub_val').val(totalAmt.toFixed(2));
            $('#tot_val').val(ftotalAmt.toFixed(2));
        });
    });
</script>
@endpush