@extends('backend.layouts.app')
@section('title', "Create University Invoice")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    Create University Invoice
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.invoice.university-invoices') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        @if(!$has_fees)
        <div class="alert alert-danger" role="alert">Tuition Fees cannot be empty!</div>
        @endif
        <!--row-->
        {{ html()->form('POST', route('admin.invoice.generate-enrolled-student-invoice.save'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
        <input type="hidden" value="{{$current_business}}" name="business_id">
        <div class="form-group row">
            <div class="col-sm-12 col-md-3">
                <label class="col-form-label">Invoice From</label>
                <select class="form-control form-select" id="business_id" name="business_id" required>
                    @foreach(get_business_list() as $business)
                    <option @if($current_business == $business->id) selected="selected" @endif value="{{$business->id}}">{{$business->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">University: <b>{{$universityData->university_name}}</b></label>
                <input type="hidden" name="university_id" value="{{$universityData->id}}">
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-6 col-md-3">
                <label class="col-form-label">Commission Percent <input type="number" min="1" step="any" id="commission_percent" class="form-control mb-0" name="commission_percent" onchange="onCommPerChange(this.value);" value="{{$universityData->commission_percent}}"></label>
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="col-form-label">Tax Rate</label><br>
                <input type="hidden" name="tax_percent" id="tax_percent" value="{{$universityData->tax_percent}}" required>
                <input type="hidden" name="tax_type" value="{{$universityData->tax_type}}" required>
                {{$universityData->tax_percent}}%  {{$universityData->tax_type}}
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-12 col-md-8">
                <label class="col-form-label">This invoice is for </label><br>
                @if($universityData->commission_count==1)
                    <input type="checkbox" value="1" id="first_pay" name="payment_stage[]" onchange="checkPayment(this);" class="pay_chk"> <label> 1st Payment</label>
                @endif
                @if($universityData->commission_count==2)
                    <input type="checkbox" value="1" id="first_pay" name="payment_stage[]" onchange="checkPayment(this);" class="pay_chk"> <label> 1st Payment</label>
                    <input type="checkbox" value="2" id="second_pay" name="payment_stage[]" onchange="checkPayment(this);" class="ms-3 pay_chk"> <label> 2nd Payment</label>
                @endif
                @if($universityData->commission_count==3)
                    <input type="checkbox" value="1" id="first_pay" name="payment_stage[]" onchange="checkPayment(this);" class="pay_chk"> <label> 1st Payment</label>
                    <input type="checkbox" value="2" id="second_pay" name="payment_stage[]" onchange="checkPayment(this);" class="ms-3 pay_chk"> <label> 2nd Payment</label>
                    <input type="checkbox" value="3" id="third_pay" name="payment_stage[]" onchange="checkPayment(this);" class="ms-3 pay_chk"> <label> 3rd Payment</label>
                @endif
                @if($universityData->commission_count==4)
                    <input type="checkbox" value="1" id="first_pay" name="payment_stage[]" onchange="checkPayment(this);" class="pay_chk"> <label> 1st Payment</label>
                    <input type="checkbox" value="2" id="second_pay" name="payment_stage[]" onchange="checkPayment(this);" class="ms-3 pay_chk"> <label> 2nd Payment</label>
                    <input type="checkbox" value="3" id="third_pay" name="payment_stage[]" onchange="checkPayment(this);" class="ms-3 pay_chk"> <label> 3rd Payment</label>
                    <input type="checkbox" value="4" id="fourth_pay" name="payment_stage[]" onchange="checkPayment(this);" class="ms-3 pay_chk"> <label> 4th Payment</label>
                @endif
            </div>
        </div>

        <div class="form-group row mb-2 mt-2">
            <div class="col-sm-12 col-md-8">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Students</th>
                            <th>Tuition Fees</th>
                            <th>Commission</th>
                            <th>Tax</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                        @foreach ($appdata_arr as $appdata)
                        <tr>
                            <input type="hidden" name="app_id[]" value="{{$appdata->id}}">
                            <input type="hidden" name="student_id[]" value="{{$appdata->userid}}">
                            <input type="hidden" name="currency" value="{{get_course_details_by_pref_id($appdata->course_pref_id)->currency}}">
                            <td>{{ $appdata->first_name }} {{$appdata->last_name }}</td>
                            <td>{{get_course_details_by_pref_id($appdata->course_pref_id)->currency." ".get_course_details_by_pref_id($appdata->course_pref_id)->total_tuition_fee}} <input type="hidden" class="course_fee" value="{{get_course_details_by_pref_id($appdata->course_pref_id)->total_tuition_fee}}"></td>
                            <td><input type="number" step="any" class="form-control comm_inputs" name="commission[]" oninput="onCommChange(this);" id="comm_{{$appdata->id}}"></td>
                            <td><input type="number" step="any" class="form-control tax_inputs" name="tax[]" readonly id="tax_{{$appdata->id}}"></td>
                            <td><input type="number" step="any" class="form-control total_inputs" name="total_inline[]" readonly id="total_{{$appdata->id}}"></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Total Commission: <span id="total_comm">--</span></label>
                <input type="hidden" name="total_commission" id="total_comm_val">
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Total Tax: <span id="total_tax">--</span></label>
                <input type="hidden" name="total_tax" id="total_tax_val">
            </div>
        </div>

        {{-- <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Tax Rate: <span>{{$universityData->tax_percent}}%</span></label>
            </div>
        </div> --}}

        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Grand Total: <span id="grand_total_amt">--</span></label>
                <input type="hidden" name="grand_total" id="grand_total_amt_val">
            </div>
        </div>
            
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                {{-- @foreach ($appdata_arr as $appdata)
                    <input type="hidden" name="lead_id[]" value="{{$appdata->id}}">
                    <label class="col-form-label"><b>{{ $appdata->first_name }} {{$leaddata->last_name }}</b>  ({{ $leaddata->email }})</label> <br>
                @endforeach --}}
            </div>
        </div>
             

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    @if(!$has_fees)
                    <button class="btn btn-primary btn-sm" disabled type="button">Create</button>
                    @else
                    {{ form_submit("Create") }}
                    @endif
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.invoice.university-invoices') }}'">Cancel</button>
                </div>
            </div>
        </div>


    </div>
</div>
@endsection
@push ('after-scripts')
<script>
    $(document).ready(function() {
        // $('.pay_chk').on('input', function() {
        //     console.log("ok");
        //     var total = 0;
        //     $('.item_value').each(function() {
        //         total += parseFloat($(this).val()) || 0;
        //     });
           
        //     var dis =  parseFloat($('#discount').val());

        //     if($('#tax_one').val()){
        //         var tax_one =  parseFloat($('#tax_one').val());
        //     }else{
        //         var tax_one =  0;
        //     }
        //     if($('#tax_two').val()){
        //         var tax_two =  parseFloat($('#tax_two').val());
        //     }else{
        //         var tax_two =  0;
        //     }
        //     //console.log(total + tax_one + tax_two - dis);
        //     $('#tot').html(total - dis);
        //     $('#ftot').html(total + tax_one + tax_two - dis);
        //     $('#sub_val').val(total);
        //     $('#tot_val').val(total + tax_one + tax_two - dis);
        // });
    });

    function checkPayment(obj) {
        var chk_count = "{{$universityData->commission_count}}";
        var tax_type = "{{$universityData->tax_type}}";
        var tax_percent = $('#tax_percent').val();
        var totalAmt = 0;
        var comm_per = 0;
        var finalComm = 0;
        var total_comm = 0;
        var total_tax = 0;
        var grand_total = 0;

        if($(obj).is(":checked")){
            comm_per = $("#commission_percent").val() / chk_count;
            $('.course_fee').each(function(){
                finalComm = (parseFloat(this.value) * parseFloat(comm_per)) / 100;
                if(tax_type == 'exclusive'){
                    var tax_amt = finalComm * tax_percent /100;
                    totalAmt = finalComm + tax_amt;
                }
                if(tax_type == 'inclusive'){
                    finalComm = finalComm / ( 1 + (tax_percent / 100));
                    var tax_amt = finalComm * tax_percent /100;
                    totalAmt = finalComm + tax_amt;
                    //finalComm = finalComm - tax_amt;
                }
                console.log(tax_amt);
                var old_comm = $(this).closest('tr').find('input[name="commission[]"]').val();
                var old_tax = $(this).closest('tr').find('input[name="tax[]"]').val();
                var old_total_inline = $(this).closest('tr').find('input[name="total_inline[]"]').val();
                if(old_comm!=0){
                    var finalComm = finalComm + parseFloat(old_comm);
                    var tax_amt = tax_amt + parseFloat(old_tax);
                    var totalAmt = totalAmt + parseFloat(old_total_inline);
                    $(this).closest('tr').find('input[name="commission[]"]').val(finalComm.toFixed(2));
                    $(this).closest('tr').find('input[name="tax[]"]').val(tax_amt.toFixed(2));
                    $(this).closest('tr').find('input[name="total_inline[]"]').val(totalAmt.toFixed(2));
                }else{
                    $(this).closest('tr').find('input[name="commission[]"]').val(parseFloat(finalComm).toFixed(2));
                    $(this).closest('tr').find('input[name="tax[]"]').val(parseFloat(tax_amt).toFixed(2));
                    $(this).closest('tr').find('input[name="total_inline[]"]').val(parseFloat(totalAmt).toFixed(2));
                }
                total_comm += finalComm;
                total_tax += tax_amt;
                grand_total += totalAmt;
            });
            $("#total_comm").html(total_comm.toFixed(2));
            $("#total_comm_val").val(total_comm.toFixed(2));
            
            $("#total_tax").html(total_tax.toFixed(2));
            $("#total_tax_val").val(total_tax.toFixed(2));
            
            $("#grand_total_amt").html(grand_total.toFixed(2));
            $("#grand_total_amt_val").val(grand_total.toFixed(2));
        }else{
            comm_per = $("#commission_percent").val() / chk_count;
            console.log("firstUnChecked "+ comm_per);
            $('.course_fee').each(function(){
                finalComm = (parseFloat(this.value) * parseFloat(comm_per)) / 100;
                if(tax_type == 'exclusive'){
                    var tax_amt = finalComm * tax_percent /100;
                    totalAmt = finalComm + tax_amt;
                }
                if(tax_type == 'inclusive'){
                    finalComm = finalComm / ( 1 + (tax_percent / 100));
                    var tax_amt = finalComm * tax_percent /100;
                    totalAmt = finalComm + tax_amt;
                    //finalComm = finalComm - tax_amt;
                }
                console.log(tax_amt); 
                var old_comm = $(this).closest('tr').find('input[name="commission[]"]').val();
                var old_tax = $(this).closest('tr').find('input[name="tax[]"]').val();
                var old_total_inline = $(this).closest('tr').find('input[name="total_inline[]"]').val();
                if(old_comm!=0){
                    var tot_comm = parseFloat(old_comm) - finalComm;
                    var tot_tax = parseFloat(old_tax) - tax_amt;
                    var tot_inline = parseFloat(old_total_inline) - totalAmt;
                    $(this).closest('tr').find('input[name="commission[]"]').val(tot_comm.toFixed(2));
                    $(this).closest('tr').find('input[name="tax[]"]').val(tot_tax.toFixed(2));
                    $(this).closest('tr').find('input[name="total_inline[]"]').val(tot_inline.toFixed(2));
                }
                total_comm += tot_comm;
                total_tax += tot_tax;
                grand_total += tot_inline;
            });
            $("#total_comm").html(total_comm.toFixed(2));
            $("#total_comm_val").val(total_comm.toFixed(2));
            $("#total_tax").html(total_tax.toFixed(2));
            $("#total_tax_val").val(total_tax.toFixed(2));
            $("#grand_total_amt").html(grand_total.toFixed(2));
            $("#grand_total_amt_val").val(grand_total.toFixed(2));
        }
    }

    function onCommChange(obj) {
        var total_comm = 0;
        var total_tax = 0;
        var grand_total = 0;
        var tax_type = "{{$universityData->tax_type}}";
        var tax_percent = $('#tax_percent').val();
            if(tax_type == 'exclusive'){
                finalComm = parseFloat(obj.value);
                var tax_amt = finalComm * tax_percent /100;
                totalAmt = parseFloat(obj.value) + tax_amt;
            }
            if(tax_type == 'inclusive'){
                finalComm = parseFloat(obj.value) / ( 1 + (tax_percent / 100));
                var tax_amt = finalComm * tax_percent /100;
                totalAmt = finalComm + tax_amt;
            }
        //$(obj).closest('tr').find('input[name="commission[]"]').val(finalComm.toFixed(2));
        $(obj).closest('tr').find('input[name="tax[]"]').val(tax_amt.toFixed(2));
        $(obj).closest('tr').find('input[name="total_inline[]"]').val(totalAmt.toFixed(2));

        // total_tax += tot_tax;
        // grand_total += tot_inline;
        $('.comm_inputs').each(function(){
            total_comm += parseFloat(this.value) || 0;
        });
        $('.tax_inputs').each(function(){
            total_tax += parseFloat(this.value) || 0;
        });
        $('.total_inputs').each(function(){
            grand_total += parseFloat(this.value) || 0;
        });
       
        $("#total_comm").html(total_comm.toFixed(2));
        $("#total_comm_val").val(total_comm.toFixed(2));
        $("#total_tax").html(total_tax.toFixed(2));
        $("#total_tax_val").val(total_tax.toFixed(2));
        $("#grand_total_amt").html(grand_total.toFixed(2));
        $("#grand_total_amt_val").val(grand_total.toFixed(2));
    }

    function onCommPerChange(obj) {
        //console.log(obj);
        $('.pay_chk').each(function() {
			this.checked = false;
            $(this).trigger('change');
		});
        $('input[name="commission[]"]').val('');
        $('input[name="tax[]"]').val('');
        $('input[name="total_inline[]"]').val('');
    }

    $("form").on("submit", function (e) {
        if($("#tax_percent").val()==""){
            e.preventDefault();
            alert("Invoice cannot be created. Tax rate is not set for the University.");
        }
        });
</script>
@endpush