@extends('backend.layouts.app')
@section('title', "New Invoice")

@section('content')
<div class="card" style="border:none;">
    <div class=" card-body printableArea">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    New Invoice
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{route('admin.invoice.student-invoices')}}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="form-horizontal" method="POST" action="{{route('admin.invoice.student-invoice-generate.store')}}">
            @csrf
            <input type="hidden" value="{{$current_business}}" name="business_id">
            <div class="row mt-4">
                <div class="col-sm-12 col-md-4">
                    Select Business
                    <select class="form-control form-select" id="business_id" name="business_id" required>
                        <option value="" hidden>Select Business</option>
                        @foreach(get_business_list() as $business)
                        <option @if($current_business == $business->id) selected="selected" @endif value="{{$business->id}}">{{$business->name}}</option>
                        {{-- <option @if($current_business == "business_2") selected="selected" @endif value="business_2">{{get_site_config('invoice_business_name_2')}}</option> --}}
                        @endforeach
                    </select>
                </div>
            </div>
            @if(empty($user))
                <div class="row mt-4">
                    <div class="col-sm-12 col-md-4">
                        Select Student
                        <select class="form-control select2_ajax" name="student_id" required></select>
                    </div>
                </div>
            @else
                <input type="hidden" name="student_id" value="{{$user->id}}">
            @endif
            <div class="row mt-4">
                <div class="col-md-4">
                    <div class="pull-left">
                        @if(empty($user))
                        <address>
                            <h5><b>Bill To</b></h5>
                            <p class="m-l-5">
                                <span id="stu_name"></span><br />
                                <span id="stu_city"></span><br />
                                Mob: <span id="stu_mob"></span><br />
                                Email: <span id="stu_email"></span>
                            </p>
                        </address>
                        @else
                        <address>
                            <h5><b>Bill To</b></h5>
                            <p class="m-l-5">
                                <span id="stu_name">{{get_user_full_name_by_id($user->id)}}</span> <br />
                                @php
                                    $address = "";
                                    if($user){
                                        if($user->address_1){
                                            $address .= $user->address_1. ", ";
                                        }
                                        if($user->address_2){
                                            $address .= $user->address_2 . ", ";
                                        }
                                        if($user->city){
                                            $address .= $user->city . ", ";
                                        }
                                        if($user->state){
                                            $address .= get_state_name($user->state) . ", ";
                                        }
                                        if($user->country){
                                            $address .= get_country_name($user->country);
                                        }
                                        if($user->post_code){
                                            $address .= "-". $user->post_code ;
                                        }
                                    }
                                @endphp
                                @if($address)
                                    <span id="stu_city"> {{ $address }}</span><br /> 
                                @else
                                    Address: N/A<br />
                                @endif
                                Ph: @if($user && $user->mobile)<span id="stu_mob">{{$user->mobile}} </span> <br /> @else -- <br />@endif
                                Email: @if($user)<span id="stu_email">{{$user->email}} </span> <br /> @else --@endif
                            </p>
                        </address>
                        @endif
                    </div>
                </div>
                @php 
                    $get_business_details = get_business_details($current_business); 
                    $get_business_details_default = get_business_details(1);
                @endphp
                <div class="col-md-5">
                </div>
                <div class="col-md-3">
                    <div class="pull-right text-left">
                        <address>
                            {{-- <h5 class="font-bold">{{get_site_config('invoice_business_name')}}</h5>
                            <p class="m-l-30">
                                Address: {!!get_site_config('invoice_business_address')!!} <br />
                                Ph: {!!get_site_config('invoice_business_phone')!!} <br />
                                Email: {!!get_site_config('invoice_business_email')!!}<br>
                                {{_label('tax_id')}}: {!!get_site_config('invoice_business_taxid')!!}<br><br />
                                <b>Due Date :</b> <input class="form-control mydatepicker" type="text" name="due_date" placeholder="dd-mm-yyyy" value="{{Carbon\Carbon::today()->format('d-m-Y')}}" autocomplete="off" required />
                            </p> --}}
                            
                            <h5 class="font-bold">
                                @if($get_business_details)
                                    {{$get_business_details->name}}
                                @elseif($get_business_details_default)
                                    {{$get_business_details_default->name}}
                                @endif
                            </h5>
                            <p class="m-l-30">
                                Address: 
                                @if($get_business_details)
                                    {!! $get_business_details->address !!} <br />
                                @elseif($get_business_details_default)
                                    {!! $get_business_details_default->address !!} <br />
                                @else
                                    -- <br />
                                @endif

                                Ph: 
                                @if($get_business_details)
                                    {!! $get_business_details->phone !!} <br />
                                @elseif($get_business_details_default)
                                    {!! $get_business_details_default->phone !!} <br />
                                @else
                                    -- <br />
                                @endif
                                
                                Email: 
                                @if($get_business_details)
                                    {!! $get_business_details->email !!} <br />
                                @elseif($get_business_details_default)
                                    {!! $get_business_details_default->email !!} <br />
                                @else
                                    -- <br />
                                @endif
                                
                                @lang('labels.general.taxid'): 
                                @if($get_business_details)
                                    {!! $get_business_details->tax_id !!} <br /><br />
                                @elseif($get_business_details_default)
                                    {!! $get_business_details_default->tax_id !!} <br /><br />
                                @else
                                    -- <br /><br />
                                @endif
                                
                                <b>Due Date :</b> <input class="form-control mydatepicker" type="text" name="due_date" placeholder="dd-mm-yyyy" value="{{Carbon\Carbon::today()->format('d-m-Y')}}" autocomplete="off" required />
                            </p>
                        </address>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="table-responsive m-t-40" style="clear: both;">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center">Sl.No</th>
                                    <th>Item & Description</th>
                                    <th class="text-right">Amount</th>
                                </tr>
                            </thead>
                            <tbody id="product_select_table_body">
                                <tr>
                                    <td class="text-center" id="ct1">1</td>
                                    <td><input type="text" class="form-control" name="item1" id="item1" style="display: inline; width: 100%;" placeholder="Enter item / description"></td>
                                    <td style="width: 220px;"><span class="curr_symb"></span> <input type="text" class="form-control item_value inputs" name="item1amount" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" style="display: inline; width: 150px;"></td>
                                </tr>
                            </tbody>
                        </table>
                        <input type="hidden" name="user_currency" id="user_currency" value="{{config('app.currency_symbol')}}">
                        <input type="hidden" name="invoiceCount" value="1" id="invoiceCount">
                        <div class="btn btn-sm btn-primary mt-2" id="add_more_invoice" style="width: 150px;">
                            <i class="bi bi-plus-circle"></i> Add More
                        </div>
                        {{-- <div class="btn btn-sm btn-primary" id="see_more">Show More &nbsp;<i class="fas fa-angle-down"></i></div>
                        <div class="btn btn-sm btn-primary" id="see_less" style="display: none;">Show Less &nbsp;<i class="fas fa-angle-up"></i></div> --}}
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="m-t-30 col-md-6" style="text-align: left;">
                            <h6><b>Terms & Conditions</b>
                            <textarea class="form-control" style="height: 100px" name="terms_conditions">
                                @if($get_business_details)
                                    {!! $get_business_details->terms_text !!}
                                @elseif($get_business_details_default)
                                    {!! $get_business_details_default->terms_text !!}
                                @else
                                    --
                                @endif
                            </textarea>
                        </div>

                        <div class="m-t-30 col-md-6 d-flex justify-content-end" style="text-align: right;">
                            <table style="border: 0px !important;">
                                <tbody style="border: 0px !important;">
                                    <tr style="border: 0px !important;">
                                        <td style="border: 0px !important; padding: 0px 10px;"><b>Sub Total : </b></td>
                                        <td style="border: 0px !important; padding: 0px 10px;">
                                            <span class="curr_symb">{{get_currency_symbol(config('app.currency'))}}</span><span id="tot">0</span>
                                            <input type="hidden" name="sub_total" id="sub_val">
                                            <input type="hidden" class="dis_tot">
                                            <p class="m-0" style="font-size:14px!important;display: none;" id="tax_incl_blk"></p>
                                        </td>
                                    </tr>
                                    <tr style="border: 0px !important;">
                                        <td style="border: 0px !important; padding: 0px 10px;"><b>Discount (-) : </b></td>
                                        <td style="border: 0px !important; padding: 0px 10px;"><span class="curr_symb">{{get_currency_symbol(config('app.currency'))}}</span></b> <input type="text" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" class="form-control inputs" name="discount" value="0" id="discount" style="display: inline; width: 80px;" required></td>
                                    </tr>
                                    <tr style="border: 0px !important;" class="@if(!get_site_config('enabled_taxes')) d-none @endif tax_tr">
                                        <td id="tax_title" style="border: 0px !important; padding: 0px 10px;"><b>Tax : </b></td>
                                        <td style="border: 0px !important; padding: 0px 10px;">
                                            <ul style="list-style: none;">
                                                <li class="clearfix" style="display: none;" id="tax_blk">
                                                    <label class="col">
                                                    <p class="text-dark small m-0" id="tax_one_name" style="font-size: 10px;"></p>
                                                    <p class="text-dark small m-0" id="tax_two_name" style="font-size: 10px;"></p>
                                                </label>
                                                <label class="col total mt-4">
                                                    <p class="m-0" id="tax_one_val"><span class="curr_symb"></span><span id="tax_one"></span></p>
                                                    <p class="m-0" id="tax_two_val"><span class="curr_symb"></span><span id="tax_two"></span></p>
                                                </label>
                                                </li>
                                                <input type="hidden" name="tax" value="">
                                                <input type="hidden" name="tax_type" value="">
                                                <input type="hidden" name="tax_one_amt" value="">
                                                <input type="hidden" name="tax_one_name" value="">
                                                <input type="hidden" name="tax_one_rate" value="">
                                                <input type="hidden" name="tax_two_amt" value="">
                                                <input type="hidden" name="tax_two_name" value="">
                                                <input type="hidden" name="tax_two_rate" value="">
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr style="border: 0px !important;" class="tax_tr">
                                        <td colspan="2" style="border: 0px !important; padding: 0px 10px;">
                                            @if(get_site_config('enabled_taxes') == 1)
                                                <button type="button" id="get_tax" class="btn btn-link p-0">Calculate Tax</button>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr style="border: 0px !important;">
                                        <td style="border: 0px !important; padding: 0px 10px;"><b>Grand Total : </b></td>
                                        <td style="border: 0px !important; padding: 0px 10px;">
                                            <span class="curr_symb">{{get_currency_symbol(config('app.currency'))}}</span><span id="grand_total">0</span>
                                            <input type="hidden" name="grand_total">
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        {{-- <div class="m-t-30 col-md-6" style="text-align: right;">
                            <h6><b>Discount :<span class="curr_symb">{{get_currency_symbol(config('app.currency'))}}</span></b> <input type="number" min="0"  class="form-control inputs" name="discount" value="0" id="discount" style="display: inline; width: 150px;" required></h6>
                            <h6><b>Sub Total :</b> <span class="curr_symb">{{get_currency_symbol(config('app.currency'))}}</span> <span id="tot">0</span>
                            </h6>
                            <p style="text-align:right;" class="mb-0">
                                <input type="text" style="display: inline; width: 150px;" name="tax1_name" placeholder="Tax Name" class="form-control">
                                <span class="curr_symb"></span> <input type="number" min="0" step="0.01" id="tax_one" name="tax1_amount" style="display: inline; width: 150px;" placeholder="Tax Amount" class="form-control inputs">
                            </p>
                            <p style="text-align:right;">
                                <input type="text" style="display: inline; width: 150px;" name="tax2_name" placeholder="Tax Name" class="form-control">
                                <span class="curr_symb"></span> <input type="number" min="0" step="0.01" id="tax_two" name="tax2_amount" style="display: inline; width: 150px;" placeholder="Tax Amount" class="form-control inputs">
                            </p>
                            {{-- //tax block--}}
                            {{-- <div class="@if(!get_site_config('enabled_taxes')) d-none @endif tax_block">
                                <p style="text-align:right;" class="mb-0"><b>Tax : </b>
                                <td style="border: 0px !important; padding: 0px 10px;">
                                    <ul style="list-style: none;">
                                        <li class="clearfix" style="display: none;" id="tax_blk">
                                            <label class="col">
                                            <p class="text-dark small m-0" id="tax_one_name" style="font-size: 10px;"></p>
                                            <p class="text-dark small m-0" id="tax_two_name" style="font-size: 10px;"></p>
                                        </label>
                                        <label class="col total mt-4"> 
                                            <p class="m-0" id="tax_one_val"><span class="curr_symb"></span><span id="tax_one"></span></p>
                                            <p class="m-0" id="tax_two_val"><span class="curr_symb"></span><span id="tax_two"></span></p>
                                        </label>
                                        </li>
                                        <input type="hidden" name="tax" value="">
                                        <input type="hidden" name="tax_type" value="">
                                        <input type="hidden" name="tax_one_amt" value="">
                                        <input type="hidden" name="tax_one_name" value="">
                                        <input type="hidden" name="tax_one_rate" value="">
                                        <input type="hidden" name="tax_two_amt" value="">
                                        <input type="hidden" name="tax_two_name" value="">
                                        <input type="hidden" name="tax_two_rate" value="">
                                    </ul>
                                </td>
                            </div> --}}
                            {{-- //tax block--}}
                            {{-- <h6><b>Grand Total :</b> <span class="curr_symb">{{get_currency_symbol(config('app.currency'))}}</span> <span id="ftot">0</span>
                                <input type="hidden" name="cart_total" id="tot_val">
                                <input type="hidden" name="sub_total" id="sub_val">
                            </h6> 
                        </div> --}}
                    </div>
                    <br><br>
                    <br><br>
                    <div class="clearfix"></div>
                    <!-- <div class="text-left">
                        <p><b>Payment Terms:</b></p>
                        <p><b>Terms & Conditions & bank/upi details can be displayed here</b></p>
                    </div> -->
                    <hr />
                    <div class="text-center">
                        <p style="text-align:center;"><label class="p-2"><input type="checkbox" name="send_invoice" value="1"> Email Invoice to Client</label></p>
                        <button class="btn btn-primary btn-sm" type="submit" name="crt" value="create">Create </button>
                        <a href="{{route('admin.invoice.student-invoices')}}" class="btn btn-primary btn-sm" type="button">Cancel</a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@push ('after-scripts')
<script>
    $(document).ready(function() {
        $("#business_id").change(function() {
                var business_id = $("#business_id").val();
                window.location.replace("{{url('admin/invoices/student-invoice-generate/?business=')}}"+business_id);
        });
        $('#see_more').click(function(){
            $('.extra_rows').slideToggle();
            $('#see_less').show();
            $('#see_more').hide();
        });
        $('#see_less').click(function(){
            $('.extra_rows').slideToggle();
            $('#see_less').hide();
            $('#see_more').show();
        });
        let max_invoice_count = 50;
        let invoice_select_option = 2;
        let user_currency = $("#user_currency").val();
        $(".curr_symb").each(function() {
            $(this).html(user_currency)
        });

        $("#add_more_invoice").click(function(){
            if(invoice_select_option <= max_invoice_count){
                $("#product_select_table_body").append(`
                    <tr>
                        <td class="text-center" id="ct${invoice_select_option}">${invoice_select_option}</td>
                        <td><input type="text" class="form-control" name="item${invoice_select_option}" id="item${invoice_select_option}" style="display: inline; width: 100%;" placeholder="Enter item / description"></td>
                        <td style="width: 220px;"><span class="curr_symb">${user_currency}</span> <input type="text" class="form-control item_value inputs" name="item${invoice_select_option}amount" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" style="display: inline; width: 150px;"></td>
                    </tr>
                `);
                $("#invoiceCount").val(invoice_select_option);
                claculateGrandTotal();
                invoice_select_option++;
            }
            if(invoice_select_option >= max_invoice_count){
                $("#add_more_invoice").hide();
            }
        });
        
        $('.select2_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.search.student") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });


        $(".select2_ajax").on("select2:close", function() {
            $.ajax({
                url: '{{ route("admin.search.studentData") }}',
                type: "post",
                data: {
                    id: $(this).val(),
                    _token: '{{csrf_token()}}'
                },
                success: function(data) {
                    // console.log(data);
                    $(".curr_symb").each(function() {
                        $(this).html(data.results.user_currency)
                    });
                    $("#user_currency").val(data.results.user_currency);
                    user_currency = data.results.user_currency;
                    $('.tax_tr').show();
                    $('#stu_name').html(data.results.first_name + ' ' + data.results.last_name);
                    if (data.address) {
                        $('#stu_city').html(data.address);
                    } else {
                        $('#stu_city').html("N/A");
                    }
                    $('#stu_mob').html(data.results.mobile);
                    $('#stu_email').html(data.results.email);
                    var len = 0;
                    if (data.batch != null) {
                        len = data.batch.length;
                    }

                    if (len > 0) {
                        // Read data and create <option >
                        for (var i = 0; i < len; i++) {
                            var id = data.batch[i].id;
                            var name = data.batch[i].code;
                            var option = "<option value='" + id + "'>" + name + "</option>";
                            $("#stu_batch1").append(option);
                        }
                        //$("#stu_batch1").attr('required', true);
                        $('#ifonly').show();
                        $('#ct2').text('2');
                        $('#ct3').text('3');
                        $('#ct4').text('4');
                        $('#ct5').text('5');
                        $('#ct7').text('7');
                        $('#ct7').text('7');
                    } else {
                        //$("#stu_batch1").attr('required', false);
                        $('#ifonly').hide();
                        $("#stu_batch1").html('');
                        var option = "<option value=''>Select Training Batch or Manually enter items below</option>";
                        $("#stu_batch1").append(option);
                        $('#ct2').text('1');
                        $('#ct3').text('2');
                        $('#ct4').text('3');
                        $('#ct5').text('4');
                        $('#ct6').text('5');
                        $('#ct7').text('6');
                    }
                }
            });
        });

        //batch change
        $('#stu_batch1').change(function() {
            var bid = $(this).val();
            if (bid != '') {
                $.ajax({
                    type: "post",
                    url: '{{ route("admin.search.get_course") }}',
                    data: {
                        id: bid,
                        _token: '{{csrf_token()}}'
                    },
                    success: function(res) {
                        //console.log("Course: "+res);     
                        if (res) {
                            $("#stu_batch1_course").html(res.title);
                            $("#course_fee1").html("{{config('app.currency_symbol')}} " + res.fees);
                            $("#item1amount").val(res.fees);
                            $("#item1").val('Batch: ' + res.code + ' Course: ' + res.title);

                            var total = 0;
                            $('.item_value').each(function() {
                                total += parseFloat($(this).val()) || 0;
                            });
                                var dis = $('#discount').val();
                                $('#tot').html(total - dis);
                                $('#sub_val').val(total);
                                $('#tot_val').val(total - dis);
                        }
                    }
                });
            } else {
                $("#stu_batch1_course").html('');
                $("#course_fee1").html('');
                $("#item1").val('');
                $("#item1amount").val('');
                var total = 0;
                $('.item_value').each(function() {
                    total += parseFloat($(this).val()) || 0;
                });
                var dis = $('#discount').val();
                $('#tot').html(total - dis);
                $('#sub_val').val(total);
                $('#tot_val').val(total - dis);
            }
        });

        // $('.inputs').on('input', function() {
        //     var total = 0;
        //     $('.item_value').each(function() {
        //         total += parseFloat($(this).val()) || 0;
        //     });
           
        //     var dis =  parseFloat($('#discount').val());

        //     if($('#tax_one').val()){
        //         var tax_one =  parseFloat($('#tax_one').val());
        //     }else{
        //         var tax_one =  0;
        //     }
        //     if($('#tax_two').val()){
        //         var tax_two =  parseFloat($('#tax_two').val());
        //     }else{
        //         var tax_two =  0;
        //     }
        //     $('#tot').html(total - dis);
        //     $('#ftot').html(total + tax_one + tax_two - dis);
        //     $('#sub_val').val(total);
        //     $('#tot_val').val(total + tax_one + tax_two - dis);
        // });

        claculateGrandTotal();
        function claculateGrandTotal(){
            $('.inputs').on('input', function() {
                $('#tax_blk').hide();
                $('[name="tax"]').val('');
                $('[name="tax_one_name"]').val('');
                $('[name="tax_one_rate"]').val('');
                $('[name="tax_one_amt"]').val('');
                $('[name="tax_two_name"]').val('');
                $('[name="tax_two_rate"]').val('');
                $('[name="tax_two_amt"]').val('');
                $('#grand_total').html('');
                $('[name="grand_total"]').val('');
                var total = 0;
                $('.item_value').each(function() {
                    total += parseFloat($(this).val()) || 0;
                });

                $('#tot').html(total);
                $('#ftot').html(total);
                // $('#ftot').html(total + tax_one + tax_two);
                $('#sub_val').val(total);
                $('#tot_val').val(total);
                // $('#tot_val').val(total + tax_one + tax_two);

                let tot_amt = total;
                if("{{get_site_config('enabled_taxes')}}" == 0){
                    if($('#discount').val()){
                        tot_amt -= $('#discount').val();
                    }
                    $('#grand_total').html(parseFloat(tot_amt).toFixed(2));
                    $('[name="grand_total"]').val(parseFloat(tot_amt).toFixed(2));
                }
                else if(exempted){
                    if($('#discount').val()){
                        tot_amt -= $('#discount').val();
                    }
                    $('#grand_total').html(parseFloat(tot_amt).toFixed(2));
                    $('[name="grand_total"]').val(parseFloat(tot_amt).toFixed(2));
                }
            });
        }

        //Get tax amt
        $("#get_tax").on("click", function() {
            let user_id = $(".select2_ajax").val();
            let tot_amt = $('#sub_val').val();
            if($('#discount').val()){
                tot_amt -= $('#discount').val();
            }

            if(user_id == '' || user_id == null){
                alert("Please select Client");
            }
            else if(tot_amt == ''){
                alert("Please add Item");   
            }else{
                $.ajax({
                url: '{{ route("admin.invoice.getTax") }}',
                type: "post",
                data: {
                    user_id:user_id,
                    total_amount:tot_amt,
                    _token: '{{csrf_token()}}'
                },
                success: function(data) {
                    // console.log(data);
                    if(data.tax && "{{get_site_config('tax_exclusive')}}" == 1){
                            $('#tax_blk').show();
                            $('#tax_one_name').html(data.tax_one_name+'('+data.tax_one_rate+'%)');
                            $('#tax_one').html(data.tax_one_amt);
                            $('[name="tax"]').val(data.tax);
                            $('[name="tax_type"]').val('exclusive');
                            $('[name="tax_one_name"]').val(data.tax_one_name);
                            $('[name="tax_one_rate"]').val(data.tax_one_rate);
                            $('[name="tax_one_amt"]').val(data.tax_one_amt);
                            if(data.tax_two_name){
                                $('#tax_two_val').show();
                                $('#tax_two_name').html(data.tax_two_name+'('+data.tax_two_rate+'%) -');
                                $('#tax_two').html(data.tax_two_amt);
                                $('[name="tax_two_name"]').val(data.tax_two_name);
                                $('[name="tax_two_rate"]').val(data.tax_two_rate);
                                $('[name="tax_two_amt"]').val(data.tax_two_amt);
                            }else{
                                $('#tax_two_val').hide();
                                $('#tax_two_name').html('');
                                $('#tax_two').html('');
                                $('[name="tax_two_name"]').val('');
                                $('[name="tax_two_rate"]').val('');
                                $('[name="tax_two_amt"]').val('');
                            }
                            tot_amt = parseFloat(data.tax) + parseFloat(tot_amt);
                            // $('#tot').html(tot_amt);
                            $('#grand_total').html(parseFloat(tot_amt).toFixed(2));
                            $('[name="grand_total"]').val(parseFloat(tot_amt).toFixed(2));
                            //$('#sub_val').val(tot_amt);
                        }else{
                            if("{{get_site_config('tax_inclusive')}}" == 1){
                                $("#tax_title").hide();
                                let tax_one_name_rate = '';
                                let tax_two_name_rate = '';
                                let allData = '';
                                let net_amt = parseFloat(tot_amt) - parseFloat(data.tax);

                                tax_one_name_rate = data.users_currency+data.tax_one_amt+' '+data.tax_one_name+' @'+data.tax_one_rate+'%';
                                $('[name="tax"]').val(data.tax);
                                $('[name="tax_type"]').val('inclusive');
                                $('[name="tax_one_name"]').val(data.tax_one_name);
                                $('[name="tax_one_rate"]').val(data.tax_one_rate);
                                $('[name="tax_one_amt"]').val(data.tax_one_amt);
                                if(data.tax_two_name){
                                    tax_two_name_rate = data.users_currency+data.tax_two_amt+' '+data.tax_two_name+' @'+data.tax_two_rate+'%';
                                    $('[name="tax_two_name"]').val(data.tax_two_name);
                                    $('[name="tax_two_rate"]').val(data.tax_two_rate);
                                    $('[name="tax_two_amt"]').val(data.tax_two_amt);
                                    allData = "("+data.users_currency+net_amt+" Net Amount + "+tax_one_name_rate+' + '+tax_two_name_rate +")";
                                }else{
                                    allData = "("+net_amt+" Net Amount + "+tax_one_name_rate+")";
                                }
                                $('#tax_incl_blk').html(allData);
                                $('#tax_incl_blk').show();
                                tot_amt = parseFloat(tot_amt);
                                $('#grand_total').html(parseFloat(tot_amt).toFixed(2));
                                $('[name="grand_total"]').val(parseFloat(tot_amt).toFixed(2));
                            }else{
                                $('#tax_blk,#tax_incl_blk').hide();
                                alert("No tax configured for the selected Clients country and state!");
                                $('[name="tax"]').val('');
                                $('[name="tax_one_name"]').val('');
                                $('[name="tax_one_rate"]').val('');
                                $('[name="tax_one_amt"]').val('');
                                $('[name="tax_two_name"]').val('');
                                $('[name="tax_two_rate"]').val('');
                                $('[name="tax_two_amt"]').val('');
                                $('#grand_total').html('');
                                $('[name="grand_total"]').val('');
                                tot_amt = parseFloat(tot_amt);
                                $('#grand_total').html(parseFloat(tot_amt).toFixed(2));
                                $('[name="grand_total"]').val(parseFloat(tot_amt).toFixed(2));
                            }
                            
                        }
                    }
                });
            }
        });
        //Get tax amt
    });
</script>
@endpush