@extends('backend.layouts.app')
@section('title', "Create Uni Apply Agent Invoice")

@section('content')
<div class="card" style="border:none;">
    <div class=" card-body printableArea">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Create Uni Apply Agent Invoice
                </h4>
            </div>
            <div class="col-sm-2 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{route('admin.invoice.university-invoices')}}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
            </div>
        </div>
        <!--row-->
        <form class="form-horizontal" method="POST">
            @csrf
            <div class="row mt-4 justify-content-md-center filterBox" style="margin-right:0px!important;margin-left:0px!important;border-radius: 8px; border: 1px solid rgb(197, 206, 252);">
                <div class="col-sm-12 col-md-2 pt-3">
                    <select name="intake_year" id="intake_year" style="width:100%;" class='form-control form-select'>
                        <option value="">Intake Year</option>
                        <?php 
                                $year = date('Y',strtotime('-1 year'));
                                for ($x = 0; $x < 3; $x++) { ?>
                                <option value="<?php echo $year+$x; ?>" >
                                    <?php echo $year+$x; ?>
                            <?php } ?>
                        </option>
                    </select>
                  
                </div>
                <div class="col-sm-12 col-md-2 pt-3">
                    <select name="app_status" id="app_status" style="width:100%;" class='form-control form-select'>
                        <option value="">Application Status</option>
                        @foreach($app_statuses as $status)
                        <option value="{{$status->status_name}}">{{$status->status_name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-4 pt-3">
                    <select name="university[]" id="university" style="width:100%;" class='form-control form-select select2' multiple>
                        <option value="">Select University</option>
                        @foreach($universities as $uni)
                            <option value="{{$uni->university_name}}">{{$uni->university_name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-2 pt-3">
                    <button class="btn btn-primary btn-sm" onclick="javascript:filterApps();" type="button" value="Filter">Submit </button>
                </div>
            </div>
            
            <div class="row mt-4" id="result_div" style="display: none;">
                <div class="col lead-horizontal" >
                    <div class="">
                        <table class="table w-100" id="apps_list">
                            <thead>
                                <tr>
                                    <th data-orderable="false">
                                        <div class="form-check form-check-sm form-check-custom form-check-solid ms-2">
                                            <input class="form-check-input" type="checkbox" id="check_all" name="check_all" />
                                        </div>
                                    </th>
                                    <th style="padding-right: 10px !important;">ID</th>
                                    <th>Date Created</th>
                                    <th>Student</th>
                                    <th>Country</th>
                                    <th>Details</th>
                                    <th style="">Status</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <h3>Select the applications from the above table which you want to process</h3>
                <div class="col-md-12 process-selected" style="display: none;">
                    <div class="text-left">
                        <button class="btn btn-primary btn-sm" type="button" id="create_btn" onclick="processGenerate();" value="create">Generate Invoice for selected Applications </button>
                        {{-- <a href="{{route('admin.invoice.index')}}" class="btn btn-primary btn-sm" type="button">Cancel</a> --}}
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@push ('after-scripts')
<script>
    $(document).ready(function() {
        $("#university").select2({
            placeholder: "Select Universities",
        });
        $("#check_all").on("click", function() {
            if ($("input:checkbox[name='check_all']").prop("checked")) {
                $("input:checkbox[name='multiselect']").prop("checked", true);
            } else {
                $("input:checkbox[name='multiselect']").prop("checked", false);
            }
            checkboxCheckSelected();
        });

    });
    
    function loadData(myleads) {
        $("#result_div").show();
        $('#apps_list').DataTable({
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            "processing": true,
            "serverSide": true,
            "language": {
                searchPlaceholder: "ID, Name, Mobile, Email, Lead Source/Details..."
            },
            "autoWidth": true,
            "responsive": true,
            "lengthMenu": [50, 100, 200],
            "ajax": {
                "url": "{{route('admin.invoice.getAgentApplications')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'app_status': $('#app_status').val(),
                    'intake_year': $('#intake_year').val(),
                    'university': $('#university').val(),
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
                $('#bulk_operation').show();                
            },
            
            columns: [
                {
                    data: 'id',
                },
                {
                    data: 'appl_id',
                    orderable: false,
                },
                {
                    data: 'created_at',
                    orderable: false,
                },
                {
                    data: 'student',
                    orderable: false,
                },
                {
                    data: 'country',
                    orderable: false,
                },
                {
                    data: 'details',
                    orderable: false,
                },
                {
                    data: 'status',
                    orderable: false,
                    
                },
                
            ],
            columnDefs: [{
                    targets: 0,
                    orderable: false,
                    render: function(data) {
                        if (data != '') {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" onclick="javascript:checkboxCheckSelected();" name="multiselect" type="checkbox" value="${data}" />
                                </div>`;
                        } else {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" name="multiselectd" type="checkbox" value="" disabled />
                                </div>`;
                        }
                    }
                },

            ],
            @if(isset($search) && strlen($search))
                "search": {
                    "search": "{{$search}}"
                },
            @endif
            @if($logged_in_user->isAdmin() || $logged_in_user->can('export lead, student data'))
            "buttons": [
                {
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [13, 1, 3, 4, 5, 6, 7, 8, 9, 10, 12]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [13, 1, 3, 4, 5, 6, 7, 8, 9, 10, 12]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13]
                    }
                },
            ]
            @endif
        });
    }

    function checkboxCheckSelected() {
        var total_check_boxes = $("input:checkbox[name='multiselect']").length;
        var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
        if (total_check_boxes === total_checked_boxes) {
            $("#check_all").prop("checked", true);
        } else {
            $("#check_all").prop("checked", false);
        }
        if (total_checked_boxes > 0) {
            $(".process-selected").show();
        } else {
            $(".process-selected").hide();
        }
    }

    function clearSelectedCheckboxs() {
        $("#check_all").prop("checked", false);
        $(".process-selected").hide();

    }

    function filterApps() {
        if(document.getElementById('university').value == ''){
            alert("Please select university");
            document.getElementById('university').focus();
        }else if(document.getElementById('intake_year').value == ''){
            alert("Please select Intake Year");
            document.getElementById('intake_year').focus();
        }else if(document.getElementById('app_status').value == ''){
            alert("Please select Status");
            document.getElementById('app_status').focus();
        }
        else{
            $("#apps_list").dataTable().fnDestroy();
            loadData();
        }
    }
    function processGenerate() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var uni_id = $("#university").val();
        var sub_options = {
            url: "{{route('admin.invoice.generate-uni-apply-agent-invoice.step-two')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                'uni_id': uni_id,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function manual_form_submit(options) {
        var $form = $("<form />");
        $form.attr("action", options.url);
        $form.attr("method", options.method);
        for (var data in options.data)
            $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
        $("body").append($form);
        $form.submit();
    }
</script>
@endpush