@extends('backend.layouts.app')
@section('title', "View Invoice")

@section('content')
<div class="card" style="border: none;">
    <div class="card-body printableArea">
        <div class="row">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                   Invoice #{{$invoice->invoice_num}}
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ url()->previous() }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <br>
        <div class="row mt-4" id="no_print">
            <div class="col-md-6 col-sm-12">
                <img src="{{ asset('storage/'.get_site_config('website_logo')) }}" style="height:{{get_site_config('website_logo_ht')}}px">
            </div>
            <div class="col-md-6 col-sm-12">
                <div class="text-right d-inline-block float-end">
                    <a title="Record Payment" href="{{route('admin.invoice.student-invoice-add-payment', $invoice->id)}}" class="btn btn-success {{($invoice->cart_total - $total_payment <= 0) ? 'disabled' : ''}}" type="button"><i class="bi bi-record-circle"></i> Record Payment</a>
                    <a title="Download" class="btn btn-primary" target="_blank" href="{{route('admin.downloads.invoice', $invoice->id)}}"><i class="bi bi-download"></i> Download </a>
                    <a title="Email" href="{{route('admin.email.invoice', $invoice->id)}}" class="btn btn-info" type="button"><i class="bi bi-envelope"></i> Email</a>
                    {{-- <button onclick="printDiv('printme')" class="btn btn-info" type="button">Print</button> --}}
                </div>
            </div>
        </div>
        <br><br><br><br><br>
        <div class="row mt-4">
            <div class="col-md-4">
                <div class="pull-left">
                    <address>
                        <h5><b>Bill To</b></h5>
                        <p class="m-l-5">
                            {{get_user_full_name_by_id($invoice->student_id)}} <br />
                            @php
                                $address = "";
                                if($stuData){
                                    if($stuData->address_1){
                                        $address .= $stuData->address_1.", " ;
                                    }
                                    if($stuData->address_2){
                                        $address .= $stuData->address_2.", " ;
                                    }
                                    if($stuData->city){
                                        $address .= $stuData->city.", ";
                                    }
                                    if($stuData->state){
                                        $address .= get_state_name($stuData->state).", " ;
                                    }
                                    if($stuData->country){
                                        $address = get_country_name($stuData->country).", ";
                                    }
                                    if($stuData->post_code){
                                        $address .= "-". $stuData->post_code ;
                                    }
                                }
                            @endphp
                            @if($address)
                                {!! $address !!}<br />
                            @endif
                            Ph: @if($stuData){{$stuData->mobile}} <br /> @else -- <br />@endif
                            Email: @if($stuData){{$stuData->email}} <br /> @else --@endif
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-5">
            </div>
            <div class="col-md-3">
                <div class="pull-right text-left">
                    <address>
                        <h5 class="font-bold">{{get_site_config('invoice_business_name')}}</h5>
                        <p class="m-l-30">
                            Address: {!!get_site_config('invoice_business_address')!!} <br />
                            Ph: {!!get_site_config('invoice_business_phone')!!} <br />
                            Email: {!!get_site_config('invoice_business_email')!!}<br>
                            @lang('labels.general.taxid'): {!!get_site_config('invoice_business_taxid')!!}<br><br />
                            Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                            Due: {{date('d/m/Y', strtotime($invoice->due_date))}}
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-12">
                <div class="table-responsive m-t-40" style="clear: both;">
                    <table class="table table-striped table-bordered">
                        <thead class="tableHeading">
                            <tr>
                                <th class="text-center">Sl.No</th>
                                <th>Item & Description</th>
                                <th class="text-right">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $i = 1; @endphp
                            @if($invoice->item1)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item1}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item1_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item2)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item2}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item2_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item3)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item3}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item3_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item4)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item4}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item4_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item5)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item5}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item5_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item6)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item6}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item6_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item7)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item7}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item7_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item8)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item8}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item8_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item9)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item9}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item9_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item10)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item10}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item10_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item11)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item11}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item11_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item12)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item12}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item12_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item13)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item13}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item13_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item14)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item14}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item14_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item15)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item15}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item15_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item16)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item16}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item16_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item17)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item17}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item17_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item18)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item18}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item18_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item19)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item19}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item19_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item20)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item20}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item20_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item21)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item21}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item21_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
            {{-- <div class="col-md-12">
                <div class="pull-right m-t-30 text-right" style="float:right;">
                    <h6><b>Discount :</b> {{$invoice->discount}}</h6>
                    <h6><b>Total :</b> {{config('app.currency_symbol')}} {{$invoice->cart_total}}</h6>
                    <h6><b>Payment Made :</b> (-) {{config('app.currency_symbol')}} {{($total_payment) ? $total_payment : '0'}}</h6>
                    <h6><b>Balance Due :</b> {{config('app.currency_symbol')}} {{($total_payment) ? $invoice->cart_total - $total_payment : $invoice->cart_total}}</h6>
                </div>
            </div> --}}
            <div class="m-t-40 col-md-6" style="text-align: left;">
                <h6><b>Terms & Conditions</b>
                {{-- <p style="font-size: 13px; font-weight:400;">{{$invoice->terms_conditions}}</p> --}}
                <p style="font-size: 13px; font-weight:400;">{!!nl2br($invoice->terms_conditions)!!}</p>
            </div>
            <div class="col-md-6">
                <div class="pull-right m-t-30 text-right" style="float:right;">
                    <h6><b>Discount :</b> (-) {{$invoice->discount}}</h6>
                    @if($invoice->tax1_amount)
                    <h6><b>{{$invoice->tax1_name}} :</b> {{config('app.currency_symbol')}} {{$invoice->tax1_amount}}</h6>
                    @endif
                    @if($invoice->tax2_amount)
                    <h6><b>{{$invoice->tax2_name}} :</b> {{config('app.currency_symbol')}} {{$invoice->tax2_amount}}</h6>
                    @endif
                    <h6><b>Total :</b> {{config('app.currency_symbol')}} {{$invoice->cart_total}}</h6>
                    <h6><b>Payment Made :</b> (-) {{config('app.currency_symbol')}} {{($total_payment) ? $total_payment : '0'}}</h6>
                    <h6><b>Balance Due :</b> {{config('app.currency_symbol')}} {{($total_payment) ? $invoice->cart_total - $total_payment : $invoice->cart_total}}</h6>
                </div>
            </div>
            <div class="col-md-12">
               <div class="clearfix"></div>
                <div class="text-left">
                    <p><b>Transactions</b></p>
                    <div class="table-responsive m-t-40" style="clear: both;">
                        <table class="table table-striped table-bordered">
                            <thead class="tableHeading">
                                <tr>
                                    <th>Date</th>
                                    <th>Mode</th>
                                    <th>Transaction ID/ Notes</th>
                                    <th>Staff</th>
                                    <th>Amount</th>
                                    @if(\Auth::user()->isAdmin() || \Auth::user()->can('edit-invoice'))
                                    <th>Action</th> 
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @if(count($payments))
                                @foreach($payments as $payment)
                                <tr>
                                    <td>{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                                    <td>{{strtoupper($payment->pay_mode)}}</td>
                                    <td>{{$payment->trans_id}}</td>
                                    <td>{{get_user_full_name_by_id($payment->staff_id)}}</td>
                                    <td>{{config('app.currency_symbol')}} {{$payment->amount}}</td>
                                    @if(\Auth::user()->isAdmin() || \Auth::user()->can('edit-invoice'))
                                    <td>
                                        <a title="Delete" href="{{ route('admin.remove.student-invoice-payment-record', $payment->id)}}" class="btn btn-sm btn-outline-danger" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure want to Delete this Record?"><i class='fas fa-trash-alt text-outline-danger' style='font-size:17px'></i> Delete</a>
                                    </td>
                                    @endif
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="6" class="text-center">No Record Found!</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection
@push('after-styles')
<style>
    @media print {
        #no_print {
            display: none !important;
        }
    }
</style>
@endpush
@push('after-scripts')
<script>
     addDeleteForms();
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
    }
</script>
@endpush