@extends('backend.layouts.app')
@section('title', "Invoices")

@section('content')
<div class="card" style="border:none;">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                    Student Invoices
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{route('admin.invoice.student-invoice-generate')}}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Create Batch"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->

        {{ html()->modelForm($logged_in_user, 'GET', route('admin.invoice.student-invoices'))->class('form-horizontal')->open() }}
        <div class="row mt-4 mx-2">
            <div class="col-md-3 col-sm-3">
                @isset($filters['search'])
                <input class="form-control" type="text" name="search" placeholder="Search by Invoice No, Student" value="{{ $filters['search'] }}" />
                @else
                <input class="form-control" type="text" name="search" placeholder="Search by Invoice No, Student" />
                @endisset
            </div>
            <div class="col-md-2 col-sm-2">
                <select class="form-select" name="status" style="display: inline; width: 150px;">
                    <option value="">All</option>
                    <option value="due" @if($filters['status']=='due' )selected @endif>Due </option>
                    <option value="paid" @if($filters['status']=='paid' )selected @endif>Paid </option>
                </select>
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="submit" name="submit" class="form-control btn btn-primary" value="Filter" />
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="button" name="cancel" class="form-control btn btn-outline-primary" value="Clear" onclick="document.location ='{{ route('admin.invoice.student-invoices') }}'" />
            </div>
        </div>
        {{ html()->closeModelForm() }}
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive mt-4">
                    <table class="table eductrl-datatable" id="invoice_tbl">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Invoice #</th>
                                <th>Student</th>
                                <th>Due Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($pages))
                                @foreach($pages as $page)
                                <tr>
                                    <td>{{get_date_time_formated($page->created_at)}}</td>
                                    <td>{{$page->invoice_num}}</td>
                                    <td><a target='_blank' href="{{route('admin.auth.user.show', $page->userid)}}"><strong><span style='white-space:nowrap;'>{{ $page->first_name}} {{$page->last_name}} <br> {{ $page->mobile}}</a></td>
                                    <td>
                                        {{config('app.currency_symbol')}} {{(get_total_invoice_payment($page->id)) ? $page->grand_total - get_total_invoice_payment($page->id) : $page->grand_total}}
                                    </td>
                                    <td>
                                        <p class="text-{{($page->status == 'due')? 'danger' : 'success'}}"><strong>{{ucfirst($page->status)}}</strong></p>
                                    </td>
                                    <td>
                                        <div class="" aria-label="User Actions">
                                            <a href="{{ route('admin.invoice.view-student-invoice',$page->id)}}" data-placement="top" title="View" class="btn btn-outline-primary"><i class="fas fa-eye"></i></a>
                                            <a href="{{route('admin.invoice.student-invoice-add-payment', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Record Payment" class="btn btn-{{($page->grand_total - get_total_invoice_payment($page->id) <= 0) ? 'outline-secondary disabled' : 'outline-info'}}"><i class="fa fa-book" aria-hidden="true"></i></a>
                                            <a href="{{route('admin.email.invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Email" class="btn btn-outline-success"><i class="fa fa-envelope" aria-hidden="true"></i></a>
                                            <a target="_blank" href="{{route('admin.downloads.invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Download" class="btn btn-outline-warning"><i class="fa fa-download" aria-hidden="true"></i></a>
                                            @if(\Auth::user()->isAdmin() || \Auth::user()->can('edit-invoice'))
                                            <a href="{{route('admin.invoice.student-invoice.edit', $page->id)}}" title="Edit" class="btn btn-outline-primary"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                            @endif
                                            @if(\Auth::user()->isAdmin())
                                            <a href="{{route('admin.invoice.delete-student-invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Delete" data-method="delete" class="btn btn-outline-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td class="text-center" colspan="6">No Record Found</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
