@extends('backend.layouts.app')
@section('title', "Add Payment")

@section('content')
<div class="card " style="border:none;">
    <div class="card-body printableArea" >
       
         <div class="row">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                   Record payment
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ url()->previous() }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <br>

        <div class="row mt-4">
            <div class="col-md-4">
                <div class="pull-left">
                    <address>
                        <h5><b>Bill To</b></h5>
                        <p class="text-muted m-l-5">
                            {{get_user_full_name_by_id($invoice->student_id)}} <br />
                            @if($stuData->address_1)
                            Address: {{ $stuData->address_1 }}<br />{{ $stuData->address_2 }} <br />
                            @else
                            Address: N/A<br />
                            @endif
                            Mob: {{$stuData->mobile}} <br />
                            Email: {{$stuData->email}}
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-5">
            </div>
            <div class="col-md-3">
                <div class="pull-right text-left">
                    <address>
                        <p class="text-muted m-l-30">
                            Invoice: <strong>#{{$invoice->invoice_num}} </strong><br />
                            Invoice Date: <strong>{{date('d/m/Y', strtotime($invoice->created_at))}}</strong>
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-12">
                <form method="post" action="{{route('admin.invoice.student-invoice-payment.store')}}" class="form-horizontal p-t-20">
                    @csrf
                    <input type="hidden" name="invoice_id" value="{{$invoice->id}}">
                    <div class="form-group row">
                        <label for="amt-rec" class="col-sm-2 control-label">Amount Received* &nbsp; {{config('app.currency_symbol')}}</label>
                        <div class="col-sm-6">
                            <div class="input-group">
                                <input type="number" min="0" name="amount" class="form-control" id="amt-rec" placeholder="Amount" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="payment-date" class="col-sm-2 control-label">Payment Date*</label>
                        <div class="col-sm-6">
                            <div class="input-group">
                                <input type="text" name="payment_date" class="form-control mydatepicker" id="payment-date" placeholder="dd-mm-yyyy" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="payment-date" class="col-sm-2 control-label">Payment Mode*</label>
                        <div class="col-sm-6">
                            <div class="input-group">
                                <select name="payment_mode" class="form-select" required>
                                    <option value="">Select</option>
                                    <option value="bank_transfer">Bank Transfer </option>
                                    <option value="upi">UPI</option>
                                    <option value="cash">Cash</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="payment-date" class="col-sm-2 control-label">Transaction ID/Notes*</label>
                        <div class="col-sm-6">
                            <div class="input-group">
                                <input type="text" name="transaction_id" class="form-control" id="payment-date" placeholder="" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="payment-date" class="col-sm-2 control-label">Received By (Staff)*</label>
                        <div class="col-sm-6">
                            <div class="input-group">
                                <select name="staff_id" class="form-select" required>
                                    <option value="">Select </option>
                                    @foreach($staff as $staffmem)
                                    <option value="{{$staffmem->id}}">{{$staffmem->first_name}} {{$staffmem->last_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
<br><br>
                    <div class="form-group row">
                        <div class="offset-sm-3 col-sm-9 ">
                            <button type="submit" class="btn btn-primary btn-sm waves-effect waves-light">Submit</button>
                            <a href="{{ url()->previous() }}" class="btn btn-primary btn-sm waves-effect waves-light">Cancel</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@push('after-scripts')

<script>
    $(document).ready(function () {
        $('.mydatepicker').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            scrollInput: false,
            maxDate: new Date()
        });
    });
</script>

@endpush