@extends('backend.layouts.app')
@section('title', "View Invoice")

@section('content')
<div class="card" style="border: none;">
    <div class="card-body printableArea">
        <div class="row">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                   Invoice #{{$invoice->invoice_num}}
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ url()->previous() }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <br>
        <div class="row mt-4" id="no_print">
            <div class="col-md-6 col-sm-12">
                {{-- <img src="{{ asset('storage/'.get_site_config('website_logo')) }}" style="height:{{get_site_config('website_logo_ht')}}px"> --}}
            <?php
                $get_business_details = get_business_details($invoice->business_id);
                if($get_business_details){
                    $logo = $get_business_details->logo;
                } else{
                    $logo = asset('storage/'.get_site_config('website_logo')); 
                }
            ?>
            <img src="{{ asset('storage/'.$logo) }}" style="height:80px">
            </div>
            <div class="col-md-6 col-sm-12">
                <div class="text-right d-inline-block float-end">
                    <a title="Record Payment" href="{{route('admin.invoice.student-invoice-add-payment', $invoice->id)}}" class="btn btn-success {{($invoice->grand_total - $total_payment <= 0) ? 'disabled' : ''}}" type="button"><i class="fas fa-money-check-alt"></i> Record Payment</a>
                    <a title="Download" class="btn btn-primary" target="_blank" href="{{route('admin.downloads.invoice', $invoice->id)}}"><i class="bi bi-download"></i> Download </a>
                    <a title="Email" href="{{route('admin.email.invoice', $invoice->id)}}" class="btn btn-outline-info" type="button"><i class="bi bi-envelope"></i> Email</a>
                    {{-- <button onclick="printDiv('printme')" class="btn btn-info" type="button">Print</button> --}}
                </div>
            </div>
        </div>
        <br><br><br><br><br>
        <div class="row mt-4">
            <div class="col-md-4">
                <div class="pull-left">
                    <address>
                        <h5><b>Bill To</b></h5>
                        <p class="m-l-5">
                            {{get_user_full_name_by_id($invoice->student_id)}} <br />
                            @php
                                $address = "";
                               if(isset($stuData) && $stuData) { 
                                    if(!empty($stuData->address_1)) {
                                        $address .= $stuData->address_1 . ", ";
                                    }
                                    if(!empty($stuData->address_2)) {
                                        $address .= $stuData->address_2 . ", ";
                                    }
                                    if(!empty($stuData->city)) {
                                        $address .= $stuData->city . ", ";
                                    }
                                    if(!empty($stuData->state)) {
                                        $address .= get_state_name($stuData->state) . ", ";
                                    }
                                    if(!empty($stuData->country)) {
                                        $address .= get_country_name($stuData->country) . ", "; 
                                    }
                                    if(!empty($stuData->post_code)) {
                                        $address .= "-" . $stuData->post_code;
                                    }
                                }
                            @endphp
                            @if($address)
                                {!! $address !!}<br />
                            @endif
                            Ph: @if($stuData){{$stuData->mobile}} <br /> @else -- <br />@endif
                            Email: @if($stuData){{$stuData->email}} <br /> @else --@endif
                            {{_label('tax_id')}}: @if($stuData){{$stuData->gstn}} <br /> @else --@endif
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-5">
            </div>
            <div class="col-md-3">
                <div class="pull-right text-left">
                    {{-- <address>
                        <h5 class="font-bold">{{get_site_config('invoice_business_name')}}</h5>
                        <p class="m-l-30">
                            Address: {!!get_site_config('invoice_business_address')!!} <br />
                            Ph: {!!get_site_config('invoice_business_phone')!!} <br />
                            Email: {!!get_site_config('invoice_business_email')!!}<br>
                            {{_label('tax_id')}}: {!!get_site_config('invoice_business_taxid')!!}<br><br />
                            Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                            Due: {{date('d/m/Y', strtotime($invoice->due_date))}}
                        </p>
                    </address> --}}
                    <address>
                        @php $get_business_details = get_business_details($invoice->business_id) @endphp
                        <h5 class="font-bold">
                            @if($get_business_details) {{$get_business_details->name}} @endif
                        </h5>
                        <p class="m-l-30">
                            Address: @if($get_business_details) {!!$get_business_details->address!!} @else -- @endif <br />
                            Ph: @if($get_business_details) {!!$get_business_details->phone!!} @else -- @endif <br />
                            Email: @if($get_business_details) {!!$get_business_details->email!!} @else -- @endif<br>
                            @lang('labels.general.taxid'): @if($get_business_details) {!!$get_business_details->tax_id!!} @else -- @endif<br><br/>
                            Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                            Due Date: {{date('d/m/Y', strtotime($invoice->due_date))}}
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-12">
                <div class="table-responsive m-t-40" style="clear: both;">
                    <table class="table table-striped table-bordered">
                        <thead class="tableHeading">
                            <tr>
                                <th class="text-center">S. No.</th>
                                <th>Item & Description</th>
                                <th class="text-right">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice_items as $items)
                                <tr>
                                    <td class="text-center">{{$loop->iteration}}</td>
                                    <td>{{$items->item}}</td>
                                    <td class="text-right">{{get_currency_symbol($items->currency)}} {{$items->item_amount}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            {{-- <div class="col-md-12">
                <div class="pull-right m-t-30 text-right" style="float:right;">
                    <h6><b>Discount :</b> {{$invoice->discount}}</h6>
                    <h6><b>Total :</b> {{config('app.currency_symbol')}} {{$invoice->grand_total}}</h6>
                    <h6><b>Payment Made :</b> (-) {{config('app.currency_symbol')}} {{($total_payment) ? $total_payment : '0'}}</h6>
                    <h6><b>Balance Due :</b> {{config('app.currency_symbol')}} {{($total_payment) ? $invoice->grand_total - $total_payment : $invoice->grand_total}}</h6>
                </div>
            </div> --}}
            <div class="m-t-40 col-md-6" style="text-align: left;">
                <h6><b>Terms & Conditions</b>
                {{-- <p style="font-size: 13px; font-weight:400;">{{$invoice->terms_conditions}}</p> --}}
                <p style="font-size: 13px; font-weight:400;">{!!nl2br($invoice->terms_conditions)!!}</p>
            </div>
            <div class="col-md-6">
                <div class="pull-right m-t-30 text-right" style="float:right;width: 200px;">
                    @if($invoice->discount > 0)
                    <h6><b>Discount :</b>
                        {{-- @if($orderData && $orderData->promocode_id)
                        <small style="font-size: 10px!important;">{{'['.get_promocode_details($orderData->promocode_id)->code.']'}}</small> 
                        @endif --}}
                        {{get_currency_symbol($invoice->currency)}}{{$invoice->discount}}
                    </h6>
                    @endif

                    {{-- @if(!$orderData) --}}
                    <tr>
                        <td><strong>Sub Total&nbsp;: </strong></td>
                        <td>
                            <strong>{{get_currency_symbol($invoice->currency)}}{{number_format($invoice->grand_total - $invoice->discount, 2)}}</strong>
                            <table class="mt-2" style="border: 0px !important;">
                                <tbody style="border: 0px !important;">
                                    @if($invoice->tax_type == 'exclusive')
                                    <tr style="border: 0px !important;">
                                        <td style="border: 0px !important; font-size: 14px !important;">
                                            <strong>
                                                @if($invoice->tax1_name)
                                                    Tax (<small style="font-size: 14px!important;">{{$invoice->tax1_name}}@ {{$invoice->tax1_rate."%"}}) : </small>
                                                @endif
                                                @if($invoice->tax2_name)
                                                <br>
                                                Tax (<small style="font-size: 14px!important;">{{$invoice->tax2_name}}@ {{$invoice->tax2_rate."%"}}) : </small>
                                                @endif
                                            </strong>
                                        </td>
                                        <td style="border: 0px !important; font-size: 14px !important;">
                                            <strong>
                                                @if($invoice->tax1_name)
                                                    {{get_currency_symbol($invoice->currency)}}{{number_format($invoice->tax1_value, 2)}}
                                                @endif
                                                @if($invoice->tax2_name)
                                                    <br>
                                                    {{get_currency_symbol($invoice->currency)}}{{number_format($invoice->tax2_value, 2)}}
                                                @endif
                                                
                                                @if($invoice->total_tax==0)
                                                {{get_currency_symbol($invoice->currency)}}0
                                                @endif
                                            </strong>
                                        </td>
                                    </tr>
                                    @endif
                                    @if($invoice->tax_type == 'inclusive')
                                    <?php $net_amt = $invoice->grand_total - $invoice->discount - $invoice->total_tax; ?>
                                    <tr style="border: 0px !important;">
                                        <td style="border: 0px !important; font-size: 14px !important;">{{get_currency_symbol($invoice->currency).$net_amt}} + {{get_currency_symbol($invoice->currency).$invoice->tax1_value.' '.$invoice->tax1_name.' @'.$invoice->tax1_rate.'%'}} @if($invoice->tax2_name)+ {{get_currency_symbol($invoice->currency).$invoice->tax2_value.' '.$invoice->tax2_name.' @'.$invoice->tax2_rate.'%'}}@endif</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    {{-- @endif --}}
                    
                    {{-- @if($orderData && $orderData->tax_type == 'exclusive')
                        @if($invoice->tax1_value!=0)
                        <h6><b>{{$orderData->tax_one_name}}({{$orderData->tax_one_rate}}%) :</b> {{get_currency_symbol($invoice->currency)}}{{$invoice->tax1_value}}</h6>
                        @endif
                        @if($invoice->tax2_value!=0)
                        <h6><b>{{$orderData->tax_two_name}}({{$orderData->tax_two_rate}}%) :</b> {{get_currency_symbol($invoice->currency)}}{{$invoice->tax2_value}}</h6>
                        @endif
                        <h6 class="mb-2"><b>Sub Total :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->grand_total}}</h6>
                    @endif
                    @if($orderData && $orderData->tax_type == 'inclusive')
                    <h6 class="mb-0"><b>Sub Total :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->grand_total}}</h6>
                        <?php $net_amt = $invoice->grand_total - $orderData->discount - $orderData->total_tax; ?>
                        <p class="m-0 mb-2" style='font-size: 14px !important;'><b style='font-size: 14px !important;'>Net Amount:</b> {{get_currency_symbol($orderData->currency).$net_amt}} + {{get_currency_symbol($orderData->currency).$orderData->tax_one_amt.' '.$orderData->tax_one_name.' @'.$orderData->tax_one_rate.'%'}} @if($orderData->tax_two_name)+ {{get_currency_symbol($orderData->currency).$orderData->tax_two_amt.' '.$orderData->tax_two_name.' @'.$orderData->tax_two_rate.'%'}}@endif</p>
                        
                    @endif --}}
                    <h6><b>Grand Total :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->grand_total}}</h6>
                    <h6><b>Payment Made :</b> (-) {{get_currency_symbol($invoice->currency)}} {{($total_payment) ? $total_payment : '0'}}</h6>
                    <h6><b>Balance Due :</b> {{get_currency_symbol($invoice->currency)}} {{($total_payment) ? $invoice->grand_total - $total_payment : $invoice->grand_total}}</h6>
                </div>
            </div>
            <div class="col-md-12">
               <div class="clearfix"></div>
                <div class="text-left">
                    <p><b>Transactions</b></p>
                    <div class="table-responsive m-t-40" style="clear: both;">
                        <table class="table table-striped table-bordered">
                            <thead class="tableHeading">
                                <tr>
                                    <th>Date</th>
                                    <th>Mode</th>
                                    <th>Transaction ID/ Notes</th>
                                    <th>Staff</th>
                                    <th>Amount</th>
                                    @if(\Auth::user()->isAdmin() || \Auth::user()->can('edit-invoice'))
                                    <th>Action</th> 
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @if(count($payments))
                                @foreach($payments as $payment)
                                <tr>
                                    <td>{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                                    <td>{{strtoupper($payment->pay_mode)}}</td>
                                    <td>{{$payment->trans_id}}</td>
                                    <td>{{get_user_full_name_by_id($payment->staff_id)}}</td>
                                    <td>{{get_currency_symbol($invoice->currency)}} {{$payment->amount}}</td>
                                    @if(\Auth::user()->isAdmin() || \Auth::user()->can('edit-invoice'))
                                    <td>
                                        <a title="Delete" href="{{ route('admin.remove.student-invoice-payment-record', $payment->id)}}" class="btn btn-sm btn-outline-danger" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure want to Delete this Record?"><i class='fas fa-trash-alt text-outline-danger' style='font-size:17px'></i> Delete</a>
                                    </td>
                                    @endif
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="6" class="text-center">No Record Found!</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection
@push('after-styles')
<style>
    @media print {
        #no_print {
            display: none !important;
        }
    }
</style>
@endpush
@push('after-scripts')
<script>
     addDeleteForms();
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
    }
</script>
@endpush