@extends('backend.layouts.app')
@section('title', "Invoices")

@section('content')
<div class="card" style="border:none; padding: 12px 0px !important;">
    <div class="card-body">
        <div class="row" style="padding-left: 0px !important; padding-right: 20px !important;">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                    Invoices
                </h4>
            </div>
            
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{route('admin.invoice.student-invoice-generate')}}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Create Batch"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
            </div>
        </div>

        {{ html()->modelForm($logged_in_user, 'GET', route('admin.invoice.student-invoices'))->class('form-horizontal')->open() }}
        <div class="row mt-4 ">
            <div class="col-md-3 col-sm-3">
                @isset($filters['search'])
                <input class="form-control" type="text" name="search" placeholder="Search by Invoice No, Student" value="{{ $filters['search'] }}" />
                @else
                <input class="form-control" type="text" name="search" placeholder="Search by Invoice No, Student" />
                @endisset
            </div>
            <div class="col-md-2 col-sm-2">
                <select class="form-select" name="status" style="display: inline; width: 150px;">
                    <option value="">All</option>
                    <option value="due" @if($filters['status']=='due' )selected @endif>Due </option>
                    <option value="paid" @if($filters['status']=='paid' )selected @endif>Paid </option>
                </select>
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="submit" name="submit" class="form-control btn btn-primary" value="Filter" />
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="button" name="cancel" class="form-control btn btn-outline-primary" value="Clear" onclick="document.location ='{{ route('admin.invoice.student-invoices') }}'" />
            </div>
        </div>
        {{ html()->closeModelForm() }}
        
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive mt-4 ">
                    <table class="table eductrl-datatable " id="invoice_tbl">
                        <thead>
                            <tr>
                                <th>Invoice #</th>
                                <th>Date</th>
                                <th>Student</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($pages as $page)
                            <tr>
                                <td><b>{{$page->invoice_num}}</b></td>
                                <td>{{get_date_time_formated($page->created_at)}}</td>
                                <td>
                                    <a target='_blank' href="{{route('admin.auth.user.show', $page->student_id)}}"><strong><span style='white-space:nowrap;'>{{ $page->first_name}} {{$page->last_name}}</a>
                                </td>
                                <td>
                                    {{get_currency_symbol($page->currency)}} {{$page->grand_total}}
                                </td>
                                <td>
                                    @if($page->status == 'due')
                                        <span class="tag mb-1" style="background-color:#f0cccc !important; color:#f46a6a !important; height: 25px !important;">{{ucfirst($page->status)}}</p>
                                        {{-- @if($page->order_id)
                                            {{get_currency_symbol($page->currency)}} {{(get_total_invoice_payment($page->id)) ? 
                                            $page->grand_total - get_total_invoice_payment($page->id) : 
                                            $page->grand_total}}
                                        @else --}}
                                            {{get_currency_symbol($page->currency)}} {{$page->grand_total - get_total_invoice_payment($page->id)}}
                                        {{-- @endif --}}
                                    @else
                                        <span class="tag mb-1" style="background-color:#c7e1d8 !important; color:#34c38f !important; height: 25px !important;">{{ucfirst($page->status)}}</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="User Actions">
                                        <a href="{{ route('admin.invoice.view-student-invoice',$page->id)}}" data-placement="top" title="View" class="btn btn-outline-primary"><i class="fas fa-eye"></i></a>
                                        <a href="{{route('admin.invoice.student-invoice-add-payment', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Record Payment" class="btn btn-outline-{{($page->grand_total - get_total_invoice_payment($page->id) <= 0) ? 'secondary disabled' : 'primary'}}"><i class="fa fa-book" aria-hidden="true"></i></a>
                                        <a href="{{route('admin.email.invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Email" class="btn btn-outline-info"><i class="fa fa-envelope" aria-hidden="true"></i></a>
                                        <a target="_blank" href="{{route('admin.downloads.invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Download" class="btn btn-outline-warning"><i class="fa fa-download" aria-hidden="true"></i></a>
                                        @if(\Auth::user()->id == 1)
                                        <a href="{{route('admin.invoice.student-invoice.edit', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Edit" class="btn btn-outline-info"><i class="fa fa-pen" aria-hidden="true"></i></a>
                                        <a href="{{route('admin.invoice.delete-student-invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Delete" data-method="delete" class="btn btn-outline-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
