@extends('backend.layouts.app')
@section('title', "View University Invoice")

@section('content')
<div class="card" style="border: none;">
    <div class="card-body printableArea">
        <div class="row">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                   Invoice #{{$invoice->invoice_num}}
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.invoice.university-invoices') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <br>
        <div class="row mt-4" id="no_print">
            <div class="col-md-3 col-sm-4">
                <?php
                if(get_business_details($invoice->business_id)->logo){
                    $logo = get_business_details($invoice->business_id)->logo;
                }
                else{
                    $logo = asset('storage/'.get_site_config('website_logo')); 
                }
                ?>
                <img src="{{ asset('storage/'.$logo) }}" style="height:80px">
            </div>
            <div class="col-md-4 col-sm-2">
                <h5 class="font-bold">{{get_business_details($invoice->business_id)->name}}</h5>
                <p class="m-l-30">
                    Address: {!!get_business_details($invoice->business_id)->address!!} <br />
                    Ph: {!!get_business_details($invoice->business_id)->phone!!} <br />
                    Email: {!!get_business_details($invoice->business_id)->email!!}<br>
                    @lang('labels.general.taxid'): {!!get_business_details($invoice->business_id)->tax_id!!}<br><br/>
                    {{-- Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                    Due Date: {{date('d/m/Y', strtotime($invoice->due_date))}} --}}
                </p>
            </div>
            <div class="col-md-5 col-sm-5">
                <div class="text-right d-inline-block float-end">
                    <a title="Record Payment" href="{{route('admin.invoice.add-uni-payment', $invoice->id)}}" class="btn btn-success {{($invoice->total - $total_payment <= 0) ? 'disabled' : ''}}" type="button"><i class="bi bi-record-circle"></i> Record Payment</a>
                    <a title="Download" class="btn btn-primary" target="_blank" href="{{route('admin.downloads.uni-invoice', $invoice->id)}}"><i class="bi bi-download"></i> Download </a>
                </div>
            </div>
        </div>
        <br><br><br><br><br>
        <div class="row mt-4">
            <div class="col-md-4">
                <div class="pull-left">
                    <address >
                        <h5><b>Bill To</b></h5>
                        <p class="m-l-5">
                            {{$uniData->university_name}} <br />
                            @php
                                $address = "";
                                if($uniData){
                                    if($uniData->address){
                                        $address .= $uniData->address.", " ;
                                    }
                                    if($uniData->country){
                                        $address .= get_country_name($uniData->country);
                                    }
                                }
                            @endphp
                            @if($address)
                                {!! $address !!}<br />
                            @endif
                            {{-- Ph: @if($uniData){{$uniData->mobile}} <br /> @else -- <br />@endif
                            Email: @if($uniData){{$uniData->email}} <br /> @else --@endif --}}
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-6">
            </div>
            <div class="col-md-2">
                <div class="pull-right text-left">
                    <address>
                        <p class="m-l-30">
                            Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                            Due: {{date('d/m/Y', strtotime($invoice->due_date))}}
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-12">
                <div class="table-responsive m-t-40" style="clear: both;">
                    <table class="table table-striped table-bordered">
                        <thead class="tableHeading">
                            <tr>
                                <th class="text-center">Sl.No</th>
                                <th>Student</th>
                                <th>Intake</th>
                                <th>Course Fees</th>
                                <th>Commission%</th>
                                <th style="width:15%;">
                                    Commission (
                                    @php $payment_count = explode(',', $invoice->payment_stage);@endphp
                                        @foreach($payment_count as $pay_count)
                                            {{"Instl ".$pay_count}}{{$loop->last ? '' : ', '}}
                                        @endforeach
                                    )
                                </th>
                                <th class="text-right">Tax</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $i = 1; @endphp
                            @foreach($invoiceDetails as $item)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{get_user_full_name_by_id($item->student_id)}}<br>SID: {{get_user_sid_by_id($item->student_id)}}<br>Appl ID: {{$item->appl_id}}</td>
                                <td>{{$item->year."-".get_intake_month_name($item->intake)}}</td>
                                <td>{{get_currency_symbol(get_course_details_by_pref_id($item->course_pref_id)->currency)." ".get_course_details_by_pref_id($item->course_pref_id)->total_tuition_fee}}</td>
                                <td>{{number_format($invoice->commission_rate,2)}}%</td>
                                <td>{{get_currency_symbol($invoice->currency)}} {{$item->commission}}</td>
                                <td class="text-right">{{get_currency_symbol($invoice->currency)}} {{$item->tax}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            {{-- <div class="col-md-12">
                <div class="pull-right m-t-30 text-right" style="float:right;">
                    <h6><b>Discount :</b> {{$invoice->discount}}</h6>
                    <h6><b>Total :</b> {{config('app.currency_symbol')}} {{$invoice->cart_total}}</h6>
                    <h6><b>Payment Made :</b> (-) {{config('app.currency_symbol')}} {{($total_payment) ? $total_payment : '0'}}</h6>
                    <h6><b>Balance Due :</b> {{config('app.currency_symbol')}} {{($total_payment) ? $invoice->cart_total - $total_payment : $invoice->cart_total}}</h6>
                </div>
            </div> --}}
            <div class="m-t-40 col-md-6" style="text-align: left;">
                <p class="mb-0"><b>Tax Type: {{ucfirst($invoice->tax_type)}}</b></p>
                <p class="mt-0"><b>Total Instl: {{$uniData->commission_count}}</b></p>
                @if($invoice->terms_conditions)
                <b>Terms & Conditions</b>
                {{-- <p style="font-size: 13px; font-weight:400;">{{$invoice->terms_conditions}}</p> --}}
                <p style="font-size: 13px; font-weight:400;">{!!nl2br($invoice->terms_conditions)!!}</p>
                @endif
            </div>
            <div class="col-md-6">
                <div class="pull-right m-t-30 text-right" style="float:right;">
                    {{-- @if($invoice->tax1_amount)
                    <h6><b>{{$invoice->tax1_name}} :</b> {{config('app.currency_symbol')}} {{$invoice->tax1_amount}}</h6>
                    @endif
                    @if($invoice->tax2_amount)
                    <h6><b>{{$invoice->tax2_name}} :</b> {{config('app.currency_symbol')}} {{$invoice->tax2_amount}}</h6>
                    @endif --}}
                    <h6><b>Commission Total :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->sub_total}}</h6>
                    <h6><b>Tax({{$invoice->tax_rate}}%) :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->tax}}</h6>
                    <h6><b>Grand Total :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->total}}</h6>
                    <h6><b>Payment Made :</b> (-) {{get_currency_symbol($invoice->currency)}} {{($total_payment) ? $total_payment : '0'}}</h6>
                    <h6><b>Balance Due :</b> {{get_currency_symbol($invoice->currency)}} {{($total_payment) ? $invoice->total - $total_payment : $invoice->total}}</h6>
                </div>
            </div>
            <div class="col-md-12">
               <div class="clearfix"></div>
                <div class="text-left">
                    <p><b>Transactions</b></p>
                    <div class="table-responsive m-t-40" style="clear: both;">
                        <table class="table table-striped table-bordered">
                            <thead class="tableHeading">
                                <tr>
                                    <th>Date</th>
                                    <th>Mode</th>
                                    <th>Transaction ID/ Notes</th>
                                    {{-- <th>Staff</th> --}}
                                    <th>Amount</th>
                                    @if(\Auth::user()->isAdmin() || \Auth::user()->can('edit-invoice'))
                                    <th>Action</th> 
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @if(count($payments))
                                @foreach($payments as $payment)
                                <tr>
                                    <td>{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                                    <td>{{strtoupper($payment->pay_mode)}}</td>
                                    <td>{{$payment->trans_id}}</td>
                                    {{-- <td>{{get_user_full_name_by_id($payment->staff_id)}}</td> --}}
                                    <td>{{get_currency_symbol($invoice->currency)}} {{$payment->amount}}</td>
                                    @if(\Auth::user()->isAdmin() || \Auth::user()->can('edit-invoice'))
                                    <td>
                                        <a title="Delete" href="{{ route('admin.remove.uni-record-payment', $payment->id)}}" class="btn btn-sm btn-outline-danger" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure want to Delete this Record?"><i class='fas fa-trash-alt text-outline-danger' style='font-size:17px'></i> Delete</a>
                                    </td>
                                    @endif
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="6" class="text-center">No Record Found!</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection
@push('after-styles')
<style>
    @media print {
        #no_print {
            display: none !important;
        }
    }
</style>
@endpush
@push('after-scripts')
<script>
     addDeleteForms();
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
    }
</script>
@endpush