@extends('backend.layouts.app')
@section('title', "Invoices")

@section('content')
<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col-10 col-sm-10">
                <h4>University Invoices</h4>
            </div>
            <div class="col-sm-2 col-2" style="text-align: right;">
                <div class="btn-group" role="group" aria-label="Button group" style="float: right;">
                    <div class="dropdown">
                        <a class="btn btn-primary btn-sm dropdown-toggle" href="#" role="button" id="breadcrumb-dropdown-1" data-bs-toggle="dropdown" aria-expanded="false">Create</a>
                        <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" aria-labelledby="breadcrumb-dropdown-1" style="">
                            <a href="{{route('admin.invoice.generate-enrolled-student-invoice')}}" class="dropdown-item"> Enrolled Student Invoice</a>
                            <a href="{{route('admin.invoice.generate-ad-hoc')}}" class="dropdown-item"> Ad-hoc Invoice</a>
                            <a href="{{route('admin.invoice.generate-uni-apply-agent-invoice')}}" class="dropdown-item"> Uni Apply Agent Invoice</a>
                        </div>
                    </div>
                </div>
            </div>
              
        </div>
       

        {{ html()->modelForm($logged_in_user, 'GET', route('admin.invoice.university-invoices'))->class('form-horizontal')->open() }}
        <div class="row mt-4">
            <div class="col-md-3 col-sm-3">
                @isset($filters['search'])
                <input class="form-control" type="text" name="search" placeholder="Search by Invoice No, University" value="{{ $filters['search'] }}" />
                @else
                <input class="form-control" type="text" name="search" placeholder="Search by Invoice No, University" />
                @endisset
            </div>
            <div class="col-md-2 col-sm-2">
                <select class="form-select" name="status" style="display: inline; width: 150px;">
                    <option value="">All</option>
                    <option value="due" @if($filters['status']=='due' )selected @endif>Due </option>
                    <option value="paid" @if($filters['status']=='paid' )selected @endif>Paid </option>
                </select>
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="submit" name="submit" class="form-control btn btn-primary" value="Filter" />
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="button" name="cancel" class="form-control btn btn-outline-primary" value="Clear" onclick="document.location ='{{ route('admin.invoice.university-invoices') }}'" />
            </div>
        </div>
        {{ html()->closeModelForm() }}
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive mt-4">
                    <table class="table eductrl-datatable" id="invoice_tbl">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Invoice #</th>
                                <th>University / Uni Apply Agent</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($pages))
                                @foreach($pages as $page)
                                <tr>
                                    <td>{{get_date_time_formated($page->created_at)}}</td>
                                    <td>{{$page->invoice_num}}</td>
                                    <td><a target='_blank'><strong><span style='white-space:nowrap;'>{!! ($page->uni_apply_agent_id) ? get_uni_apply_agent_name_by_id($page->uni_apply_agent_id)."<br><small>(Uni Apply Agent)</small>" : get_university_name($page->university_id)!!}<br> </a></td>
                                    {{-- <td>{{get_currency_symbol($page->currency)}} {{(get_total_uni_invoice_payment($page->id)) ? $page->total - get_total_uni_invoice_payment($page->id) : $page->total}}</td> --}}
                                    <td>{{get_currency_symbol($page->currency)}} {{$page->total}}</td>
                                    <td>
                                        <p class="text-{{($page->status == 'due')? 'danger' : 'success'}}"><strong>{{ucfirst($page->status)}}</strong></p>
                                    </td>
                                    <td>
                                        <div class="" aria-label="User Actions">
                                            @if($page->uni_apply_agent_id)
                                                <a href="{{ route('admin.invoice.view-uni-apply-agent-invoice',$page->id)}}" data-placement="top" title="View" class="btn btn-outline-primary"><i class="fas fa-eye"></i></a>

                                                <a href="{{route('admin.invoice.add-uni-apply-agent-payment', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Record Payment" class="btn btn-{{($page->total - get_total_uni_invoice_payment($page->id) <= 0) ? 'outline-secondary disabled' : 'outline-info'}}"><i class="fa fa-book" aria-hidden="true"></i></a>

                                                <a target="_blank" href="{{route('admin.downloads.uni-apply-agent-invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Download" class="btn btn-outline-warning"><i class="fa fa-download" aria-hidden="true"></i></a>
                                                @if(\Auth::user()->isAdmin())
                                                <a href="{{route('admin.invoice.uni-apply-agent-invoice.delete', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Delete" data-method="delete" class="btn btn-outline-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                                @endif
                                            @elseif($page->ad_hoc)
                                                <a href="{{ route('admin.invoice.view-ad-hoc-invoice',$page->id)}}" data-placement="top" title="View" class="btn btn-outline-primary"><i class="fas fa-eye"></i></a>
                                                
                                                <a href="{{route('admin.invoice.add-ad-hoc-payment', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Record Payment" class="btn btn-{{($page->total - get_total_uni_invoice_payment($page->id) <= 0) ? 'outline-secondary disabled' : 'outline-info'}}"><i class="fa fa-book" aria-hidden="true"></i></a>

                                                <a target="_blank" href="{{route('admin.downloads.ad-hoc-invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Download" class="btn btn-outline-warning"><i class="fa fa-download" aria-hidden="true"></i></a>

                                                @if(\Auth::user()->isAdmin())
                                                <a href="{{route('admin.invoice.ad-hoc-invoice.delete', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Delete" data-method="delete" class="btn btn-outline-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                                @endif
                                            @else
                                                <a href="{{ route('admin.invoice.view-uni-invoice',$page->id)}}" data-placement="top" title="View" class="btn btn-outline-primary"><i class="fas fa-eye"></i></a>

                                                <a href="{{route('admin.invoice.add-uni-payment', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Record Payment" class="btn btn-{{($page->total - get_total_uni_invoice_payment($page->id) <= 0) ? 'outline-secondary disabled' : 'outline-info'}}"><i class="fa fa-book" aria-hidden="true"></i></a>

                                                <a target="_blank" href="{{route('admin.downloads.uni-invoice', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Download" class="btn btn-outline-warning"><i class="fa fa-download" aria-hidden="true"></i></a>
                                                @if(\Auth::user()->isAdmin())
                                                <a href="{{route('admin.invoice.uni-invoice.delete', $page->id)}}" data-toggle="tooltip" data-placement="top" title="Delete" data-method="delete" class="btn btn-outline-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                                @endif
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td class="text-center" colspan="6">No Record Found</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
