<!DOCTYPE html>
<html>
    <head>
        <title>{{ $stuData->first_name }} Invoice #{{$invoice->invoice_num}}</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">
        <style type="text/css">
       
            @font-face {
                font-family: 'Open Sans';
                src: url({{ storage_path('fonts/Open_Sans/static/OpenSans-Regular.ttf') }}) format("truetype");
                font-weight: 400; // use the matching font-weight here ( 100, 200, 300, 400, etc).
                font-style: normal; // use the matching font-style here
            }
            @font-face {
                font-family: 'Open Sans';
                src: url({{ storage_path('fonts/Open_Sans/static/OpenSans-Bold.ttf') }}) format("truetype");
                font-weight: 600; // use the matching font-weight here ( 100, 200, 300, 400, etc).
                font-style: normal; // use the matching font-style here
            }
            
            body {
                font-family: 'Open Sans', sans-serif;
                color: #121212;
                font-weight: 400;
                font-size: 13px;
                /* border: 1px solid red; */
            }
            th {
                font-size: 14px !important;
                font-weight: 600 !important;
            }
            table tr td {
                padding: 10px 5px;
            }
            .invoice_info{
                padding: 3px 5px;
            }
            table tr th {
                padding: 10px 5px;
                font-weight: 1000;
                font-family: 'Open Sans', sans-serif;
            }
            b{
                color: rgb(49, 49, 49);
            }
            *{
                color: #464646;
            }
            .quantity{
                text-align: center;
                vertical-align: middle;
            }
        </style>        
    </head>
<body >
<div class="printableArea">
    <div class="">
        <table style="width: 100%;">
            <tr style="">
                <td style="padding-top: 0px; padding-bottom: 0px;">
                    {{-- <img src="{{ asset('storage/'.get_site_config('website_logo')) }}" style="height:{{get_site_config('website_logo_ht')}}px"> --}}
                    <?php
                        if(get_business_details($invoice->business_id)->logo){
                            $logo = get_business_details($invoice->business_id)->logo;
                        }
                        else{
                            $logo = asset('storage/'.get_site_config('website_logo')); 
                        }
                    ?>
                    <img src="{{ asset('storage/'.$logo) }}" style="height:80px">
                </td>
                <td style="padding-top: 0px; padding-bottom: 0px;">
                    <address style="font-style: normal; padding: 0px 40px;">
                        {{-- <p style="">
                            <b>{{get_site_config('invoice_business_name')}}</b><br>
                            {!!get_site_config('invoice_business_address')!!} <br/>
                            Ph: {!!get_site_config('invoice_business_phone')!!} <br/>
                            Email: {!!get_site_config('invoice_business_email')!!}<br>
                        </p> --}}
                        <p style="">
                            <b>{{get_business_details($invoice->business_id)->name}}</b><br>
                            {!!get_business_details($invoice->business_id)->address!!} <br/>
                            Ph: {!!get_business_details($invoice->business_id)->phone!!} <br/>
                            Email: {!!get_business_details($invoice->business_id)->email!!}<br>
                       </p>
                    </address>
                </td>
                <td>
                    <h3 style="float:right; font-size: 20px;">INVOICE</h3>
                </td>
            </tr>
        </table>
    </div>
    <div class="" style="padding: 5px 20px; border-radius: 5px; background-color:#f4f4f4;">
        <div style="font-weight: 600; color:#616161 !important; padding-left: 5px;">Bill To</div>
        <table style="width: 100%;" cellspacing="0">
            <tr>
                <td class="invoice_info">
                    <b>{{get_user_full_name_by_id($invoice->client_id)}}</b> <br/>
                    @if($stuData->address_1 && $stuData->address_2)
                        Address: {{ $stuData->address_1 }}
                        <br />
                        {{ $stuData->address_2 }}
                    @elseif($stuData->address_1)
                        {{ $stuData->address_1 }} <br/>
                    @else
                    Address: N/A<br/>
                    @endif
                    @if($stuData->city)
                        {{get_state_name($stuData->city)}}<br>
                    @endif
                    @if($stuData->state)
                        {{get_state_name($stuData->state)}}<br>
                    @endif
                    @if($stuData->country)
                        {{get_country_name($stuData->country)}}<br>
                    @endif
                    Mob: {{$stuData->mobile}} <br/>
                    Email: {{$stuData->email}}
                </td>
                <td class="invoice_info" style="vertical-align: top;">
                    <table style="width: 60%; margin-left: auto;" cellspacing="0">
                        <tr>
                            <td class="invoice_info">Invoice No: </td>
                            <td class="invoice_info"><b style="font-size: 18px;">{{$invoice->invoice_num}}</b></td>
                        </tr>
                        <tr>
                            <td class="invoice_info">Invoice Date: </td>
                            <td class="invoice_info"><b>{{date('d/m/Y', strtotime($invoice->created_at))}}</b></td>
                        </tr>
                        <tr>
                            <td class="invoice_info">Due Date: </td>
                            <td class="invoice_info"><b>{{date('d/m/Y', strtotime($invoice->due_date))}}</b></td>
                        </tr>
                        <tr>
                            <td class="invoice_info">Balance Due: </td>
                            <td class="invoice_info"><b @if($invoice->grand_total - $total_payment) style="color: red;font-family: 'Roboto', sans-serif;" @endif>{{get_currency_symbol($invoice->currency)}}{{
                            ($total_payment) ? $invoice->grand_total - $total_payment : $invoice->grand_total
                            }}</b></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>   
    
    <div class="" style="border:1px solid #dadada; margin-top: 20px; border-radius: 5px;">
        <table style="width: 100%;" cellspacing="0">
            <thead style="padding: 5px 20px; font-family: Open Sans;">
                <tr>
                    <th style="margin: 0px;color: rgb(0,122,255); font-family: Open Sans; font-weight: 600 !important;">S. No.</th>
                    <th style="text-align: left;margin: 0px; color: rgb(0,122,255); font-family: Open Sans !important; font-weight: 600 !important;">Item & Description</th>
                    {{-- <th class="quantity" style="color: rgb(0,122,255); font-family: Open Sans !important; font-weight: 600 !important;">Quantity</th> --}}
                    <th style="text-align: right;margin: 0px; color: rgb(0,122,255); padding-right: 15px; font-family: Open Sans !important; font-weight: 600 !important;">Amount</th>
                </tr>
            </thead>
            <tbody>
                @php $i = 1; @endphp               
                @foreach($invoice_items as $items)
                    <tr>
                        <td style="text-align: center;margin: 0px; font-family: Open Sans;">{{$i}}</td>
                        <td style="text-align: left;margin: 0px; font-family: Open Sans !important;">
                            {{$items->item}}
                        </td>
                        {{-- <td style="text-align:center;font-family: Open Sans !important;">{{$items->item_qty}}</td> --}}
                        <td style="text-align: right;margin: 0px; padding-right: 15px; font-family: 'Roboto', sans-serif;">{{get_currency_symbol($items->currency)}} {{$items->item_amount}}</td>
                    </tr>
                    @php $i += 1; @endphp
                @endforeach
            </tbody>
        </table>
    </div>
    
    <div style="width: 100%;" >
        <table style="width: 100%;" cellspacing="0">
            <tr style="">
                <td class="invoice_info" style="width: 60%; padding-right: 20px; vertical-align: top;">
                    <p style="">Total in Words <b>: {{$invoice->currency}} {{($invoice->grand_total) ? get_amount_in_words($invoice->grand_total) : get_amount_in_words(0)}}</b></p>               
                    @if(get_business_details($invoice->business_id)->bank_details)
                        <b class="mb-0">Bank Details</b>
                        <p style="font-size: 12px;margin-top:0px;" class="mt-0">{!! nl2br(e(get_business_details($invoice->business_id)->bank_details)) !!}</p>
                    @endif
                </td>
                <td class="" style="width: 35%; vertical-align: top; padding-top: 20px;">
                    @if($invoice->discount != 0)
                    <div style="">
                        <p style="width: 25%; display: inline-block;"><b>Discount</b></p>              
                        <p style="width: 70%; text-align: right; display: inline-block;font-family: 'Roboto', sans-serif;"><b>{{get_currency_symbol($invoice->currency)}}{{$invoice->discount}}</b></p>              
                    </div> 
                    @endif
                    @if($invoice->tax_type == 'exclusive')
                        @if($invoice->tax1_value!=0)
                        <div style="">
                            <p style="width: 45%; display: inline-block;"><b>{{$invoice->tax1_name}}({{$invoice->tax1_rate}}%)</b></p>              
                            <p style="width: 50%; text-align: right; display: inline-block;font-family: 'Roboto', sans-serif;"><b>{{get_currency_symbol($invoice->currency)}}{{$invoice->tax1_value}}</b></p>              
                        </div>
                        @endif
                        @if($invoice->tax2_value!=0)
                        <div style="">
                            <p style="width: 45%; display: inline-block;"><b>{{$invoice->tax2_name}}({{$invoice->tax2_rate}}%)</b></p>              
                            <p style="width: 50%; text-align: right; display: inline-block;font-family: 'Roboto', sans-serif;"><b>{{get_currency_symbol($invoice->currency)}}{{$invoice->tax2_value}}</b></p>              
                        </div>
                        @endif 
                        <div style="">
                            <p style="width: 45%; display: inline-block;margin-bottom:0px!important;"><b>Sub Total</b></p>              
                            <p style="width: 50%; text-align: right; display: inline-block;font-family: 'Roboto', sans-serif;margin-bottom:0px!important;"><b>{{get_currency_symbol($invoice->currency)}}{{$invoice->grand_total}}</b></p>              
                        </div>
                    @endif
                    {{-- @if($orderData && $orderData->tax_type == 'inclusive')
                    <div style="">
                        <p style="width: 45%; display: inline-block;margin-bottom:0px!important;"><b>Sub Total</b></p>              
                        <p style="width: 50%; text-align: right; display: inline-block;font-family: 'Roboto', sans-serif;margin-bottom:0px!important;"><b>{{currency_symbol($invoice->currency)}}{{$invoice->grand_total}}</b></p>              
                    </div>
                        <?php $net_amt = $invoice->grand_total - $orderData->discount - $orderData->total_tax; ?>
                        <p class="m-0 mb-2" style='font-size: 12px !important;margin-top:0px!important;'>(<b style='font-size: 12px !important;'>Net Amount:</b> {{currency_symbol($orderData->currency).$net_amt}} + {{currency_symbol($orderData->currency).$orderData->tax_one_amt.' '.$orderData->tax_one_name.' @'.$orderData->tax_one_rate.'%'}} @if($orderData->tax_two_name)+ {{currency_symbol($orderData->currency).$orderData->tax_two_amt.' '.$orderData->tax_two_name.' @'.$orderData->tax_two_rate.'%'}}@endif)</p>
                    @endif --}}
                    <div style="height: 40px; padding-left: 5px; background-color: rgb(0,122,255); border-radius: 5px; border: 1px solid rgb(0,122,255); font-weight: bold;margin-top:10px!important;">
                        <p style="width: 45%; display: inline-block; margin-top: 20px;"><b style="color: white !important; font-size: 18px;">Grand Total</b></p>              
                        <p style="width: 50%; display: inline-block; text-align: right; margin-top: 20px;"><b style="color: white !important; font-size: 18px;font-family: 'Roboto', sans-serif;">{{get_currency_symbol($invoice->currency)}}{{$invoice->grand_total}}</b></p>              
                    </div>  
                </td>
            </tr>
        </table>
    </div>

    <p style="font-style: normal; padding: 5px 10px; margin-top: 10px;"><b>Transaction History</b></p>
    <div class="" style="">
        <table style="width: 100%; border:1px solid #dadada; border-radius: 5px;" >
            <thead style="font-style: normal; background-color: white; padding: 5px 20px;">
                <tr>
                    <th style="text-align: left; color: rgb(0,122,255); padding-top: 3px; padding-bottom: 7px; font-size: 13px;">Date</th>
                    <th style="text-align: left; color: rgb(0,122,255); padding-top: 3px; padding-bottom: 7px; font-size: 13px;">Mode</th>
                    <th style="text-align: left; color: rgb(0,122,255); padding-top: 3px; padding-bottom: 7px; font-size: 13px;">Transaction ID/ Notes</th>
                    <th style="text-align: left; color: rgb(0,122,255); padding-top: 3px; padding-bottom: 7px; font-size: 13px;">Amount</th>
                </tr>
            </thead>
            <tbody>
                @if(count($payments))
                    @foreach($payments as $payment)
                    <tr @if(!$loop->even) style="background-color: #f4f4f4;border-top: 1px solid #f4f4f4;" @endif>
                        <td style="padding: 5px;">{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                        <td style="padding: 5px;">{{strtoupper(str_replace("_", " ", $payment->pay_mode))}}</td>
                        <td style="padding: 5px;">{{$payment->trans_id}}</td>
                        <td style="padding: 5px;font-family: 'Roboto', sans-serif;">{{get_currency_symbol($invoice->currency)}}{{$payment->amount}}</td>
                    </tr>
                    @endforeach
                @else
                <tr style="padding: 5px; background-color: #f4f4f4;border-top: 1px solid #f4f4f4;">
                    <td colspan="4" style="text-align: center; font-size: 13px;">No Transaction Found</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
    @if($invoice->terms_conditions)
    <p style="text-align:center; margin-top: 20px;"><b>Terms & Conditions:</b></p>
    <p style="margin-bottom: 20px; text-align:center; font-size: 12px;">
        {{$invoice->terms_conditions}}
    </p>
    @endif
</div>
</body>
</html>