<!DOCTYPE html>
@langrtl
    <html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
@else
    <html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endlangrtl

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    @if (get_site_config('favicon'))
        <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('storage/' . get_site_config('favicon')) }}">
    @endif
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', app_name())</title>
    <meta name="description" content="@yield('meta_description', '')">
    @yield('meta')

    @stack('before-styles')

    <link href="https://fonts.gstatic.com" rel="preconnect">
    <link
        href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i"
        rel="stylesheet">

    <link href="{{ asset('assets/backend/vendorfiles/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/remixicon/remixicon.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/boxicons/css/boxicons.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/quill/quill.snow.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/quill/quill.bubble.css') }}" rel="stylesheet">


    <link href="{{ asset('assets/backend/css/style.css') }}?v=6" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/select2/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('assets/backend/vendorfiles/dist/css/dropify.css') }}">

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.0/css/all.css">
    {{-- <link href="{{asset('assets/DataTables/DataTables-1.12.1/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" type="text/css"> --}}
    <link href="{{ asset('assets/DataTables/DataTables-1.12.1/css/dataTables.bootstrap5.css') }}" rel="stylesheet"
        type="text/css">
    <link href="{{ asset('assets/DataTables/Buttons-2.2.3/css/buttons.bootstrap5.min.css') }}" rel="stylesheet"
        type="text/css">
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/3.4.0/css/bootstrap-colorpicker.css"
        integrity="sha512-HcfKB3Y0Dvf+k1XOwAD6d0LXRFpCnwsapllBQIvvLtO2KMTa0nI5MtuTv3DuawpsiA0ztTeu690DnMux/SuXJQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    {{-- Font Changing --}}
    <link href="https://fonts.gstatic.com/" rel="preconnect">
    <link href="{{ asset('assets/backend/fonts/fonts.css') }}" rel="stylesheet">


    @stack('after-styles')
    <style>
        .swal2-title {
            font-size: 1.3em !important;
            margin: 20px 0 15px 0;
        }

        .swal2-confirm {
            background-color: #0D6EFC !important;
        }

        .swal2-confirm:hover {
            background-color: #1160d7 !important;
        }
    </style>
</head>

<body class="{{ config('backend.body_classes') }}">
    @include('includes.partials.backend-logged-in-as')
    @include('backend.includes.header')

    <div class="app-body" >
        @include('backend.includes.sidebar')

        <main id="main" class="main" style="@if(auth()->user() && session()->has("admin_user_id") && session()->has("temp_user_id")) margin-top: 93px !important; @endif">
            <div class="row" style="margin:0px;">
                <div class="col-md-6">
                    <ol class="breadcrumb">
                        <x-tabuna-breadcrumbs class="breadcrumb-item" />
                    </ol>
                </div>
                <div class="col-md-6">
                    @yield('toprightmenu')
                </div>
            </div>

            {{-- @include('includes.partials.logged-in-as') --}}

            <div class="container-fluid">
                <div class="">
                    <div class="content-header">
                        @yield('page-header')
                    </div>
                    <!--content-header-->

                    @include('includes.partials.messages')
                    @yield('content')
                </div>
                <!--animated-->
            </div>
            <!--container-fluid-->
        </main>
        <!--main-->


    </div>
    <!--app-body-->

    @include('backend.includes.footer')

    <!-- Scripts -->
    @stack('before-scripts')

    <script src="https://use.fontawesome.com/releases/v5.15.0/js/all.js"></script>
    <!-- Vendor JS Files -->
    <script src="{{ asset('assets/backend/vendorfiles/bootstrap/js/bootstrap.bundle.js') }}"></script>
    <script src="{{ asset('assets/backend/vendorfiles/quill/quill.min.js') }}"></script>
    <script src="{{ asset('assets/backend/vendorfiles/tinymce/tinymce.min.js') }}"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <!--  Main JS File -->
    <script src="{{ asset('assets/backend/js/main.js') }}"></script>

    <!-- Select2 JS files -->
    <script src="{{ asset('assets/backend/vendorfiles/select2/select2.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/ckeditor5/build/ckeditor.js?v=1.13') }}"></script>

    <!-- Dropify JS file -->
    <script src="{{ asset('assets/backend/vendorfiles/dist/js/dropify.js?v=1.1') }}"></script>

    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.css"
        integrity="sha512-bYPO5jmStZ9WI2602V2zaivdAnbAhtfzmxnEGh9RwtlI00I9s8ulGe4oBa5XxiC6tCITJH/QG70jswBhbLkxPw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.full.min.js"
        integrity="sha512-AIOTidJAcHBH2G/oZv9viEGXRqDNmfdPVPYOYKGy3fti0xIplnlgMHUGfuNRzC6FkzIo0iIxgFnr9RikFxK+sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/3.4.0/js/bootstrap-colorpicker.min.js"
        integrity="sha512-94dgCw8xWrVcgkmOc2fwKjO4dqy/X3q7IjFru6MHJKeaAzCvhkVtOS6S+co+RbcZvvPBngLzuVMApmxkuWZGwQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        $(document).ready(function() {
            $(".validate_inpt").on('keyup input blur', function() {
                var elementx = this.value;
                this.value = this.value.replace(/[^a-zA-Z0-9 @+-?:.,#&/\|$*£€GH₵₹]+/, '');
            });

            $(".colorPicker").colorpicker();
            $(".select2").select2();
            
            $('.mydatepicker, #datepicker').datetimepicker({
                timepicker: false,
                format: 'd-m-Y',
                scrollInput: false,
            });
            $('#datepicker-autoclose').datetimepicker({
                timepicker: false,
                format: 'd-M-Y',
            });
            $('#counselling_datetime').datetimepicker({
                format: 'd-m-Y g:i a',
                formatTime: 'g:i a',
                minTime: '09:00',
                maxTime: '19:00',
                validateOnBlur: false,
            });

            $('.mydatetimepicker, #datetimepicker').datetimepicker({
                timepicker: true,
                format: 'd-M-Y H:i',
            });
            $('#datetimepicker-autoclose').datetimepicker({
                timepicker: true,
                format: 'd-M-Y H:i',
            });

            $(".ckeditor_toolbar1").each(function(index) {
                editor_id = $(this).attr("id");
                ClassicEditor
                    .create(document.querySelector('#' + editor_id), {
                        licenseKey: '',
                        removePlugins: ['Title'],
                        toolbar: ['heading', '|', 'bold', 'italic', 'link', 'bulletedList',
                            'numberedList', 'Undo', 'Redo'
                        ],
                    })
                    .then(editor => {
                        window.editor = editor;
                    })
                    .catch(error => {
                        console.error('Oops, something went wrong!');
                        console.error(error);
                    });
            });
            $(".ckeditor_comprehension").each(function(index) {
                editor_id = $(this).attr("id");
                ClassicEditor
                    .create(document.querySelector('#' + editor_id), {
                        licenseKey: '',
                        removePlugins: ['Title'],
                        toolbar: ['heading', '|', 'bold', 'italic', 'link', 'bulletedList',
                            'numberedList', 'Undo', 'Redo'
                        ],
                    })
                    .then(editor => {
                        window.editor = editor;
                    })
                    .catch(error => {
                        console.error('Oops, something went wrong!');
                        console.error(error);
                    });
            });

            $(".ckeditor_toolbar2").each(function(index) {
                editor_id = $(this).attr("id");
                ClassicEditor
                    .create(document.querySelector('#' + editor_id), {
                        licenseKey: '',
                        removePlugins: ['Title'],
                        toolbar: {
                            items: [
                                'heading', '|',
                                'alignment', 'bold', 'italic', 'link', 'underline', 'undo', 'redo',
                                '|',
                                'bulletedList', 'numberedList', 'insertTable', '|',
                                'fontfamily', 'fontsize', 'fontColor', 'fontBackgroundColor',
                                'blockQuote', 'highLight', '|',
                                'outdent', 'indent', '|',
                                'subscript', 'superscript', 'code', 'codeBlock', 'strikethrough',
                                'sourceEditing', '|',
                            ],
                            shouldNotGroupWhenFull: true
                        },
                    })
                    .then(editor => {
                        window.editor = editor;
                    })
                    .catch(error => {
                        console.error('Oops, something went wrong!');
                        console.error(error);
                    });
            });

            $(".ckeditor_toolbar_all").each(function(index) {
                editor_id = $(this).attr("id");
                ClassicEditor
                    .create(document.querySelector('#' + editor_id), {
                        licenseKey: '',
                        //extraPlugins: [ MyCustomUploadAdapterPlugin ],
                        simpleUpload: {
                            uploadUrl: "{{ route('admin.articles.storeimage') }}",
                            withCredentials: true,
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        },
                        toolbar: {
                            items: [
                                'heading', 'findAndReplace', '|',
                                'alignment', 'bold', 'italic', 'link', 'underline', 'undo', 'redo',
                                '|',
                                'bulletedList', 'numberedList', 'uploadImage', 'insertTable',
                                'mediaEmbed', 'pageBreak', 'horizontalLine', '|',
                                'fontfamily', 'fontsize', 'fontColor', 'fontBackgroundColor',
                                'blockQuote', 'highLight', '|',
                                'outdent', 'indent', '|',
                                'subscript', 'superscript', 'code', 'codeBlock', 'strikethrough',
                                'sourceEditing', '|',
                            ],
                            shouldNotGroupWhenFull: true
                        },


                        image: {
                            // You need to configure the image toolbar, too, so it uses the new style buttons.
                            toolbar: ['imageTextAlternative', '|', 'imageStyle:alignLeft',
                                'imageStyle:alignCenter', 'imageStyle:alignRight'
                            ],

                            styles: [
                                // This option is equal to a situation where no style is applied.
                                'full',

                                // This represents an image aligned to the left.
                                'alignLeft',

                                // This represents an image aligned to the right.
                                'alignRight'
                            ]
                        }

                    })
                    .then(editor => {
                        window.editor = editor;
                    })
                    .catch(error => {
                        console.error('Oops, something went wrong!');
                        console.error(error);
                    });
            });


            // Basic
            $('.dropify').dropify();

            // Translated
            $('.dropify-fr').dropify({
                messages: {
                    default: 'Glissez-déposez un fichier ici ou cliquez',
                    replace: 'Glissez-déposez un fichier ou cliquez pour remplacer',
                    remove: 'Supprimer',
                    error: 'Désolé, le fichier trop volumineux'
                }
            });

            // Used events
            var drEvent = $('#input-file-events').dropify();

            drEvent.on('dropify.beforeClear', function(event, element) {
                return confirm("Do you really want to delete \"" + element.file.name + "\" ?");
            });

            drEvent.on('dropify.afterClear', function(event, element) {
                alert('File deleted');
            });

            drEvent.on('dropify.errors', function(event, element) {
                console.log('Has Errors');
            });

            var drDestroy = $('#input-file-to-destroy').dropify();
            drDestroy = drDestroy.data('dropify')
            $('#toggleDropify').on('click', function(e) {
                e.preventDefault();
                if (drDestroy.isDropified()) {
                    drDestroy.destroy();
                } else {
                    drDestroy.init();
                }
            })
        });
    </script>


    <script type="text/javascript" src="{{ asset('assets/DataTables/DataTables-1.12.1/js/jquery.dataTables.min.js') }}">
    </script>
    <script type="text/javascript"
        src="{{ asset('assets/DataTables/DataTables-1.12.1/js/dataTables.bootstrap5.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/dataTables.buttons.min.js') }}">
    </script>
    <script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/buttons.bootstrap5.min.js') }}">
    </script>
    <script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/buttons.html5.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/buttons.print.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/DataTables/pdfmake-0.1.36/pdfmake.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/DataTables/pdfmake-0.1.36/vfs_fonts.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/DataTables/JSZip-2.5.0/jszip.min.js') }}"></script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function addDeleteForms() {
            $('a[data-method]').append(function() {
                    if (!$(this).find('form').length > 0) {
                        return "\n<form action='" + $(this).attr('href') +
                            "' method='POST' name='delete_item' style='display:none'>\n" +
                            "<input type='hidden' name='_method' value='" + $(this).attr('data-method') + "'>\n" +
                            "<input type='hidden' name='_token' value='" + $('meta[name="csrf-token"]').attr(
                            'content') + "'>\n" +
                            '</form>\n';
                    } else {
                        return ''
                    }
                })
                .attr('href', '#')
                .attr('style', 'cursor:pointer;')
                .attr('onclick', '$(this).find("form").submit();');
        }

        $(document).ready(function() {

            /**
             * Generic confirm form delete using Sweet Alert
             */
            $('body').on('submit', 'form[name=delete_item]', function(e) {
                e.preventDefault();

                const form = this;
                const link = $('a[data-method="delete"]');
                const cancel = (link.attr('data-trans-button-cancel')) ? link.attr(
                    'data-trans-button-cancel') : 'Cancel';
                const confirm = (link.attr('data-trans-button-confirm')) ? link.attr(
                    'data-trans-button-confirm') : 'Yes, delete';
                const title = (link.attr('data-trans-title')) ? link.attr('data-trans-title') :
                    'Are you sure you want to delete this item?';
                const message = (link.attr('data-message')) ? link.attr('data-message') : '';

                Swal.fire({
                    title: title,
                    text: message,
                    showCancelButton: true,
                    confirmButtonText: confirm,
                    cancelButtonText: cancel,
                    type: 'warning'
                }).then((result) => {
                    result.value && form.submit();
                });
            }).on('click', 'a[name=confirm_item]', function(e) {
                /**
                 * Generic 'are you sure' confirm box
                 */
                e.preventDefault();

                const link = $(this);
                const title = (link.attr('data-trans-title')) ? link.attr('data-trans-title') :
                    'Are you sure you want to do this?';
                const cancel = (link.attr('data-trans-button-cancel')) ? link.attr(
                    'data-trans-button-cancel') : 'Cancel';
                const confirm = (link.attr('data-trans-button-confirm')) ? link.attr(
                    'data-trans-button-confirm') : 'Continue';

                Swal.fire({
                    title: title,
                    showCancelButton: true,
                    confirmButtonText: confirm,
                    cancelButtonText: cancel,
                    type: 'info'
                }).then((result) => {
                    result.value && window.location.assign(link.attr('href'));
                });
            });
            $(".notification-close").click(function() {
                $(".notification-card").hide();
            });
            $(".notificaton-icon").click(function() {
                $(".notification-card").show();
            });
            $('.app-body').click(function() {
                $(".notification-card").hide();
            });
            var table = $('.eductrl-datatable').DataTable({
                "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
                "ordering": false,
                "lengthMenu": [25, 50, 100],
                "drawCallback": function(settings) {
                    addDeleteForms();
                },
                "buttons": [{
                        extend: 'excel',
                        text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                    },
                    {
                        extend: 'pdf',
                        text: '<i class="bi bi-file-earmark-pdf"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                    },
                    {
                        extend: 'print',
                        text: '<i class="bi bi-printer"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                    },
                    {
                        extend: 'copy',
                        text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                    },
                    {
                        extend: 'csv',
                        text: '<i class="ri-file-excel-line export-btn-size"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                    },
                ]
            });

        });

        var el_up = document.getElementById('GFG_UP');

        if ($('.eductrl-datatable').attr("data-datatable-nopaging") == 1) {
            $('.eductrl-datatable').dataTable({
                "paging": false
            });
        }

        function GetURLParameter(sParam) {
            var sPageURL = window.location.search.substring(1);
            var sURLVariables = sPageURL.split('&');
            for (var i = 0; i < sURLVariables.length; i++) {
                var sParameterName = sURLVariables[i].split('=');
                if (sParameterName[0] == sParam) {
                    return sParameterName[1];
                }
            }
        }


        function notiCount() {
            $.ajax({
                url: "{{ route('admin.unread-noti-count') }}",
                type: 'GET',
                dataType: 'json',
                success: function(count) {
                    if (count != 0) {
                        $('.noti-count').show();
                    } else {
                        $('.noti-count').hide();
                    }
                },
            });
        }

        function noti_list() {
            $.ajax({
                url: "{{ route('admin.noti-list') }}",
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    if (data == "") {
                        $('.noti-list').html(
                            "<li class='text-center'><h4 class='text-center p-4'>No new notifications!</h4></li>"
                            );
                    } else {
                        $('.noti-list').html(data);
                    }
                },
            });
        }
        //noti_list();
        setInterval(function() {
            notiCount();
            noti_list();
        }, {{ config('app.notification_refresh_interval') * 1000 }});
        //noti_list();


        function noti_seen($obj) {
            $obj.removeClass("unseen");
            var noti_id = $obj.attr("data-id");
            $.ajax({
                url: "{{ route('admin.noti-seen') }}",
                type: "POST",
                data: {
                    noti_id: noti_id,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(data) {
                    console.log(data);
                },
            });
        }

        function all_noti_seen($obj) {
            $obj.parent().children("li").removeClass("unseen");
            //$obj.removeClass("unseen");
            var noti_id = $obj.attr("data-id");
            $.ajax({
                url: "{{ route('admin.noti-seen') }}",
                type: "POST",
                data: {
                    noti_id: noti_id,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(data) {
                    console.log(data);
                },
            });
        }
        
    </script>


    @stack('after-scripts')

    @yield('footer_scripts')
    @include('backend.includes.partials.ga')

</body>

</html>
