<!DOCTYPE html>
<!-- Root element of the HTML document -->
@langrtl
<!-- If the language is right-to-left -->
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
@else
<!-- Otherwise, use the default language direction -->
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endlangrtl

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    @if (get_site_config('favicon'))
        <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('storage/' . get_site_config('favicon')) }}">
    @endif
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', app_name())</title>
    <meta name="description" content="@yield('meta_description', '')">
    @yield('meta')

    @stack('before-styles')

    <link href="https://fonts.gstatic.com" rel="preconnect">
    <link
        href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i"
        rel="stylesheet">

    <link href="{{ asset('assets/backend/vendorfiles/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/remixicon/remixicon.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/boxicons/css/boxicons.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/quill/quill.snow.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/quill/quill.bubble.css') }}" rel="stylesheet">


    <link href="{{ asset('assets/backend/css/style.css') }}?v=6" rel="stylesheet">
    <link href="{{ asset('assets/backend/vendorfiles/select2/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('assets/backend/vendorfiles/dist/css/dropify.css') }}">

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.0/css/all.css">
    {{-- <link href="{{asset('assets/DataTables/DataTables-1.12.1/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" type="text/css"> --}}
    <link href="{{ asset('assets/DataTables/DataTables-1.12.1/css/dataTables.bootstrap5.css') }}" rel="stylesheet"
        type="text/css">
    <link href="{{ asset('assets/DataTables/Buttons-2.2.3/css/buttons.bootstrap5.min.css') }}" rel="stylesheet"
        type="text/css">
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/3.4.0/css/bootstrap-colorpicker.css"
        integrity="sha512-HcfKB3Y0Dvf+k1XOwAD6d0LXRFpCnwsapllBQIvvLtO2KMTa0nI5MtuTv3DuawpsiA0ztTeu690DnMux/SuXJQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    {{-- Font Changing --}}
    <link href="https://fonts.gstatic.com/" rel="preconnect">
    <link href="{{ asset('assets/backend/fonts/fonts.css') }}" rel="stylesheet">

    @stack('after-styles')
    <style>
        .swal2-title {
            font-size: 1.3em !important;
            margin: 20px 0 15px 0;
        }

        .swal2-confirm {
            background-color: #0D6EFC !important;
        }

        .swal2-confirm:hover {
            background-color: #1160d7 !important;
        }
    </style>
</head>

<body class="wrapper bg-soft-primary">    
    <header id="header" class="header fixed-top d-flex align-items-center" style="@if(auth()->user() && session()->has("admin_user_id") && session()->has("temp_user_id")) top: 33px !important; @endif">
        <div class="d-flex align-items-center justify-content-between">
            <img src="{{ asset('storage/'.get_site_config('backend_logo')) }}" style="height:{{get_site_config('backend_logo_ht')}}px" alt="Logo" class="dark-logo" />
        </div>
        <div class="search-bar">
            <nav class="header-nav ms-auto">
                <ul class="d-flex align-items-center">
                    <li class="nav-item dropdown">
                        <a class="nav-link nav-icon" href="{{ route('index') }}" target="_blank"><i class="ri-home-8-line" style="font-size:20px;"></i></a>
                    </li>
                </ul>
            </nav>
        </div>
    </header>

    <div class="app-body" >
        <main id="main" class="main" style="">
            <div class="container-fluid">
                <div class="">
                    <div class="content-header">
                        @yield('page-header')
                    </div>
                    <!--content-header-->

                    @include('includes.partials.messages')
                    @yield('public_content')
                </div>
                <!--animated-->
            </div>
            <!--container-fluid-->
        </main>
    </div>

    @include('backend.includes.footer')
</body>

</html>

