@extends('backend.layouts.app')
@section('title', "Leads - Assign Staff")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                Leads - Update Next Follow-up
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.leads.next-followup-date.update'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Leads</b></span></label>
            </div>
        </div>
            
        <div class="leaddata" style="max-height: 200px; overflow: auto; padding: 5px; overflow-x: hidden; border: 1px solid #ccc">
            <div class="form-group row mb-2" >
                <div class="col-sm-12 col-md-4">
                    @foreach ($leaddata_arr as $leaddata)
                        <input type="hidden" name="lead_id[]" value="{{$leaddata->id}}">
                        <label class="col-form-label"><b>{{ $leaddata->first_name }} {{$leaddata->last_name }}</b>  ({{ $leaddata->email }})</label> <br>
                    @endforeach
                </div>
            </div> 
        </div> 
        
        <div class="col-sm-12 col-md-4">
            <label class="col-form-label" id="next_followup_label">Next Follow-up</label>
            <div class="">
                <input type="text" placeholder="Next Follow-up" autocomplete="off" class="form-control followdatetimepicker" placeholder="Choose Date & Time" id="next_followup" name="next_followup">
                <div class="form-text">Note: Leave blank to clear the next follow-up date.</div>
            </div>
        </div> 

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Update") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'">Cancel</button>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('.followdatetimepicker').datetimepicker({
            timepicker: true,
            format: 'd-m-Y H:i',
            formatTime: 'g:i A',
            container: "followupsModal",
        });
    });
</script>
@endpush
