@extends('backend.layouts.app')
@section('title', "Leads - Change Status")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                Leads - Change Status
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.leads.changestatus.update'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Leads</b></span></label>
            </div>
        </div>
            
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                @foreach ($leaddata_arr as $leaddata)
                    <input type="hidden" name="lead_id[]" value="{{$leaddata->id}}">
                    <label class="col-form-label"><b>{{ $leaddata->first_name }} {{$leaddata->last_name }}</b>  ({{ $leaddata->email }})</label> <br>
                @endforeach
            </div>
        </div>
            
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>New Status</b></label>
                <div class="">
                    <select class="form-select" id='status' name="status">
                        <option value=''>Select</option>
                            @foreach(lead_status_list() as $status_data)
                                @if($status_data->status != get_counselling_lead_status())
                                    <option value="{{$status_data->id}}">{{$status_data->status}}</option>
                                @endif
                            @endforeach
                    </select>
                </div>
            </div>
        </div>  
        
        <div class="row d-none" id="disqualified_reason">
            <div class="col-sm-12 col-md-4">
                <label style="padding-bottom: 2px;" class="col-form-label required-field"><b>Disqualified Reason</b></label>
                <div class="">
                    <select class="form-select" id='lead_disqualified_reason' name="lead_disqualified_reason">
                        <option value=''>Select</option>
                        @foreach(get_lead_disqualified_reason() as $source_data)
                        <option value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Save") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'">Cancel</button>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@push ('after-scripts')
<script>
    $("#status").change(function() {
        if (this.value == "{{get_disqualified_lead_status_id()}}") {
            $('#disqualified_reason').removeClass('d-none');
            $('#lead_disqualified_reason').attr('required','required');
        }else{
            $('#disqualified_reason').addClass('d-none');
            $('#lead_disqualified_reason').removeAttr('required');
        }
    });
</script>
@endpush
