<style>
    .error {
        color: #FF0000;
    }
</style>
<div class="form-group row">
    <div class="row">
        {{-- {{ html()->form('POST', route('admin.leadmanagement.assigncounseller'))->class('form-horizontal')->open() }} --}}
        <form method="post" action="" id="counselling-form" class="form-horizontal">
            <input type="hidden" name="lead_id" id="lead_id" value="{{$lead->id}}">
            <div class="form-group row mb-2">
                <div class="col-md-12">
                    <p class="">{{ $lead->first_name }} {{$lead->last_name }}</p>
                    {{-- <label class="col-form-label"><b>Lead</b></span></label>
                    <div class="">
                        <p>Email: {{ $lead->email }}<br />
                        Ph: @if($lead->dialcode) +{{$lead->dialcode}}-@endif{{ $lead->mobile }}</p>
                    </div> --}}
                </div>
            </div>
            
            <div class="form-group row mb-2">
                <div class="col-sm-12">
                    <label class="col-form-label required-field"><b>Select Counsellor</b></label>
                    <div class="">
                        <select class="form-select" id='counsellor' name="counsellor" required>
                            <option value=''>Select</option>
                                @foreach($staff as $stf)
                                    <option value="{{$stf->id}}" {{($lead->counselling_date && $lead->assigned_to == $stf->id) ? 'selected' : ''}}>{{$stf->first_name . ' ' . $stf->last_name}}</option>
                                @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group row mb-2">
                <div class="col-sm-12 ">
                    <label class="col-form-label required-field"><b>Counselling Date & Time</b></label>
                    <div class="">
                        <input type="text" class="form-control followdatetimepicker" value="{{($lead->counselling_date)? date('d-m-Y g:i a',strtotime($lead->counselling_date)): ''}}" autocomplete="off" id="counselling_datetime" name="date_time" required>
                    </div>
                </div>
            </div>

            <div class="row" style="margin-top:10px;">
                <div class="col-sm-2 mx-auto">
                    <div class="form-group mb-0 clearfix">
                        <button class="btn btn-primary btn-sm" type="submit">Update</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    $('.followdatetimepicker').datetimepicker({
        timepicker: true,
        format: 'd-m-Y H:i',
        formatTime: 'g:i A',
        container: "followupsModal",
    });

    $('#counselling-form').on('submit', function(e) {
        e.preventDefault();
        let lead_id = $('#lead_id').val();
        let counsellor = $('#counsellor').val();
        let date_time = $('#counselling_datetime').val();
        console.log(lead_id);
        $.ajax({
            url: "{{route('admin.leadmanagement.assigncounseller')}}",
            type: "POST",
            data: {
                "_token": "{{ csrf_token() }}",
                lead_id: lead_id,
                counsellor: counsellor,
                date_time: date_time,
            },
            success: function(result) {
                if(result.success){
                    swal.fire({
                        title: result.message,
                        icon: "success",
                        button: "ok",
                    });
                    $('#counsellingModal').modal('hide');
                    var table = $('#lead_list').DataTable();
                    table.draw( false );
                } else{
                    swal.fire({
                        title: result.message,
                        icon: "error",
                        button: "ok",
                    });
                    $('#counsellingModal').modal('hide');
                }
            },
            error: function(response) {
                swal.fire({
                    title: "Something went wrong!",
                    icon: "danger"
                });
            },
        });
    });
</script>
