<style>
    .error {
        color: #FF0000;
    }
</style>
<div class="form-group row">
    <div class="row">
        <p class="">{{ $lead->first_name }} {{$lead->last_name }}</p>
        {{-- {{ html()->form('POST', route('admin.leadmanagement.update-to-disqualified'))->class('form-horizontal')->open() }} --}}
        <form method="post" action="" id="disqualified-form" class="form-horizontal">
            <input type="hidden" name="lead_id" id="lead_id" value="{{$lead->id}}">
            <div class="col-sm-12">
                <label style="padding-bottom: 2px;" class="col-form-label required-field"><b>Lead Status</b></label>
                <div>
                    <input type="text" class="form-control form-select" name="status" id="status" value="{{ get_disqualified_lead_status() }}" readonly>
                </div>
            </div>
            <div class="col-sm-12">
                <label style="padding-bottom: 2px;" class="col-form-label required-field"><b>Disqualified Reason</b></label>
                <div class="">
                    <select class="form-select" id='lead_disqualified_reason' name="lead_disqualified_reason" required>
                        <option value=''>Select</option>
                        @foreach(get_lead_disqualified_reason() as $source_data)
                        <option value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="row" style="margin-top:10px;">
                <div class="col-sm-2 mx-auto">
                    <div class="form-group mb-0 clearfix">
                        <button class="btn btn-primary btn-sm" type="submit">Update</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    $('.followdatetimepicker').datetimepicker({
        timepicker: true,
        format: 'd-m-Y H:i',
        formatTime: 'g:i A',
        container: "followupsModal",
    });

    $('#disqualified-form').on('submit', function(e) {
        e.preventDefault();
        let lead_id = $('#lead_id').val();
        let status = $('#status').val();
        let lead_disqualified_reason = $('#lead_disqualified_reason').val();

        $.ajax({
            url: "{{route('admin.leadmanagement.update-to-disqualified')}}",
            type: "POST",
            data: {
                "_token": "{{ csrf_token() }}",
                lead_id: lead_id,
                status: status,
                lead_disqualified_reason: lead_disqualified_reason,
            },
            success: function(result) {
                if(result.success){
                    swal.fire({
                        title: result.message,
                        icon: "success",
                        button: "ok",
                    });
                    $('#disqualifiedModal').modal('hide');
                    var table = $('#lead_list').DataTable();
                    table.draw( false );
                } else{
                    swal.fire({
                        title: result.message,
                        icon: "error",
                        button: "ok",
                    });
                    $('#disqualifiedModal').modal('hide');
                }
            },
            error: function(response) {
                swal.fire({
                    title: "Something went wrong!",
                    icon: "danger"
                });
            },
        });
    });
</script>
