@extends('backend.layouts.app')
@section('title', "Edit Lead")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Edit Lead
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->

        {{ html()->form('POST', route('admin.leadmanagement.update', $leaddata->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <div class="col-sm-12 col-md-9">
            <div class="form-group row">
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label required-field">First Name</span></label>
                    <div class="">
                        <input type="text" placeholder="First Name" class="form-control" name="first_name" value="@if(Request::old('first_name')){{ Request::old('first_name') }}@else{{ $leaddata->first_name }}@endif" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed" required>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Last Name</label>
                    <div class="">
                        <input type="text" placeholder="Last Name" class="form-control" name="last_name" value="@if(Request::old('last_name')){{ Request::old('last_name') }}@else{{ $leaddata->last_name }}@endif" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed">
                    </div>
                </div>
            </div>

            <div class="form-group row mt-2 mb-2">
                <div class="col-sm-12">
                    <input type="radio" class="radio-col-blue" id="radio_1" name="gender" value="male" @if(Request::old('gender') == "male") checked @elseif($leaddata->gender == "male") checked @endif required />
                    <label for="radio_1">Male</label>

                    <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_2" name="gender" value="female" @if(Request::old('gender') == "female") checked @elseif($leaddata->gender == "female") checked @endif required />
                    <label for="radio_2">Female</label>
                </div>
            </div>

            <div class="form-group row ">
                <div class="col-sm-12 col-md-8">
                    <label class="col-form-label @if(get_site_config('lead_create_admin_mandatory') == 'email' || get_site_config('lead_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Email</label>
                    <div class="">
                        <input type="email" placeholder="Email ID" class="form-control" name="email" value="@if(Request::old('email')){{ Request::old('email')}}@else{{ $leaddata->email }}@endif" @if(get_site_config('lead_create_admin_mandatory') == 'email' || get_site_config('lead_create_admin_mandatory') == 'email_and_mobile') required @endif>
                    </div>
                </div>

                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Date of Birth</label>
                    <input type="text" placeholder="Date of Birth" class="form-control dobmydatepicker" autocomplete="off" id="dob" name="date_of_birth" value="@if(Request::old('date_of_birth')) {{ date('d-m-Y', strtotime(Request::old('date_of_birth'))) }} @elseif($leaddata->birthday) {{ date('d-m-Y', strtotime($leaddata->birthday)) }} @endif">
                </div>
            </div>

            <div class="form-group row ">
                <div class="col-sm-12 col-md-6">
                    <label class="col-form-label 
                    @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Mobile No.</label>
                    <div class="input-group">
                        <div class="input-group-prepend" style="width: 50%">
                            <select class="form-select select2" id="dialcode" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                {{-- <option value=''>Dialcode</option> --}}
                                @foreach($dialcodes as $dialcode)
                                <option 
                                {{(($dialcode->code == $leaddata->dialcode) || (Request::old('dialcode') && Request::old('dialcode') == $dialcode->code)) ? 'selected' : ''}} 
                                value="{{$dialcode->code}}" data-name="{{$dialcode->name}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                @endforeach
                            </select>
                        </div>
                        <input 
                            type="text" 
                            placeholder="Mobile No." 
                            class="form-control" 
                            onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" 
                            name="mobile" 
                            id="mobile"
                            value="@if(Request::old('mobile')){{ Request::old('mobile') }}@else{{ $leaddata->mobile }}@endif" 
                            minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                            maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" 
                            @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required @endif>
                            
                    </div>
                </div>

                <div class="col-sm-12 col-md-6">
                    <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label>
                    <div class="input-group">
                        <div class="input-group-prepend" style="width: 50%">
                            <select class="form-select select2" id="whatsapp_dialcode" name="whatsapp_dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                {{-- <option value=''>Dialcode</option> --}}
                                @foreach($dialcodes as $dialcode)
                                <option 
                                {{
                                    (($dialcode->code == $leaddata->whatsapp_dialcode) || 
                                    (Request::old('whatsapp_dialcode') && Request::old('whatsapp_dialcode') == $dialcode->code)) ? 'selected' : ''
                                }} 
                                value="{{$dialcode->code}}" data-name="{{$dialcode->name}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                @endforeach
                            </select>
                        </div>
                        <input type="text" placeholder="Whatsapp No." id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp_number" value="@if(Request::old('whatsapp_number')){{ Request::old('whatsapp_number') }}@else{{ $leaddata->whatsapp }}@endif">
                    </div>
                    <div class="form-check" style="margin-top: -7px;">
                        <input type="checkbox"
                            class="form-check-input"
                            id="sameAsMobile"
                            >  
                        <label class="form-check-label" for="sameAsMobile" style="font-weight:500 !important;">Same as Mobile No.</label>
                    </div>
                </div>

                <div class="col-sm-12 col-md-4">
                    <label for="alternate_contact">Alternate Contact</label>
                    <div class="">
                        <input type="text" placeholder="Alternate Contact" id="alternate_contact" maxlength="50" class="form-control" name="alternate_contact" value="@if(Request::old('alternate_contact')){{ Request::old('alternate_contact') }}@else{{ $leaddata->alternate_contact }}@endif">
                    </div>
                </div>
            </div>

            {{-- <div class="form-group row ">
                <div class="col-sm-12 col-md-8">
                    <label for="address" class="col-form-label">Address</label>
                    <div class="">
                        <input type="text" id="address" class="form-control" name="address" value="{{ $leaddata->address_1 }}">
                    </div>
                </div>
            </div> --}}

            <div class="form-group row ">
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label required-field">Country</label>
                    <select class="form-select" id="country" name="country" required>
                        @foreach ($country_list as $key => $value)
                        <option value="{{ $key }}" @if(Request::old('country') == $key) selected @elseif ($leaddata->country == $key) selected @endif>{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">State</label>
                    <div class="form-group">
                        <select class="form-control form-select" name="state" id="state-dd" >
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">City</label>
                    <input type="text" placeholder="City" value="@if(Request::old('city')){{ Request::old('city') }}@else{{ $leaddata->city }}@endif" class="form-control validate_inpt" id="city" name="city">
                </div>
            </div>
            <hr style="height:1px;">
            <div class="form-group row">
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Interested Study Level</label>
                    <select class="form-select" id="study_level" name="study_level">
                        <option value="">Select Study Level</option>
                        @foreach(get_study_levels() as $key => $value)
                        <option value="{{$value}}" @if(Request::old('study_level') == $value) selected @elseif($leaddata->overseas_study_level_selection == $value) selected @endif>{{$value}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-8">
                    <label class="col-form-label">Country Interested to Study In</label>
                    <select name="country_pref[]" class="form-control form-select select2" style="width: 100%" multiple="multiple">
                        @foreach($countries as $country)
                            <?php $countryInterest = "";  
                            if(Request::old('country_pref'))
                                $country_interested = Request::old('country_pref'); 
                            else
                                $country_interested = explode(",", $leaddata->country_interested); 
                            ?>
                            @foreach($country_interested as $interest)
                                @if($interest == $country->title_en)
                                    <?php $countryInterest = "selected"; ?>
                                @endif
                            @endforeach
                            <option value="{{ $country->title_en }}" {{$countryInterest}}>{{ $country->title_en }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row " id="interested">
                
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Course Interested to Study</label>
                    <input type="text" placeholder="Course Interested to Study" class="form-control validate_inpt" value="@if(Request::old('course_interested')){{ Request::old('course_interested') }}@else{{ $leaddata->overseas_course_intersted }}@endif" id="course_interested" name="course_interested">
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Intake</label>
                    <select name="intake" class="form-select form-control">
                    <option value="">Intake</option>
                    <?php $month = date('n'); // current month
                     for ($x = 0; $x < 24; $x++) { ?>
                      <option @if(Request::old('intake') == date('m Y', mktime(0,0,0,$month + $x,1))) selected @elseif($leaddetails->intake_month.' '.$leaddetails->intake_year == date('m Y', mktime(0,0,0,$month + $x,1))) selected  @endif value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                      <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                     <?php } ?></option>
                    </select>
                </div>
                
            </div>
            <hr style="height:1px;">

            @if(config('app.product_code') == 'EDUCTRL_CRM')
            <div class="form-group row">
                <label class="col-form-label">Course Interested in</label>
                <div class="col-sm-12 col-md-8">
                    <select class="form-select" name="course">
                        <option value="">Select Course</option>
                        @foreach($courses as $course)
                        <option value="{{ $course->id }}" @if(Request::old('course') == $course->id) selected @elseif($leaddata->course == $course->id) selected="selected" @endif>{{ $course->title }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <hr style="height:1px;">
            @endif

            @if(env('ADDITIONAL_SERVICES_ENABLE'))
            <div class="row">
                <div class="col-sm-12 col-md-8">
                    <label class="col-form-label">Other Services Interested</label>
                    <select name="services[]" class="form-select select2" multiple>
                        {{-- <option value="">Select</option> --}}
                        @foreach(get_services_data() as $service)
                            <?php $serviceInterest = "";  
                            if(Request::old('services'))
                                $service_interested = Request::old('services'); 
                            else
                                $service_interested = explode(",", $leaddata->services); 
                            ?>
                            @foreach($service_interested as $interest)
                                @if($interest == $service->id)
                                    <?php $serviceInterest = "selected"; ?>
                                @endif
                            @endforeach
                            <option value="{{$service->id}}" {{$serviceInterest}}>{{$service->service_name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <hr style="height:1px;">
            @endif

            @if(config('app.product_code') == 'TRAINING')
                <input type="hidden" name="student_type" value="course">
                @elseif(config('app.product_code') == 'OVERSEAS')
                <input type="hidden" name="student_type" value="study_abroad">
                @elseif(config('app.product_code') == 'VISA')
                <input type="hidden" name="student_type" value="visa">
                @else
                <div class="form-group row mb-3">
                    <div class="col-md-6">
                        <label class="required-field">Interested In</label>
                        <select class="form-select" id="student_type" name="student_type" required>
                            <option value="">Select</option>
                            <option value="study_abroad">Study Abroad</option>
                            <option value="course">Trainings</option>
                            <option value="study_abroad_course">Study Abroad & Trainings</option>
                            @if(env('ABROAD_JOB_ADDON'))
                            <option value="abroad_job">Abroad Job</option>
                            @endif
                            @if(env('VISA_ADDON'))
                            <option value="visa">Visa</option>
                            @endif
                        </select>
                    </div>
                </div>
                <hr style="height:1px;">
                @endif

            @if(config('app.product_code') == 'OVERSEAS')
            <input type="hidden" name="leadtype" value="Study Abroad">
            @elseif(config('app.product_code') == 'TRAINING')
            <input type="hidden" name="leadtype" value="Coaching">
            @elseif(config('app.product_code') == 'VISA')
            <input type="hidden" name="leadtype" value="Visa">
            @else
            <div class="form-group row">
                <label class="col-form-label required-field">Lead Type</label>
                <div class="col-sm-12 col-md-8">
                    <select class="form-select" id="leadtype" name="leadtype" required>
                        <option value="">Select</option>
                        @foreach(get_student_types() as $lead_type)
                        <option value="{{$lead_type}}" @if(Request::old('leadtype') == $lead_type) selected @elseif($lead_type == $leaddata->lead_type) selected @endif>{{$lead_type}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            @endif

            @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
            <div id="overseas_fields" @if(config('app.product_code')=='EDUCTRL_CRM' ) style="display:none;" @endif>
                <div class="form-group row">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Qualification</label>
                        <select class="form-select" id="qualification" name="qualification">
                            <option value="">Select Qualification</option>
                            @foreach(get_student_qualification_levels() as $value)
                                        <option value="{{$value}}" @if(Request::old('qualification') == $value) selected @elseif($leaddetails->highest_level_education == $value) selected @endif>{{$value}}</option>
                            @endforeach
                            {{-- <option value="9th" @if(Request::old('qualification') == "9th") selected @elseif($leaddetails->highest_level_education == '9th') selected @endif>9th
                            </option>
                            <option value="10th" @if(Request::old('qualification') == "10th") selected @elseif($leaddetails->highest_level_education == '10th') selected @endif>10th
                            </option>
                            <option value="11th" @if(Request::old('qualification') == "11th") selected @elseif($leaddetails->highest_level_education == '11th') selected @endif>11th
                            </option>
                            <option value="12th" @if(Request::old('qualification') == "12th") selected @elseif($leaddetails->highest_level_education == '12th') selected @endif>12th
                            </option>
                            <option value="Bachelors" @if(Request::old('qualification') == "Bachelors") selected @elseif($leaddetails->highest_level_education == 'Bachelors') selected @endif>Bachelors
                            </option>
                            <option value="Masters" @if(Request::old('qualification') == "Masters") selected @elseif($leaddetails->highest_level_education == 'Masters') selected @endif>Masters
                            </option>
                            <option value="Ph.D" @if(Request::old('qualification') == "Ph.D") selected @elseif($leaddetails->highest_level_education == 'Ph.D') selected @endif>Ph.D
                            </option>                             --}}
                        </select>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Passout Year</label>
                        <input type="text" placeholder="Passout Year" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4" class="form-control" id="passout_year" name="passout_year" value="@if(Request::old('passout_year')){{ Request::old('passout_year') }}@else{{ $leaddetails->passout_year }}@endif">
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Score/Grade</label>
                        <input type="text" placeholder="Score/Grade" class="form-control" id="passout_year" name="qualification_score" value="@if(Request::old('qualification_score')){{ Request::old('qualification_score') }}@else{{ $leaddetails->qualification_score }}@endif">
                    </div>
                </div>

                <div class="form-group row " id="csc">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Currently Studying Course</label>
                        <input type="text" placeholder="Currently Studying Course" class="form-control" id="currently_studying_course" name="currently_studying_course" value="@if(Request::old('currently_studying_course')){{ Request::old('currently_studying_course') }}@else{{ $leaddetails->current_course }}@endif">
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Work Experience</label>
                        <input type="text" placeholder="Work Experience" class="form-control" id="work_experience" name="work_experience" value="@if(Request::old('work_experience')){{ Request::old('work_experience') }}@else{{ $leaddetails->work_experience }}@endif">
                    </div>
                </div>

                <div class="row mb-3" id="scores">
                    {{-- <div class="col-sm-6 col-md-2">
                        <label class="col-form-label">CGPA</label>
                        <div class="">
                            <input type="text" class="form-control" id="cgpa" name="cgpa" value="{{ $leaddetails->cgpa }}">
                        </div>
                    </div> --}}
                    <div class="col-sm-6 col-md-2">
                        <label class="col-form-label">IELTS</label>
                        <div class="">
                            <input type="text" placeholder="IELTS" class="form-control" id="ielts" name="ielts" value="@if(Request::old('ielts')){{ Request::old('ielts') }}@else{{ $leaddetails->ielts }}@endif">
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-2">
                        <label class="col-form-label">TOEFL</label>
                        <div class="">
                            <input type="text" placeholder="TOEFL" class="form-control" id="toefl" name="toefl" value="@if(Request::old('toefl')){{ Request::old('toefl') }}@else{{ $leaddetails->toefl }}@endif">
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-2">
                        <label class="col-form-label">PTE</label>
                        <div class="">
                            <input type="text" placeholder="PTE" class="form-control" id="pte" name="pte" value="@if(Request::old('pte')){{ Request::old('pte') }}@else{{ $leaddetails->pte }}@endif">
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-2">
                        <label class="col-form-label">GRE</label>
                        <div class="">
                            <input type="text" placeholder="GRE" class="form-control" id="gre" name="gre" value="@if(Request::old('gre')){{ Request::old('gre') }}@else{{ $leaddetails->gre }}@endif">
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-2">
                        <label class="col-form-label">DUOLINGO</label>
                        <div class="">
                            <input type="text" placeholder="DUOLINGO" class="form-control" id="duolingo" name="duolingo" value="@if(Request::old('duolingo')){{ Request::old('duolingo')}}@else{{ $leaddetails->duolingo }}@endif">
                        </div>
                    </div>
                </div>

                {{-- <div class="form-group row mt-2 mb-2" id="req">
                    <div class="col-sm-4">
                        <label class="col-form-label">Require Accommodation?</label>
                        <select class="form-select" name="accommodation">
                            <option value="">Select </option>
                            <option value="1" @if(Request::old('accommodation') == "1") selected @elseif($leaddetails->accommodation == '1') selected @endif>Yes</option>
                            <option value="0" @if(Request::old('accommodation') == "0") selected @elseif($leaddetails->accommodation == '0') selected @endif>No</option>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <label class="col-form-label">Require Study Permit?</label>
                        <select class="form-select" name="study_permit">
                            <option value="">Select </option>
                            <option value="1" @if(Request::old('study_permit') == "1") selected @elseif($leaddetails->study_permit == '1') selected @endif>Yes</option>
                            <option value="0" @if(Request::old('study_permit') == "0") selected @elseif($leaddetails->study_permit == '0') selected @endif>No</option>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <label class="col-form-label">Require Education Loan?</label>
                        <select class="form-select" name="education_loan">
                            <option value="">Select </option>
                            <option value="1" @if(Request::old('education_loan') == "1") selected @elseif($leaddetails->education_loan == '1') selected @endif>Yes</option>
                            <option value="0" @if(Request::old('education_loan') == "0") selected @elseif($leaddetails->education_loan == '0') selected @endif>No</option>
                        </select>
                    </div>
                </div> --}}
            </div>
            @endif
{{-- //Dynamic fields --}}
@if(count($custom_attributes))
            <hr style="height:1px;">
            <div class="form-group row ">
                <?php 
                $attrData =  json_decode($leaddetails->user_data_js, true);
                ?>
                @foreach($custom_attributes as $custom_attribute)
                    @if($custom_attribute->for_lead_mandatory)
                    <?php   $red = "required-field";
                            $mandate = "required"; ?>
                    @else
                    <?php $red="";
                          $mandate = "";?>
                   @endif
                   
                    @if($custom_attribute->type == 'input')
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                    <input type="@if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal'){{'number'}}@elseif($custom_attribute->input_datatype == 'date' || $custom_attribute->input_datatype == 'year' || $custom_attribute->input_datatype == 'phone'){{'text'}}@else{{$custom_attribute->input_datatype}}@endif" {{ ($custom_attribute->input_datatype == 'decimal')? "step=any" : ''}} 
                                    @if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal')
                                        {{"min=$custom_attribute->input_min"}} {{"max=$custom_attribute->input_max"}}
                                    @elseif($custom_attribute->input_datatype == 'date')
                                    {{-- //No min or max added --}}
                                    @elseif($custom_attribute->input_datatype == 'year')
                                        onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4"
                                    @elseif($custom_attribute->input_datatype == 'phone')
                                        onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)" minlength="10" maxlength="18"
                                    @else
                                        {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}}
                                    @endif
                                     placeholder="{{$custom_attribute->placeholder}}" autocomplete="off" class="form-control @if($custom_attribute->input_datatype == 'date') {{'mydatepicker'}}@endif" name="{{$custom_attribute->attr_name}}" value='@if(isset($attrData[$custom_attribute->attr_name])){{ $attrData[$custom_attribute->attr_name]}}@else{{old("$custom_attribute->attr_name")}}@endif' {{$mandate}} >
                                    
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'textarea')
                    <div class="form-group row ">
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                    <textarea placeholder="{{$custom_attribute->placeholder}}" {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}} class="form-control" name="{{$custom_attribute->attr_name}}" {{$mandate}}>@if(isset($attrData[$custom_attribute->attr_name])){{ $attrData[$custom_attribute->attr_name]}}@else{{old("$custom_attribute->attr_name")}}@endif</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    @if($custom_attribute->type == 'select')
                    <?php
                        $is_multi = $select2 = "";
                        $select_vals = explode('|',$custom_attribute->selection_values);
                        if($custom_attribute->select_multiple){
                            $is_multi = "multiple";
                            $select2 = "select2";
                        }
                    ?>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                    <select placeholder="{{$custom_attribute->placeholder}}" class="form-select {{$select2}}" name="{{$custom_attribute->attr_name}}[]" {{$mandate}} {{$is_multi}}>
                                        @if(!$is_multi)
                                        <option value="">{{$custom_attribute->placeholder}}</option>
                                        @endif
                                        @foreach($select_vals as $sel_val)
                                        <option {{ (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name])) ? ' selected' : '' }}{{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' selected' : '' }} value="{{ $sel_val }}">{{ $sel_val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'checkbox')
                    <?php
                        $select_vals = explode('|',$custom_attribute->selection_values);
                    ?>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                        @foreach($select_vals as $sel_val)
                                        <label>
                                            <input class="form-check-input ms-2 dyna_chkbx {{$custom_attribute->attr_name}}" @if($mandate) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif {{ (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name])) ? ' checked' : '' }} {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' checked' : '' }} type="checkbox" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" @if(isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{''}} @else{{$mandate}}@endif> {{$sel_val}}
                                        </label>
                                        @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'radio')
                    <?php
                        $select_vals = explode('|',$custom_attribute->selection_values);
                    ?>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                        @foreach($select_vals as $sel_val)
                                        <label>
                                            <input class="form-check-input ms-2 {{$custom_attribute->attr_name}}" @if($mandate) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif {{ (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name])) ? ' checked' : '' }} {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' checked' : '' }} type="radio" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" @if(isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{''}} @else{{$mandate}}@endif> {{$sel_val}}
                                        </label>
                                        @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
            <hr>
            @endif

{{-- //Dynamic fields --}}
            <div class="form-group row ">
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Lead Source</label>
                    <div class="">
                        <select class="form-select" id='lead_source' name="lead_source">
                            <option value=''>Select</option>
                            @foreach(get_lead_sources() as $source_data)
                            <option @if(Request::old('lead_source') == $source_data) selected @elseif($source_data == $leaddata->lead_source) selected @endif value="{{ $source_data }}">{{ucfirst($source_data)}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="address" class="col-form-label">Lead Source Details</label>
                        <div class="">
                            <input type="text" placeholder="Lead Source Details" class="form-control validate_inpt" name="lead_source_detail" value="@if(Request::old('lead_source_detail')){{ Request::old('lead_source_detail') }}@else{{ $leaddetails->lead_source_detail }}@endif">
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="" class="col-form-label">Campaign Name</label>
                        <div class="">
                            <input type="text" placeholder="Campaign Name" class="form-control" name="campaign_name" value="@if(Request::old('campaign_name')){{ Request::old('campaign_name') }}@else{{ $leaddetails->lead_campaign_name }}@endif">
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-12 col-md-8">
                    <label class="col-form-label">Lead Notes</label>
                    <textarea class="form-control validate_inpt" placeholder="Lead Notes" name="note">@if(Request::old('note')){{Request::old('note')}}@else{{$leaddetails->lead_notes}}@endif</textarea>
                </div>
                @if(get_site_config('module_student_referral'))
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Referred by Student</label>
                    <div class="">
                        <select class="form-select select2_ajax" id='ref_by' name="referred_by">
                            <option value=''>Select Student</option>
                            @if($leaddata->ref_by)
                                <option selected value="{{$leaddata->ref_by}}">{{get_user_full_name_by_id($leaddata->ref_by)}}</option>
                            @endif
                        </select>
                    </div>
                </div>
                @endif
            </div>
            <hr>
            <div class="form-group row" id="branch">
                <label class="col-form-label required-field">Branch</label>
                <div class="col-sm-12 col-md-8">
                    <select class="form-select" id="branch" name="branch" required>
                        <option value="">Select Branch</option>
                        @foreach($branch as $branches)
                        <option @if(Request::old('branch') == $branches) selected @elseif($branches->id == $leaddata->branch) selected @endif value="{{ $branches->id }}">{{ $branches->branch_name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="row" style="margin-top:10px;">
                <div class="col-sm-12 col-md-8 text-center">
                    <div class="form-group mb-0 clearfix">
                        {{ form_submit("Save") }}
                    </div>
                </div>
            </div>
        </div>
        </form>

    </div>
</div>
@endsection

@push ('after-styles')
<style>
    .select2-container .select2-selection--single {
        height: 33px !important;
    }
</style>
@endpush

@push('after-scripts')
<script>
    function syncWhatsapp() {
        if ($("#sameAsMobile").is(":checked")) {
            $("#whatsapp_number").val($("#mobile").val()).prop("readonly", true);
            $("#whatsapp_dialcode").val($("#dialcode").val()).prop("readonly", true);
            $("#whatsapp_dialcode").trigger('change');
        } else {
            $("#whatsapp_number").prop("readonly", false);
            $("#whatsapp_dialcode").prop("readonly", false);
        }
    }

    // $("#sameAsMobile").prop("checked", true);

    syncWhatsapp();                                
    $("#mobile, #dialcode").on("input change", syncWhatsapp);
    $("#sameAsMobile").on("change", syncWhatsapp);
</script>
<script>
    $(document).ready(function() {

        // $(".select2").select2({
        //     placeholder: "Country Interested to Study In",
        // });
        $('.select2_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.get-ref-users") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        exclude_user: '{{$leaddata->id}}',
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $('.dobmydatepicker').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            scrollInput: false,
            maxDate: new Date()
        });

        $('#country').on('change', function () {
            var idCountry = this.value;
            $("#state-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-states')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#state-dd').html('<option value="">Select State</option>');
                    $.each(result.states, function (key, value) {
                        if(value.id == "{{($leaddata)?$leaddata->state:''}}"){
                            var selectedState = "selected=\"'selected'\"";
                        }else if(value.id == "{{old('state')}}"){
                            var selectedState = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedState = "";
                        }
                        $("#state-dd").append('<option '+selectedState+' value="'+ value.id + '">' + value.name + '</option>');
                    });
                }
            });
        });

        $('#country').trigger('change');

        $('#dialcode').change(function(){
            var dialcode = $('#dialcode').val();
            $('#whatsapp_dialcode').val(dialcode);
        })

        $("#leadtype").change(function(e) {
            e.preventDefault();
            if (this.value == 'Coaching') {
                $("#course").show();
                $("#overseas_fields").hide();
                $('#country,#study_level').removeAttr("required");
                $("#scores").hide();
            } else if (this.value == 'Study Abroad') {
                $("#course").hide();
                ////$("#courses").removeAttr('required');
                $("#overseas_fields").show();
                $('#country,#study_level').attr("required", "required");
                $("#scores").show();
            } else if (this.value == 'Study Abroad & Coaching') {
                $("#course").show();
                $("#overseas_fields").show();
                $('#country,#study_level').attr("required", "required");
                $("#scores").show();
                ////$("#courses").removeAttr('required');
            }
        });

        // $('#batches').hide(); //initially dropdown is hidden
        // $('#checkbox').change(function() { //change click to hidden

        //     if ($(this).is(':checked')) { //check if checkbox is checked
        //         $('#batches').show(); //show if checked
        //     } else {
        //         $('#batches').hide(); //hide if unchecked
        //     }

        // });

    });
function chk_mend(elClass) {
  el = document.getElementsByClassName(elClass);
  var atLeastOneChecked = false; //at least one cb is checked
  for (i = 0; i < el.length; i++) {
    if (el[i].checked === true) {
      atLeastOneChecked = true;
    }
  }

  if (atLeastOneChecked === true) {
    for (i = 0; i < el.length; i++) {
      el[i].required = false;
    }
  } else {
    for (i = 0; i < el.length; i++) {
      el[i].required = true;
    }
  }
}
</script>
@endpush