@extends('backend.layouts.app')
@section('title', "Lead Details & Follow-ups")
@section('content')
<style>
    .error {
        color: #FF0000;
    }
</style>
<div class="card">
    <div class="card-body">

        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Lead Details & Follow-ups
                </h4><br>
            </div>
            <!--col-->
            <!-- <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div> -->
        </div>
        <!--row-->

        <div class="form-group row">
            <div class="col-sm-12 col-md-6">
                {{ html()->form('POST', route('admin.leadmanagement.update_followups', $lead->id))->class('form-horizontal')->open() }}
                <p><strong>Add New Follow-up</strong></p>
                <textarea class="form-control" name="followup_details" rows="5" placeholder="Add follow-up details*" cols="30" required></textarea>
                <div class="col-sm-12 col-md-10">
                    <label class="col-form-label required-field"><b>Lead Status</b></label>
                    <div class="">
                        <select class="form-control form-select" id="lead_status" name="status" required>
                            @foreach($lead_status as $stat)
                            @if($stat->status != get_converted_lead_status())
                            <option value="{{$stat->status}}" {{($lead->lead_status==$stat->status)? 'selected' :''}}>{{$stat->status}}</option>
                            @endif
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-10">
                    <label class="col-form-label required-field" id="next_followup_label"><b>Next Follow-up</b></label>
                    <div class="">
                        <input type="text" autocomplete="off" class="form-control mydatetimepicker" placeholder="Choose Date & Time" id="next_followup" name="next_followup" required>
                    </div>
                </div>
                <div class="form-group mt-2 clearfix text-center">
                    {{ form_submit("Submit") }}
                </div>
                </form>
            </div>

            <div class="col-sm-12 col-md-6">
                {!!($lead->next_followup!='')? '<span class="badge badge-warning" style="font-size:14px;">Next Followup: '.date('d/m/Y h:s A', strtotime($lead->next_followup)).'</span><br /><br />' : ''!!}
                <p><strong>Lead Details</strong></p>
                <h4>{{$lead->first_name}} {{$lead->last_name}}</h4>
                <h6>{{$lead->email}}
                    <a style="padding:8px 8px;color:#5a9af9;font-size:1.3em;" target="_blank" href="{{route('admin.broadcast.mail.lead', $lead->id)}}"><i class="fas fa-envelope"></i></a>
                </h6>
                <?php
                if ($lead->dialcode != '') {
                    $mob = "+" . $lead->dialcode . '-' . $lead->mobile;
                    $mob_value = $lead->dialcode . $lead->mobile;
                } else {
                    $mob = $lead->mobile;
                    $mob_value = $lead->mobile;
                }
                ?>
                <h6>{{$mob}}
                    <a style="padding-left:8px;color:#5a9af9;font-size:1.3em;" target="_blank" href="tel:{{$mob_value}}"><i class="fas fa-phone-square-alt"></i></a>
                    <a style="padding-left:8px;color:#5a9af9;font-size:1.3em;" target="_blank" href="{{route('admin.broadcast.sms.lead', $lead->id)}}"><i class="fas fa-comment"></i></a>
                    {{-- @if(env('WATI_WHATSAPP_TOKEN')) --}}
                    @if(get_site_config('whatsapp_enabled'))
                    <a style="padding-left:8px;color:#5a9af9;font-size:1.3em;" target="_blank" href="{{route('admin.broadcast.whatsapp.lead', $lead->id)}}"><i class="fab fa-whatsapp"></i></a>
                    @else
                    <a style="padding-left:8px;color:#5a9af9;font-size:1.3em;" target="_blank" href="https://wa.me/{{$mob_value}}"><i class="fab fa-whatsapp"></i></a>
                    @endif
                </h6>
                <br />
                <p><strong>Notes:</strong></p>
                @if($lead_details->lead_notes)
                {!!nl2br($lead_details->lead_notes)!!}
                @else
                -
                @endif
                <?php
                if ($lead_details->accommodation == 1) {
                    $acc = "Yes";
                } else {
                    $acc = "No";
                }
                if ($lead_details->study_permit == 1) {
                    $sp = "Yes";
                } else {
                    $sp = "No";
                }
                if ($lead_details->education_loan == 1) {
                    $loan = "Yes";
                } else {
                    $loan = "No";
                }
                ?>
                <hr>
                <div class="form-group row mb-2" id="">
                    <div class="col-md-6">
                        <label>Lead ID</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{$lead->id}}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Course Interested to Study</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $lead->course_interested ? $lead->course_interested : '-'}}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Interested Study Level</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $lead->study_level ? $lead->study_level : '-'}}</strong>
                        </label>
                    </div>
                </div>
                @if($lead->student_type != 'Coaching')
                <div class="form-group row mb-2" id="country">
                    <div class="col-md-6">
                        <label>Country Interested in</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="country" name="country">
                            <strong>{{ $lead->country_pref ? $lead->country_pref : '-' }}</strong>
                        </label>
                    </div>
                </div>
                @endif
                <div class="form-group row mb-2" id="qualification">
                    <div class="col-md-6">
                        <label>Qualification</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="qualification" name="qualification">
                            <strong>{{ $lead_details->highest_level_education ? ucfirst($lead_details->highest_level_education) : '-' }}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="passout">
                    <div class="col-md-6">
                        <label>Passout Year</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="passout_year" name="passout">
                            <strong>{{ $lead_details->passout_year ? $lead_details->passout_year : '' }}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Currently Studying Course</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $lead_details->current_course ? $lead_details->current_course : '-'}}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Work Experience</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $lead_details->work_experience ? $lead_details->work_experience : '-'}}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Require Study Permit?</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $lead_details->study_permit ? $sp : '-'}}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Require Accommodation?</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $lead_details->accommodation ? $acc : '-'}}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Require Education Loan?</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $lead_details->education_loan ? $loan : '-'}}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="qualification">
                    <div class="col-md-6">
                        <label>Gender</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="gender" name="gender">
                            <strong>{{ $lead->gender ? ucfirst($lead->gender) : '-' }}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="qualification">
                    <div class="col-md-6">
                        <label>Date of Birth</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="gender" name="gender">
                            <strong>{{ $lead->birthday ? date('d-m-Y', strtotime($lead->birthday)) : '-' }}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2" id="qualification">
                    <div class="col-md-6">
                        <label>Alternate Contact</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="gender" name="gender">
                            <strong>{{ $lead->alternate_contact ? $lead->alternate_contact : '-' }}</strong>
                        </label>
                    </div>
                </div>
                @if(config('app.product_code') == 'EDUCTRL_CRM')
                <div class="form-group row mb-2">
                    <div class="col-md-6">
                        <label>Lead Type</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="leadtype" name="leadtype">
                            <strong>{{ $lead->student_type }}</strong>
                        </label>
                    </div>
                </div>
                @endif

                <div class="form-group row mb-2">
                    <div class="col-md-6">
                        <label for="address">City</label>
                    </div>
                    <div class="col-sm-6">
                        <label name="address"><strong>{{ $lead->city ? $lead->city : '-' }}</strong>
                        </label>
                    </div>
                </div>
                <div class="form-group row mb-2">
                    <div class="col-md-6">
                        <label for="address">Address</label>
                    </div>
                    <div class="col-sm-6">
                        <label name="address"><strong>{{ $lead->address ? $lead->address_1 : '-' }}</strong>
                        </label>
                    </div>
                </div>

                @if($lead->lead_type != 'Coaching')

                <div class="form-group row mb-2" id="country">
                    <div class="col-md-6">
                        <label>Country of Citizenship</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="country" name="country">
                            <strong>{{ $lead->country ? $lead->country : '-' }}</strong>
                        </label>
                    </div>
                </div>
                @if($lead_details->cgpa)
                <div class="form-group row mb-2" id="cgpa">
                    <div class="col-md-6">
                        <label>CGPA</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="cgpa" name="cgpa"><strong>{{ $lead_details->cgpa }}</strong>
                        </label>
                    </div>
                </div>
                @endif

                @if($lead_details->ielts)
                <div class="form-group row mb-2" id="ielts">
                    <div class="col-md-6">
                        <label>IELTS</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="ielts" name="ielts"><strong>{{$lead_details->ielts}}</strong>
                        </label>
                    </div>
                </div>
                @endif

                @if($lead_details->toefl)
                <div class="form-group row mb-2" id="toefl">
                    <div class="col-md-6">
                        <label>TOEFL</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="toefl" name="toefl"><strong>{{$lead_details->toefl}}</strong>
                        </label>
                    </div>
                </div>
                @endif

                @if($lead_details->pte)
                <div class="form-group row mb-2" id="pte">
                    <div class="col-md-6">
                        <label>PTE</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="pte" name="pte"><strong>{{$lead_details->pte}}</strong>
                        </label>
                    </div>
                </div>
                @endif
                @if($lead_details->gre)
                <div class="form-group row mb-2" id="pte">
                    <div class="col-md-6">
                        <label>GRE</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="gre" name="gre"><strong>{{$lead_details->gre}}</strong>
                        </label>
                    </div>
                </div>
                @endif
                @if($lead_details->duolingo)
                <div class="form-group row mb-2" id="pte">
                    <div class="col-md-6">
                        <label>Duolingo</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="duolingo" name="duolingo"><strong>{{$lead_details->duolingo}}</strong>
                        </label>
                    </div>
                </div>
                @endif

                @endif

                @if($lead->student_type =='Coaching' || $lead->student_type =='Study Abroad & Coaching')
                <div class="form-group row mb-2" id="course">
                    <div class="col-md-6">
                        <label>Course Interested in</label>
                    </div>
                    <div class="col-sm-6">
                        <label>
                            <strong>{{ $coursevalues ? $coursevalues->title : '-'}}</strong>
                        </label>
                    </div>
                </div>
                @endif

                <div class="row mb-2">
                    <div class="col-md-6">
                        <label>Lead Source</label>
                    </div>
                    <div class="col-sm-6">
                        <label><strong>{{$lead->lead_source ? ucfirst($lead->lead_source) : '-'}} @if($lead->lead_source && $lead_details->lead_source_detail) ({{$lead_details->lead_source_detail}}) @endif</strong></label>
                    </div>
                </div>

                <div class="form-group row mb-2" id="campaign">
                    <div class="col-md-6">
                        <label>Campaign</label>
                    </div>
                    <div class="col-sm-6">
                        <label id="campaign_name" name="campaign_name">
                            <strong>{{ $lead_details->lead_campaign_name ? $lead_details->lead_campaign_name : '-' }}</strong>
                        </label>
                    </div>
                </div>		
		
                <p class="text-muted mt-3">Created at {{$lead->created_at}} by {{($lead->created_by==0)?get_user_full_name_by_id(1) :get_user_full_name_by_id($lead->created_by)}}</p>

            </div>

        </div>

        <div class="row">
            <div class="col-sm-12">
                <hr>
                <h4 class="mb-4">Lead Activity</h4>
                @if(count($lead_followups))
                <div class="card">
                    <div class="card-body">
                        @foreach($lead_followups as $followups)
                        <div style="padding-top: 15px;color: #6e6e6e;font-size: 14px;font-style: italic;">
                            {{ date('d M Y g:i A', strtotime($followups->created_at)) }}, {{get_user_name_by_id($followups->staff)}}:
                        </div>
                        <div class="card-text" style="font-size:15px;color: #353535 !important;padding-bottom:10px;border-bottom:1px solid #ccc;">{!!$followups->detail!!}</div>
                        @endforeach
                    </div>
                </div>
                @else
                No records found!
                @endif
            </div>
        </div>


    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $("#lead_status").change(function() {
            if (this.value == '{{get_counselling_lead_status()}}' || this.value == '{{get_disqualified_lead_status()}}') {
                $('#next_followup').removeAttr('required');
                $('#next_followup_label').removeClass('required-field');
            } else {
                $('#next_followup').attr('required', 'required');
                $('#next_followup_label').addClass('required-field');
            }
        });
    });
</script>
@endpush