@extends('backend.layouts.app')

@section('title', "Leads")

{{-- @include('backend.auth.user.includes.top-links-leads') --}}
@section('content')
<div class="card" >
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important; margin-top: -10px !important;">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Leads
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <button onclick="javascript:searchTable();" class="btn btn-sm  btn-outline-primary" title="Refresh" style=""><i class="bi bi-arrow-clockwise"></i></button>
                    {{-- <a style="margin-left: 5px; " target="_blank" href="{{ route('admin.leadmanagement.import.open','leads') }}" class="btn btn-sm  btn-outline-primary" data-toggle="tooltip" title="Import Leads"><i class="bi bi-cloud-arrow-up-fill"></i></a> --}}
                    <a style="margin-left: 5px; " target="_blank" href="{{ route('admin.import-export.index','leads') }}" class="btn btn-sm  btn-outline-primary" data-toggle="tooltip" title="Import Leads"><i class="bi bi-cloud-arrow-up-fill"></i></a>
                    <a href="{{ route('admin.leadmanagementdetails.create') }}" class="btn ml-1 btn-sm btn-primary" data-toggle="tooltip" title="Add New Lead" style="margin-left:10px; "><i class="bi bi-plus-circle"></i> New Lead</a>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->

        {{-- <div id="filters" style="border-top:1px solid #ccc;border-bottom:1px solid #ccc;padding:0px 15px 4px 15px !important;background-color:#f8f8f8;display:none"> --}}
        
        <div class="filterBox mx-2" style="border-radius: 8px; border: 1px solid rgb(197, 206, 252);">
            <p class="" style="font-size: 18px !important; margin-top: 10px; margin-bottom: 6px;">Filter</p>
            <div class="row" >
                <div class="col-sm-12 col-md-3">
                    <label for="status_search" style="font-weight: normal !important;">Lead Status</label>
                    <select class="form-select select2stats" id='status_search' multiple>
                        {{-- <option value=''>All Open Leads</option> --}}
                        @foreach(lead_status_list() as $status_data)
                            @if($filters['allOpenLeads'])
                                <option value="{{$status_data->status}}" selected>{{$status_data->status}}</option>
                            @elseif(!empty($filters['assigned_to']) && empty($filters['status']))
                                <option value="{{$status_data->status}}" selected>{{$status_data->status}}</option>
                            @else
                                <option value="{{$status_data->status}}" {{($filters['status'] == $status_data->status)? 'selected' : ''}}>{{$status_data->status}}</option>
                            @endif
                        @endforeach
                        <option value="all_leads" {{($filters['status'] == $status_data->status)? 'selected' : ''}}>ALL LEADS</option>
                    </select>
                </div>

                @if(config('app.product_code') == 'EDUCTRL_CRM')
                <div class="col-sm-12 col-md-3">
                    <label for="leadtype" style="font-weight: normal !important;">Lead Type</label>
                    <select class="form-select" id="leadtype">
                        <option value="">- Lead Type -</option>
                        @foreach(get_lead_types() as $lead_type)
                        <option value="{{$lead_type}}">{{$lead_type}}</option>
                        @endforeach
                    </select>
                </div>
                @else
                <input type='hidden' id="leadtype" value=''>
                @endif
                {{-- @if(!\Auth::user()->can('view assigned data only')) --}}
                <div class="col-sm-12 col-md-3">
                    <label for="assigned_to" style="font-weight: normal !important;">Assigned To Staff</label>
                    <select class="form-select" name="assigned_to" id="assigned_to" @if(\Auth::user()->can('view assigned data only')) disabled @endif>
                        <option value="">- Select -</option>
                        <option value="null">Unassigned</option>
                        @foreach($staff as $stf)
                        <option {{($filters['assigned_to'] == $stf->id)? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}} @if($logged_in_user->id == $stf->id)(Me) @endif</option>
                        @endforeach
                    </select>
                </div>
                {{-- @endif --}}

                <div class="col-sm-12 col-md-3">
                    <label for="lead_country" style="font-weight: normal !important;">Country of Residence</label>
                    <select class="form-select" name="lead_country" id="lead_country">
                        <option value="">- Select -</option>
                        @foreach($lead_countries as $countries)
                        <option {{($filters['lead_countries'] == $countries->country)? 'selected' : ''}} value="{{$countries->country}}">{{get_country_name($countries->country)}}</option>
                        lead_countries
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-12 col-md-2">
                    <label for="branch" style="font-weight: normal !important;">Branch</label>
                    <select class="form-select" id="branch" name="branch">
                        <option value="all" @if($current_branch=='all' ) selected="selected" @endif>All</option>
                        @foreach($branch as $id => $name)
                        <option value="{{ $id }}" @if($current_branch==$id) selected="selected" @endif>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-1">
                    <button id="filter_toggle" class="btn btn-sm btn-outline-primary" title="Filters" style=" margin-top: 22px; padding-left: 5px; padding-right: 5px;"><i class="bi bi-funnel"></i> <span id="filter_more">More</span></button>
                </div>

                <div class="col-12">
                    <div class="row" id="filters" style="display:none; border: none !important;">
                        <div class="col-sm-12 col-md-3">
                            <label for="country_pref" style="font-weight: normal !important;">Country Interested In</label>
                            <select class="form-select country_interested_in" id='country_pref' multiple>
                                {{-- <option value=''>Country Interested In</option> --}}
                                @foreach($countriesFilter as $country)
                                <option value="{{$country->title_en}}">{{$country->title_en}}</option>
                                @endforeach
                            </select>
                        </div>
    
                        <div class="col-sm-12 col-md-3">
                            <label for="study_level_filter" style="font-weight: normal !important;">Study Level Interested</label>
                            <select class="form-select" id="study_level_filter" name="study_level_filter">
                                <option value="">Select Study Level</option>
                                @foreach(get_study_levels() as $key => $value)
                                    <option value="{{$value}}">{{$value}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <label for="course_interested_filter" style="font-weight: normal !important;">Course Interested to Study In</label>
                            <select name="course_interested_filter" id="course_interested_filter" class="form-select">
                                <option value="">Select Course Interested</option>
                                @foreach($courseFilter as $key => $value)
                                    <option value="{{$value->overseas_course_intersted}}">{{$value->overseas_course_intersted}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <label for="intake_filter" style="font-weight: normal !important;">Intake</label>
                            <select name="intake_filter" id="intake_filter" class="form-select form-control">
                                <option value="">Intake</option>
                                <?php $month = date('n'); // current month
                                for ($x = 0; $x < 24; $x++) { ?>
                                    <option {{(Request::old('intake')==date('m Y', mktime(0,0,0,$month + $x,1)))? 'selected' : ''}} value="<?php echo date('m Y', mktime(0, 0, 0, $month + $x, 1)); ?>">
                                        <?php echo date('F Y', mktime(0, 0, 0, $month + $x, 1)); ?>
                                    <?php } ?></option>
                            </select>
                        </div>
                        @if(env('ADDITIONAL_SERVICES_ENABLE'))
                        <div class="col-sm-12 col-md-3">
                            <label for="service_pref" style="font-weight: normal !important;">Service Interested In</label>
                            <select class="form-select service_interested_in" id='service_pref' multiple>
                                @foreach(get_services_data() as $service)
                                <option @if(old('services') == $service->id) selected @endif value="{{$service->id}}">{{$service->service_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        @endif
    
                        <div class="col-sm-12 col-md-3">
                            <label for="created_date" style="font-weight: normal !important;">Created Date</label>
                            <input type="text" autocomplete="off" class="form-control" id="created_date" name="created_date" placeholder="Created Date">
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <label for="next_followup_counselling_date" style="font-weight: normal !important;">Next Follow-up/Counselling Date</label>
                            <select class="form-select" id="next_followup_counselling_date" name="next_followup_counselling_date">
                                <option value="--">- Select -</option>
                                <option value="overdue">Overdue</option>
                                <option value="today">Today</option>
                                <option value="tomorrow">Tomorrow</option>
                                <option value="in_next_7_days" >In Next 7 Days</option>
                                <option value="custom" id="custom">Custom</option>
                            </select>
                        </div>
                        <div class="col-sm-12 col-md-3 d-none" id="followup_daterange_box">
                            <label for="followup_daterange" style="font-weight: normal !important;">Date Range</label>
                            <div class="input-group mb-3" >
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="border-top-right-radius: 0px; border-bottom-right-radius: 0px;" id="basic-addon2"><i class="bi bi-calendar-check" style="font-size: 0.9rem;"></i></span>
                                </div>
                                <input type="text" autocomplete="off" id="followup_daterange" value="@isset($filters['followup_daterange']){{$filters['followup_daterange']}}@endisset" name="followup_daterange" class="daterange form-control" placeholder="Choose">
                            </div>
                        </div>                
                        <div class="col-sm-12 col-md-3">
                            <label for="lead_source" style="font-weight: normal !important;">Lead Source</label>
                            <select class="form-select" id="lead_source" name="lead_source">
                                <option value=''>Lead Source</option>
                                @foreach(get_lead_sources() as $source_data)
                                    <option value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <label for="lead_age" style="font-weight: normal !important;">Lead Age Greater Than</label>
                            <input type="number" id="lead_age" style="width: 100%" min="1" step="1" value="@isset($filters['lead_age']){{$filters['lead_age']}}@endisset" name="lead_age" class="form-control" placeholder="Days">
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <label for="no_activity_since" style="font-weight: normal !important;">No Activity Since</label>
                            <input type="number" id="no_activity_since" min="1" step="1" value="@isset($filters['no_activity_since']){{$filters['no_activity_since']}}@endisset" name="no_activity_since" class="form-control" placeholder="Days">
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <label style="font-weight: normal !important;" for="tags_filter">Tags</label>
                            <select class="form-select tags2 select2" id='tags_filter' name="tags_filter" multiple>
                                @foreach(get_all_tags() as $tags_data)
                                        <option value="{{$tags_data->tag_name}}" {{($filters['tags_filter'] == $tags_data->tag_name)? 'selected' : ''}}>{{$tags_data->tag_name}}</option>
                                @endforeach
                            </select>
                        </div>
    
                        <div class="row ">
                            <div class="col-12">
                                <input type="checkbox" name="leadsWithNoFollowup" id="leadsWithNoFollowup" value="1"> 
                                <label for="leadsWithNoFollowup" style="font-weight: normal !important;">Leads with No Follow-up</label>
            
                                <input type="checkbox" class="ms-3" name="myleads" id="myleads" value="1">
                                <label for="myleads" style="font-weight: normal !important;">My Leads Only</label>
            
                                {{-- <input type="checkbox" class="ms-3" name="excludeAgent" id="excludeAgent" value="1"> 
                                <label for="excludeAgent">Exclude Agent Leads</label>
            
                                <input type="checkbox" class="ms-3" name="agentListOnly" id="agentListOnly" value="1"> 
                                <label for="agentListOnly">Agent Leads Only</label> --}}
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-sm-12 col-md-6 mx-auto d-flex justify-content-center">
                                <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm px-4 mx-2">
                                    <span id="filter-spin-button">Filter</span>
                                    <div class="spinner-border text-white spinner-border-sm mx-2" id="filter-spin" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </button>
                                <button onclick="javascript:clearTable();" class=" btn btn-outline-primary btn-sm px-4">Clear</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col lead-horizontal" >
                <div class="">
                    <table class="table w-100" id="lead_list">
                        <thead>
                            <tr>
                                <th data-orderable="false">
                                    <div class="form-check form-check-sm form-check-custom form-check-solid ms-2">
                                        <input class="form-check-input" type="checkbox" id="check_all" name="check_all" />
                                    </div>
                                </th>
                                <th style="padding-right: 10px !important;">ID</th>
                                <th>Lead</th>
                                <th style="display: none;">Lead</th>
                                <th style="display: none;">Email</th>
                                <th style="display: none;">Mobile</th>
                                <th style="display: none;">Whatsapp</th>
                                <th style="display: none;">Location</th>
                                <th style="display: none;">Branch</th>
                                <th style="display: none;">Status</th>
                                <!-- <th>Branch</th> -->
                                <th style="padding-right: 20px !important;min-width: 90px !important;">Next Followup</th>
                                <th>Status</th>
                                <th>Assigned to</th>
                                {{-- <th>Last Followup</th> --}}
                                <th style="padding-right: 20px !important; min-width: 65px !important;">Created</th>
                                <th style="min-width: 141px !important;">Actions</th>
                            </tr>
                        </thead>

                    </table>
                    <div class="col-md-3 col-sm-12 process-selected mx-3" id="bulk_operation" style="display: none;">
                        {{-- <label>With Selected</label> --}}
                        <select class="form-select" name="bulk_assigned_to" id="bulk_assigned_to">
                            <option value="">- Bulk Actions -</option>
                            <option value="bulk_lead_assignment">Assign Leads to Staff</option>
                            <option value="bulk_change_status">Change Status</option>
                            <option value="bulk_next_followup_date">Update Next-Followup Date</option>
                            <option value="bulk_lead_delete">Delete Leads</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <!--row-->
        <div class="row mt-4 px-3">
            <div class="col-md-12">
            <small>
                <b>Notes:</b> By default “All open leads” are shown. It shows all leads except “Converted”, “Disqualified” leads. To view “Converted” or “Disqualified” leads, select the corresponding status in Status filter & click “Filter”.
            </small>
            </div>
        </div>
    </div>
    <!--card-body-->
    
</div>
<!--card-->
<div class="modal fade" id="followupsModal">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Lead Follow-ups</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="counsellingModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Convert Lead to Counselling</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="disqualifiedModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Disqualify Lead</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="leadAssignedStaffModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Lead - Assign Staff</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 30px;"></button>
            </div>
            <div class="modal-body load_modal" style="padding: 0px 20px;">

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="createTagModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Tags</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body tag_modal_data">
                <form method="POST" id="add_tag_form" action="">
                @csrf
                <div class="form-group row">
                        <input type="hidden" name="lead_id" id="tag_lead_id" value="">
                        <div class="col-sm-12">
                            <label style="padding-bottom: 2px;" class="col-form-label required-field"><b>Select/Add New Tag</b></label>
                            <div class="">
                                <select class="form-select select2tags" id='lead_tags' name="lead_tags[]" multiple>
                                        @foreach(get_all_tags() as $tags)
                                        <option value="{{$tags->tag_name}}">{{$tags->tag_name}}</option>
                                        @endforeach
                                </select>
                            </div>
                        </div>
                </div>
                <div class="row" style="margin-top:10px;">
                    <div class="col-sm-4 mx-auto">
                        <div class="form-group mb-0 clearfix">
                            <button class="btn btn-primary btn-sm" type="submit">Add Tag</button>
                        </div>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<style>
    .select2-search--inline > textarea{
        height: 12px !important;
    } 
</style>
@endpush

@push ('after-scripts')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>

<script type="text/javascript">
    $(document).ready(function() {
        // $("#loader").hide();
        // const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
        // const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

        $(document).on('click', '.call_btn', function(e) {
        var user_id = $(this).attr('data-num');

        Swal.fire({
        title: `Are you sure you want to call?`,
            showCancelButton: true,
            confirmButtonText: "Yes",
            cancelButtonText: "Cancel",
            icon: 'question'
        }).then((result) => {
            if(user_id !="" && result.value){
                    var url = "{{route('admin.communicate.phoneCall', [':user_id'])}}";
                    url = url.replace(':user_id', user_id);
                    $.ajax({
                        type:'GET',
                        url: url,
                        dataType:'json',
                        success:function(data){
                            console.log(data);
                            if(data.err){
                                // console.log($('.toast'));
                                $.toast({
                                    heading: 'Error',
                                    text: data.msg,
                                    position: 'top-right',
                                    loaderBg: '#ff6849',
                                    icon: 'error',
                                    hideAfter: 3000,
                                    stack: 8
                                });
                                return false;
                            }
                            if(data.Call.Status){
                                Swal.fire({
                                    title: "Call Status: "+data.Call.Status,
                                    text: "Calling: "+data.Call.To,
                                    icon: "success"
                                });
                            }
                            if(data.RestException){
                                alert("Error!");
                            }
                        }
                    });
                }
            });
        });

        $(".select2stats").select2({
            placeholder: "",
        });
        $(".country_interested_in").select2({
            placeholder: "",
        });
        $(".service_interested_in").select2({
            placeholder: "",
        });
        $(".tags2").select2({
            placeholder: ""
        });
        $(".select2tags").select2({
            tags: true
        });
        $(document).on('keypress', '.select2-search__field', function() {
            $(this).attr('maxlength', 20);
            var inputValue = event.which;
            if ((inputValue == 44)) {
                event.preventDefault();
            }
        });

        loadData();
        var tech = GetURLParameter('lead_info');
        if (tech && $.isNumeric(tech)) {
            var this_id = tech;
            var base_url = "{{ url('admin/lead/')}}/" + this_id + "/followups";
            $.get(base_url, function(data) {
                $('#followupsModal').on('shown.bs.modal', function() {
                    $('#followupsModal .load_modal').html(data);
                });
                $('#followupsModal').modal('show');
                $('#followupsModal').on('hidden.bs.modal', function() {
                    $('#followupsModal .load_modal').html("");
                });
            });
        }

        $('.daterange').daterangepicker({
            autoUpdateInput: false,
        });
        $('.daterange').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
        });
        $('.daterange').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        $("#check_all").on("click", function() {
            if ($("input:checkbox[name='check_all']").prop("checked")) {
                $("input:checkbox[name='multiselect']").prop("checked", true);
            } else {
                $("input:checkbox[name='multiselect']").prop("checked", false);
            }
            checkboxCheckSelected();
        });
        
        // $('#myleads').change(function() {
        //     $("#lead_list").dataTable().fnDestroy();
        //     loadData();
        // });

        $('#bulk_assigned_to').on('change', function() {
            // Checking with selected empty or not
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            if(dataArray.length == 0){
                alert("Please select at-least one lead!");
                $('#bulk_assigned_to').val("");
                return;
            }

            if (this.value == 'bulk_lead_assignment') {
                processBulkLead();
            }
            if (this.value == 'bulk_change_status') {
                processBulkStatusCahnge();
            }
            if (this.value == 'bulk_next_followup_date') {
                processBulkNextFollowupDateChange();
            }
            if (this.value == 'bulk_lead_delete') {
                Swal.fire({
                    title: `Are you sure you want to delete selected leads?`,
                    html: "<h6 class='text-danger'>This action cannot be undone!</h6>",
                    showCancelButton: true,
                    confirmButtonText: "Delete",
                    cancelButtonText: "Cancel",
                    type: 'warning'
                }).then((result) => {
                    result.value && processBulkDelete();
                });
            } else {}
        });

        let filter_more_count = 0;
        $('#filter_toggle').on('click', function() {
            $('#filters').slideToggle();
            let filter_text = $('#filter_more').text();
            if(filter_text === "More"){
                $('#filter_more').text("Less");
            } else{
                $('#filter_more').text("More");
            }
            
        });
        
        $('#status_search ~.select2-container--default, #lead_country, #assigned_to, #branch').on('click', function() {
            $('#filters').slideDown();
            let filter_text = $('#filter_more').text();
            if(filter_text === "More"){
                $('#filter_more').text("Less");
            } 
            // else{
            //     $('#filter_more').text("More");
            // }
        });

    });

    function processBulkDelete() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.leads.bulkdeletelead')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function processBulkLead() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.leads.bulkassignstaff')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function processBulkStatusCahnge() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.leads.bulkstatuschange')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function processBulkNextFollowupDateChange() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.leads.next-followup-date.view')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function manual_form_submit(options) {
        var $form = $("<form />");
        $form.attr("action", options.url);
        $form.attr("method", options.method);
        for (var data in options.data)
            $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
        $("body").append($form);
        $form.submit();
    }

    function checkboxCheckSelected() {
        var total_check_boxes = $("input:checkbox[name='multiselect']").length;
        var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
        if (total_check_boxes === total_checked_boxes) {
            $("#check_all").prop("checked", true);
        } else {
            $("#check_all").prop("checked", false);
        }
        if (total_checked_boxes > 0) {
            $(".process-selected").show();
        } else {
            $(".process-selected").hide();
        }
    }

    function clearSelectedCheckboxs() {
        $("#check_all").prop("checked", false);
        $(".process-selected").hide();

    }

    // function changeLead(staff_id, lead_id) {
    //     $.ajax({
    //         url: "leads/assignStaff/" + staff_id + "/" + lead_id,
    //         method: "GET",
    //         success: function(data) {
    //             alert(data);
    //         }
    //     });
    // }

    var start = moment().subtract(29, 'days');
    var end = moment();
    $('#created_date').daterangepicker({
        "showDropdowns": true,
        "showWeekNumbers": true,
        "showISOWeekNumbers": true,
        autoUpdateInput: false,
        locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
        },
        "ranges": {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
        "alwaysShowCalendars": true,
    });
    $('#created_date').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
    });
    $('#created_date').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });

    function loadData(myleads) {
        $('#lead_list').DataTable({
            @if($logged_in_user->isAdmin() || $logged_in_user->can('export lead, student data'))
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            @else
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end" >>rt<"ps-3"i><"pe-3"p>',
            @endif
            "processing": true,
            "serverSide": true,
            "language": {
                searchPlaceholder: "ID, Name, Mobile, Email, Lead Source/Details..."
            },
            "autoWidth": true,
            "responsive": true,
            "lengthMenu": [10, 25, 50, 100, 500],
            "ajax": {
                "url": "{{route('admin.ajaxleadlist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'status': $('#status_search').val(),
                    'leadtype': $('#leadtype').val(),
                    'lead_country': $('#lead_country').val(),
                    'branch': $('#branch').val(),
                    'next_followup_counselling_date': $('#next_followup_counselling_date').val(),
                    'created_date': $('#created_date').val(),
                    'assigned_to': $('#assigned_to').val(),
                    'myleads': $('#myleads:checked').val(),
                    'leadsWithNoFollowup': $('#leadsWithNoFollowup:checked').val(),
                    // 'excludeAgent': $('#excludeAgent:checked').val(),
                    // 'agentListOnly': $('#agentListOnly:checked').val(),
                    'followup_daterange': $('#followup_daterange').val(),
                    'lead_age': $('#lead_age').val(),
                    'no_activity_since': $('#no_activity_since').val(),
                    'lead_source': $('#lead_source').val(),
                    'country_pref': $('#country_pref').val(),

                    'study_level_filter': $('#study_level_filter').val(),
                    'course_interested_filter': $('#course_interested_filter').val(),
                    'intake_filter': $('#intake_filter').val(),
                    'service_pref': $('#service_pref').val(),
                    'tags_filter': $('#tags_filter').val()
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
                $('#bulk_operation').show();                
            },
            'order': [
                [13, 'desc']
            ],
            columns: [
                {
                    data: 'id'
                },
                {
                    data: 'id'
                },
                {
                    data: 'name',
                },
                {
                    data: 'lead_name',
                    visible: false,
                },
                {
                    data: 'email',
                    visible: false,
                },
                {
                    data: 'mobile',
                    visible: false,
                },
                {
                    data: 'whatsapp',
                    visible: false,
                },
                {
                    data: 'location',
                    visible: false,
                },
                {
                    data: 'branch',
                    visible: false,
                },
                {
                    data: 'export_status',
                    visible: false,
                },
                // {
                //     data: 'branch',
                //     orderable: false,
                // },
                {
                    data: 'next_followup',
                },
                {
                    data: 'status',
                    // orderable: false,
                },
                {
                    data: 'assigned_to_name',
                    // orderable: false,
                    //searchable: false,
                },
                // {
                //     data: 'last_followup'
                // },
                {
                    data: 'created_at',
                },
                {
                    data: 'actions',
                    orderable: false,
                    //searchable: false
                },
            ],
            "fnInitComplete": function (oSettings, json) {
                $("#filter-spin").hide();
                $("#filter-spin-button").text("Filter");
            },
            columnDefs: [{
                    targets: 0,
                    orderable: false,
                    render: function(data) {
                        if (data != '') {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" onclick="javascript:checkboxCheckSelected();" name="multiselect" type="checkbox" value="${data}" />
                                </div>`;
                        } else {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" name="multiselectd" type="checkbox" value="" disabled />
                                </div>`;
                        }
                    }
                },

            ],
            @if(isset($search) && strlen($search))
                "search": {
                    "search": "{{$search}}"
                },
            @endif
            @if($logged_in_user->isAdmin() || $logged_in_user->can('export lead, student data'))
            "buttons": [
                {
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [13, 1, 3, 4, 5, 6, 7, 8, 9, 10, 12]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [13, 1, 3, 4, 5, 6, 7, 8, 9, 10, 12]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13]
                    }
                },
            ]
            @endif
        });
    }

    $(document).on('click', '.add-tag-btn', function() {
        var this_id = $(this).attr('data-id');
            $('#tag_lead_id').val(this_id);
            $('#createTagModal').modal('show');
            $('#createTagModal').on('hidden.bs.modal', function() {
                $('#tag_lead_id').val('');
                $('#lead_tags').val("").trigger("change");
            });
    });

    $(document).on('click', '.remove-tag', function(event) {
        event.preventDefault();
        var lead_id = $(this).attr('id');
        var tag_name = $(this).attr('data-tag_name');
        $.ajax({
            url: "{{route('admin.leadmanagement.remove-tag')}}",
            type: "POST",
            data: {
                lead_id: lead_id,
                tag_name: tag_name,
                _token: '{{csrf_token()}}'
            },
            context: this,
            success: function (result) {
                if(result.success){
                    var table = $('#lead_list').DataTable();
                    table.draw( false );
                } else{
                    swal.fire({
                        title: result.message,
                        icon: "error",
                        button: "ok",
                    });
                }
            }
        }); 
    });

    $(document).on('click', '.lead-status-row', function(event) {
        event.preventDefault();
        var lead = $(this).attr('id');
        var lead_id = $(this).attr('data-lead_id');
        var lead_status = $(this).attr('data-lead_status');
        $.ajax({
            url: "{{route('admin.leads.changestatus')}}",
            type: "POST",
            data: {
                lead_id: lead_id,
                lead_status: lead_status,
                _token: '{{csrf_token()}}'
            },
            context: this,
            success: function (result) {
                if(result.success){
                    swal.fire({
                        title: result.message,
                        icon: "success",
                        button: "ok",
                    });
                    var table = $('#lead_list').DataTable();
                    table.draw( false );
                } else{
                    swal.fire({
                        title: result.message,
                        icon: "error",
                        button: "ok",
                    });
                }
            }
        }); 
    });

    $(document).on('click', '.followup-btn', function() {
        var this_id = $(this).attr('data-id');

        var base_url = "{{ url('admin/lead/')}}/" + this_id + "/followups";
        $.get(base_url, function(data) {
            $('#followupsModal').on('shown.bs.modal', function() {
                $('#followupsModal .load_modal').html(data);
            });
            $('#followupsModal').modal('show');
            $('#followupsModal').on('hidden.bs.modal', function() {
                $('#followupsModal .load_modal').html("");
            });
        });
    });

    $(document).on('click', '.counselling-btn', function() {
        var this_id = $(this).attr('data-id');

        var base_url = "{{ url('admin/lead/')}}/" + this_id + "/counselling";
        $.get(base_url, function(data) {
            $('#counsellingModal').on('shown.bs.modal', function() {
                $('#counsellingModal .load_modal').html(data);
            });
            $('#counsellingModal').modal('show');
            $('#counsellingModal').on('hidden.bs.modal', function() {
                $('#counsellingModal .load_modal').html("");
            });
        });
    });

    $(document).on('click', '.disqualified-btn', function() {
        var this_id = $(this).attr('data-id');
        var base_url = "{{ url('admin/lead/')}}/" + this_id + "/disqualified";
        $.get(base_url, function(data) {
            $('#disqualifiedModal').on('shown.bs.modal', function() {
                $('#disqualifiedModal .load_modal').html(data);
            });
            $('#disqualifiedModal').modal('show');
            $('#disqualifiedModal').on('hidden.bs.modal', function() {
                $('#disqualifiedModal .load_modal').html("");
            });
        });
    });

    $(document).on('click', '.assigned_to_staff', function() {
        var this_id = $(this).attr('data-id');

        var base_url = "{{ url('admin/lead/assignstaff/')}}/" + this_id;
        $.get(base_url, function(data) {
            $('#leadAssignedStaffModal').on('shown.bs.modal', function() {
                $('#leadAssignedStaffModal .load_modal').html(data);
            });
            $('#leadAssignedStaffModal').modal('show');
            $('#leadAssignedStaffModal').on('hidden.bs.modal', function() {
                $('#leadAssignedStaffModal .load_modal').html("");
            });
        });
    });

    function searchTable() {
        $("#filter-spin").show();
        $("#filter-spin-button").text("Filtering");
        $("#lead_list").dataTable().fnDestroy();
        loadData();
        // $("#loader").hide();
    }

    function clearTable() {
        $("#filter-spin").show();
        $('#status_search').val('').trigger('change');
        // $('#country_pref').val('').trigger('change');
        // $('#lead_source').val('').trigger('change');
        $('#next_followup_counselling_date').val('--').trigger('change');
        $('#created_date').val(''); 
        $('#leadtype').val('');
        $('#assigned_to').val('');
        $('#lead_country').val('');
        $('#branch').val('all');
        $('#next_followup_counselling_date').val('all');
        $('#followup_daterange').val('');
        $('#lead_age').val('');
        $('#no_activity_since').val('');
        $('#tags_filter').val('').trigger('change');
        $('#lead_source').val('').trigger('change');
        $('#country_pref').val('').trigger('change');

        $('#study_level_filter').val('').trigger('change');
        $('#course_interested_filter').val('').trigger('change');
        $('#intake_filter').val('').trigger('change');
        $('#service_pref').val('').trigger('change');
        $('#tags_filter').val('').trigger('change');
        $('#myleads').val('1').prop('checked',false);
        $('#leadsWithNoFollowup').val('1').prop('checked',false);
        // $('#excludeAgent').val('1').prop('checked',false);
        // $('#agentListOnly').val('1').prop('checked',false);

        $('#next_followup_counselling_date').val('--');
        $("#lead_list").dataTable().fnDestroy();
        $('#filters').slideToggle();
        $('#filter_more').text("More");
        loadData();
    }

    $("#next_followup_counselling_date").change(function() {
        if (this.value == 'custom') {
            $('#followup_daterange_box').removeClass('d-none');
        }else{
            $('#followup_daterange_box').addClass('d-none');            
        }
    });

    $('#add_tag_form').on('submit', function(e) {
        e.preventDefault();
        let lead_id = $('#tag_lead_id').val();
        let lead_tags = $('#lead_tags').val();
        $.ajax({
            url: "{{route('admin.leadmanagement.add-tag')}}",
            type: "POST",
            data: {
                "_token": "{{ csrf_token() }}",
                lead_id: lead_id,
                lead_tags: lead_tags,
            },
            success: function(result) {
                if(result.success){
                    swal.fire({
                        title: result.message,
                        icon: "success",
                        button: "ok",
                    });
                    $('#createTagModal').modal('hide');
                    var table = $('#lead_list').DataTable();
                    table.draw( false );
                } else{
                    swal.fire({
                        title: result.message,
                        icon: "error",
                        button: "ok",
                    });
                    $('#createTagModal').modal('hide');
                }
            },
            error: function(response) {
                swal.fire({
                    title: "Something went wrong!",
                    icon: "danger"
                });
            },
        });
    });

    // $("#excludeAgent").change(function() {
    //     $('#agentListOnly').val('1').prop('checked',false);
    // });
    // $("#agentListOnly").change(function() {
    //     $('#excludeAgent').val('1').prop('checked',false);
    // });

</script>
@endpush

@push ('after-styles')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
    .select2-container {
        width: 100% !important;
    }
    .select2-container.select2-container--default.select2-container--open {
        z-index: 5000;
    }

    .select2-container .select2-search--inline .select2-search__field{
        height: 10px !important;
        padding: 8px !important;
    }
    .select2-container--default .select2-selection--multiple{
        padding-bottom: 0px !important;
    }

    .edu-tooltip {
        position: relative;
        margin-top: -10px;
        /* margin-bottom: 0px; */
        /* display: inline-block; */
        /* border-bottom: 1px dotted black; */
    }

    .edu-tooltip .edu-tooltiptext {
        visibility: hidden;
        width: 300px;
        background-color: rgb(62, 62, 62);
        color: #fff;
        font-size: 0.9em;
        text-align: center;
        border-radius: 6px;
        padding: 5px 5px;
        position: absolute;
        z-index: 1;
        top: 100%;
        left: 50%;
        margin-left: -60px;
        line-height: 16px;
        font-size: 12px;
        text-wrap: wrap;
        font-style:normal;
    }

    .edu-tooltip .edu-tooltiptext::after {
        content: "";
        position: absolute;
        bottom: 100%;
        left: 20%;
        margin-left: -5px;
        border-width: 5px;
        border-style: solid;
        border-color: transparent transparent rgb(62, 62, 62) transparent;
    }

    .edu-tooltip:hover .edu-tooltiptext {
        visibility: visible;
    }
    .lead-horizontal {
        overflow-x: scroll;
    }
     
</style>
@endpush