@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->
                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('leads-settings')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general active show" id="banners">

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Add New Status</h4>
                                                <br />
                                                <form action="{{route('admin.lead-status.save')}}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-sm-12 col-md-6">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Status Name</b></label>
                                                                <input type="text" class="form-control" name="status_name" maxlength="200" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-sm-12 col-md-12">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Type</b></label>
                                                                <input class="form-check-input" type="radio" value='none' id="none" name="type" required checked>
                                                                <label class="form-check-label" for="none">
                                                                    None&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='default' id="default" name="type" required>
                                                                <label class="form-check-label" for="default">
                                                                    Default&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='counselling' id="counselling" name="type" required>
                                                                <label class="form-check-label" for="counselling">
                                                                    Counselling&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='converted' id="converted" name="type" required>
                                                                <label class="form-check-label" for="converted">
                                                                    Converted&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='disqualified' id="disqualified" name="type" required>
                                                                <label class="form-check-label" for="disqualified">
                                                                    Disqualified&nbsp;&nbsp;
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2" id="ddln_blk">
                                                        <div class="col-sm-12 col-md-3">
                                                            <label class=""><b>Deadline (Optional)</b></label>
                                                            <div class="input-group mb-0">
                                                                <input type="number" min="1" class="form-control" name="deadline" >
                                                                <div class="input-group-append">
                                                                  <span class="input-group-text" style="padding: 5px;">Days</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <small>Lead age (No. of days since lead is created) deadline to reach this status</small>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-sm-12 col-md-6">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Color</b></label>
                                                                <input type="text" autocomplete="off" class="form-control colorPicker" name="color" required />
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-12 col-md-6">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Order</b></label>
                                                                <input type="number" class="form-control" name="display_order" value="99" required />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="text-center">
                                                        <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-12">
                                        <hr>
                                        <h4>Existing Lead Status</h4>

                                        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                                            <table class="table table-striped bg-none mb-0">
                                                <thead class="tableHeading">
                                                    <tr>
                                                        <th>Status Name</th>
                                                        <th>Default</th>
                                                        <th>Counselling</th>
                                                        <th>Converted</th>
                                                        <th>Disqualified</th>
                                                        <th>Deadline</th>
                                                        <th>Order/Stage</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($status as $stat)
                                                    <?php
                                                    if ($stat->default == 0) {
                                                        $def = "";
                                                    } else {
                                                        $def = "Yes";
                                                    }
                                                    if ($stat->counselling_status == 0) {
                                                        $coun = "";
                                                    } else {
                                                        $coun = "Yes";
                                                    }
                                                    if ($stat->converted_status == 0) {
                                                        $conv = "";
                                                    } else {
                                                        $conv = "Yes";
                                                    }
                                                    if ($stat->disqualified_status == 0) {
                                                        $dis = "";
                                                    } else {
                                                        $dis = "Yes";
                                                    }
                                                    ?>
                                                    <tr>
                                                        <td><span class="tag" style="background-color:{{$stat->colorcode}} !important">{{$stat->status}}</span></td>
                                                        <td>{{$def}}</td>
                                                        <td>{{$coun}}</td>
                                                        <td>{{$conv}}</td>
                                                        <td>{{$dis}}</td>
                                                        <td>
                                                            {{($stat->deadline)? $stat->deadline." day(s)" : ''}}
                                                        </td>
                                                        <td>{{$stat->display_order}}</td>
                                                        <td>
                                                            <a title="Edit" href="" id="editStatus" data-toggle="modal" data-target='#practice_modal' data-id="{{ $stat->id }}" data-order="{{$stat->display_order}}" data-deadline="{{$stat->deadline}}" data-stat_default="{{$stat->default}}" data-stat_disqualified="{{$stat->disqualified_status}}" data-color="{{$stat->colorcode}}" data-status="{{$stat->status}}"><i class='fas fa-edit text-primary' style='font-size:17px'></i></a>&nbsp;
                                                            @if(get_default_lead_status() == $stat->status || get_converted_lead_status() == $stat->status || get_disqualified_lead_status() == $stat->status)
                                                            <a href="#"><i class='fas fa-trash-alt text-secondary' style='font-size:17px; cursor: not-allowed! important'></i></a>
                                                            @else
                                                            <a title="Delete" href="{{ route('admin.removeLeadStatus', $stat->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?"><i class='fas fa-trash-alt text-danger' style='font-size:17px'></i></a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <p class="mt-2">
                                            Notes:
                                            <ul>
                                                <li>'Default', 'Converted', 'Disqualified' statuses are required for proper functioning of Leads feature.</li>
                                                <li>When a Lead is created by staff or a student registers from the website, or a lead is imported, it will be in "Default" status value.</li>
                                                <li>When a Lead status is changed to "Counselling" status value, staff is asked to input Counsellor name & Counselling Date & time.</li>
                                                <li>When a Lead is "Converted", lead becomes a Student.</li>
                                            </ul>
                                        </p>

                                    </div>
                                </div>
                                    <hr>
                                <div class="row">
                                    <div class="col-12">
                                        <form method="post" action="{{route('admin.leads-settings.update')}}">
                                            @csrf
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <h4>Unassigned leads Notification</h4>
                                                        <div class="form-group">
                                                            <label>
                                                                <input disabled checked type="checkbox" class="" {{(get_site_config('unassigned_lead_notification_lead_age') > 0) ? 'checked' : ''}} > Send notification when lead is not assigned to staff and lead age is more than 
                                                                <input type="number" value="{{get_site_config('unassigned_lead_notification_lead_age')}}" class="form-control" name="unassigned_lead_notification_lead_age" style="display: inline; width:70px;"> days.
                                                            </label>
                                                        </div>
                                                        <small>Notification email is sent to Super admin daily at 10am</small>
                                                </div>
                                            </div>

                                            <hr>


                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <h4>Lead Follow-up Reminder Notifications</h4>
                                                        <div class="form-group">
                                                            <label>
                                                                <input type="checkbox" class="" name="lead_followup_reminder_notification" value="1" {{(get_site_config('lead_followup_reminder_notification') == 1) ? 'checked' : ''}} >
                                                                Email Assigned Staff.
                                                            </label>
                                                        </div>
                                                        <small>Notification emails sent hourly at xx:55</small>
                                                </div>
                                            </div>

                                            <hr>
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <h4>Lead Follow-up Missed Notifications</h4>
                                                        <div class="form-group">
                                                            <label>
                                                                <input type="checkbox" class="" name="lead_followup_missed_notification" value="1" {{(get_site_config('lead_followup_missed_notification') == 1) ? 'checked' : ''}} >
                                                                Email Assigned Staff, Reporting Manager & Superadmin.
                                                            </label>
                                                        </div>
                                                        <small>Notification emails sent daily at 8pm</small>
                                                </div>
                                            </div>

                                            <hr>
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <h4>Lead Stage Deadline Missed Notifications</h4>
                                                        <div class="form-group">
                                                            <label>
                                                                <input type="checkbox" class="" name="lead_stage_deadline_missed_notification" value="1" {{(get_site_config('lead_stage_deadline_missed_notification') == 1) ? 'checked' : ''}} >
                                                                Email Assigned Staff, Reporting Manager & Superadmin.
                                                            </label>
                                                        </div>
                                                        <small>Notification emails sent at 6pm</small>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <h4>Lead Status Change Restriction</h4>
                                                        <div class="form-group">
                                                            <label>
                                                                <input type="checkbox" class="" name="lead_status_change_restriction" value="1" {{(get_site_config('lead_followup_mandatory') == 1) ? 'checked' : ''}} >
                                                                Do not allow to change lead status without adding follow-up details
                                                            </label>
                                                        </div>
                                                </div>
                                            </div>
                                            <br>
                                                <div class="row ">
                                                    <div class="col-12">
                                                        <h4>Lead Disqualified Reasons</h4>
                                                            <div class="form-group">
                                                                <label class="required-field">Define the reasons for Lead Disqualification</label>
                                                                <input type="text" style="margin: 0%" class="form-control" name="lead_disqualified_reason" value="{{get_site_config('lead_disqualified_reason')}}" required>
                                                                <p class="small">Enter comma seperated values</p>
                                                            </div>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <h4>Mode of communication</h4>
                                                            <div class="form-group">
                                                                <label class="required-field">Define Mode Of Communication</label>
                                                                <input type="text" style="margin: 0%" class="form-control" name="communication_mode" value="{{get_site_config('communication_mode')}}" required>
                                                                <p class="small">Enter comma seperated values</p>
                                                            </div>
                                                    </div>
                                                </div>
                                                <br>
                                                <h4>Lead Sources</h4>
                                                    <div class="form-group">
                                                        <label class="required-field">Lead Sources</label>
                                                        <input type="text" style="margin: 0%"  class="form-control" name="lead_sources" value="{{get_site_config('lead_sources')}}" required>
                                                        <p class="small">Enter comma seperated values</p>
                                                    </div>
                                                    <br>
                                                    {{-- <h4>Automated Email/SMS to Leads</h4>
                                                    <div class="form-group">
                                                        <input type="checkbox" class="" name="lead_welcome_email_web2lead" value="1" @if(get_site_config('lead_welcome_email_web2lead')) checked @endif> <label class="">Send Welcome email to leads received through Web to Lead forms</label>
                                                    </div>
                                                    <div class="form-group">
                                                        <input type="checkbox" class="" name="lead_welcome_email_lead_create" value="1" @if(get_site_config('lead_welcome_email_lead_create')) checked @endif> <label class="">Send Welcome email to leads added from Admin panel</label>
                                                    </div>
                                                    <p class="small text-primary">&nbsp;&nbsp;&nbsp;&nbsp;<a target="_blank" href="{{route('admin.mailtemplates.edit','LEAD_WELCOME')}}">Edit Welcome email template <i class="bi bi-box-arrow-up-right"></i></a></p> --}}
                                            </div>
                                            <div class="form-group mx-auto col-sm-1" >
                                                <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                            </div>
                                    </form>
                                </div>

                            </div>


                        </div>

                    </div><!-- End Bordered Tabs -->

                </div>
            </div>
        </div>
    </div>
</div>
</div>


<div class="modal fade" id="status_update_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Status</h5>

                <button type="button" class="btn btn-sm btn-outline-dark" data-bs-dismiss="modal">&times;</button>
            </div>
            <form id="statusDataForm" method="POST" action="{{route('admin.lead-status.update')}}">
                @csrf
                <input type="hidden" id="status_id" name="status_id" value="">
                <div class="modal-body">
                    <span class="label"><b>Status</b></span>
                    <input type="text" autocomplete="off" name="edit_status" id="edit_status" value="" class="form-control">
                    <div class="row mb-2" id="edtddln_blk" style="display: none;">
                        <div class="col-sm-12 col-md-6">
                            <label class=""><b>Deadline (Optional)</b></label>
                            <div class="input-group mb-0">
                                <input type="number" min="1" class="form-control" id="deadline" name="deadline" >
                                <div class="input-group-append">
                                  <span class="input-group-text" style="padding: 5px;">Days</span>
                                </div>
                            </div>
                        </div>
                        <small>Lead age (No. of days since lead is created) deadline to reach this status</small>
                    </div>
                    <span class="label"><b>Color</b></span>
                    <input type="text" autocomplete="off" name="color" id="color" value="" class="form-control colorPicker" required>
                    <span class="label"><b>Order</b></span>
                    <input type="number" autocomplete="off" name="display_order" id="display_order" value="" class="form-control" required>
                    <span class="text-danger">If Status name is changed, any existing leads status will also be updated</span>
                    <div class="row mt-3">
                        <div class="col text-center">
                            <button type="submit" class="btn btn-md btn-primary" style="font-size: 0.9em;">Update</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    addDeleteForms();
    $('body').on('click', '#editStatus', function(event) {

        event.preventDefault();
        var id = $(this).data('id');
        var order = $(this).data('order');
        var deadline = $(this).data('deadline');
        var color = $(this).data('color');
        var edit_status = $(this).data('status');
        var stat_default = $(this).data('stat_default');
        var stat_disqualified = $(this).data('stat_disqualified');
        $('#status_update_modal').modal('show');
        $('#status_id').val(id);
        $('#color').val(color);
        if(stat_default != 1 && stat_disqualified != 1){
            $("#edtddln_blk").show();
        }else{
            $("#edtddln_blk").hide();
        }
        $('#deadline').val(deadline);
        $('#edit_status').val(edit_status);
        $('#display_order').val(order);

    });

    $('.form-check-input').change(function() {
                var inpt_type_val = $(this).val();
                if(inpt_type_val != "default" && inpt_type_val != "disqualified"){
                    $("#ddln_blk").show();
                }
                else{
                    $("#ddln_blk").hide();
                    
                }
            });
</script>
@endpush