<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <title>Study Abroad</title>

  <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-one/css/carousel.min.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-one/css/owl.theme.default.min.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-one/css/bootstrap.min.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-one/font/font.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-one/css/style.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-one/css/responsive.css')}}">

</head>

<body>

  <header class="header-main">
    <div class="container">
      <div class="header">
        <div class="logo">
          <a href="{{ route('index') }}"><img src="{{ asset('storage/'.get_site_config('website_logo')) }}" alt="logo" /></a>
        </div>
        <div class="header-right navbar" id="navbar">
          <div class="cross-icon" id="close-icon">
            <img src="{{ asset('assets/landing-pages/assets-one/images/cross-icon.webp')}}" alt="cross-icon" />
          </div>
          <nav class="menu">
            <!--<ul>
              <li><a href="#">Home</a></li>
              <li><a href="#">About us</a></li>
              <li><a href="#">Contact us</a></li>
            </ul>-->
          </nav>
        </div>
        <div class="d-flex justify-content-end w-auto">
          <a style="font-size:24px;" href="tel:{{get_site_config('contact_phone')}}" class="text-nowrap"><i class="fa-solid fa-phone"></i> {{get_site_config('contact_phone')}}</a>
        </div>
        <!-- <div class="burger" id="burger">
          <span class="burger-line"></span>
          <span class="burger-line"></span>
          <span class="burger-line"></span>
        </div> -->
        <span class="overlay"></span>
      </div>
    </div>
  </header>

  <section class="banner-section">
    <div class="container">
      <div class="banner-main">
        <div class="banner-content">
          <h1>{!!$p1_banner_heading!!}</h1>
          <p style="font-size:22px;color: #787878;font-weight: 600;">{!!$p1_banner_desc!!}</p>
          <!-- <a class="primary-btn" href="{{ route('index') }}">Know More</a> -->
        </div>
        <div class="banner-image">
          <img src="{{ asset('assets/landing-pages/assets-one/images/banner.svg')}}" alt="banner" />
        </div>
      </div>
    </div>
  </section>

  <section class="education-section">
    <div class="container">
      <div class="education-main">
        <div class="education-content">
          <h2 class="heading">Offering The Best In Education To The World</h2>
          <div class="education-content-points">
            <div class="education-content-point">
              <div class="icon">
                <img src="{{ asset('assets/landing-pages/assets-one/images/poststudy.png')}}" alt="" />
              </div>
              <h3>{!!$p1_intro_b1_title!!}</h3>
              <p>{!!$p1_intro_b1_desc!!}</p>
            </div>
            <div class="education-content-point">
              <div class="icon">
                <img src="{{ asset('assets/landing-pages/assets-one/images/jobmarket.png')}}" alt="" />
              </div>
              <h3>{!!$p1_intro_b2_title!!}</h3>
              <p>{!!$p1_intro_b2_desc!!}</p>
            </div>
            <div class="education-content-point">
              <div class="icon">
                <img src="{{ asset('assets/landing-pages/assets-one/images/programs.png')}}" alt="" />
              </div>
              <h3>{!!$p1_intro_b3_title!!}</h3>
              <p>{!!$p1_intro_b3_desc!!}</p>
            </div>
            <div class="education-content-point">
              <div class="icon">
                <img src="{{ asset('assets/landing-pages/assets-one/images/scholarship.png')}}" alt="" />
              </div>
              <h3>{!!$p1_intro_b4_title!!}</h3>
              <p>{!!$p1_intro_b4_desc!!}</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="university-section">
    <h2 class="heading">Top Universities</h2>
    <div class="university-slider owl-carousel owl-theme ">
      <div class="university item">
        <img src="{{ asset('storage/media-upload/university-01.png')}}" alt="university" />
      </div>
      <div class="university item">
        <img src="{{ asset('storage/media-upload/university-02.png')}}" alt="university" />
      </div>
      <div class="university item">
        <img src="{{ asset('storage/media-upload/university-03.png')}}" alt="university" />
      </div>
      <div class="university item">
        <img src="{{ asset('storage/media-upload/university-04.png')}}" alt="university" />
      </div>
      <div class="university item">
        <img src="{{ asset('storage/media-upload/university-05.png')}}" alt="university" />
      </div>
    </div>
  </section>

  <section class="content-with-image-section">
    <div class="container">
      <div class="content-with-image-main">
        <div class="content-with-image">
          <div class="content">
            <h3>{!!$p1_ub1_title!!}</h3>
            <p>{!!$p1_ub1_desc!!}</p>
          </div>
          <div class="image">
            <img src="{{ asset('assets/landing-pages/assets-one/images/australia1.jpg')}}" alt="" />
          </div>
        </div>
        <div class="content-with-image">
          <div class="image">
            <img src="{{ asset('assets/landing-pages/assets-one/images/australia2.jpg')}}" alt="" />
          </div>
          <div class="content">
            <h3>{!!$p1_ub2_title!!}</h3>
            <p>{!!$p1_ub2_desc!!}</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="counter-section">
    <div class="container">
      <div class="counter-main">
        <div class="counter">
          <h5>100+</h5>
          <p>University</p>
        </div>
        <div class="counter">
          <h5>95%</h5>
          <p>Visa Success</p>
        </div>
        <div class="counter">
          <h5>5K+</h5>
          <p>Students Enrolled</p>
        </div>
      </div>
    </div>
  </section>

  <section class="contactus-section">
    <div class="container">
      <div class="contactus-main">
        <div class="contactus-left">
          <img src="{{ asset('assets/landing-pages/assets-one/images/contactus.jpg')}}" alt="contactus" />
        </div>
        <div class="contactus-right">
          <form class="contact-form" action="{{route('web-to-lead-tracking')}}" method='POST'>
            <input type='hidden' name='wl_staff' value='1'>
            <input type='hidden' name='wl_staff_branch' value='1'>
            <h4>Book Free Counseling</h4>
            <p>Share your details to get a callback from our team.</p>
            <div class="field">
              <input type="text" id="wl_first_name" name="wl_first_name" placeholder="Name*" required>
            </div>
            <div class="field">
              <input type="text" id="wl_email" name="wl_email" placeholder="Email*" required>
            </div>
            <div class="field">
              <select class="form-select form-control" name="wl_dialcode" id="wl_dialcode" style="width:100px;">
                <option value="1">1</option>
                <option value="7">7</option>
                <option value="20">20</option>
                <option value="27">27</option>
                <option value="30">30</option>
                <option value="31">31</option>
                <option value="32">32</option>
                <option value="33">33</option>
                <option value="34">34</option>
                <option value="36">36</option>
                <option value="38">38</option>
                <option value="39">39</option>
                <option value="40">40</option>
                <option value="41">41</option>
                <option value="43">43</option>
                <option value="44">44</option>
                <option value="45">45</option>
                <option value="46">46</option>
                <option value="47">47</option>
                <option value="48">48</option>
                <option value="49">49</option>
                <option value="51">51</option>
                <option value="52">52</option>
                <option value="53">53</option>
                <option value="54">54</option>
                <option value="55">55</option>
                <option value="56">56</option>
                <option value="57">57</option>
                <option value="58">58</option>
                <option value="60">60</option>
                <option value="61">61</option>
                <option value="62">62</option>
                <option value="63">63</option>
                <option value="64">64</option>
                <option value="65">65</option>
                <option value="66">66</option>
                <option value="70">70</option>
                <option value="81">81</option>
                <option value="82">82</option>
                <option value="84">84</option>
                <option value="86">86</option>
                <option value="90">90</option>
                <option value="91">91</option>
                <option value="92">92</option>
                <option value="93">93</option>
                <option value="94">94</option>
                <option value="95">95</option>
                <option value="98">98</option>
                <option value="211">211</option>
                <option value="212">212</option>
                <option value="213">213</option>
                <option value="216">216</option>
                <option value="218">218</option>
                <option value="220">220</option>
                <option value="221">221</option>
                <option value="222">222</option>
                <option value="223">223</option>
                <option value="224">224</option>
                <option value="225">225</option>
                <option value="226">226</option>
                <option value="227">227</option>
                <option value="228">228</option>
                <option value="229">229</option>
                <option value="230">230</option>
                <option value="231">231</option>
                <option value="232">232</option>
                <option value="233">233</option>
                <option value="234">234</option>
                <option value="235">235</option>
                <option value="236">236</option>
                <option value="237">237</option>
                <option value="238">238</option>
                <option value="239">239</option>
                <option value="240">240</option>
                <option value="241">241</option>
                <option value="242">242</option>
                <option value="244">244</option>
                <option value="245">245</option>
                <option value="246">246</option>
                <option value="248">248</option>
                <option value="249">249</option>
                <option value="250">250</option>
                <option value="251">251</option>
                <option value="252">252</option>
                <option value="253">253</option>
                <option value="254">254</option>
                <option value="255">255</option>
                <option value="256">256</option>
                <option value="257">257</option>
                <option value="258">258</option>
                <option value="260">260</option>
                <option value="261">261</option>
                <option value="262">262</option>
                <option value="263">263</option>
                <option value="264">264</option>
                <option value="265">265</option>
                <option value="266">266</option>
                <option value="267">267</option>
                <option value="268">268</option>
                <option value="269">269</option>
                <option value="290">290</option>
                <option value="291">291</option>
                <option value="297">297</option>
                <option value="298">298</option>
                <option value="299">299</option>
                <option value="350">350</option>
                <option value="351">351</option>
                <option value="352">352</option>
                <option value="353">353</option>
                <option value="354">354</option>
                <option value="355">355</option>
                <option value="356">356</option>
                <option value="357">357</option>
                <option value="358">358</option>
                <option value="359">359</option>
                <option value="370">370</option>
                <option value="371">371</option>
                <option value="372">372</option>
                <option value="373">373</option>
                <option value="374">374</option>
                <option value="375">375</option>
                <option value="376">376</option>
                <option value="377">377</option>
                <option value="378">378</option>
                <option value="380">380</option>
                <option value="381">381</option>
                <option value="385">385</option>
                <option value="386">386</option>
                <option value="387">387</option>
                <option value="389">389</option>
                <option value="420">420</option>
                <option value="421">421</option>
                <option value="423">423</option>
                <option value="500">500</option>
                <option value="501">501</option>
                <option value="502">502</option>
                <option value="503">503</option>
                <option value="504">504</option>
                <option value="505">505</option>
                <option value="506">506</option>
                <option value="507">507</option>
                <option value="508">508</option>
                <option value="509">509</option>
                <option value="590">590</option>
                <option value="591">591</option>
                <option value="592">592</option>
                <option value="593">593</option>
                <option value="594">594</option>
                <option value="595">595</option>
                <option value="596">596</option>
                <option value="597">597</option>
                <option value="598">598</option>
                <option value="599">599</option>
                <option value="670">670</option>
                <option value="672">672</option>
                <option value="673">673</option>
                <option value="674">674</option>
                <option value="675">675</option>
                <option value="676">676</option>
                <option value="677">677</option>
                <option value="678">678</option>
                <option value="679">679</option>
                <option value="680">680</option>
                <option value="681">681</option>
                <option value="682">682</option>
                <option value="683">683</option>
                <option value="684">684</option>
                <option value="686">686</option>
                <option value="687">687</option>
                <option value="688">688</option>
                <option value="689">689</option>
                <option value="690">690</option>
                <option value="691">691</option>
                <option value="692">692</option>
                <option value="850">850</option>
                <option value="852">852</option>
                <option value="853">853</option>
                <option value="855">855</option>
                <option value="856">856</option>
                <option value="880">880</option>
                <option value="886">886</option>
                <option value="960">960</option>
                <option value="961">961</option>
                <option value="962">962</option>
                <option value="963">963</option>
                <option value="964">964</option>
                <option value="965">965</option>
                <option value="966">966</option>
                <option value="967">967</option>
                <option value="968">968</option>
                <option value="970">970</option>
                <option value="971">971</option>
                <option value="972">972</option>
                <option value="973">973</option>
                <option value="974">974</option>
                <option value="975">975</option>
                <option value="976">976</option>
                <option value="977">977</option>
                <option value="992">992</option>
                <option value="994">994</option>
                <option value="995">995</option>
                <option value="996">996</option>
                <option value="998">998</option>
                <option value="1242">1242</option>
                <option value="1246">1246</option>
                <option value="1264">1264</option>
                <option value="1268">1268</option>
                <option value="1284">1284</option>
                <option value="1340">1340</option>
                <option value="1345">1345</option>
                <option value="1441">1441</option>
                <option value="1473">1473</option>
                <option value="1649">1649</option>
                <option value="1664">1664</option>
                <option value="1670">1670</option>
                <option value="1671">1671</option>
                <option value="1684">1684</option>
                <option value="1758">1758</option>
                <option value="1767">1767</option>
                <option value="1784">1784</option>
                <option value="1787">1787</option>
                <option value="1809">1809</option>
                <option value="1868">1868</option>
                <option value="1869">1869</option>
                <option value="1876">1876</option>
                <option value="7370">7370</option>
              </select>
              <input type='text' name='wl_mobile' id='wl_mobile' class='form-control' placeholder='Mobile No.*'>
            </div>
            <button type="submit" class="secondary-btn">Submit</button>
          </form>
        </div>
      </div>
    </div>
  </section>

  <footer>
    <div class="container">
      <div class="footer-main">
        <div class="logo">
          <a href="{{ route('index') }}"><img src="{{ asset('storage/'.get_site_config('website_sticky_logo')) }}" /></a>
        </div>
      </div>
      <!-- <div class="social-media">
          <a href="#" class="icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
              <path d="M9 22H15C20 22 22 20 22 15V9C22 4 20 2 15 2H9C4 2 2 4 2 9V15C2 20 4 22 9 22Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
              <path d="M12 15.5C13.933 15.5 15.5 13.933 15.5 12C15.5 10.067 13.933 8.5 12 8.5C10.067 8.5 8.5 10.067 8.5 12C8.5 13.933 10.067 15.5 12 15.5Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
              <path d="M17.6361 7H17.6477" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
              </svg>
          </a>
          <a href="#" class="icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
              <path d="M24 14.8498V24.1202H18.8341V15.4151C18.8341 13.2671 18.0807 11.7974 16.2511 11.7974C14.852 11.7974 13.991 12.8149 13.6682 13.7193C13.5605 14.0585 13.4529 14.5107 13.4529 15.0759V24.1202H8.28699C8.28699 24.1202 8.39462 9.4233 8.28699 7.95361H13.4529V10.2147C14.0987 9.08414 15.3901 7.5014 18.0807 7.5014C21.417 7.5014 24 9.87551 24 14.8498ZM2.90583 0.152954C1.18385 0.152954 0 1.39654 0 2.97928C0 4.56202 1.07623 5.8056 2.79821 5.8056C4.6278 5.8056 5.70404 4.56202 5.70404 2.97928C5.81166 1.28348 4.73542 0.152954 2.90583 0.152954ZM0.322869 24.1202H5.48879V7.95361H0.322869V24.1202Z" fill="white"/>
              </svg>
          </a>
          <a href="#" class="icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="15" height="29" viewBox="0 0 15 29" fill="none">
              <path d="M9.24292 6.18382C9.24292 5.02153 10.3603 4.60401 11.6113 4.60401C12.8623 4.60401 14.1984 4.96511 14.1984 4.96511L15 0.541647C15 0.541647 13.2996 0 9.24292 0C6.75304 0 5.30769 0.880177 4.25101 2.17788C3.25506 3.40787 3.21862 5.38263 3.21862 6.65776V9.55784H0V13.8797H3.21862V28.8879H9.24292V13.8797H14.0162L14.3684 9.55784H9.24292V6.18382Z" fill="white"/>
              </svg>
          </a>
        </div>       -->
    </div>
  </footer>

  <script src="{{ asset('assets/landing-pages/assets-one/js/jquery.min.js')}}"></script>
  <script src="{{ asset('assets/landing-pages/assets-one/js/bootstrap.min.js')}}"></script>
  <script src="{{ asset('assets/landing-pages/assets-one/js/owl.carousel.js')}}"></script>
  <script src="{{ asset('assets/landing-pages/assets-one/js/script.js')}}"></script>

</body>

</html>