<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <title>Study Abroad</title>
    <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-two/fonts/fonts.css')}}">
    <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-two/css/style.css')}}">
    <link rel="stylesheet" href="{{ asset('assets/landing-pages/assets-two/css/responsive.css')}}">

</head>

<body class="bg-body-white">
    <header class="header">
        <div class="container">
            <div class="header-inner">
                <a href="#" class="header-logo">
                    <img src="{{ asset('storage/'.get_site_config('website_sticky_logo')) }}" style="height:60px;" alt="logo" />
                </a>
                <!-- <div class="close-icon"></div> -->
                <div class="header-nav">
                    <nav class="nav">
                        <!-- <ul class="nav-menu">
                            <li class="nav-item">
                                <a href="#" class="nav-link active">Home</a>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link">About Us</a>
                            </li>
                        </ul>
                        <a href="#" class="border-button">Sign In</a> -->
                    </nav>
                </div>

                <div class="button-group">
                    <!-- <div class="bar-icon">
                        <span class="bar-line"></span>
                        <span class="bar-line"></span>
                        <span class="bar-line"></span>
                    </div> -->
                    <!-- <div class="overlay"></div> -->
                </div>
                <div>
                    <h3 class="ms-e" id="hello"><a href="tel:{{get_site_config('contact_phone')}}" style="color:white;"><i class="fa-solid fa-phone"></i>{{get_site_config('contact_phone')}}</a></h3>
                </div>
            </div>
        </div>
    </header>

    <div class="home-banner">
        <div class="container">
            <div class="content">
                <h1>{{$p2_banner_heading}}</h1>
                <p>{{$p2_banner_desc}}</p>

                <!-- <div class="button-ineen">
                    <a href="#" class="button-white">FREE one on one consultation</a>
                </div> -->
            </div>
        </div>
    </div>

    <div class="container">
        <div class="about-tripgo">
            <div class="about-content">
                <h2 class="heading-section">{!!$p2_intro_title!!}</h2>
                <p>{!!$p2_intro_desc!!}</p>
                <!--<div class="icon-read-more">
                    <a href="#" class="read-more-button">Read more <i class="icon-icon-16"></i></a>
                </div>-->
            </div>
            <div class="about-image">
                <img src="{{ asset('assets/landing-pages/assets-two/images/hero-image2.svg')}}" alt="About">
            </div>
        </div>
    </div>

    <div class="top-most-section">
        <div class="top-most-wrapper">
            <h5>World's Top destinations for aspiring students</h5>
            <div class="top-most-list">
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>Canada</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>Australia</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>United Kingdom</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>United States</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>Germany</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>France</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>Ireland</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>Singapore</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
                <div class="top-most-item">
                    <div class="destinations-name">
                        <p>New Zealand</p>
                    </div>
                    <!--<a href="#" class="destinations-link"><i class="icon-icon-17"></i></a>-->
                </div>
            </div>
            <!-- <a href="#" class="show-morw-link">Show More</a> -->
        </div>
    </div>

    <div class="container">
        <div class="why-tripgo">
            <h4 class="heading-section">WHY <span>{{app_name()}}</span></h4>

            <div class="why-tripgo-wrapper">
                <div class="tripgo-wrapper-box">
                    <div class="icon-box">
                        <img src="{{ asset('assets/landing-pages/assets-two/images/save-time.svg')}}" alt="">
                    </div>
                    <div class="tripgo-wrapper-info">
                        <h6>{{$p2_study_b1_title}}</h6>
                        <p>{!!$p2_study_b1_desc!!}</p>
                    </div>
                </div>
                <div class="tripgo-wrapper-box">
                    <div class="icon-box">
                        <img src="{{ asset('assets/landing-pages/assets-two/images/meet-fellow.svg')}}" alt="">
                    </div>
                    <div class="tripgo-wrapper-info">
                        <h6>{{$p2_study_b2_title}}</h6>
                        <p>{!!$p2_study_b2_desc!!}</p>
                    </div>
                </div>
                <div class="tripgo-wrapper-box">
                    <div class="icon-box">
                        <img src="{{ asset('assets/landing-pages/assets-two/images/travel-more.svg')}}" alt="">
                    </div>
                    <div class="tripgo-wrapper-info">
                        <h6>{{$p2_study_b3_title}}</h6>
                        <p>{!!$p2_study_b3_desc!!}</p>
                    </div>
                </div>
                <div class="tripgo-wrapper-box">
                    <div class="icon-box">
                        <img src="{{ asset('assets/landing-pages/assets-two/images/avoid.svg')}}" alt="">
                    </div>
                    <div class="tripgo-wrapper-info">
                        <h6>{{$p2_study_b4_title}}</h6>
                        <p>{!!$p2_study_b4_desc!!}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-add_new">
        <div class="container">
            <div class="faq-main-section">
                <div class="title-icon-box">
                    <i class="icon-icon-39"></i>
                    <div class="title-content-faq">
                        <h5 class="heading-section">Students - <span>Frequently Asked Questions</span></h5>
                        <p>You study abroad questions answered...</p>
                    </div>
                </div>
                <div id="accordion" class="faq-accordion">
                    <div class="faq-item">
                        <div class="faq-header is-active">
                            <p class="faqs-title">
                                What are the academic requirements for studying abroad?
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                The academic requirements for studying abroad vary depending on the program and the university. However, most programs require a minimum GPA mentioned in the program page. Some programs may also require specific coursework or test scores.
                            </p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-header">
                            <p class="faqs-title">
                                Is the English language test mandatory for university admission?
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                The language test is a requirement, as we use it to determine your level of English. It is, however, possible to secure university admission before taking the test.
                            </p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-header">
                            <p class="faqs-title">
                                How long does the application process take?
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                The application process for studying abroad can vary depending on the program and the university. However, it is generally a good idea to start planning at least 12 months in advance. This will give you enough time to research programs, gather the required documentation, and complete the application process.
                            </p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-header">
                            <p class="faqs-title">
                                When is the right time to apply for overseas education?
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                August to December months of the preceding year of academics is the most important period for students planning to study abroad. It is the time period during which the applications are accepted.
                            </p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-header">
                            <p class="faqs-title">
                                Can I apply for multiple study abroad programs?
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                Yes, you can apply for multiple study abroad programs. However, it is important to note that each program has its own application deadline. So, you will need to carefully plan your application schedule.
                            </p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-header">
                            <p class="faqs-title">
                                How can you assist me with my application documents
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                We'll assist you with your application documents by providing you with information about the required documentation and by helping you to proofread and edit your application essays and letters of recommendation.
                            </p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-header">
                            <p class="faqs-title">
                                What's the least and maximum cost to study abroad?
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                Cost of studying undergraduate courses: Undergraduate courses will cost anywhere between INR 8 lakhs and INR 20 lakhs.
                            </p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-header">
                            <p class="faqs-title">
                                Do I get a work permit after I graduate?
                            </p>
                            <i class="icon-icon-30 icon"></i>
                        </div>
                        <div class="faq-content">
                            <p>
                                Depending on the destination you choose, you may be able to obtain a work visa for up to 3 years. You will also be allowed to work during the academic year.
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="about-car-dots faq-line-center">
            <div class="about-dots-left">
                <img src="{{ asset('assets/landing-pages/assets-two/images/dots-left.svg')}}" alt="">
            </div>
            <div class="container">
                <div class="car-aboutus">
                    <hr class="border01">
                </div>
            </div>
            <div class="about-dots-right">
                <img src="{{ asset('assets/landing-pages/assets-two/images/dots-right.svg')}}" alt="">
            </div>
        </div>
        <div class="container">
            <div class="customer-support-section" id="support">
                <h6 class="heading-section">Get In Touch</h6>
                <p class="sub-text-customer">Fill in the form for a one-on-one session with our expert study abroad consultants.</p>
                <div class="customer-support-box">
                    <div class="images-support">
                        <img src="{{ asset('assets/landing-pages/assets-two/images/customer-support.png')}}" alt="">
                    </div>
                    <form class="customer-support-form" action='{{route('web-to-lead-tracking')}}' method='POST'>
                        <input type='hidden' name='wl_staff' value='1'>
                        <input type='hidden' name='wl_staff_branch' value='1'>

                        <div class="input-row">
                            <div class="input-field">
                                <label for="first_name">Your Name*</label>
                                <input type="text" id="wl_first_name" name="wl_first_name" placeholder="Enter Name" required>
                            </div>
                        </div>
                        <div class="input-row">
                            <div class="input-field">
                                <label for="email_address">Email Address*</label>
                                <input type="email" name="wl_email" id="wl_email" placeholder="Enter email address" required>
                            </div>
                        </div>
                        <div class="input-row">
                            <label for="mobile" class="input-field">Mobile No.*</label>
                            <div class="input-field" style="flex-direction: row !important; margin-top: -12px !important;">
                                <select class="form-select form-control" name="wl_dialcode" id="wl_dialcode" style="width:100px;">
                                    <option value="1">1</option>
                                    <option value="7">7</option>
                                    <option value="20">20</option>
                                    <option value="27">27</option>
                                    <option value="30">30</option>
                                    <option value="31">31</option>
                                    <option value="32">32</option>
                                    <option value="33">33</option>
                                    <option value="34">34</option>
                                    <option value="36">36</option>
                                    <option value="38">38</option>
                                    <option value="39">39</option>
                                    <option value="40">40</option>
                                    <option value="41">41</option>
                                    <option value="43">43</option>
                                    <option value="44">44</option>
                                    <option value="45">45</option>
                                    <option value="46">46</option>
                                    <option value="47">47</option>
                                    <option value="48">48</option>
                                    <option value="49">49</option>
                                    <option value="51">51</option>
                                    <option value="52">52</option>
                                    <option value="53">53</option>
                                    <option value="54">54</option>
                                    <option value="55">55</option>
                                    <option value="56">56</option>
                                    <option value="57">57</option>
                                    <option value="58">58</option>
                                    <option value="60">60</option>
                                    <option value="61">61</option>
                                    <option value="62">62</option>
                                    <option value="63">63</option>
                                    <option value="64">64</option>
                                    <option value="65">65</option>
                                    <option value="66">66</option>
                                    <option value="70">70</option>
                                    <option value="81">81</option>
                                    <option value="82">82</option>
                                    <option value="84">84</option>
                                    <option value="86">86</option>
                                    <option value="90">90</option>
                                    <option value="91">91</option>
                                    <option value="92">92</option>
                                    <option value="93">93</option>
                                    <option value="94">94</option>
                                    <option value="95">95</option>
                                    <option value="98">98</option>
                                    <option value="211">211</option>
                                    <option value="212">212</option>
                                    <option value="213">213</option>
                                    <option value="216">216</option>
                                    <option value="218">218</option>
                                    <option value="220">220</option>
                                    <option value="221">221</option>
                                    <option value="222">222</option>
                                    <option value="223">223</option>
                                    <option value="224">224</option>
                                    <option value="225">225</option>
                                    <option value="226">226</option>
                                    <option value="227">227</option>
                                    <option value="228">228</option>
                                    <option value="229">229</option>
                                    <option value="230">230</option>
                                    <option value="231">231</option>
                                    <option value="232">232</option>
                                    <option value="233">233</option>
                                    <option value="234">234</option>
                                    <option value="235">235</option>
                                    <option value="236">236</option>
                                    <option value="237">237</option>
                                    <option value="238">238</option>
                                    <option value="239">239</option>
                                    <option value="240">240</option>
                                    <option value="241">241</option>
                                    <option value="242">242</option>
                                    <option value="244">244</option>
                                    <option value="245">245</option>
                                    <option value="246">246</option>
                                    <option value="248">248</option>
                                    <option value="249">249</option>
                                    <option value="250">250</option>
                                    <option value="251">251</option>
                                    <option value="252">252</option>
                                    <option value="253">253</option>
                                    <option value="254">254</option>
                                    <option value="255">255</option>
                                    <option value="256">256</option>
                                    <option value="257">257</option>
                                    <option value="258">258</option>
                                    <option value="260">260</option>
                                    <option value="261">261</option>
                                    <option value="262">262</option>
                                    <option value="263">263</option>
                                    <option value="264">264</option>
                                    <option value="265">265</option>
                                    <option value="266">266</option>
                                    <option value="267">267</option>
                                    <option value="268">268</option>
                                    <option value="269">269</option>
                                    <option value="290">290</option>
                                    <option value="291">291</option>
                                    <option value="297">297</option>
                                    <option value="298">298</option>
                                    <option value="299">299</option>
                                    <option value="350">350</option>
                                    <option value="351">351</option>
                                    <option value="352">352</option>
                                    <option value="353">353</option>
                                    <option value="354">354</option>
                                    <option value="355">355</option>
                                    <option value="356">356</option>
                                    <option value="357">357</option>
                                    <option value="358">358</option>
                                    <option value="359">359</option>
                                    <option value="370">370</option>
                                    <option value="371">371</option>
                                    <option value="372">372</option>
                                    <option value="373">373</option>
                                    <option value="374">374</option>
                                    <option value="375">375</option>
                                    <option value="376">376</option>
                                    <option value="377">377</option>
                                    <option value="378">378</option>
                                    <option value="380">380</option>
                                    <option value="381">381</option>
                                    <option value="385">385</option>
                                    <option value="386">386</option>
                                    <option value="387">387</option>
                                    <option value="389">389</option>
                                    <option value="420">420</option>
                                    <option value="421">421</option>
                                    <option value="423">423</option>
                                    <option value="500">500</option>
                                    <option value="501">501</option>
                                    <option value="502">502</option>
                                    <option value="503">503</option>
                                    <option value="504">504</option>
                                    <option value="505">505</option>
                                    <option value="506">506</option>
                                    <option value="507">507</option>
                                    <option value="508">508</option>
                                    <option value="509">509</option>
                                    <option value="590">590</option>
                                    <option value="591">591</option>
                                    <option value="592">592</option>
                                    <option value="593">593</option>
                                    <option value="594">594</option>
                                    <option value="595">595</option>
                                    <option value="596">596</option>
                                    <option value="597">597</option>
                                    <option value="598">598</option>
                                    <option value="599">599</option>
                                    <option value="670">670</option>
                                    <option value="672">672</option>
                                    <option value="673">673</option>
                                    <option value="674">674</option>
                                    <option value="675">675</option>
                                    <option value="676">676</option>
                                    <option value="677">677</option>
                                    <option value="678">678</option>
                                    <option value="679">679</option>
                                    <option value="680">680</option>
                                    <option value="681">681</option>
                                    <option value="682">682</option>
                                    <option value="683">683</option>
                                    <option value="684">684</option>
                                    <option value="686">686</option>
                                    <option value="687">687</option>
                                    <option value="688">688</option>
                                    <option value="689">689</option>
                                    <option value="690">690</option>
                                    <option value="691">691</option>
                                    <option value="692">692</option>
                                    <option value="850">850</option>
                                    <option value="852">852</option>
                                    <option value="853">853</option>
                                    <option value="855">855</option>
                                    <option value="856">856</option>
                                    <option value="880">880</option>
                                    <option value="886">886</option>
                                    <option value="960">960</option>
                                    <option value="961">961</option>
                                    <option value="962">962</option>
                                    <option value="963">963</option>
                                    <option value="964">964</option>
                                    <option value="965">965</option>
                                    <option value="966">966</option>
                                    <option value="967">967</option>
                                    <option value="968">968</option>
                                    <option value="970">970</option>
                                    <option value="971">971</option>
                                    <option value="972">972</option>
                                    <option value="973">973</option>
                                    <option value="974">974</option>
                                    <option value="975">975</option>
                                    <option value="976">976</option>
                                    <option value="977">977</option>
                                    <option value="992">992</option>
                                    <option value="994">994</option>
                                    <option value="995">995</option>
                                    <option value="996">996</option>
                                    <option value="998">998</option>
                                    <option value="1242">1242</option>
                                    <option value="1246">1246</option>
                                    <option value="1264">1264</option>
                                    <option value="1268">1268</option>
                                    <option value="1284">1284</option>
                                    <option value="1340">1340</option>
                                    <option value="1345">1345</option>
                                    <option value="1441">1441</option>
                                    <option value="1473">1473</option>
                                    <option value="1649">1649</option>
                                    <option value="1664">1664</option>
                                    <option value="1670">1670</option>
                                    <option value="1671">1671</option>
                                    <option value="1684">1684</option>
                                    <option value="1758">1758</option>
                                    <option value="1767">1767</option>
                                    <option value="1784">1784</option>
                                    <option value="1787">1787</option>
                                    <option value="1809">1809</option>
                                    <option value="1868">1868</option>
                                    <option value="1869">1869</option>
                                    <option value="1876">1876</option>
                                    <option value="7370">7370</option>
                                </select>
                                <input type='text' name='wl_mobile' id='wl_mobile' style="width:100%;" class='form-control' placeholder='Mobile No.*'>
                            </div>
                        </div>

                        <button type="submit" class="button submit-button">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <a href="#" class="logo-footer">
                <img src="{{ asset('storage/'.get_site_config('website_sticky_logo')) }}" style="height:40px;" alt="logo" />
            </a>
            <div class="link_footer">

            </div>
        </div>
    </footer>
    <div class="copy-right">
        <div class="container">
            <div class="copy-right-wrapper">
                <!-- <p>&copy; 2023 All Rights Reserved.</p> -->
                <!-- <div class="social-icon-list">
                    <a href="#" class="social-icon">
                        <img src="./assets/images/facebook.svg" alt="Facebook">
                    </a>
                    <a href="#">
                        <img src="./assets/images/linkedin.svg" alt="Linkedin">
                    </a>
                    <a href="#">
                        <img src="./assets/images/instagram.svg" alt="Instagram">
                    </a>
                    <a href="#">
                        <img src="./assets/images/twitter.svg" alt="Twitter">
                    </a>
                </div> -->
            </div>
        </div>
    </div>

    <script src="{{ asset('assets/landing-pages/assets-two/js/jquery.min.js')}}"></script>
    <script src="{{ asset('assets/landing-pages/assets-two/js/script.js')}}"></script>
</body>

</html>