@extends('backend.layouts.app')
@section('title', "My Commission")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-8">
                <h4 class="card-title mb-0">
                    My Commission
                </h4>
                <p>Total Earnings: <b>{{$agent_currency_symbol." ".$total_pay}}</b></p>
            </div>
            <!--col-->
            <div class="col-sm-4 ">
            </div>
        </div>
        <!--row-->

        <div class="row mt-4">
             <div class="col-sm-12 col-md-3">
                <select class="form-select" id='status'>
                    <option value=''>Status</option>
                    <option value="pending">Pending</option>
                    <option value="1">Paid</option>
                </select>
            </div>
            <div class="col-sm-12 col-md-4">
                <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                <button onclick="javascript:clearTable();" class=" btn btn-primary btn-sm">Clear</button>
            </div>
        </div>

        <div class="table-responsive">
            <table id="data_table" class="table table-bordered table-hover w-100">
                <thead>
                    <tr>
                        <th style="min-width: 100px !important;">Payment ID</th>
                        <th style="min-width: 100px !important;">Created Date</th>
                        <th>Application</th>
                        <th>Student</th>
                        <th>Commission Notes</th>
                        <th>Commission</th>
                        <th>Deduction</th>
                        <th>Net Pay</th>
                        <th>Comments</th>
                        <th>Date Paid</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>

    </div>
</div>
@endsection
@push('after-styles')
@endpush
@push('after-scripts')

<script type="text/javascript">
  
    $(document).ready(function() {
        loadData();
    });
  

    function loadData() {
        $('#data_table').DataTable({
            "dom": '<"row"<"col-md-2 text-start"l><"col-md-1"><"col-md-5"f><"col-md-4 text-end">>rtip',
            "processing": true,
            "serverSide": true,
            "language": {
                searchPlaceholder: "Appl ID"
            },
            "lengthMenu": [10, 25, 50, 100],

            "ajax": {
                "url": "{{route('admin.agents.mycommissiondata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'status': $('#status').val(),
                },

            },
            // "drawCallback": function( settings ) {
            //     addDeleteForms();
            // },
            "columns": [
                { "data": 'payment_id' },
                { "data": 'created_at' },
                {
                    "data": "applId"
                },
                {
                    "data": "student",
                    orderable: false,
                },
                {
                    "data": "commission_notes",
                    orderable: false,
                },
                {
                    "data": "commission"
                },
                {
                    "data": "deduction"
                },
                {
                    "data": "net_pay"
                },
                {
                    "data": "trans_details"
                },
                {
                    "data": "date_paid"
                },
                {
                    "data": "status"
                }
            ],
            'order': [
                [5, 'desc']
            ],
           
            // "buttons": [{
            //         extend: 'excel',
            //         text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
            //         className: 'btn btn-outline-secondary exportBtn',
            //         footer: false,
            //         header: true,
            //         exportOptions: {
            //             columns: [0, 1, 2, 3, 4, 5]
            //         }
            //     },
            //     {
            //         extend: 'pdf',
            //         text: '<i class="bi bi-file-earmark-pdf"></i>',
            //         className: 'btn btn-outline-secondary exportBtn',
            //         footer: false,
            //         header: true,
            //         exportOptions: {
            //             columns: [0, 1, 2, 3, 4, 5]
            //         }
            //     },
            //     {
            //         extend: 'print',
            //         text: '<i class="bi bi-printer"></i>',
            //         className: 'btn btn-outline-secondary exportBtn',
            //         footer: false,
            //         header: true,
            //         exportOptions: {
            //             columns: [0, 1, 2, 3, 4, 5]
            //         }
            //     },
            //     {
            //         extend: 'copy',
            //         text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
            //         className: 'btn btn-outline-secondary exportBtn',
            //         footer: false,
            //         header: true,
            //         exportOptions: {
            //             columns: [0, 1, 2, 3, 4, 5]
            //         }
            //     },
            //     {
            //         extend: 'csv',
            //         text: '<i class="ri-file-excel-line export-btn-size"></i>',
            //         className: 'btn btn-outline-secondary exportBtn',
            //         footer: false,
            //         header: true,
            //         exportOptions: {
            //             columns: [0, 1, 2, 3, 4, 5]
            //         }
            //     },
            // ]
        });
    }

    function searchTable() {
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#status').val('');
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

</script>
@endpush