@extends('backend.layouts.app')
@section('title', "New Order")

@section('content')
<div class="card" style="border:none;">
    <div class=" card-body printableArea">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    New Order
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{route('admin.orders')}}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="form-horizontal" method="POST" action="{{route('admin.order.generate.save')}}">
            @csrf
            <div class="row mt-4">
                <div class="col-sm-12 col-md-5">
                    Select Student
                    <select class="form-control select2_ajax" name="student_id" required></select>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-4">
                    <div class="pull-left">
                        <address>
                            <h5><b>Bill To</b></h5>
                            <p class="m-l-5">
                                Name: <span id="stu_name"></span><br />
                                Address: <span id="stu_city"></span><br />
                                Mob: <span id="stu_mob"></span><br />
                                Email: <span id="stu_email"></span>
                            </p>
                        </address>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="table-responsive m-t-40" style="clear: both;">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center">Sl.No</th>
                                    <th>Product</th>
                                    <th class="text-right">Quantity</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- <tr id="ifonly" style="display:none;">
                                    <td class="text-center">1</td>
                                    <td>
                                        <select class="form-select" name="batch_id" id="stu_batch1" style="display: inline; width: 250px;">
                                            <option value=''>Select Training Batch or Manually enter items below</option>
                                        </select>
                                        <span class="ml-2" id="stu_batch1_course"></span>
                                        <input type="hidden" name="item1" id="item1">
                                    </td>
                                    <td id="course_fee1"></td>
                                    <input class="item_value inputs" type="hidden" name="item1amount" id="item1amount">
                                </tr> --}}
                                <tr>
                                    <td class="text-center" id="ct2">1</td>
                                    <td>
                                        <select class="form-select item_value" name="item1" id="sel_val1" >
                                            <option value=''>Select Product</option>
                                            @foreach($products as $prods)
                                                <?php 
                                                        if($prods->offer_price == 0){
                                                            $price = $prods->price;
                                                        }else{
                                                            $price = $prods->offer_price;
                                                        }
                                                ?>
                                                <option value="{{$prods->id}}" data-val="{{$price}}">{{$prods->title}}-{{config('app.currency_symbol')}}{{$price}}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="item1amt" id="item1amt">
                                    </td>
                                    <td style="width: 220px;">
                                        <input type="number" class="form-control item_value inputs" value="1" name="item1qty" style="display: inline; width: 100px;">
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-center" id="ct3">2</td>
                                    <td>
                                        <select class="form-select item_value" id="sel_val2" name="item2">
                                            <option value=''>Select Product</option>
                                            @foreach($products as $prods)
                                                <?php 
                                                        if($prods->offer_price == 0){
                                                            $price = $prods->price;
                                                        }else{
                                                            $price = $prods->offer_price;
                                                        }
                                                ?>
                                                <option value="{{$prods->id}}" data-val="{{$price}}">{{$prods->title}}-{{config('app.currency_symbol')}}{{$price}}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="item2amt" id="item2amt">
                                    </td>
                                    <td style="width: 220px;">
                                       <input type="number" class="form-control item_value inputs"  value="1" name="item2qty" style="display: inline; width: 100px;">
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-center" id="ct3">3</td>
                                    <td>
                                        <select id="sel_val3" class="form-select item_value" name="item3">
                                            <option value=''>Select Product</option>
                                            @foreach($products as $prods)
                                                <?php 
                                                        if($prods->offer_price == 0){
                                                            $price = $prods->price;
                                                        }else{
                                                            $price = $prods->offer_price;
                                                        }
                                                ?>
                                                <option value="{{$prods->id}}" data-val="{{$price}}">{{$prods->title}}-{{config('app.currency_symbol')}}{{$price}}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="item3amt" id="item3amt">
                                    </td>
                                    <td style="width: 220px;">
                                        <input type="number" class="form-control item_value inputs"  value="1" name="item3qty" style="display: inline; width: 100px;">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="m-t-30" style="text-align: right;">
                        {{-- <h6><b>Discount :</b> <input type="text" class="form-control inputs" name="discount" value="0" id="discount" style="display: inline; width: 150px;" required></h6> --}}
                        <h6><b>Total :</b> {{config('app.currency_symbol')}} <span id="tot">0</span>
                            <input type="hidden" name="sub_total" id="sub_val">
                        </h6>
                    </div>
                    <br><br>
                    <div class="clearfix"></div>
                    <hr />
                    <div class="text-center">
                        {{-- <p style="text-align:center;"><label class="p-2"><input type="checkbox" name="send_invoice" value="1"> Email Invoice to Client</label></p> --}}
                        <button class="btn btn-primary btn-sm" type="submit" name="crt" value="create">Create </button>
                        <a href="{{route('admin.orders')}}" class="btn btn-primary btn-sm" type="button">Cancel</a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@push ('after-scripts')
<script>
    $(document).ready(function() {

        $('.select2_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.create-order.search_student") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });


        $(".select2_ajax").on("select2:close", function() {
            $.ajax({
                url: '{{ route("admin.create-order.searchStudentData") }}',
                type: "post",
                data: {
                    id: $(this).val(),
                    _token: '{{csrf_token()}}'
                },
                success: function(data) {
                    console.log(data);
                    $('#stu_name').html(data.results.first_name + ' ' + data.results.last_name);
                    if (data.results.address_1 == '' || data.results.address_1 == null) {
                        $('#stu_city').html("N/A");
                    } else {
                        $('#stu_city').html(data.results.address_1 + ', ' + data.results.address_2);
                    }
                    $('#stu_mob').html(data.results.mobile);
                    $('#stu_email').html(data.results.email);
                    var len = 0;
                    if (data.batch != null) {
                        len = data.batch.length;
                    }

                    if (len > 0) {

                        // Read data and create <option >
                        for (var i = 0; i < len; i++) {
                            var id = data.batch[i].id;
                            var name = data.batch[i].code;
                            var option = "<option value='" + id + "'>" + name + "</option>";
                            $("#stu_batch1").append(option);
                        }
                        //$("#stu_batch1").attr('required', true);
                        $('#ifonly').show();
                        $('#ct2').text('2');
                        $('#ct3').text('3');
                    } else {
                        //$("#stu_batch1").attr('required', false);
                        $('#ifonly').hide();
                        $("#stu_batch1").html('');
                        var option = "<option value=''>Select Training Batch or Manually enter items below</option>";
                        $("#stu_batch1").append(option);
                        $('#ct2').text('1');
                        $('#ct3').text('2');
                    }
                }
            });
        });

        //batch change
        $('#stu_batch1').change(function() {
            var bid = $(this).val();
            if (bid != '') {
                $.ajax({
                    type: "post",
                    url: '{{ route("admin.search.get_course") }}',
                    data: {
                        id: bid,
                        _token: '{{csrf_token()}}'
                    },
                    success: function(res) {
                        //console.log("Course: "+res);     
                        if (res) {
                            $("#stu_batch1_course").html(res.title);
                            $("#course_fee1").html("{{config('app.currency_symbol')}} " + res.fees);
                            $("#item1amount").val(res.fees);
                            $("#item1").val('Batch: ' + res.code + ' Course: ' + res.title);

                            var total = 0;
                            $('.item_value').each(function() {
                                total += parseFloat($(this).val()) || 0;
                            });
                                var dis = $('#discount').val();
                                $('#tot').html(total - dis);
                                $('#sub_val').val(total);
                                $('#tot_val').val(total - dis);
                        }
                    }
                });
            } else {
                $("#stu_batch1_course").html('');
                $("#course_fee1").html('');
                $("#item1").val('');
                $("#item1amount").val('');
                var total = 0;
                $('.item_value').each(function() {
                    total += parseFloat($(this).val()) || 0;
                });
                var dis = $('#discount').val();
                $('#tot').html(total - dis);
                $('#sub_val').val(total);
                $('#tot_val').val(total - dis);
            }
        });
        
        $('.item_value').on('input', function() {
            var total = 0;
            $('.item_value').each(function() {
                total += parseFloat($(this).children('option:selected').data('val') * $(this).parent().parent().find('.inputs').val()) || 0;
            });

            var dis = $('#discount').val();
            $('#tot').html(total);
            $('#sub_val').val(total);
            $('#tot_val').val(total - dis);
        });

        $("#sel_val1").change(function(){
            $("#item1amt").val($(this).children('option:selected').data('val'));
        });
        $("#sel_val2").change(function(){
            $("#item2amt").val($(this).children('option:selected').data('val'));
        });
        $("#sel_val3").change(function(){
            $("#item3amt").val($(this).children('option:selected').data('val'));
        });

    });
</script>
@endpush