@extends('backend.layouts.app')
@section('title', "Orders")
@section('content')
<div class="card">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Orders
                </h4>
            </div>
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{route('admin.order.generate')}}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Create Batch"><i class="bi bi-plus-circle"></i> Create Order</a>
                </div>
            </div>
        </div> 

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="orders-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Date</th>
                                <th>Order ID</th>
                                <!-- <th>Products</th> -->
                                {{-- <th>Seller</th> --}}
                                <th>Customer</th>
                                <th>Amount</th>
                                <th>Payment</th>
                                <th>Delivery</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection      

@push ('after-scripts')
<!-- DataTables Core and Extensions -->
<script type="text/javascript">
$('#orders-table').DataTable({
        "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        ajax: '{{ route("admin.orders.orders-list") }}',
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'date',name:'date'},
            {data: 'order_id', name: 'order_id'},
            // {data: 'num_products', name: 'num_products'},
            // {data: 'seller', name: 'seller'},
            {data: 'customer', name: 'customer'},
            {data: 'amount', name: 'amount'},
            {data: 'payment_status', name: 'payment_status'},
            {data: 'delivery_status', name: 'delivery_status'},
            {data: 'action', name: 'action', orderable: false, searchable: false}
        ],
        columnDefs: [
            {
                "targets": 0, 
                "className": "text-center",
           },{
                "targets": 1,
                "className": "text-center",
           },{
                "targets": 2, 
                "className": "text-center",
           },{
                "targets": 3, 
                "className": "text-center",
           },{
                "targets": 4, 
                "className": "text-center",
           },{
                "targets": 5, 
                "className": "text-center",
           },{
                "targets": 6, 
                "className": "text-center",
           },{
                "targets": 7, 
                "className": "text-center",
           }
        //    ,{
        //         "targets": 8, 
        //         "className": "text-center",
        //    }
         ],
         "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
            ]          
    });
</script>
@endpush
